*  compiler.prg  Version 1.1  Released 07-Apr-92


* DOC
*      Routine:Compiler
*   Parameters:character string of source filename including extension
*       Author:David Frankenbach    FRNKNBCH on BORBBS
*              DF Software Development, Inc.
*              PO Box 87
*              Forest, VA  24551
*  Description:This procedure can be used as a replacement for build,
*              in dBASE IV 1.5 it is a true MAKE facility only compiling
*              the source code modules that are out of date with their
*              object modules.
*        Usage:do Compiler with "test.prg"
*     dBASE IV:Releases 1.1 and 1.5
*     Revision:07-Apr-92 Updated to 1.5, public release
*              06-Feb-91 Initial Release
procedure Compiler
parameter filename
private filen, source_ext, target, target_ext, recompile, set_exact

set_exact_off = ( set("exact") = "OFF" )
set exact on

if ( type("dbversion") = "U" )  && only do this once
   public dbversion
   dbversion = version()        && find out what version of dBASE we are using
   if ( "IV" $ dbversion )
      do case
         case ( "1.0" $ dbversion )
            ? "Call Borland and get your free upgrade to a version that works!"
            dbversion = "1.0"
         case ( "1.1" $ dbversion )
            dbversion = "1.1"
         case ( "1.5" $ dbversion )
            dbversion = "1.5"
      otherwise
         ? "Unsupported version of dBASE IV:" + dbversion
         dbversion = "Unsupported"
      endcase

   else
      ? "only tested compatible with dBASE IV"
      dbversion = "Unsupported"
   endif
endif

if ( dbversion = "Unsupported" )
   return                          && return without doing anything
endif

filename = lower( filename )
? "File:" + filename
filen = substr( filename, 1, at( ".", filename ) )
source_ext = substr( filename, at( ".", filename ) )
do case
   case ( source_ext = ".frg" )
      target_ext = "fro"
   case ( source_ext = ".lbg" )
      target_ext = "lbo"
   case ( source_ext = ".fmt" )
      target_ext = "fmo"
   case ( source_ext = ".prg" )
      target_ext = "dbo"
otherwise
   ? "unknown source file:" + filename
   return
endcase

target = filen + target_ext

recompile = .f.

if ( dbversion = "1.0" ) .or. ( dbversion = "1.1" ) .or. (.not. file( target ) )
   recompile = .t.
else
   if ( fdate( filename ) > fdate( target ) )
      recompile = .t.
   else
      if ( fdate( filename ) = fdate( target ) )
         recompile = ( ftime( filename ) > ftime( target ) )
      endif
   endif
endif

if ( recompile )
   ?? " compiling..."
   do case
      case ( ".fmt" = source_ext )
         set format to (filename)     && you can't compile a .fmt

      case ( ".frg" = source_ext ) .or. ( ".lbg" = source_ext )
         compile (filename) runtime
         erase (target)
         rename (filen) + "dbo" to (target)

      otherwise
         compile (filename) runtime
   endcase
else
   ?? " target:" + target + " is up to date"
endif

if ( set_exact_off )
   set exact off
endif

return
