*:**************************************************************************
*:
*:        Program: ASCTODBF.PRG
*:        Version: 1.5b
*:
*:                 This program imports ASCII files into a DBF.  The DBF
*:                 either already exists, or can be created by this program.
*:
*:                 After the DBF is created or recalled from disk,
*:                 the program  adds records from an ASCII flat file.
*:                 The ASCII file may be fixed format, without delimiters,
*:                 or may be a delimited file.
*:
*:                 If the file is fixed format, records can be, but do not
*:                 need to be, separated by a CR/LF.
*:                 Delimited files *must* use CR/LF to separate records.
*:
*:                 Delimited records may have fields that have embedded CRs.
*:
*:
*:     Start Date: 01/08/94
*:     modified:   09/20/94	             - PRESET function
*:                                                       Windows ready.
*:                 10/15/94 Version 1.5  - File name checking disabled if _MAC
*:                                                       Some general clean up.
*:                 10/28/94 Version 1.5a - Allowed record to span more than
*:                                                       1 line. (Retained the capability to
*:                                                        handle embedded CR/LFs in fields.)
*:                 11/08/94 Version 1.5b - Allowed for date field to be all numeric
*:                                                        in  fixed format records.
*:
*:      Author: Joe Vles
*:      Copyright (c) 1994, Joe Vles
*:
*:  Joe Vles  CIS # 75450,343
*:  51 Priest Street
*:  San Francisco, CA 94109
*:  415-776-5350
*:
*: Thanks to: Bill Budney   (CIS 70431,3706)
*:            Bill Babcock  (CIS 70272,2152)
*:            For their suggestions and critique. 
*:
*:**************************************************************************
*:*** Dear fellow FoxPro-er:                                               *
*:***                                                                      *
*:*** Thank you for using this utility. I hope that it does exactly what   *
*:*** you expected of it.                                                  *
*:***                                                                      *
*:*** If you think that you might be using this routine regularly, you may *
*:*** want to think about sending $25, whereupon you will be registered,   *
*:*** and you will receive updates as they become available.               *                                *
*:**************************************************************************

DIMENSION BeginCol[255]
DIMENSION EndCol[255]
PUBLIC FieldName[255]
PUBLIC FieldType[255]
PUBLIC FLength[255]
PUBLIC DecPoint[255]
PUBLIC DBFfield[1,4]
PUBLIC I, NxtLn, SaveNxtLn1, FirstLine, GetOut
PUBLIC PrevTalk, PrevPrint, PrevSafety, PrevEscape, OutOfExit

CLEAR
IF SET("century" ) = "OFF"
	SET CENTURY ON
	m.SetCentury = "OFF"
 ELSE
 	m.SetCentury = "ON"
 ENDIF
IF SET("talk") = "ON"
   SET TALK OFF
   m.PrevTalk = "ON"
 ELSE
   m.PrevTalk = "OFF"
ENDIF
IF SET("print") = "ON"
   SET PRINT OFF
   m.PrevPrint = "ON"
 ELSE
   m.PrevPrint = "OFF"
ENDIF
IF SET("safety") = "ON"
   SET SAFETY OFF
   m.PrevSafety = "ON"
 ELSE
   m.PrevSafety = "OFF"
ENDIF
IF SET("escape") = "ON"
   SET ESCAPE OFF
   m.PrevEscape = "ON"
 ELSE
   m.PrevEscape = "OFF"
ENDIF

PUSH KEY CLEAR

ON KEY LABEL ESC DO ExitRoutine

I = 0
m.NxtLn = 1
m.SaveNxtLn1 = 0
m.KnowDataRecord = 0
m.GetOut = 0
m.OutOfExit = 0

FOR m.InDDX = 1 TO 255
   BeginCol[m.InDDX]  = 0
   EndCol[m.InDDX]    = 0
   FieldName[m.InDDX] = "          "
   FieldType[m.InDDX] = " "
   Flength[m.InDDX]   = 0
   DecPoint[m.InDDX]  = 0
ENDFOR

*** Let's set up a window to display information in

IF _DOS
	DEFINE WINDOW MainWindow FROM 0,0 TO 23,74 ;
	   TITLE "ASCTODBF-V1.5b. ASCII RECORDS TO DBF ROUTINE"
 ELSE
	DEFINE WINDOW MainWindow	AT 1,0 ;
								SIZE 32,70 ;
	   TITLE "ASCTODBF-V1.5b. ASCII RECORDS TO DBF ROUTINE";
	  							STYLE "B" ;
	  							FONT "foxfont",9 ;
	   							FLOAT ;
	   							NOCLOSE ;
	   							MINIMIZE ;
	   							SYSTEM ;
	   							COLOR RGB(,,,192,192,192)
ENDIF	   							
MOVE WINDOW MainWindow CENTER	   							 

***
*** Beginning of program execution
***

ACTIVATE WINDOW MainWindow

*** Get DBF name, and check if it exists

DO WHILE .T.
   m.DBFname = GETFILE("DBF","DBF To Append Text To", ;
                         "Select",1)
   CLOSE ALL
   IF EMPTY(m.DBFname)
      DO ExitRoutine
   ENDIF
   IF "Untitled" $ m.DBFname
      DO WHILE .T.
         m.DBFname = SPACE(60)
         IF _DOS
            @ m.NxtLn,1 SAY "Enter The Name For The DBF To Be Created:"  
            m.NxtLn = m.NxtLn + 1
            @ m.NxtLn,1 GET m.DBFname
          ELSE
            @ m.NxtLn,1 SAY "Enter The Name For The DBF To Be Created:" ;           
            FONT "Arial", 10;
            STYLE "BT"
            m.NxtLn = m.NxtLn + 2            
            @ m.NxtLn,1 GET m.DBFname ;
            FONT "Arial", 10;
            STYLE "B" ;
            PICTURE "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
            m.NxtLn = m.NxtLn + 1             
         ENDIF       
         READ
         IF EMPTY(m.DBFname)
            LOOP
         ENDIF
         IF AT(".",m.DBFname) = 0
            m.DBFname = ALLTRIM(m.DBFname) + ".DBF"
         ENDIF
         m.Fexists = ADIR(TempArray,m.DBFname)
         IF m.Fexists > 0
            WAIT WINDOW ;
            "This File Already Exists. Do you want to overwrite it (Y/N):";
            TO m.Answer
            IF "N" $ SUBSTR(ALLTRIM(UPPER(m.Answer)),1,1)
               LOOP
             ELSE
               DELETE FILE (m.DBFname)
               DELETE FILE ((SUBSTR(m.DBFname, 1, AT(".",m.DBFname)) + "FPT"))
            ENDIF
         ENDIF
         EXIT
      ENDDO
   ENDIF
   
   m.BadName = 0
   
   *** Check for legal file name, except when on a MAC 
       
   IF .NOT. _MAC
      FOR m.DbLetter = 1 TO LEN(ALLTRIM(m.DBFname))
         IF .NOT. BETWEEN(SUBSTR(UPPER(m.DBFname),m.DbLetter,1),"A","Z") .AND. ;
            .NOT. BETWEEN(SUBSTR(UPPER(m.DBFname),m.DbLetter,1),"0","9") .AND. ;
            .NOT. SUBSTR(m.DBFname,m.DbLetter,1) = "." .AND. ;
            .NOT. SUBSTR(m.DBFname,m.DbLetter,1) = "\" .AND. ;
            .NOT. SUBSTR(m.DBFname,m.DbLetter,1) = "_" .AND. ;
            .NOT. SUBSTR(m.DBFname,m.DbLetter,1) = ":" 
            WAIT WINDOW " Illegal File Name."
            m.NxtLn = m.NxtLn - 1
            m.BadName = 1
            EXIT
         ENDIF
      ENDFOR
   ENDIF
   
   IF m.BadName = 1
      LOOP
   ENDIF
   IF AT(".",m.DBFname) = 0
      m.DBFname = ALLTRIM(m.DBFname) + ".DBF"
   ENDIF
   m.NxtLn = m.NxtLn + 1
   EXIT
ENDDO   

*** If the data base doesn't exist, get field information.
*** First ask for the data file name, and display the first record.

m.DataFile = SPACE(45)
m.CrLf = "Y"
DO WHILE .T.
   m.DataFile = GETFILE("DAT|TXT","Data File To Append", ;
                         "Select",0)
   CLOSE ALL
   IF EMPTY(m.DataFile) .OR. "Untitled" $ m.DataFile
      DO ExitRoutine
   ENDIF
   IF m.OutOfExit = 1
      m.OutOfExit = 0
      LOOP
   ENDIF


*** We need to know if this is a fixed record length, or a delimited file.
***

   m.DictSlash = RAT("\",m.DataFile)
   m.DataFileX = m.DataFile
   IF m.DictSlash # 0
      m.DataFileX = SUBSTR(m.DataFile,m.DictSlash+1,(LEN(m.DataFile)-m.DictSlash+1))
   ENDIF
   m.FileType = " "
   IF _DOS
   	@m.NxtLn,1 SAY "Does " + m.DataFileX + ; 
            " have Fixed Length or Delimited Fields (F/D): " ;
            GET m.FileType PICTURE "!" VALID m.FileType = "F" .OR. ;
                                             m.FileType = "D"
	ELSE
   	@m.NxtLn,1 SAY "Does " + m.DataFileX + ; 
            " have Fixed Length or Delimited Fields (F/D): " ;
            FONT "Arial", 10;
            STYLE "BT"
    @m.NxtLn,50 GET m.FileType ;
            FONT "Courier New", 10;
            STYLE "B";
            PICTURE "@K !" VALID m.FileType = "F" .OR. ;
                              m.FileType = "D"
	ENDIF	
	READ
	IF _DOS
		m.NxtLn = m.NxtLn + 1
	 ELSE
		m.NxtLn = m.NxtLn + 2
	ENDIF	 
      
*** Is this a CR/LF delimited file, or do the records run on?

   IF _DOS
      @m.NxtLn,1 SAY "Are The Records In This File Separated By CR/LF (Y/N):" ;
                 GET m.CrLf PICTURE "!" VALID m.CrLf = "Y" .OR. m.CrLf = "N"
	ELSE
      @m.NxtLn,1 SAY "Are The Records In This File Separated By CR/LF (Y/N):" ;
      			FONT "Arial", 10;
      			STYLE "BT"
      @m.NxtLn,50 GET m.CrLf ;
      			FONT "Courier New", 10;
      			STYLE "B" ;
      			PICTURE "@K !" VALID m.CrLf = "Y" .OR. m.CrLf = "N"
	ENDIF		                 
    READ
   
*** If the records are not separated by CR/LF, we need record length.

   m.RecSize = 0
   IF m.CrLf = "N"
      IF _DOS
         @m.NxtLn+1,43 SAY "Record Size:" GET m.RecSize VALID m.RecSize > 0
       ELSE
         @m.NxtLn+2,45 SAY "Record Size:" ;
        				FONT "Arial", 10;
      	    			STYLE "BT"
         @m.NxtLn+2,60 GET m.RecSize ;
      	     			FONT "Courier New", 10;
      		    		STYLE "B" ;
      		    		PICTURE "@K" ;
      			    	VALID m.RecSize > 0
      ENDIF
      READ
   ENDIF

*** Does file exist?
   
   m.DataFileIn = FOPEN(m.DataFile)
   IF m.DataFileIn < 0
      WAIT WINDOW "File Does Not Exist."
      LOOP
   ENDIF

*** Check that it is an ASCII file
*** Read the first record; then check the first 3 characters

   IF m.CrLf = "Y"   
      m.FirstLine = FGETS(m.DataFileIn,9999)
    ELSE
      m.FirstLine = FREAD(m.DataFileIn,m.RecSize)
   ENDIF
   m.AsciiCheck = 0
   FOR m.CheckChar = 1 TO 3
      IF BETWEEN(ASC(SUBSTR(m.FirstLine,m.CheckChar,1)),0,6) .OR. ;
         BETWEEN(ASC(SUBSTR(m.FirstLine,m.CheckChar,1)),14,31) .OR. ;
         BETWEEN(ASC(SUBSTR(m.FirstLine,m.CheckChar,1)),129,255) .OR. ;
         ASC(SUBSTR(m.FirstLine,m.CheckChar,1)) = 8
         WAIT WINDOW "Not An ASCII File."
         =FCLOSE(m.DataFileIn)
         m.AsciiCheck = 1
         EXIT
      ENDIF
   ENDFOR
   IF m.AsciiCheck = 1
      LOOP
   ENDIF

*** It is an ASCII file.  Set the file pointer back to BOF.

   IF m.CrLf = "Y"
      m.BackToStart =FSEEK(m.DataFileIn,-1*(LEN(m.FirstLine)+2),1)
    ELSE
      m.BackToStart =FSEEK(m.DataFileIn,-1*m.RecSize,1)
   ENDIF
      
*** And continue with the program.
   
   EXIT
ENDDO

*** There is at present no existing DBF.
*** Display a ruler and a record of the ASCII file,
*** then define the DBF.

IF .NOT. FILE(m.DBFname)
   
   m.KnowDataRecord = 1
   m.DataByteReached = 0
   m.ContLine = 0
   m.SSaveLine = 0
   m.EndOfFile = 0
   DO WHILE .NOT. FEOF(m.DataFileIn)
      m.FirstLine = ""
      IF m.CrLf = "Y"   
         m.FirstLine = FGETS(m.DataFileIn,9999)
       ELSE
         m.FirstLine = FREAD(m.DataFileIn,m.RecSize)
      ENDIF
      
      IF m.CrLf = "Y"
         m.DataByteReached = m.DataByteReached + (LEN(m.FirstLine) + 2)
       ELSE
         m.DataByteReached = m.DataByteReached + m.RecSize
      ENDIF

      m.NxtLn = 0
      FOR m.EmptyLine = m.NxtLn TO 5
         @ m.EmptyLine,0 SAY SPACE(74)
      ENDFOR
      DO Ruler
      m.NxtLn = m.NxtLn + 1
      m.LookAtAnother = "N"
      m.ContLine = m.NxtLn
      IF _DOS
         @m.NxtLn,1 SAY "This is a data file record. Type Y if you want to look at another:" ;
                  GET m.LookAtAnother
       ELSE
         @m.NxtLn,1 SAY "This is a data file record. Type Y if you want to look at another:" ;
            FONT "Arial", 10;
            STYLE "B"
         @m.NxtLn,60 GET m.LookAtAnother;
            FONT "Courier New", 10;
            STYLE "B";
            PICTURE "@K !"
      ENDIF 
      READ         
      IF UPPER(m.LookAtAnother) = "Y"
         m.SSaveLine = m.NxtLn
         m.NxtLn = 3
         LOOP
      ENDIF
      m.NxtLn = m.NxtLn - 1
      @m.NxtLn,1 SAY SPACE(74)
      @m.NxtLn+1,1 SAY SPACE(74)
      @m.NxtLn+2,1 SAY SPACE(74)
      @m.NxtLn+3,1 SAY SPACE(74)            
      IF _DOS
         @m.NxtLn,20 SAY 'Answer  NO  to "Input data records now?"' COLOR R/W
       ELSE
         @m.NxtLn,20 SAY 'Answer  NO  to "Input data records now?"' ;
         			 COLOR R/W ;
         			 FONT "Arial", 10 ;
         			 STYLE "BT"
      ENDIF
      EXIT
   ENDDO   
         
*** Set pointer back to beginning in the data file
      
   m.BackToStart =FSEEK(m.DataFileIn,(-1 * m.DataByteReached),1)

   CREATE (m.DBFname)

   FOR m.EmptyLine = 0 TO 5
      @m.EmptyLine,0 SAY SPACE(74)
   ENDFOR
   
ENDIF 
CLOSE ALL

***
*** We are now going to build the ASCII data file.
*** Call the appropriate routine.
***

IF m.FileType = "F"
   DO FixedFile
 ELSE
   DO DelimFile
ENDIF

*** End Of Program

POP KEY ALL
CLOSE DATABASES

DO CASE
   CASE m.SetCentury = "OFF"
      SET CENTURY OFF
   CASE m.PrevTalk = "ON"
      SET TALK ON
   CASE m.PrevPrint = "ON"
      SET PRINT ON
   CASE m.PrevSafety = "ON"
      SET SAFETY ON
   CASE m.PrevEscape = "ON"
      SET ESCAPE ON
ENDCASE

CLEAR
DEACTIVATE WINDOW MainWindow
RELEASE WINDOW MainWindow
CANCEL

***
*** End of main line program.
***

*** Fixed Format Records to DBF
***

PROCEDURE FixedFile

*** Now open the DBF, get the ASCII data file, and ask how the records
*** in the ASCII file are structured.  Then build records to the DBF

IF _DOS
	DEFINE WINDOW MainWindow FROM 0,0 TO 23,74 ;
   	TITLE "STATE BEGINNING AND ENDING COLUMNS FOR FIELDS IN ASCII FILE"
 ELSE
	DEFINE WINDOW MainWindow	AT 1,0 ;
								SIZE 32,70 ;
	   TITLE "STATE BEGINNING AND ENDING COLUMNS FOR FIELDS IN ASCII FILE";
	  							STYLE "B" ;
	  							FONT "foxfont",9 ;
	   							FLOAT ;
	   							NOCLOSE ;
	   							MINIMIZE ;
	   							SYSTEM ;
	   							COLOR RGB(,,,192,192,192)
ENDIF
MOVE WINDOW MainWindow CENTER
	   		
ACTIVATE WINDOW MainWindow         

*** Get beginning and ending columns for all fields
*** Ask if a PRESET should be used (PRESETS are DBFs with 2 fields per record)

Preset = .F.
WantPreset = " "
IF _DOS
   @m.NxtLn,1 SAY "Use an already stored PRESET for begin and end columns? " ;
   GET WantPreset
 ELSE
   @m.NxtLn,1 SAY "Use an already stored PRESET for begin and end columns? " ;
   			FONT "Arial", 10 ;
   			STYLE "BT" 
   @m.NxtLn,57 GET WantPreset ;
   			FONT "Courier New", 10 ;
   			STYLE "B" ;
   			PICTURE "@K !"
ENDIF
READ
@m.NxtLn,1 SAY SPACE(65)	
IF SUBSTR(UPPER(ALLTRIM(WantPreset)),1,1) == "Y"
   Preset = .T.
   m.Presetname = GETFILE("DBF","PRESET File name", "Select",0)
   IF .NOT. USED (m.PresetName)
	   USE (m.PresetName) IN 0 AGAIN
   ENDIF
   MMM = 0

   DO WHILE .NOT. EOF()
      MMM = MMM + 1
      BeginCol[MMM] = STARTCOLUM
      EndCol[MMM]   = ENDCOLUMN
      SKIP
   ENDDO
ENDIF
CLOSE DATABASES

USE (m.DBFname) IN 0
m.NumFields = AFIELDS(DBFfield)

IF Preset
	m.InDDX = m.NumFields
	FOR MMM = 1 TO m.INDDX
    	FieldName[MMM] = DBFfield[MMM,1]
    	FieldType[MMM] = DBFfield[MMM,2]
    ENDFOR
ENDIF

m.NxtLn = 0
m.SaveNxtLn = 0

m.DataFileIn = FOPEN(m.DataFile)

IF .NOT. Preset
   @m.NxtLn,1 SAY SPACE(65)
   FOR m.InDDX = 1 TO m.NumFields
      IF m.InDDX = 1
         IF _DOS
            @m.NxtLn,4 SAY "IF DATA FOR A FIELD IS NOT IN THE RECORD, ENTER" + ;
               " 0 FOR 1ST COLUMN"
            m.NxtLn = m.NxtLn + 1
            @m.NxtLn,1 SAY "                NUMERIC DATA MAY HAVE EMBEDDED COMMAS"
            m.NxtLn = m.NxtLn + 1
            @m.NxtLn,1 SAY "   IF LAST FIELD IS VARIABLE LENGTH (I.E: MEMO);" + ;
               " STATE END COL:9999"
          ELSE
            @m.NxtLn,4 SAY "IF DATA FOR A FIELD IS NOT IN THE RECORD, ENTER" + ;
               " 0 FOR 1ST COLUMN" ;
               FONT "Courier New", 10 ;
   			   STYLE "B" 
            m.NxtLn = m.NxtLn + 1
            @m.NxtLn,1 SAY "                NUMERIC DATA MAY HAVE EMBEDDED COMMAS" ;
    		FONT "Courier New", 10 ;
   			STYLE "B" 
            m.NxtLn = m.NxtLn + 1
            @m.NxtLn,1 SAY "   IF LAST FIELD IS VARIABLE LENGTH (I.E: MEMO);" + ;
               " STATE END COL:9999" ;
   			FONT "Courier New", 10 ;
   			STYLE "B" 
         ENDIF
             
         m.NxtLn = m.NxtLn + 1

         IF m.KnowDataRecord = 0
            m.DataByteReached = 0
            m.ContLine = 0
            DO WHILE .NOT. FEOF(m.DataFileIn)
               m.FirstLine = ""
               IF m.CrLf = "Y"   
                  m.FirstLine = FGETS(m.DataFileIn,9999)
                ELSE
                  m.FirstLine = FREAD(m.DataFileIn,m.RecSize)
               ENDIF
      
               IF m.CrLf = "Y"
                  m.DataByteReached = m.DataByteReached + (LEN(m.FirstLine) + 2)
                ELSE
                  m.DataByteReached = m.DataByteReached + m.RecSize
               ENDIF
               m.NxtLn = m.NxtLn + 2
               DO Ruler
               m.NxtLn = m.NxtLn + 1
               m.LookAtAnother = "N"
               m.ContLine = m.NxtLn
               IF _DOS
                  @m.NxtLn,1 SAY "This is a data file record. Type Y if you want to look at another:" ;
                             GET m.LookAtAnother ;
                             PICTURE "!"
                ELSE
                  @m.NxtLn,1 SAY "This is a data file record. Type Y if you want to look at another:" ;
   			      FONT "Arial", 10 ;
   			      STYLE "B" 
                  @m.NxtLn,62 GET m.LookAtAnother ;
   			      FONT "Courier New", 10 ;
   			      STYLE "B" ;
   			      PICTURE "@K !" 
                  
               ENDIF 
               READ         
               IF SUBSTR(UPPER(ALLTRIM(m.LookAtAnother)),1,1) = "Y"
                  m.NxtLn = 3
                  LOOP
               ENDIF
               EXIT
           ENDDO   
            IF m.NxtLn = 5
               m.NxtLn = m.ContLine
               @m.NxtLn,1 SAY SPACE(75)
               @m.NxtLn+1,1 SAY SPACE(75)
            ENDIF
         
*** Set pointer back to beginning in the data file
      
           m.BackToStart =FSEEK(m.DataFileIn,(-1 * m.DataByteReached),1)
           m.NxtLn = m.NxtLn - 1
          ELSE     
            DO Ruler
         ENDIF     
         m.SaveNxtLn = m.NxtLn
      ENDIF
      FieldName[m.InDDX] = DBFfield[m.InDDX,1]
      FieldType[m.InDDX] = DBFfield[m.InDDX,2]
      Flength[m.InDDX]   = DBFfield[m.InDDX,3]
      DecPoint[m.InDDX]  = DBFfield[m.InDDX,4]
      m.NxtLn = m.NxtLn + 1
      IF m.NxtLn <= 20
         @m.NxtLn,1 SAY SPACE(75) 
      ENDIF
      IF m.NxtLn > 20
         FOR m.EmptyLine = m.SaveNxtLn TO 20
            @m.EmptyLine,0 SAY SPACE(74)
         ENDFOR
         m.NxtLn = m.SaveNxtLn
      ENDIF
   
      DO WHILE .T.
   
        @m.NxtLn,1 SAY SPACE(74)
        @m.NxtLn+1,1 SAY SPACE(74)
        @m.NxtLn+2,1 SAY SPACE(74)
        
        DO CASE
            CASE FieldType[m.InDDX] = "N" .OR. FieldType[m.InDDX] = "F"
               @m.NxtLn,0 SAY "1st column in data file for " + UPPER(FieldName[m.InDDX]) + ;
               " (in DBF:" + ALLTRIM(FieldType[m.InDDX]) + ;
               ALLTRIM(STR(Flength[m.InDDX],3)) + ;
               "." + ALLTRIM(STR(DecPoint[m.InDDX],3)) + ")"
     
           CASE FieldType[m.InDDX] = "C" 
               @m.NxtLn,0 SAY "1st column in data file for " + UPPER(FieldName[m.InDDX]) + ;
               " (in DBF:" + ALLTRIM(FieldType[m.InDDX]) + ;
               ALLTRIM(STR(Flength[m.InDDX],3)) + ")"
           
            CASE FieldType[m.InDDX] = "D" .OR. ;
                 FieldType[m.InDDX] = "L" .OR. FieldType[m.InDDX] = "M"
               @m.NxtLn,0 SAY "1st column in data file for " + UPPER(FieldName[m.InDDX]) + ;
               " (in DBF:" + ALLTRIM(FieldType[m.InDDX]) + ")"
         ENDCASE
            
         @m.NxtLn,52 GET BeginCol[m.InDDX] PICTURE "9999"
         READ
         IF BeginCol[m.InDDX] < 0 
            WAIT WINDOW "Illegal Value Specified For Beginning Column."
            LOOP
         ENDIF
         IF FieldType[m.InDDX] # "L" .AND. BeginCol[m.InDDX] # 0
            IF Flength[m.InDDX] # 1
               @m.NxtLn,57 SAY "End:" GET EndCol[m.InDDX] PICTURE "9999"
               READ 
             ELSE
               EndCol[m.InDDX] = BeginCol[m.InDDX]
            ENDIF         
            IF EndCol[m.InDDX] < 1 .OR. EndCol[m.InDDX] < BeginCol[m.InDDX]
               WAIT WINDOW "Illegal Value Specified For Ending Column."
               LOOP
            ENDIF
            IF (EndCol[m.InDDX] - BeginCol[m.InDDX] + 1) > Flength[m.InDDX] .AND. ;
               FieldType[m.InDDX] # "D" .AND. FieldType[m.InDDX] # "M" .AND. ;
               FieldType[m.InDDX] # "N" .AND. FieldType[m.InDDX] # "F"
               WAIT WINDOW "DBF Field Not Long Enough For Data Specified."
               LOOP
            ENDIF
          ELSE 
            EndCol[m.InDDX] = BeginCol[m.InDDX]
         ENDIF
         EXIT
      ENDDO
   ENDFOR

*** Give user a chance to correct columnar position of data
*** Again, we must stay within the confines of the window.

   @m.SaveNxtLn,0 SAY "   CHECK THESE POSITIONS. CORRECT IF REQUIRED. CTRL W WHEN DONE.  " COLOR R/W

   FOR m.DBfld = 1 TO m.InDDX STEP (20 - m.SaveNxtLn)
      FOR m.EmptyLine = m.SaveNxtLn+1 TO 20
         @m.EmptyLine,0 SAY SPACE(74)
      ENDFOR
      m.JJX = 0
      FOR m.JJ = m.SaveNxtLn+1 TO 20
         m.JJX = m.JJX + 1
         IF .NOT. EMPTY(FieldName[m.DBfld+m.JJX-1]) .AND. ;
            .NOT. "!" $ FieldName[m.DBfld+m.JJX-1] .AND. ;
            (m.DBfld+m.JJX-1) <= m.InDDX
            @ m.JJ,0  SAY "1st column in data file for "
            @ m.JJ,28 SAY PADR(UPPER(FieldName[m.DBfld+m.JJX-1]),10) + SPACE(13) ;
                    GET BeginCol[m.DBfld+m.JJX-1] PICTURE "9999"
            @ m.JJ,57 SAY "End:"
            @ m.JJ,62 SAY SPACE(1) ;
                    GET EndCol[m.DBfld+m.JJX-1] PICTURE "9999"
         ENDIF
      ENDFOR
      READ CYCLE
   
*** Check that the corrections haven't resulted in illegal field sizes

      DO WHILE .T.
         m.JJX = 0
         FOR m.JJ = m.SaveNxtLn+1 TO 20
            m.JJX = m.JJX + 1
            IF .NOT. EMPTY(FieldName[m.DBfld+m.JJX-1]) .AND. ;
               .NOT. "!" $ FieldName[m.DBfld+m.JJX-1] .AND. ;
               (m.DBfld+m.JJX-1) <= m.InDDX .AND. FieldType[m.DBfld+m.JJX-1] # "M" ;
		 .AND. FieldType[m.DBfld+m.JJX-1] # "D"              
               IF ((EndCol[m.DBfld+m.JJX-1] - BeginCol[m.DBfld+m.JJX-1] + 1) > ;
                  Flength[m.DBfld+m.JJX-1]) .OR. ;
                  (EndCol[m.DBfld+m.JJX-1] < BeginCol[m.DBfld+m.JJX-1])
                  @ m.JJ,28 SAY PADR(UPPER(FieldName[m.DBfld+m.JJX-1]),10) + SPACE(13) ;
                          GET BeginCol[m.DBfld+m.JJX-1] PICTURE "9999"
                  @ m.JJ,39 SAY "Max Size:" + ;
                              TRANSFORM(Flength[m.DBfld+m.JJX-1],"9999") COLOR R/N
                  @ m.JJ,62 SAY SPACE(1) ;
                          GET EndCol[m.DBfld+m.JJX-1] PICTURE "9999"
                  READ
               ENDIF
            ENDIF
         ENDFOR
         m.StillWrong = 0
         FOR m.EmptyLine = m.SaveNxtLn+1 TO 20
           @m.EmptyLine,38 SAY SPACE(13)
         ENDFOR
         m.KKX = 0
         FOR m.KK = m.SaveNxtLn+1 TO 20
            m.KKX = m.KKX + 1
	        IF .NOT. EMPTY(FieldName[m.DBfld+m.KKX-1]) .AND. ;
               .NOT. "!" $ FieldName[m.DBfld+m.KKX-1] .AND. ;
               (m.DBfld+m.KKX-1) <= m.InDDX .AND. FieldType[m.DBfld+m.KKX-1] # "M" ;
                .AND. FieldType[m.DBfld+m.KKX-1] # "D"
               IF ((EndCol[m.DBfld+m.KKX-1] - BeginCol[m.DBfld+m.KKX-1] + 1) > ;
                  Flength[m.DBfld+m.KKX-1]) .OR. ;
                  (EndCol[m.DBfld+m.KKX-1] < BeginCol[m.DBfld+m.KKX-1])
                  m.StillWrong = 1
                  EXIT
               ENDIF
            ENDIF
         ENDFOR
         IF m.StillWrong = 1
            LOOP
         ENDIF
         EXIT
      ENDDO
   ENDFOR
ENDIF

*** Now build the records to the DBF.

DEACTIVATE WINDOW MainWindow

IF _DOS
	DEFINE WINDOW MainWindow FROM 0,0 TO 23,74 ;
  	TITLE "NOW APPENDING RECORDS FROM THE ASCII FILE TO THE DBF"
 ELSE
	DEFINE WINDOW MainWindow	AT 1,0 ;
								SIZE 32,70 ;
	   TITLE "NOW APPENDING RECORDS FROM THE ASCII FILE TO THE DBF";
	  							STYLE "B" ;
	  							FONT "foxfont",9 ;
	   							FLOAT ;
	   							NOCLOSE ;
	   							MINIMIZE ;
	   							SYSTEM ;
	   							COLOR RGB(,,,192,192,192)
ENDIF
MOVE WINDOW MainWindow CENTER  	

ACTIVATE WINDOW MainWindow         

m.DBFshort = SUBSTR(m.DBFname,1,AT(".",m.DBFname))
m.TextFromFile = ""
m.Fname        = ""
m.RecCount     = 0
FOR m.EmptyLine = 0 TO 20
   @m.EmptyLine,0 SAY SPACE(74)
ENDFOR
IF _DOS
   @ 17,1 SAY "The program will now append the records in the flat file to the DBF"
 ELSE
   @ 17,1 SAY "The program will now append the records in the flat file to the DBF";
   		FONT "Arial", 10;
   		STYLE "BT"
ENDIF 
m.NonPrint = "N"
IF _DOS
   @ 18,1 SAY "Check for non-printable characters? (Y/N): " ;
          GET m.NonPrint PICTURE "!" VALID m.NonPrint = "Y" .OR. ;
                                           m.NonPrint = "N"
 ELSE
   @ 19,1 SAY "Check for non-printable characters? (Y/N): " ;
   			FONT "Arial", 10 ;
   			STYLE "BT"
   @ 19,35 GET m.NonPrint ;
   			FONT "Courier New", 10 ;
   			STYLE "B" ;
   			PICTURE "@K !" ;
   			VALID m.NonPrint = "Y" .OR. m.NonPrint = "N"
ENDIF 
READ

DO WHILE .NOT. FEOF(m.DataFileIn)
   m.RecCount = m.RecCount + 1
   IF MOD(m.RecCount,100) = 0
      IF _DOS
         @19,5 SAY STR(m.RecCount,6) + " Records built to " + UPPER(m.DBFname)
       ELSE
       	 @21,5 SAY SPACE(60)
         @21,5 SAY STR(m.RecCount,6) + " Records built to " + UPPER(m.DBFname);
         		FONT "Arial", 10 ;
         		STYLE "BT"       
      ENDIF
   ENDIF

   IF m.CrLf = "Y"   
      m.TextFromFile = FGETS(m.DataFileIn,9999)
    ELSE
      m.TextFromFile = FREAD(m.DataFileIn,m.RecSize)
   ENDIF

*** Replace non-printable characters with space.

   IF m.NonPrint = "Y"
      m.SaveText = ""
      FOR m.CharSearch = 1 TO LEN(m.TextFromFile)
         IF BETWEEN(ASC(SUBSTR(m.TextFromFile,m.CharSearch,1)),0,6) .OR. ;
            BETWEEN(ASC(SUBSTR(m.TextFromFile,m.CharSearch,1)),14,31) .OR. ;
            BETWEEN(ASC(SUBSTR(m.TextFromFile,m.CharSearch,1)),129,255) .OR. ;
            ASC(SUBSTR(m.TextFromFile,m.CharSearch,1)) = 8
            m.SaveText = m.SaveText + CHR(32)
          ELSE
            m.SaveText = m.SaveText + SUBSTR(m.TextFromFile,m.CharSearch,1)
         ENDIF
      ENDFOR
      m.TextFromFile = m.SaveText
   ENDIF
   
   APPEND BLANK
   FOR m.DBfld = 1 TO m.InDDX
      m.Fname = FieldName[m.DBfld]

      DO CASE
         CASE FieldType[m.DBfld] = "C" .AND. BeginCol[m.DBfld] > 0
            REPLACE (m.Fname) WITH SUBSTR(m.TextFromFile, BeginCol[m.DBfld], ;
                                   (EndCol[m.DBfld]-BeginCol[m.DBfld]+1))

         CASE FieldType[m.DBfld] = "M" .AND. BeginCol[m.DBfld] > 0
            REPLACE (m.Fname) WITH ALLTRIM(SUBSTR(m.TextFromFile, BeginCol[m.DBfld], ;
                                   (EndCol[m.DBfld]-BeginCol[m.DBfld]+1)))
      
         CASE FieldType[m.DBfld] = "D" .AND. BeginCol[m.DBfld] > 0
         	UnDigit = 0 
         	SaveXdate = ALLTRIM(SUBSTR(m.TextFromFile, BeginCol[m.DBfld], ;
                                   (EndCol[m.DBfld]-BeginCol[m.DBfld]+1)))
              SaveXend = LEN(SaveXdate)
              FOR ColCnt = 1 TO SaveXend
              	IF .NOT. ISDIGIT(SUBSTR(SaveXdate,ColCnt,1))
              		UnDigit = 1
              		EXIT
              	ENDIF
              ENDFOR
              IF UnDigit = 1
	            REPLACE (m.Fname) WITH CTOD(SUBSTR(m.TextFromFile, BeginCol[m.DBfld], ;
                                   (EndCol[m.DBfld]-BeginCol[m.DBfld]+1)))
              ENDIF
 		      IF UnDigit = 0 .AND. SaveXend = 6
	            REPLACE (m.Fname) WITH CTOD( ;
	            		SUBSTR(m.TextFromFile, BeginCol[m.DBfld],2) +  "/" + ;
	            		SUBSTR(m.TextFromFile, BeginCol[m.DBfld] + 2,2) +  "/" + ;
	            		SUBSTR(m.TextFromFile, BeginCol[m.DBfld] + 4,2))	            			            		
              ENDIF
		      IF UnDigit = 0 .AND. SaveXend = 8
	            REPLACE (m.Fname) WITH CTOD( ;
	            		SUBSTR(m.TextFromFile, BeginCol[m.DBfld],2) +  "/" + ;
	            		SUBSTR(m.TextFromFile, BeginCol[m.DBfld] + 2,2) +  "/" + ;
	            		SUBSTR(m.TextFromFile, BeginCol[m.DBfld] + 4,4))	            			            		
              ENDIF

         CASE FieldType[m.DBfld] = "N" .OR. FieldType[m.DBfld] = "F" ;
              .AND. BeginCol[m.DBfld] > 0

            *** Look for commas in number fields, and remove them

            m.FieldToDBF = ""
            m.FieldToDBF = SUBSTR(m.TextFromFile, BeginCol[m.DBfld], ;
                                   (EndCol[m.DBfld]-BeginCol[m.DBfld]+1))
            m.FieldToDBF = STRTRAN(m.FieldToDBF,",","")                          
            REPLACE (m.Fname) WITH VAL(m.FieldToDBF)

         CASE FieldType[m.DBfld] = "L" .AND. BeginCol[m.DBfld] > 0
            IF ((SUBSTR(UPPER(m.TextFromFile), BeginCol[m.DBfld], ;
               (EndCol[m.DBfld]-BeginCol[m.DBfld]+1)) # "F") .AND. ;
               (SUBSTR(UPPER(m.TextFromFile), BeginCol[m.DBfld], ;
               (EndCol[m.DBfld]-BeginCol[m.DBfld]+1)) # "T") .AND. ;
               (SUBSTR(UPPER(m.TextFromFile), BeginCol[m.DBfld], ;
               (EndCol[m.DBfld]-BeginCol[m.DBfld]+1)) # "Y") .AND. ;
               (SUBSTR(UPPER(m.TextFromFile), BeginCol[m.DBfld], ;
               (EndCol[m.DBfld]-BeginCol[m.DBfld]+1)) # "N")) 
               REPLACE (m.Fname) WITH .F.
            ENDIF                        
            IF (SUBSTR(m.TextFromFile, BeginCol[m.DBfld], ;
               (EndCol[m.DBfld]-BeginCol[m.DBfld]+1)) = "F") .OR. ;
               (SUBSTR(m.TextFromFile, BeginCol[m.DBfld], ;
               (EndCol[m.DBfld]-BeginCol[m.DBfld]+1)) = "N") 
	           REPLACE (m.Fname) WITH .F.
            ENDIF
            IF (SUBSTR(m.TextFromFile, BeginCol[m.DBfld], ;
               (EndCol[m.DBfld]-BeginCol[m.DBfld]+1)) = "T") .OR. ;
               (SUBSTR(m.TextFromFile, BeginCol[m.DBfld], ;
               (EndCol[m.DBfld]-BeginCol[m.DBfld]+1)) = "Y") 
               REPLACE (m.Fname) WITH .T.
            ENDIF

         CASE FieldType[m.DBfld] = "L" .AND. BeginCol[m.DBfld] = 0
            REPLACE (m.Fname) WITH .F.
   
      ENDCASE
      
   ENDFOR
ENDDO         

IF _DOS
   @19,5 SAY STR(m.RecCount,6) + " Records built to " + UPPER(m.DBFname)
 ELSE
   @21,5 SAY SPACE(60)   
   @21,5 SAY STR(m.RecCount,6) + " Records built to " + UPPER(m.DBFname);
   		FONT "Arial", 10 ;
   		STYLE "BT" 
ENDIF
=FCLOSE(m.DataFileIn)

*** Save the BeginCol, EndCol sequence (if desired)

WAIT WINDOW

DoPreset = " "
IF .NOT. Preset
    IF _DOS
	  @14,5 SAY "A PRESET is a DBF that stores Begin and End columns"
	  @15,5 SAY "Do you want to create a PRESET? " GET DoPreset
	ELSE
	  @24,1 SAY "A PRESET is a DBF that stores Begin and End columns" ;
	  		FONT "Arial", 10 ;
	  		STYLE "BT"
	  @26,1 SAY "Do you want to create a PRESET? " ;
	  		FONT "Arial", 10 ;
	  		STYLE "BT"
	  @26,30 GET DoPreset ;
	  		FONT "Courier New", 10 ;
	  		STYLE "B" ;
	  		PICTURE "@K !"
    ENDIF	
	READ
	DoPreset = SUBSTR(ALLTRIM(UPPER(DoPreset)),1,1)
ENDIF

DEACTIVATE WINDOW MainWindow

IF DoPreset == "Y"
   IF _DOS
    	DEFINE WINDOW MainWindow FROM 0,0 TO 23,74 ;
    	TITLE "NOW CREATING A PRESET OF BEGIN, END COLUMNS"
    ELSE
    	DEFINE WINDOW MainWindow	AT 1,0 ;
    								SIZE 32,70 ;
	      TITLE "NOW CREATING A PRESET OF BEGIN, END COLUMNS";
	    							STYLE "B" ;
	  	    						FONT "foxfont",9 ;
	   		    					FLOAT ;
	   		    					NOCLOSE ;
	   			    				MINIMIZE ;
	   				    			SYSTEM ;
	   					    		COLOR RGB(,,,192,192,192)
   ENDIF
   MOVE WINDOW MainWindow CENTER	  	
   
   ACTIVATE WINDOW MainWindow         

   m.NxtLn = 3
   DO WHILE .T.
      m.StColName = GETFILE("DBF","PRESET file name", ;
                            "Select",1)
      IF EMPTY(m.StColName)
         Exit
      ENDIF
      IF "Untitled" $ m.StColName
         DO WHILE .T.
            m.StColName = SPACE(45)
            @ m.NxtLn,1 SAY "Name For The Preset To Be Created:" 
            m.NxtLn = m.NxtLn + 1
            @ m.NxtLn,1 GET m.StColName
            READ
            IF EMPTY(m.StColName)
               LOOP
            ENDIF
            IF AT(".",m.StColName) = 0
               m.StColName = ALLTRIM(m.StColName) + ".DBF"
            ENDIF
            m.Fexists = ADIR(TempArray,m.StColName)
            IF m.Fexists > 0
               WAIT WINDOW ;
               "This File Already Exists. Do you want to overwrite it (Y/N):";
               TO m.Answer
               IF "N" $ SUBSTR(ALLTRIM(UPPER(m.Answer)),1,1)
                  LOOP
                ELSE
                  DELETE FILE (m.StColName)
                  DELETE FILE ((SUBSTR(m.StColName, 1, AT(".",m.StColName)) + "FPT"))
               ENDIF
            ENDIF
            EXIT
         ENDDO
      ENDIF
      
      m.BadName = 0
      
      *** Check for legal file name, except when on a MAC
      
      IF .NOT. _MAC
         FOR m.DbLetter = 1 TO LEN(ALLTRIM(m.StColName))
            IF .NOT. BETWEEN(SUBSTR(UPPER(m.StColName),m.DbLetter,1),"A","Z") .AND. ;
               .NOT. BETWEEN(SUBSTR(UPPER(m.StColName),m.DbLetter,1),"0","9") .AND. ;
               .NOT. SUBSTR(m.StColName,m.DbLetter,1) = "." .AND. ;
               .NOT. SUBSTR(m.StColName,m.DbLetter,1) = "\" .AND. ;
               .NOT. SUBSTR(m.StColName,m.DbLetter,1) = "_" .AND. ;
               .NOT. SUBSTR(m.StColName,m.DbLetter,1) = ":" 
               WAIT WINDOW " Illegal File Name."
               m.NxtLn = m.NxtLn - 1
               m.BadName = 1
               EXIT
            ENDIF
         ENDFOR
      ENDIF
      IF m.BadName = 1
         LOOP
      ENDIF
      IF AT(".",m.StColName) = 0
         m.StColName = ALLTRIM(m.DBFname) + ".DBF"
      ENDIF
      m.NxtLn = m.NxtLn + 1
      EXIT
   ENDDO   

   CREATE TABLE (m.StColName) (StartColum N(8,0), EndColumn N(8,0))
   IF .NOT. USED (m.StColName)
	   USE (m.StColName) IN 0 AGAIN
   ENDIF 
   FOR MMM = 1 TO m.NumFields
	   APPEND BLANK
	   REPLACE STARTCOLUM WITH BeginCol[MMM]
	   REPLACE ENDCOLUMN WITH EndCol[MMM]	
   ENDFOR
ENDIF

RETURN


***
*** Delimited Format Records To DBF
***

PROCEDURE DelimFile

IF _DOS
	DEFINE WINDOW MainWindow FROM 0,0 TO 23,74 ;
	TITLE "ASCTODBF-V1.5b. BUILDING DATA TO THE DBF"
 ELSE
	DEFINE WINDOW MainWindow	AT 1,0 ;
								SIZE 32,70 ;
	   TITLE "ASCTODBF-V1.5b. BUILDING DATA TO THE DBF";
	  							STYLE "B" ;
	  							FONT "foxfont",9 ;
	   							FLOAT ;
	   							NOCLOSE ;
	   							MINIMIZE ;
	   							SYSTEM ;
	   							COLOR RGB(,,,192,192,192)
ENDIF
MOVE WINDOW MainWindow CENTER
		
ACTIVATE WINDOW MainWindow         

*** Ask for Separator and Delimiter

m.IsComma = ""
m.IsQuote = '"'
IF _DOS
   @2,0 SAY "If separator btwn fields is a TAB, type TAB char,then CtrlTAB to go on."
 ELSE
   @2,1 SAY "If separator between fields is a TAB, type TAB character, then CtrlTAB to continue.";
   		FONT "Arial", 10;
   		STYLE "BT"
ENDIF
IF _DOS 
   @3,0 SAY "Separator character between fields: "
 ELSE
   @4,1 SAY "Separator character between fields: " ;
   		FONT "Arial", 10;
   		STYLE "BT"
ENDIF  
IF _DOS
   @3,42 EDIT m.IsComma SIZE 1,2 TAB COLOR W/G
 ELSE
   @4,35 EDIT m.IsComma SIZE 1,2 TAB COLOR W/G
ENDIF 
READ
IF _DOS
   @4,0 SAY "Delimiter character for text:            " Get m.IsQuote
 ELSE
   @6,1 SAY "Delimiter character for text:" ;
   		FONT "Arial", 10 ;
   		STYLE "BT"
   @6,35 Get m.IsQuote ;
   		FONT "Courier New", 10 ;
   		STYLE "B" ;
   		PICTURE "@K X"
ENDIF   		
READ

m.KeepCR = "R"
IF _DOS
   @5,0 SAY "If embedded CR is found in alphanumeric fields,"
   @6,0 SAY "do you want to Strip or Retain them (S/R): " ;
     GET m.KeepCR PICTURE "!" VALID m.KeepCR = "S" .OR. ;
                                  m.KeepCR = "R"
 ELSE
   @8,1 SAY "If embedded CR is found in alphanumeric fields,";
   		FONT "Arial", 10 ;
   		STYLE "BT"
   @10,1 SAY "do you want to Strip or Retain them (S/R): " ;
   		FONT "Arial", 10 ;
   		STYLE "BT"
   @10,35 GET m.KeepCR ;
   		FONT "Courier New", 10;
   		STYLE "B" ;
   		PICTURE "@K !" ;
   		VALID m.KeepCR = "S" .OR. m.KeepCR = "R"
ENDIF 
READ
   
m.NonPrint = "N"
IF _DOS
   @ 7,0 SAY "Check for non-printable characters? (Y/N): " ;
         GET m.NonPrint PICTURE "!" VALID m.NonPrint = "Y" .OR. ;
                                          m.NonPrint = "N"
 ELSE
   @ 12,1 SAY "Check for non-printable characters? (Y/N): " ;
        FONT "Arial", 10 ;
        STYLE "BT"
   @ 12,35 GET m.NonPrint ;
   		FONT "Courier New", 10 ;
   		STYLE "B" ;
   		PICTURE "@K !" ;
   		VALID m.NonPrint = "Y" .OR. m.NonPrint = "N"
ENDIF
READ

IF _DOS
   FOR PK = 0 TO 20
      @ PK,0 SAY SPACE(74)
   ENDFOR
ELSE
   FOR PK = 0 TO 30
      @ PK,0 SAY SPACE(74)
   ENDFOR
ENDIF   

IF _DOS
   @ 2,0 SAY "The next 2 questions concern the layout of the data in the ASCII file."
   @ 4,0 SAY "1. If you do not want to start building the DBF with the first data"
   @ 5,0 SAY "   element in the records of the ASCII file, indicate so below."
   @ 6,0 SAY "2. If the data record occupies more than 1 'line' (has CR/LFs between"
   @ 7,0 SAY "   data elements) indicate how many lines are occupied by each record."
   @ 8,0 SAY " "
   @ 9,0 SAY "   If CR/LFs exist WITHIN a data element (within the delimiters for"
   @10,0 SAY "   a field), and there are no CR/LFs BETWEEN data elements, the record"
   @11,0 SAY "   is considered to occupy only 1 line in the data file."
   @12,0 SAY " "
   @13,0 SAY "   If the data record occupies more than 1 line (2. above), it can only"
   @14,0 SAY "   build the DBF starting with the FIRST data element in the record."  
 ELSE
   @ 0,0 SAY "The next 2 questions concern the layout of the data in the ASCII file." ;
        FONT "Arial", 10 ;
        STYLE "BT"   
   @ 3,0 SAY "1. If you do not want to start building the DBF with the first data" ;
        FONT "Arial", 10 ;
        STYLE "BT"   
   @ 5,0 SAY "   element in the records of the ASCII file, indicate so below." ;
        FONT "Arial", 10 ;
        STYLE "BT"   
   @ 7,0 SAY "2. If the data record occupies more than 1 'line' (has CR/LFs between" ;
        FONT "Arial", 10 ;
        STYLE "BT"   
   @ 9,0 SAY "   data elements) indicate how many lines are occupied by each record." ;
        FONT "Arial", 10 ;
        STYLE "BT"   
   @11,0 SAY " "
   @13,0 SAY "   If CR/LFs exist WITHIN a data element (within the delimiters for" ;
        FONT "Arial", 10 ;
        STYLE "BT"   
   @15,0 SAY "   a field), and there are no CR/LFs BETWEEN data elements, the record" ;
        FONT "Arial", 10 ;
        STYLE "BT"   
   @17,0 SAY "   is considered to occupy only 1 line in the data file." ;
        FONT "Arial", 10 ;
        STYLE "BT"   
   @19,0 SAY " "
   @21,0 SAY "   If the data record occupies more than 1 line (2. above), it can only" ;
        FONT "Arial", 10 ;
        STYLE "BT"   
   @23,0 SAY "   build the DBF starting with the FIRST data element in the record."  ;
        FONT "Arial", 10 ;
        STYLE "BT"   
ENDIF
 
m.StartField = 1
IF _DOS
   @ 16,0 SAY "Starting data element in the ASCII records (Usually 1): " ;
         GET m.StartField PICTURE "999" VALID m.StartField > 0
 ELSE
   @ 26,1 SAY "Starting data element in the ASCII records (Usually 1): " ;
   		FONT "Arial", 10 ;
   		STYLE "BT"
   @ 26,60 GET m.StartField ;
   		FONT "Courier New", 10 ;
   		STYLE "B" ;
   		PICTURE "@K 999" ;
   		VALID m.StartField > 0
ENDIF 
* READ      

m.LinesPerRec = 1
IF _DOS
   @ 17,0 SAY "Number of 'lines' for one record in the data file (Usually 1): " ;
         GET m.LinesPerRec PICTURE "999" VALID m.LinesPerRec > 0
 ELSE
   @ 28,1 SAY "Number of 'lines' for one record in the data file (Usually 1): " ;
   		FONT "Arial", 10 ;
   		STYLE "BT"
   @ 28,60 GET m.LinesPerRec ;
   		FONT "Courier New", 10 ;
   		STYLE "B" ;
   		PICTURE "@K 999" ;
   		VALID m.LinesPerRec > 0
ENDIF 
READ      

*** If m.StartField > 1, we need to shorten the ASCII record.
*** The simplest way to do this is to write shortened records
*** to a new file.
*** There is a built-in problem with doing this: if there is a memo
*** field that has CRs in it, and the memo field is part of the fields
*** that need to be written out, this section will fail to act correctly.

IF m.StartField > 1
   IF _DOS
      FOR PK = 0 TO 20
         @ PK,0 SAY SPACE(74)
      ENDFOR
      @ 9,0 SAY "The program will now create a new input file that has shortened"
      @10,0 SAY "records in it.  If the part of the record that is going to be"
      @11,0 SAY "used contains data for a Memo field, AND has embedded CRs,"
      @12,0 SAY "this section will not work correctly."
      @13,0 SAY "If the above is the case, you need to create your own input file"
      @14,0 SAY "with the exact number of fields per record for building to the DBF."
      m.Proceed = "Y"
      @16,0 SAY "Continue (Y/N)? " GET m.Proceed ;
                                   PICTURE "!" ;
                                   VALID m.Proceed == "Y" .OR. m.Proceed == "N"
    ELSE
      FOR PK = 0 TO 30
         @ PK,0 SAY SPACE(74)
      ENDFOR
      @2,1 SAY "The program will now create a new input file that has shortened";
      		FONT "Arial", 10 ;
      		STYLE "BT"
      @4,1 SAY "records in it.  If the part of the record that is going to be";
         	FONT "Arial", 10 ;
      		STYLE "BT"
      @6,1 SAY "used contains data for a Memo field, AND has embedded CRs,";
         	FONT "Arial", 10 ;
      		STYLE "BT"
      @8,1 SAY "this section will not work correctly.";
         	FONT "Arial", 10 ;
      		STYLE "BT"
      @10,1 SAY "If the above is the case, you need to create your own input file";
         	FONT "Arial", 10 ;
      		STYLE "BT"
      @12,1 SAY "with the exact number of fields per record for building to the DBF.";
         	FONT "Arial", 10 ;
      		STYLE "BT"
      m.Proceed = "Y"
      @14,1 SAY "Continue (Y/N)? ";
         	FONT "Arial", 10 ;
      		STYLE "BT"
      @14,15 GET m.Proceed ;
      		FONT "Courier New", 10 ;
      		STYLE "B" ;
            PICTURE "@K !" ;
            VALID m.Proceed == "Y" .OR. m.Proceed == "N"
   ENDIF 
   READ                                
   IF m.Proceed == "N"
      DO ExitRoutine
   ENDIF                                

   m.NewDfile = "D()()()(.)()"

   m.TextFromFile = ""
   m.AsciiText = ""
   m.BeenToAdd = 0
   m.FoundQuote = 0
   m.FoundComma = 0
   m.FieldData = ""
   m.RecCount = 0
   m.KK = 0

   m.DataFileIn = FOPEN(m.DataFile)
   m.DataFileOut = FCREATE(m.NewDfile)
   
   DO WHILE .NOT. FEOF(m.DataFileIn)
      m.AsciiText = ALLTRIM(FGETS(m.DataFileIn,9999))
      m.KK = 1
      
*** We'll assume no more than 999 fields per record in the ASCII file
      
      FOR m.InDDX = 1 TO 999   
         DO WHILE .T.
            FOR m.JJ = m.KK TO LEN(m.AsciiText)
               IF SUBSTR(m.AsciiText,m.JJ,1) = m.IsQuote
                  m.FoundQuote = m.FoundQuote + 1
                  IF m.FoundQuote = 2
                     m.FoundQuote = 0
                     m.FoundComma = 0
                     IF m.InDDX = m.StartField-1
                        m.AsciiText = ;
                         SUBSTR(m.AsciiText,m.JJ+1,LEN(m.AsciiText)-(m.JJ+1)+1)
                        =FPUTS(m.DataFileOut,m.AsciiText)
                        m.FieldData = ""
                        EXIT
                     ENDIF
                     IF m.InDDX # m.StartField-1
                        m.FieldData = ""
                     ENDIF
                     m.KK = m.JJ + 1
                     EXIT
                  ENDIF
               ENDIF
               IF SUBSTR(m.AsciiText,m.JJ,1) = m.IsComma .AND. m.FoundQuote = 0
                  m.FoundComma = m.FoundComma + 1
                  IF m.FoundComma = 2 .OR. (m.FoundComma = 1 .AND. ;
                                          .NOT. EMPTY(m.FieldData))
                     m.FoundComma = 0
                     m.FoundQuote = 0
                     IF m.InDDX = m.StartField-1
                        m.AsciiText = ;
                         SUBSTR(m.AsciiText,m.JJ+1,LEN(m.AsciiText)-(m.JJ+1)+1)
                        =FPUTS(m.DataFileOut,m.AsciiText)
                        m.FieldData = ""
                        EXIT
                     ENDIF
                     IF m.InDDX # m.StartField-1
                        m.FieldData = ""
                     ENDIF
                     m.KK = m.JJ + 1
                     EXIT
                  ENDIF
               ENDIF
               IF SUBSTR(m.AsciiText,m.JJ,1) = m.IsComma .AND. m.FoundQuote = 1
                  m.FieldData= m.FieldData + SUBSTR(m.AsciiText,m.JJ,1)
               ENDIF
               IF SUBSTR(m.AsciiText,m.JJ,1) # m.IsQuote .AND.  ;
                  SUBSTR(m.AsciiText,m.JJ,1) # m.IsComma
                  m.FieldData = m.FieldData + SUBSTR(m.AsciiText,m.JJ,1)
               ENDIF
            ENDFOR
            IF m.InDDX = m.StartField-1
               EXIT
            ENDIF
            IF m.JJ >= LEN(m.AsciiText) .AND.  m.FoundQuote = 1
               m.AsciiText = ALLTRIM(FGETS(m.DataFileIn,9999))
               m.KK = 1
               m.FoundComma = 0
               IF m.KeepCR = "R"
                  m.FieldData = m.FieldData + CHR(13) 
               ENDIF
               LOOP
            ENDIF
            EXIT
         ENDDO
         IF m.InDDX = m.StartField-1
            EXIT
         ENDIF
      ENDFOR
   ENDDO
   =FCLOSE(m.DataFileIn)
   =FCLOSE(m.DataFileOut)
   m.NewDfile = "D()()()(.)()"
   m.DataFile = m.NewDfile
ENDIF

*** Ready to start disecting the ASCII record

m.TextFromFile = ""
m.AsciiText = ""
m.BeenToAdd = 0
m.FoundQuote = 0
m.FoundComma = 0
m.FieldData = ""
m.RecCount = 0
m.KK = 0


USE (m.DBFname) IN 0
m.NumFields = AFIELDS(DBFfield)

m.DataFileIn = FOPEN(m.DataFile)

DO WHILE .NOT. FEOF(m.DataFileIn)
   m.AsciiText = ""
   FOR NLperRec = 1 TO LinesPerRec
      m.AsciiText = m.AsciiText + ALLTRIM(FGETS(m.DataFileIn,9999))
   ENDFOR

*** Replace non-printable characters with space.

   IF m.NonPrint = "Y"
      m.SaveText = ""
      FOR m.CharSearch = 1 TO LEN(m.AsciiText)
         IF BETWEEN(ASC(SUBSTR(m.AsciiText,m.CharSearch,1)),0,6) .OR. ;
            BETWEEN(ASC(SUBSTR(m.AsciiText,m.CharSearch,1)),14,31) .OR. ;
            BETWEEN(ASC(SUBSTR(m.AsciiText,m.CharSearch,1)),129,255) .OR. ;
            ASC(SUBSTR(m.AsciiText,m.CharSearch,1)) = 8
            m.SaveText = m.SaveText + CHR(32)
          ELSE
            m.SaveText = m.SaveText + SUBSTR(m.AsciiText,m.CharSearch,1)
         ENDIF
      ENDFOR
      m.AsciiText = m.SaveText
   ENDIF
   
   m.KK = 1
   m.RecCount = m.RecCount + 1
   IF MOD(m.RecCount,100) = 0
      IF _DOS
         FOR PK = 0 TO 20
            @ PK,0 SAY SPACE(74)
         ENDFOR
      ELSE
         FOR PK = 0 TO 30
            @ PK,0 SAY SPACE(74)
         ENDFOR
      ENDIF   
      IF _DOS
         @19,5 SAY STR(m.RecCount,6) + " Records built to " + UPPER(m.DBFname)
       ELSE
         @21,5 SAY SPACE(60)       
         @21,5 SAY STR(m.RecCount,6) + " Records built to " + UPPER(m.DBFname);
     	    	FONT "Arial", 10 ;
       		    STYLE "BT"
      ENDIF       
   ENDIF

   FOR m.InDDX = 1 TO m.NumFields   
      FieldName[m.InDDX] = DBFfield[m.InDDX,1]
      FieldType[m.InDDX] = DBFfield[m.InDDX,2]
      Flength[m.InDDX]   = DBFfield[m.InDDX,3]
      DecPoint[m.InDDX]  = DBFfield[m.InDDX,4]
      IF m.InDDX = 1
         APPEND BLANK
      ENDIF

*** Get data for the current field

      DO WHILE .T.
         FOR m.JJ = m.KK TO LEN(m.AsciiText)
            IF SUBSTR(m.AsciiText,m.JJ,1) = m.IsQuote
               m.FoundQuote = m.FoundQuote + 1
               IF m.FoundQuote = 2
                  m.FoundQuote = 0
                  m.FoundComma = 0
                  DO AddField          
                  m.KK = m.JJ + 1
                  EXIT
	           ENDIF
            ENDIF
            
            IF SUBSTR(m.AsciiText,m.JJ,1) = m.IsComma .AND. m.FoundQuote = 0
               m.FoundComma = m.FoundComma + 1
               IF m.FoundComma = 2 .OR. (m.FoundComma = 1 .AND. ;
                                        .NOT. EMPTY(m.FieldData)) ;
                     .OR. (m.FoundComma = 1 .AND. ;
                         substr(m.AsciiText,m.JJ-1,1) = m.IsComma)
              
                  m.FoundComma = 0
                  m.FoundQuote = 0
                  DO AddField
                  m.KK = m.JJ + 1
                  EXIT
               ENDIF
            ENDIF
            
            IF SUBSTR(m.AsciiText,m.JJ,1) = m.IsComma .AND. m.FoundQuote = 1
               m.FieldData= m.FieldData + SUBSTR(m.AsciiText,m.JJ,1)
            ENDIF
            
            IF SUBSTR(m.AsciiText,m.JJ,1) # m.IsQuote .AND.  ;
               SUBSTR(m.AsciiText,m.JJ,1) # m.IsComma
               m.FieldData = m.FieldData + SUBSTR(m.AsciiText,m.JJ,1)
            ENDIF

            IF m.FoundQuote = 0 .AND. m.JJ = LEN(m.AsciiText)
               m.FoundComma = 0
               m.FoundQuote = 0
               DO AddField
               m.KK = m.JJ + 1
               EXIT
            ENDIF
            
         ENDFOR
         
         IF m.JJ >= LEN(m.AsciiText) .AND.  m.FoundQuote = 1
            m.AsciiText = ALLTRIM(FGETS(m.DataFileIn,9999))

*** Replace non-printable characters with space.

            IF m.NonPrint = "Y"
               m.SaveText = ""
               FOR m.CharSearch = 1 TO LEN(m.AsciiText)
                  IF BETWEEN(ASC(SUBSTR(m.AsciiText,m.CharSearch,1)),0,6) .OR. ;
                     BETWEEN(ASC(SUBSTR(m.AsciiText,m.CharSearch,1)),14,31) .OR. ;
                     BETWEEN(ASC(SUBSTR(m.AsciiText,m.CharSearch,1)),129,255) .OR. ;
                     ASC(SUBSTR(m.AsciiText,m.CharSearch,1)) = 8
                     m.SaveText = m.SaveText + CHR(32)
                   ELSE
                     m.SaveText = m.SaveText + SUBSTR(m.AsciiText,m.CharSearch,1)
                  ENDIF
               ENDFOR
               m.AsciiText = m.SaveText
            ENDIF

            m.KK = 1
            m.FoundComma = 0
            IF m.KeepCR = "R"
               m.FieldData = m.FieldData + CHR(13) 
            ENDIF
            LOOP
         ENDIF
         EXIT
      ENDDO
   ENDFOR
ENDDO

IF _DOS
   FOR PK = 0 TO 20
      @ PK,0 SAY SPACE(74)
   ENDFOR
ELSE
   FOR PK = 0 TO 30
      @ PK,0 SAY SPACE(74)
   ENDFOR
ENDIF   

IF _DOS
   @19,5 SAY STR(m.RecCount,6) + " Records built to " + UPPER(m.DBFname)
 ELSE
   @21,5 SAY SPACE(60) 
   @21,5 SAY STR(m.RecCount,6) + " Records built to " + UPPER(m.DBFname);
   		FONT "Arial", 10 ;
   		STYLE "BT"
ENDIF 
=FCLOSE(m.DataFileIn)
WAIT WINDOW 
DEACTIVATE WINDOW MainWindow
IF FILE("D()()()(.)()")
   DELETE FILE "D()()()(.)()"
ENDIF
RETURN

***
*** Add A Field From Delimited File To DBF
***

PROCEDURE AddField

m.Fname = FieldName[m.InDDX]
m.FieldData = ALLTRIM(m.FieldData)
DO CASE
   CASE FieldType[m.InDDX] = "C" .OR. FieldType[m.InDDX] = "M"
      REPLACE (m.Fname) WITH m.FieldData

   CASE FieldType[m.InDDX] = "D"
	UnDigit = 0 
       SaveXend = LEN(m.FieldData)
       FOR ColCnt = 1 TO SaveXend
      		IF .NOT. ISDIGIT(SUBSTR(m.FieldData,ColCnt,1))
			UnDigit = 1
      			EXIT
      		ENDIF
       ENDFOR
       IF UnDigit = 1
		  REPLACE (m.Fname) WITH CTOD(m.FieldData)              
       ENDIF
       IF UnDigit = 0 .AND. SaveXend = 6
		 REPLACE (m.Fname) WITH CTOD( ;
	            		SUBSTR(m.FieldData,1,2) +  "/" + ;
	            		SUBSTR(m.FieldData,3,2) +  "/" + ;
	            		SUBSTR(m.FieldData,5,2))	            			            		
	   ENDIF
	   IF UnDigit = 0 .AND. SaveXend = 8
		  REPLACE (m.Fname) WITH CTOD( ;
	            		SUBSTR(m.FieldData,1,2) +  "/" + ;
	            		SUBSTR(m.FieldData,3,2) +  "/" + ;
	            		SUBSTR(m.FieldData,5,4))	            			            		
	   ENDIF

   CASE FieldType[m.InDDX] = "N" .OR. FieldType[m.InDDX] = "F" 

      *** Look for commas in number fields, and remove them

      m.FieldToDBF = ""
      m.FieldToDBF = m.FieldData
      m.FieldToDBF = STRTRAN(m.FieldToDBF,",","")                          
      REPLACE (m.Fname) WITH VAL(m.FieldToDBF)

   CASE FieldType[m.InDDX] = "L" .AND. (SUBSTR(UPPER(m.FieldData),1,1) = "F" .OR. ;
                           SUBSTR(UPPER(m.FieldData),1,1) = "N")
      REPLACE (m.Fname) WITH .F.
                        
   CASE FieldType[m.InDDX] = "L" .AND. (SUBSTR(UPPER(m.FieldData),1,1) = "T" .OR. ;
                           SUBSTR(UPPER(m.FieldData),1,1) = "Y")
      REPLACE (m.Fname) WITH .T.

ENDCASE                        
m.FieldData = ""
RETURN

***
*** Ruler Routine.
***

PROCEDURE Ruler
m.OneR   = -6
m.TwoR   = -5
m.ThreeR = -4
m.FourR  = -3
FiveR  = -2
m.SixR   = -1
m.SevenR =  0
m.PrintLine = 0

FOR m.EmptyLine = m.NxtLn TO 20
   @m.EmptyLine,1 SAY SPACE(74)
ENDFOR

FOR NumLines = 1 TO LEN(m.FirstLine) STEP 70
   m.PrintLine = m.PrintLine + 1
   
*** We'll only print up to 3 lines of the text.  If there is more, the user
*** needs to know how it is structured.  We just ran out of display room.

   IF m.PrintLine > 3
      FOR m.EmptyLine = m.NxtLn TO 20
         @m.EmptyLine,1 SAY SPACE(74)
      ENDFOR
      EXIT
   ENDIF

   m.OneR   = m.OneR + 7
   m.TwoR   = m.TwoR + 7
   m.ThreeR = m.ThreeR + 7
   m.FourR  = m.FourR + 7
   m.FiveR  = m.FiveR + 7
   m.SixR   = m.SixR + 7
   m.SevenR = m.SevenR + 7

   IF .NOT. _DOS   
      IF LEN(m.FirstLine) > 9
         @m.NxtLn,0  SAY TRANSFORM(m.OneR,"9999999999") COLOR N/W*
      ENDIF
      IF LEN(m.FirstLine) > 19
         @m.NxtLn,10 SAY TRANSFORM(m.TwoR,"9999999999") COLOR N/W*
      ENDIF
      IF LEN(m.FirstLine) > 29
         @m.NxtLn,20 SAY TRANSFORM(m.ThreeR,"9999999999") COLOR N/W*
      ENDIF
      IF LEN(m.FirstLine) > 39
         @m.NxtLn,30 SAY TRANSFORM(m.FourR,"9999999999") COLOR N/W*
      ENDIF
      IF LEN(m.FirstLine) > 49
         @m.NxtLn,40 SAY TRANSFORM(m.FiveR,"9999999999") COLOR N/W*
      ENDIF
      IF LEN(m.FirstLine) > 59
         @m.NxtLn,50 SAY TRANSFORM(m.SixR,"9999999999") COLOR N/W*
      ENDIF
      IF LEN(m.FirstLine) > 69
         @m.NxtLn,60 SAY TRANSFORM(m.SevenR,"9999999999") COLOR N/W*
      ENDIF
 
      m.NxtLn = m.NxtLn + 1
      IF LEN(m.FirstLine) >= 70
         @m.NxtLn,0 SAY "1234567890123456789012345678901234567890123456789012345678901234567890" COLOR N/W*
       ELSE
         FOR m.KK = 1 TO LEN(m.FirstLine)
            LL = MOD(KK,10)
            @m.NxtLn,KK-1 SAY TRANSFORM(LL,"9") COLOR N/W*
         ENDFOR
      ENDIF
      m.NxtLn = m.NxtLn + 1     
      @m.NxtLn,0 SAY SPACE(75)
      @m.NxtLn,0 SAY SUBSTR(m.FirstLine,NumLines,70) COLOR R/W*
      m.NxtLn = m.NxtLn + 1
   ELSE
      IF LEN(m.FirstLine) > 9
         @m.NxtLn,0  SAY TRANSFORM(m.OneR,"9999999999") COLOR N/W
      ENDIF
      IF LEN(m.FirstLine) > 19
         @m.NxtLn,10 SAY TRANSFORM(m.TwoR,"9999999999") COLOR N/W
      ENDIF
      IF LEN(m.FirstLine) > 29
         @m.NxtLn,20 SAY TRANSFORM(m.ThreeR,"9999999999") COLOR N/W
      ENDIF
      IF LEN(m.FirstLine) > 39
         @m.NxtLn,30 SAY TRANSFORM(m.FourR,"9999999999") COLOR N/W
      ENDIF
      IF LEN(m.FirstLine) > 49
         @m.NxtLn,40 SAY TRANSFORM(m.FiveR,"9999999999") COLOR N/W
      ENDIF
      IF LEN(m.FirstLine) > 59
         @m.NxtLn,50 SAY TRANSFORM(m.SixR,"9999999999") COLOR N/W
      ENDIF
      IF LEN(m.FirstLine) > 69
         @m.NxtLn,60 SAY TRANSFORM(m.SevenR,"9999999999") COLOR N/W
      ENDIF
 
      m.NxtLn = m.NxtLn + 1
      IF LEN(m.FirstLine) >= 70
         @m.NxtLn,0 SAY "1234567890123456789012345678901234567890123456789012345678901234567890" COLOR N/W
       ELSE
         FOR m.KK = 1 TO LEN(m.FirstLine)
            LL = MOD(KK,10)
            @m.NxtLn,KK-1 SAY TRANSFORM(LL,"9") COLOR N/W
         ENDFOR
      ENDIF
      m.NxtLn = m.NxtLn + 1     
      @m.NxtLn,0 SAY SPACE(75)
      @m.NxtLn,0 SAY SUBSTR(m.FirstLine,NumLines,70) COLOR R/W
      m.NxtLn = m.NxtLn + 1
   ENDIF
ENDFOR
m.NxtLn = m.NxtLn + 1

RETURN


***
*** User typed An Esc
***

PROCEDURE ExitRoutine
m.OutOfExit = 0
IF m.GetOut # 1
   WAIT WINDOW TO EndProg "Are You Sure That You Want To Exit (Y or N)?"
   IF .NOT. "Y" $ UPPER(ALLTRIM(EndProg))
      m.OutOfExit = 1
      RETURN
   ENDIF
ENDIF
POP KEY ALL

DO CASE
   CASE m.SetCentury = "OFF"
      SET CENTURY OFF
   CASE m.PrevTalk = "ON"
      SET TALK ON
   CASE m.PrevPrint = "ON"
      SET PRINT ON
   CASE m.PrevSafety = "ON"
      SET SAFETY ON
   CASE m.PrevEscape = "ON"
      SET ESCAPE ON
ENDCASE

CLEAR   
RELEASE WINDOW MainWindow
CLOSE DATABASES
CANCEL
