# include <afx.h>
# include <iostream.h>
# include <stdio.h>

class Foo : public CObject
    {
    public:
        Foo()
            {
            n++;
			}

        Foo(const Foo&)
            {
            n++;
			}

        ~Foo()
            {
            cout << "Destroying a Foo at " << (void*) this;
            cout << '\t' << --n << " Foo left" << endl;
            }

    private:
        static int n;

    DECLARE_DYNAMIC(Foo)
    };

int Foo::n;

IMPLEMENT_DYNAMIC(Foo, CObject)

class Bar : public CObject
    {
    public:
        Bar()
            {
            n++;
            SetUnwindObject(); // I have CObject-derived members
            }

        Bar(const Bar&)
            {
            n++;
            SetUnwindObject(); // ditto
            }

        ~Bar()
            {
            cout << "Destroying a Bar at " << (void*) this;
            cout << '\t' << --n << " Bar left" << endl;
            }

        Foo t;

    friend Bar operator +(Bar b1, Bar b2)
        {
        return Bar();
        }

    friend Bar operator -(Bar b1, Bar b2)
        {
        AfxThrowNotSupportedException();
        return Bar();
        }

    private:
        static int n;

    DECLARE_DYNAMIC(Bar)
    };

int Bar::n;

IMPLEMENT_DYNAMIC(Bar, CObject)

void TestTemp()
    {
    Bar b1, b2, b3 = b1 + b2;

    TRY {
        b1 = b2 + b3 - b1;
        }

    CATCH (CException, e)
        {
        }

    END_CATCH
    }

int main()
    {
    Foo f;

    TRY {
        Bar b;
        AfxThrowNotSupportedException();
        }

    CATCH (CException, e)
        {
        }

    END_CATCH

    TestTemp();

    return 0;
    }
