/* File: WORST.C */

/* Written by Dan Lewis and released to the public domain.		*/

/* Compiled using the C-Ware (DeSmet) DC88 compiler and the -px switch	*/
/* Bound (linked) using C-Ware (DeSmet) BIND and the -s2000 switch	*/

typedef unsigned char	BOOL ;
typedef unsigned char	BYTE ;
typedef unsigned int	WORD ;
typedef	long		DUBL ;

#define	FALSE	0
#define	TRUE	1

#define	NULL	((void *) 0)

#define	READ_ONLY	0x01
#define	HIDDEN		0x02
#define	SYSTEM		0x04
#define	VOL_LABEL	0x08
#define	DIR_ENTRY	0x10
#define	ARCHIVE		0x20

#define	FIND_ATTB	(HIDDEN|SYSTEM|DIR_ENTRY)

#define	FIND_FIRST	0x4E
#define	FIND_NEXT	0x4F

typedef struct TIME
	{
	unsigned
	hsec:5,		/* seconds/2 (0-29)	*/
	min:6,		/* minute (0-59)	*/
	hour:5 ;	/* hour (0-23)	*/
	} TIME ;

typedef struct DATE
	{
	unsigned
		day:5,		/* day (1-31)	*/
		month:4,	/* month (1-12)	*/
		year:7 ;	/* year - 1980	*/
	} DATE ;

typedef struct DTA
	{
	char	rsvd[21] ;
	char	attb ;
	TIME	time ;
	DATE	date ;
	long	size ;
	char	name[13] ;
	} DTA ;

typedef struct STAT
	{
	char	*name ;
	char	file[100] ;
	TIME	time ;
	DATE	date ;
	DUBL	size ;
	} STAT ;

#define	NEWER(a, b)	(*((DUBL *) &a.time) > *((DUBL *) &b.time))

BOOL found = FALSE ;
char *slash ;

STAT newest   = {"Newest"} ;
STAT oldest   = {"Oldest"} ;
STAT largest  = {"Largest"} ;
STAT smallest = {"Smallest"} ;

void Set_DTA(DTA *) ;
BOOL Find(BYTE, char *, WORD) ;
void Replace(STAT *, char *, DTA *) ;
void Get_Root(char *, char *) ;
void Header(void) ;
char *Time(TIME *) ;
char *Date(DATE *) ;
void Empty(char *, DTA *) ;
DUBL Search(char *, BOOL) ;
void Display(STAT *) ;
void Clean(char *) ;

void Set_DTA(dta)
DTA *dta ;
	{
#ifndef	_lint
#asm
	mov	ah,1Ah
	mov	dx,#dta
	int	21h
#end
#endif
	}

BOOL Find(mode, spec, attb)
BYTE mode ;
char *spec ;
WORD attb ;
	{
#ifndef	_lint
#asm
	mov	ah,#mode
	xor	al,al
	mov	cx,#attb
	mov	dx,#spec
	int	21h
	mov	ax,0
	jc	Fail1
	inc	ax
Fail1:
#end
#endif
	}

void Replace(stat, dir, dta)
STAT *stat ;
char *dir ;
DTA *dta ;
	{
	strcpy(stat->file, dir) ;
	strcat(stat->file, dta->name) ;
	stat->time = dta->time ;
	stat->date = dta->date ;
	stat->size = dta->size ;
	found = TRUE ;
	}

void Get_Root(spec, root)
char *spec ;
char *root ;
	{
	char temp[100] ;
	char *token ;
	BOOL first ;

	first = TRUE ;
	strcpy(temp, spec) ;
	strcpy(root, "") ;

	for (token = temp; token = strtok(token, "\\/"); token = NULL)
		{
		if (!first || strchr("\\/", spec[0])) strcat(root, slash) ;
		first = FALSE ;
		if (strpbrk(token, "?*")) break ;
		strcat(root, token) ;
		}
	}

void Header()
	{
	static BOOL virgin = TRUE ;

	if (!virgin) return ;
	printf("Category   Date    Time     Bytes File or Directory Name\n") ;
	printf("-------- -------- ------ -------- -------------------------");
	printf("\n") ;
	virgin = FALSE ;
	}

char *Time(t)
TIME *t ;
	{
	static char time[7] ;
	char ampm ;

	if (t->hour >= 12)
		{
		t->hour -= 12 ;
		ampm = 'p' ;
		}
	else ampm = 'a' ;
	sprintf(time, "%2u:%02u%c", t->hour, t->min, ampm) ;
	return time ;
	}

char *Date(d)
DATE *d ;
	{
	static char date[9] ;

	sprintf(date, "%2u-%02u-%02u", d->month, d->day,
		(d->year + 1980) % 100) ;
	return date ;
	}

void Clean(spec)
char *spec ;
	{
	char *p = spec ;

	while ((p = strstr(p, ".\\")) || (p = strstr(p, "./")))
		{
		if (p == spec || p[-1] != '.') strcpy(p, p + 2) ;
		else p++ ;
		}
	}

void Empty(dir, dta)
char *dir ;
DTA *dta ;
	{
	Header() ;
	printf("Empty    %s %s %8lu %s%s%s\n",
		Date(&dta->date),
		Time(&dta->time),
		dta->size,
		dir,
		dta->name,
		slash) ;
	found = TRUE ;
	}

DUBL Search(spec, recurse)
char *spec ;
BOOL recurse ;
	{
	char dir[100] ;
	DUBL bytes, dbytes ;
	BYTE mode ;
	DTA dta ;


	bytes = 0L ;
	Get_Root(spec, dir) ;

	Set_DTA(&dta) ;
	mode = FIND_FIRST ;
	while (Find(mode, spec, FIND_ATTB))
		{
		mode = FIND_NEXT ;
		if (!strcmp(dta.name, "."))	continue ;
		if (!strcmp(dta.name, ".."))	continue ;

		if (dta.attb & DIR_ENTRY)
			{
			if (recurse)
				{
				strcpy(spec, dir) ;
				strcat(spec, dta.name) ;
				strcat(spec, slash) ;
				strcat(spec, "*.*") ;
				dbytes = Search(spec, recurse) ;
				if (!dbytes) Empty(dir, &dta) ;
				bytes += dbytes ;
				Set_DTA(&dta) ;
				}
			continue ;
			}

		bytes += dta.size ;

		if (NEWER(dta, newest))       Replace(&newest,   dir, &dta) ;
		if (NEWER(oldest, dta))       Replace(&oldest,   dir, &dta) ;

		if (dta.size > largest.size)  Replace(&largest,  dir, &dta) ;
		if (dta.size < smallest.size) Replace(&smallest, dir, &dta) ;
		}

	return bytes ;
	}

void Display(stat)
STAT *stat ;
	{
	printf("%-8s %s %s %8lu %s\n",
		stat->name,
		Date(&stat->date),
		Time(&stat->time),
		stat->size,
		stat->file) ;
	}

main(argc, argv)
unsigned argc ;
char *argv[] ;
	{
	BOOL recurse, searched ;
	char spec[100] ;
	unsigned arg ;
	DTA dta ;


	smallest.size = 0x7FFFFFFFL ;
	*((DUBL *) &oldest.time)   = 0x7FFFFFFFL ;

	slash = "\\" ;
	for (arg = 1; arg < argc; arg++)
		{
		if (!strchr(argv[arg], '/')) continue ;
		slash = "/" ;
		break ;
		}

	recurse = FALSE ;
	strcpy(spec, "*.*") ;

	printf("\n") ;
	searched = FALSE ;
	for (arg = 1; arg < argc; arg++)
		{
		strupr(argv[arg]) ;
		if (!strcmp(argv[arg], "+S"))
			{
			recurse = TRUE ;
			continue ;
			}

		if (!strcmp(argv[arg], "-S"))
			{
			recurse = FALSE ;
			continue ;
			}

		strcpy(spec, argv[arg]) ;
		switch (spec[strlen(spec) - 1])
			{
			case ':':
			case '/':
			case '\\':
				strcat(spec, "*.*") ;
				break ;

			case '.':
				strcat(spec, slash) ;
				strcat(spec, "*.*") ;
				break ;
			}

		Set_DTA(&dta) ;
		if (!strpbrk(spec, "*?")	&&
		    Find(0x4E, spec, FIND_ATTB)	&&
		    (dta.attb & DIR_ENTRY))
			{
			strcat(spec, slash) ;
			strcat(spec, "*.*") ;
			}

		Clean(spec) ;
		Search(spec, recurse) ;
		searched = TRUE ;
		}

	if (!searched) Search(spec, recurse) ;

	if (!found)
		{
		printf("\tNo files matching '%s'!\7\n", spec) ;
		exit(0xFF) ;
		}

	Header() ;
	Display(&smallest) ;
	Display(&largest) ;
	Display(&oldest) ;
	Display(&newest) ;
	exit(0x00) ;
	}
