#include <WLink.h>

// copyright (c) 1992, 1993 by Paul Wheaton

//.parse

LinkedList::LinkedList()
  {
    RootRec=NULL;
    CurRec=NULL;
    NumRecs=0;
    CurRecNum=0;
  }

//.parse

LinkedList::~LinkedList()
  {
    For(CurRecNum,NumRecs)
      {
        LinkedListElement *Temp=CurRec->NextRec;
        #ifdef MAJORBBS
          free(CurRec);
        #else
          delete CurRec;
        #endif
        CurRec=Temp;
      }
  }

//.parse

Bool LinkedList::Add(void *NewRec)
  {
    #ifdef MAJORBBS
      LinkedListElement* LLE=(LinkedListElement*)malloc(sizeof(LinkedListElement));
    #else
      LinkedListElement* LLE= new LinkedListElement;
    #endif
    if (LLE==NULL) return False;
    LLE->Rec=NewRec;
    if (NumRecs)
      {
        LLE->PrevRec=CurRec;
        LLE->NextRec=CurRec->NextRec;
        CurRec->NextRec->PrevRec=LLE;
        CurRec->NextRec=LLE;
        CurRecNum++;
      }
    else
      {
        RootRec=LLE;
        LLE->NextRec=LLE;
        LLE->PrevRec=LLE;
      }
    CurRec=LLE;
    NumRecs++;
    return True;
  }

//.parse

Bool LinkedList::Append(void *NewRec)
  {
    if (Size())
      {
        Root();
        Prev();
      }
    return Add(NewRec);
  }

//.parse

void* LinkedList::operator[](Long Index)
  {
    if (NumRecs==0) return NULL;
    if (NumRecs==1) return(CurRec->Rec);
    Index%=NumRecs;
    if (Index==CurRecNum+1) return(Next());
    if (Index==CurRecNum) return(CurRec->Rec);
    if (Index==0) return(Root());
    if (Index+1==CurRecNum) return(Prev());
    Root();
    Long I=NumRecs/2;
    if (Index>I)
      {
        Long StopVal=NumRecs-Index;
        For(I,StopVal) Prev();
      }
    else For(I,Index) Next(); // search forwards
    return (CurRec->Rec);
  }

//.parse

void LinkedList::DelCur()
  {
    if (NumRecs>1)
      {
        if (RootRec==CurRec) RootRec=CurRec->NextRec;
        CurRec->NextRec->PrevRec=CurRec->PrevRec;
        CurRec->PrevRec->NextRec=CurRec->NextRec;
        LinkedListElement *Temp=CurRec->NextRec;
        #ifdef MAJORBBS
          free(CurRec);
        #else
          delete CurRec;
        #endif
        CurRec=Temp;
        NumRecs--;
        CurRecNum %= NumRecs;
      }
    else if (NumRecs==1)
      {
        NumRecs=0;
        RootRec=NULL;
        #ifdef MAJORBBS
          free(CurRec);
        #else
          delete CurRec;
        #endif
        CurRec=NULL;
      }
  }

//.parse

Bool LinkedList::Insert(void *NewRec)
  {
    #ifdef MAJORBBS
      LinkedListElement* LLE=(LinkedListElement*)malloc(sizeof(LinkedListElement));
    #else
      LinkedListElement* LLE= new LinkedListElement;
    #endif
    if (LLE==NULL) return False;
    LLE->Rec=NewRec;
    if (NumRecs)
      {
        LLE->PrevRec=CurRec->PrevRec;
        LLE->NextRec=CurRec;
        CurRec->PrevRec->NextRec=LLE;
        CurRec->PrevRec=LLE;
        if (CurRecNum==0) RootRec=LLE;  // insert before the root
      }
    else
      {
        RootRec=LLE;
        LLE->NextRec=LLE;
        LLE->PrevRec=LLE;
      }
    CurRec=LLE;
    NumRecs++;
    return True;
  }

//.parse

void* LinkedList::Last()
  {
    if (Size())
      {
        Root();
        return Prev();
      }
    else return NULL;
  }

//.parse

void *LinkedList::Next()
  {
    if (Size())
      {
        CurRecNum=(CurRecNum+1)%NumRecs;
        CurRec=CurRec->NextRec;
        return CurRec->Rec;
      }
    return NULL;
  }

//.parse

void* LinkedList::Pop()
  {
    Root();
    void* P=Prev();
    DelCur();
    Prev();
    return P;
  }

//.parse

void* Queue::Pop()
  {
    void* P=Root();
    DelCur();
    return P;
  }

//.parse

void *LinkedList::Prev()
  {
    if (Size())
      {
        CurRecNum=(CurRecNum+NumRecs-1)%NumRecs;
          //  trying to avoid a 0-1 situation in an unsigned storage area
        CurRec=CurRec->PrevRec;
        return CurRec->Rec;
      }
    return NULL;
  }

//.parse

void *LinkedList::Root()
  {
    if (RootRec==NULL) return NULL;
    CurRecNum=0;
    CurRec=RootRec;
    return CurRec->Rec;
  }

