#ifndef WLinkIncluded
#define WLinkIncluded

// copyright (c) 1992, 1993 by Paul Wheaton
// 1916 Brooks #205, Missoula, MT  59801
//
//       phone:  (406)543-1928
//  CompuServe:  72707,207
//    Internet:  72707.207@CompuServe.com

#include <stddef.h>
#include <WMisc.h>

#ifdef MAJORBBS
  #include <stdlib.h>
#endif

struct LinkedListElement
  {
    friend class LinkedList;
    LinkedListElement *PrevRec, *NextRec;
    void* Rec;
  };

class LinkedList
  {
      LinkedListElement *RootRec, *CurRec;
      Long NumRecs;
      Long CurRecNum; // 0...NumRecs-1
    public:
      LinkedList();
        // an empty form
      ~LinkedList();
      void* Root();
        // returns rec 0.  CurRec is set to RootRec.
      void* Cur() {return CurRec->Rec;}
      Long Size() {return NumRecs;}
        // the number of things in list
      Long Top() {return(NumRecs-1);}
      Long Num() {return CurRecNum;}
        // 0..Top():  Cur's index
      void* Next();
        // Cur is moved up and returned
      void* Prev();
        // Cur is moved back and returned
      void* Last();
        // like Root only it's the last element
      Bool Insert(void* NewRec);
        // will be inserted between Prev and Cur
      Bool Add(void* NewRec);
        // will be inserted between Cur and Next
      Bool Append(void* NewRec);
        // will be the last record in the list
      Bool Push(void* NewRec){return Append(NewRec);}
      void DelCur();
        // link is destroyed.  Cur will be old Next.  Object is not deleted
      #ifndef MAJORBBS
      void DelCurObj()  // same as DelCur cept object is destroyed too
        // Note!  Only the object memory is freed.  No object destructors are called
        {delete Cur(); DelCur();}
      #endif
      void* Pop();
        // Returns pointer to last rec. Link is destroyed. Cur will be old Prev.
      void* operator[](Long Index);

    //  to do:  add in stuff like Add(void* NewRec,...);

      #ifdef MAJORBBS
        void* operator new(size_t size){return malloc(size);}
        void  operator delete(void* p) {free(p);}
      #endif
  };

#ifdef MAJORBBS

  #define CreateLinkedListClass(ClassName,ObjType)                        \
                                                                          \
  class ClassName: public LinkedList                                      \
    {                                                                     \
      public:                                                             \
        ObjType& Root(){return *(ObjType*)LinkedList::Root();}            \
        ObjType& Last(){return *(ObjType*)LinkedList::Last();}            \
        ObjType& Cur() {return *(ObjType*)LinkedList::Cur();}             \
        ObjType& Next(){return *(ObjType*)LinkedList::Next();}            \
        ObjType& Prev(){return *(ObjType*)LinkedList::Prev();}            \
        ObjType& Pop() {return *(ObjType*)LinkedList::Pop();}             \
        Bool Insert(ObjType& NewRec){return LinkedList::Insert(&NewRec);} \
        Bool Add(ObjType& NewRec)   {return LinkedList::Add(&NewRec);}    \
        Bool Append(ObjType& NewRec){return LinkedList::Append(&NewRec);} \
        Bool Push(ObjType& NewRec)  {return LinkedList::Push(&NewRec);}   \
        ObjType& operator[](Long Index)                                   \
          {return *(ObjType*)(LinkedList::operator[](Index));}            \
        void DelAllObj(); /* {while (Size()) DelCurObj();} */             \
    };

#else

  #define CreateLinkedListClass(ClassName,ObjType)                        \
                                                                          \
  class ClassName: public LinkedList                                      \
    {                                                                     \
      public:                                                             \
        ObjType& Root(){return *(ObjType*)LinkedList::Root();}            \
        ObjType& Last(){return *(ObjType*)LinkedList::Last();}            \
        ObjType& Cur() {return *(ObjType*)LinkedList::Cur();}             \
        ObjType& Next(){return *(ObjType*)LinkedList::Next();}            \
        ObjType& Prev(){return *(ObjType*)LinkedList::Prev();}            \
        ObjType& Pop() {return *(ObjType*)LinkedList::Pop();}             \
        Bool Insert(ObjType& NewRec){return LinkedList::Insert(&NewRec);} \
        Bool Add(ObjType& NewRec)   {return LinkedList::Add(&NewRec);}    \
        Bool Append(ObjType& NewRec){return LinkedList::Append(&NewRec);} \
        Bool Push(ObjType& NewRec)  {return LinkedList::Push(&NewRec);}   \
        Bool Insert(ObjType* NewRec){return LinkedList::Insert(NewRec);} \
        Bool Add(ObjType* NewRec)   {return LinkedList::Add(NewRec);}    \
        Bool Append(ObjType* NewRec){return LinkedList::Append(NewRec);} \
        Bool Push(ObjType* NewRec)  {return LinkedList::Push(NewRec);}   \
        ObjType& operator[](Long Index)                                   \
          {return *(ObjType*)(LinkedList::operator[](Index));}            \
        void DelCurObj()                                                  \
          {delete ((ObjType*)LinkedList::Cur()); LinkedList::DelCur();}   \
        void DelAllObj(); /* {while (Size()) DelCurObj();} */             \
    };

#endif

class Queue:public LinkedList
  {
    public:
      Queue(){}
      void* Pop();
  };

class Stack:public LinkedList
  {
    public:
      Stack(){}
  };

#endif
