#include <dir.h>
#include <dos.h>
#include <stdio.h>
#include <WTime.h>
#include <WDOS.h>

#ifdef MAJORBBS
  extern "C"
    {
      #include <dosface.h>
    }
#endif

#pragma hdrstop

// copyright (c) 1993 by Paul Wheaton

#ifdef MAJORBBS

  void LoadDirectory(const char* DirMask,Directory& D)
    {
      fndblk FF;
      Bool Found=(fnd1st(&FF,(char*)DirMask,0)==1);
      while(Found)
        {
          DirElementType* DE=(DirElementType*)malloc(sizeof(DirElementType));
          if (DE==NULL) FatalError("dir mem new");
          strcpy(DE->Name,FF.name);
          D.Add(*DE);
          Found=(fndnxt(&FF)==1);
        }
    }

#else

  static int UnpackInt(int X,int StartBit, int StopBit)
    {
      X>>=StartBit;
      StopBit-=StartBit;
      int Mask=(1<<(StopBit+1))-1;
      X&=Mask;
      return X;
    }

  static Moment MakeAMoment(const ffblk& F)
    {
      int Year=UnpackInt(F.ff_fdate,9,15)+1980;
      int Month=UnpackInt(F.ff_fdate,5,8);
      int Day=UnpackInt(F.ff_fdate,0,4);
      int Hour=UnpackInt(F.ff_ftime,11,15);
      int Minute=UnpackInt(F.ff_ftime,5,10);
      JulianDate J(Year,Month,Day);
      Moment M(J,Hour,Minute);
      return M;
    }

  void LoadDirectory(const char* DirMask,Moment StartMoment,Directory& D)
    {
      ffblk FF;
      Bool Found=(findfirst(DirMask,&FF,0)==0);
      while(Found)
        {
          Moment M=MakeAMoment(FF);
          if (M>=StartMoment)
            {
              DirElementType* DE=new DirElementType;
              if (DE==NULL) FatalError("cannot allocate for dir");
              strcpy(DE->Name,FF.ff_name);
              DE->M=M;
              D.Add(*DE);
            }
          Found=(findnext(&FF)==0);
        }
    }

  void LoadDirectory(const char* DirMask,Directory& D)
    {
      ffblk FF;
      Bool Found=(findfirst(DirMask,&FF,0)==0);
      while(Found)
        {
          DirElementType* DE=new DirElementType;
          if (DE==NULL) FatalError("dir mem new");
          strcpy(DE->Name,FF.ff_name);
          D.Add(*DE);
          Found=(findnext(&FF)==0);
        }
    }

  long DirCount(const char* DirMask)
    {
      long Quan=0;
      ffblk FF;
      Bool Found=(findfirst(DirMask,&FF,0)==0);
      while(Found)
        {
          Quan++;
          Found=(findnext(&FF)==0);
        }
      return Quan;
    }

#endif

