#if !defined(SWIN_H)
#include <windows.h>
#include "winbase.h"

class StdWindow : public WindowRegClass {
    LPSTR WinName;
    HANDLE hInstance;
public:
    StdWindow(LPSTR WinN, HANDLE hInst, HANDLE hPrev,
                    LPSTR menu = NULL, LPSTR icon = IDI_APPLICATION,
                    LPSTR cursorname = IDC_ARROW)
                    :WindowRegClass("stdXXX", hInst, hPrev,
                            StdWindow::WndProc) {
        WinName = WinN;
        hInstance = hInst;
        SetClassMenu(menu);
        SetClassIcon(icon);
        SetClassCursor(cursorname);
        Register();
        Window StdWin("stdXXX",WinName,hInstance);
        StdWin.SetWinStyle(WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN);
        StdWin.SetWinX(100);
        StdWin.SetWinY(50);
        StdWin.SetWinWidth(500);
        StdWin.SetWinHeight(300);
        StdWin.Create();
        StdWin.Display();
        StdWin.Update();
        StdWin.MessageLoop();
    }

    static long FAR PASCAL _export WndProc(HWND,WORD,WORD,LONG);
};
#define SWIN_H
#endif
