#include <windows.h>
#include "swin.h"
#include "dlgbase.h"
#include "test.h"
#include "testm.h"

#pragma argsused
int PASCAL WinMain(HANDLE hInstance,HANDLE hPrevInstance,
           LPSTR lpszCmdLine,int nCmdShow)
{
    StdWindow TheTestWindow("Test",        // Title to appear in window
                            hInstance,     // This instance of "Test" program
                            hPrevInstance, // Any prev instances of "Test"
                            "AMENU",       // Our menu
                            "TEST");       // Our icon

    return 0;
}

#pragma argsused
long FAR PASCAL _export StdWindow::WndProc(HWND hwnd,WORD message,WORD wParam,
                                LONG lParam)
{
    HANDLE hInstance; 

    switch(message)
    {

    case WM_CREATE:
        hInstance = ((LPCREATESTRUCT)lParam)->hInstance;
        static TDlg Testdlg(hInstance, "aboutbox", hwnd); //MUST be static !
        return 0;                           // Create dialog

    case WM_COMMAND:
        switch(wParam)
        {
            case IDM_SILLY:
                MessageBox(hwnd,"Feature not implemented",NULL,
                            MB_OK | MB_ICONQUESTION);
                return 0;

            case IDM_ABOUT:
                Testdlg.Show();             // Show it
                return 0;
        }
    case WM_DESTROY:
        PostQuitMessage(0);
        return 0;
    }
    return DefWindowProc(hwnd,message,wParam, lParam);
}
