#define BLANK           ' '

    /* type of indexed find */
#define FIND_FIRST      0
#define FIND_NEXT       1
#define FIND_PREV       2
#define FIND_LAST       3

    /* find condition */
#define FIND_EQL        0
#define FIND_GTR        1
#define FIND_LSS        2
#define FIND_NEQ        3
#define FIND_GEQ        4
#define FIND_LEQ        5

    /* function returns */
#define OK              0
#define OPEN_ERROR      -2
#define IX_IO_ERR       -1
#define IX_ERR          1
#define NOT_FOUND       2
#define NO_MORE         3
#define INV_PARAM       5
#define INV_NUM_KEYS    6

    /* index record length,
       number bytes available for keys,
       minimum number of keys acceptable */
#define REC_LENGTH      2048
#define KEY_BYTES       2036
#define MIN_NUM_KEYS    4

    /* data_type */
#define ftCHAR      0
#define ftUCHAR     1
#define ftSCHAR     2
#define ftUNS_INT   3
#define ftINT       4
#define ftULONG     5
#define ftLONG      6
#define ftFLOAT     7
#define ftDOUBLE    8
#define ftH_BCD_1   50
#define ftH_BCD_2   51
#define ftH_BCD_3   52
#define ftH_BCD_4   53
#define ftH_BCD_5   54
#define ftH_BCD_6   55
#define ftH_BCD_7   56
#define ftH_BCD_8   57
#define ftH_BCD_9   58
#define ftH_BCD_10  59
#define ftT_BCD_1   60
#define ftT_BCD_2   61
#define ftT_BCD_3   62
#define ftT_BCD_4   63
#define ftT_BCD_5   64
#define ftT_BCD_6   65
#define ftT_BCD_7   66
#define ftT_BCD_8   67
#define ftT_BCD_9   68
#define ftT_BCD_10  69
#define ftSTRUCT    127

#define LEVEL_0     0
#define LEVEL_1     1
#define LEVEL_2     2

#define EQUAL       0
#define GREATER     1
#define LESS        2

#define FLD_TYP(x)              ((x & 0x80)?0:x)
#define KEY_LNG(x,y)            (FLD_LENG (x,y) + sizeof (long))
#define KEY_lng(x)              (x + sizeof (long))
#define NUM_KEY(x,y)            (KEY_BYTES / KEY_LNG(x,y) )
#define NUM_key(x)              (KEY_BYTES / x)
#define KEY_POS(i,x,y)          (i * KEY_LNG (x,y) )
#define KEY_pos(i,x)            (i * x)
#define SET_KEY(key,ix_rec,x,y,z)  key=(KEY *)(&(ix_rec->keys[KEY_POS(x,y,z)]))
#define SET_key(key,ix_rec,x,y)    key=(KEY *)(&(ix_rec->keys[KEY_pos(x,y)]))

typedef struct
{
    char            level;
    unsigned char   data_type;
    int             num_keys;
    long            next;
    long            prev;
    char            keys[KEY_BYTES];
} IX_REC;

typedef struct
{
    long            avail_boc;
    long            level0_boc;
    long            level0_eoc;
    char            filler [KEY_BYTES];
} BOF;

typedef union VALue VALUE;

typedef struct
{
    unsigned char   data_type;  /* data storage type */
    VALUE           *val;       /* value of the item */
} KEY_COMPONENT;

typedef struct
{
    unsigned char   num_keys;   /* number of keys */
    KEY_COMPONENT   key [10];   /* up to ten keys */
} KEY_STRUCT;

union VALue
{
    char            wdCHAR [128];
    unsigned short  wdUINT;
    short           wdINT;
    long            wdLONG;
    float           wdFLOAT;
    double          wdDOUBLE;
    unsigned char   wdUCHR;
    signed char     wdSCHR;
    unsigned long   wdULONG;
    KEY_STRUCT      KSTRUCT;
};

typedef struct
{
    long            ptr_down;
    VALUE           value;
} KEY;

typedef struct
{
    long            data_rec;   /* returned record # for user */
    long            recno[3];   /* record # for all 3 index levels */
    int             ix[3];      /* index for all 3 levels */
    unsigned char   data_type;  /* data storage type */
    unsigned char   find_type;  /* FIND_EQL, FIND_GTR, FIND_LSS,
                                   FIND_NEQ, FIND_GEQ, FIND_LEQ */
    VALUE           *val;       /* original key argument */
    int             fn;         /* file number */
} FIND_IX;

int IX_get_down (IX_REC *, IX_REC *, int, int, VALUE *);
int IX_get_rec (long, IX_REC *, int);
int IX_put_rec (long, IX_REC *, int);
int IX_get_BOF (int);
int IX_put_BOF (int);
int IX_compare_struct (IX_REC *, VALUE *, int, int, unsigned char, int);
int IX_compare (IX_REC *, VALUE *, int);
int IX_compare_rec (IX_REC *, VALUE *, int *);
int IX_compare_EQL (IX_REC *, VALUE *, int *);
int IX_compare_L2 (IX_REC *, VALUE *, int, long);
int IX_compare_L2_EQL (IX_REC *, VALUE *, int *, long);
int IX_compare_L0 (IX_REC *, VALUE *, long *, int *, int);
int IX_compare_L0_EQL (IX_REC *, VALUE *, long *, int *, int);
int FLD_LENG (unsigned char, VALUE *);
int COPY_KEY (char *, VALUE *, unsigned char);
int IX_add (long, char *, unsigned char, int);
int IX_del (char *, long, unsigned char, int);
int IX_find_first (FIND_IX *, char *, int, int, unsigned char);
int IX_find_last (FIND_IX *, char *, int, int, unsigned char);
int IX_find_next (FIND_IX *);
int IX_find_prev (FIND_IX *);
