/******************************************************************

	Program:      WDIRLIST

                      Copyright 1992.

	Author:	      Frank McCallister
		      I can be contacted on CompuServe account 71544,2053

        Purpose:      To produce a report of the amount of disk space
                      and number of files in a directory and all of it's
                      sub directories. Can be useful to determine where
                      all of your disk space is being used. This differs
                      from most other directory list programs in that I
                      add up all the sub directory nodes to compute a
                      total for each directory node.

                      This program evolved as a first windows program
                      project and is really just an example of using
                      various windows features. Since it was only an
                      exercise for a novice windows programmer it does
                      not necessarily demonstrate the best approaches or
                      even the best style of windows programming.

	Usage:        Run from Windows

        Restrictions: If the directory allocation of memory goes over
                      128K then the structure will span a segment boundry
                      and will probably crash or at least not work. It will
                      take about 1600 directory entries to do this. Anyone
                      with more than 1600 directory nodes needs a lot better
                      program than this to manage their disks. To fix this
                      the DIRINFO structure needs to have a size that is a
                      power of 2. It is now 78 and the next power of 2 is 128.
                      I didn't want to waste that much space.

        References:   I have used techniques from several sources including
                      Petzold, Beirne, DiLascia, and others.

	Things to do: None
		     

******************************************************************/

/******************************************************************

  Revision Record

	Rev	Date		Auth	Changes
	===	====		====	=======

	0.0	11/03/92	FWM  	start
	1.0	11/22/92 	FWM	release 1 uses 600 element array
        2.0     12/15/92        FWM     release 2 changed array to use
                                        memory management pointers

******************************************************************/


/*
**
**	 Includes
**
*/

#define WINVER  0x0300

#if !defined(WINVER) || (WINVER < 0x030a)
#include <win30.h>
#else
#include <windows.h>
#endif  /* WINVER */

#include <commdlg.h>

#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <dir.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>


#include "wdirlist.h"

/*
**
**	 Defines
**
*/

#define ALLOC_SIZE    100
#define REALLOC_SIZE  100
#define LINE_LENGTH 81		// DOS converts CR/LF to CR only


typedef struct
      { int             n_level;
        int             n_num_files;
	long int	ln_size;
	char		sz_name[70];
      } DIRINFO ;
typedef DIRINFO huge * LPDIRINFO;
/*
**
**	 Global Variables
**
*/

  DIRINFO st_dir_item;
  LPDIRINFO lp_dir_data,
	    lp_dir_walker_i,
	    lp_dir_walker_j,
	    lp_dir_walker_k,
	    lp_dir_walker_k1;

  struct  ffblk ff;

  char	sz_drive[_MAX_DRIVE],
  	sz_dir[_MAX_DIR],
  	sz_fname[_MAX_FNAME],
  	sz_ext[_MAX_EXT],
  	sz_file_name[_MAX_FNAME + _MAX_EXT + 1],
        sz_buf[128],
	sz_message[40],
	sz_frame[] = IDS_APPNAME,
  LAST_CHAR;

  int   i,j,k,l,m,
        n_print_it,
	n_print_level,
	n_alloc_size = ALLOC_SIZE,
	n_max_index,
        n_max_files,
	n_tot_files,
	n_char_width,
	n_char_height,
	n_lb_char_width,
	n_lb_char_height,
	n_scroll_width,
  LAST_INT;

  long int ln_tot_size,
	   ln_max_size,
	   ln_alloc_offset = (65536L % sizeof(DIRINFO)),
  LAST_LONG_INT;

  float f_temp,
	f_temp1,
        f_temp2,
  LAST_FLOAT;

  WORD w_timer;

  BOOL b_user_abort,
       b_pie_ok = FALSE;

  HWND h_inst_save,    // the instance
       h_wnd,	       // the main (and only) window
       h_listbox,      // the directory list box
       h_listall,      // the file list box	
       h_control,      // the icon control in the about box
       h_pie,          // the pie control
       h_percent,      // the percent text box
       h_header,       // the heading text box for number of files read
       h_message,      // the test box for the number of files
       h_dlg_print;    // the print dialog box
     
  HDC  h_dc,
       h_dc_pie;

  HICON h_icon1,
        h_icon2,
        h_which_icon;
  
  HCURSOR h_hour_glass,
          h_save_cursor;

  HBRUSH h_black,
         h_white,
         h_grey,
         h_brown,
         h_red,
         h_yellow,
         h_green,
         h_cyan,
         h_blue,
         h_magenta,
         h_old_brush;

  HANDLE h_global_mem,
	 h_realloc_mem;

  RECT r_client,
       r_window;

  OFSTRUCT st_ofs;

  FARPROC lp_dirs_proc;		       
  FARPROC lp_dirs_subclass_proc;
  FARPROC lp_fn_abort_proc;
  FARPROC lp_fn_print_dlg_proc ;

/*
**
**	 Function Prototypes
**
*/

void Paint(HWND hwnd);

int RegisterCls(HANDLE h_inst);
HWND CreateWin(HANDLE h_inst, int n_show);
LONG FAR PASCAL _export FrameWndProc (HWND h_wnd, WORD w_msg, WORD w_param, LONG l_param );
WORD FillListBox(HWND h_list_box);
WORD PrintListBox(HWND h_list_box);
WORD PrintListBoxAll(HWND h_list_box);
void LocateChildWindows(HWND h_wnd);
BOOL CommandLine(LPSTR lp_cmd_line);
void TotalDir(int n_level, char *sz_direct, struct ffblk ff);
void NewDir(HWND h_wnd,HWND h_dirs);
BOOL ClearAndFill(HWND h_wnd);
void SizePie(HWND h_wnd,HWND h_list_box);
BOOL FAR PASCAL _export AboutBox(HWND h_dlg, WORD w_message, WORD w_param, LONG l_param);
LONG FAR PASCAL _export DirsSubClassProc(HWND h_list, WORD w_message, WORD w_param, LONG l_param);
BOOL FAR PASCAL _export PrintDlgProc (HWND h_pdlg, WORD w_message, WORD w_param, LONG l_param);
BOOL FAR PASCAL _export AbortProc (HDC h_printer_dc, short n_code);
void DebugBox(HWND h_wnd,char *sz_format, ...);

/**/

/******************************************************************

	Name:        WinMain

	Parameters : h_inst is the instance handle
                     h_pinst is the previous instance handle
		     sz_cmd_line is the command line
		     n_show determines the initial appearance of the window

	Action:      1) Register the class if necessary
                     2) Create the Windows
                     3) Process the message loop

	Returns:

******************************************************************/

extern int __argc;
extern char **__argv;


int PASCAL WinMain(HANDLE h_inst, HANDLE h_pinst, LPSTR sz_cmd_line, int n_show)

{/*BEGIN WinMain */
	MSG sz_msg;

    h_inst_save = h_inst;
    	
/* If this is the first instance of the app. register window classes */
    if (h_pinst == NULL)
       if (!RegisterCls(h_inst)) return FALSE;

/* Create the windows */
    h_wnd = CreateWin(h_inst,n_show);
    if (!h_wnd)
       return 1;


    h_global_mem = GlobalAlloc (GMEM_MOVEABLE, ((n_alloc_size+1) * sizeof(DIRINFO)));

/* Parse the command line and fill the listbox */
    if (!CommandLine(sz_cmd_line))
       return 1;

    strcpy(sz_dir,"\\");

    if (!ClearAndFill(h_wnd))
       return 1;

/* Enter main message loop */
    while (GetMessage (&sz_msg, NULL, 0, 0))
    {/*BEGIN while */
       if (!IsDialogMessage(h_wnd,&sz_msg))
       {/*BEGIN*/
	  TranslateMessage (&sz_msg);
	  DispatchMessage (&sz_msg);
       }/*END*/
    }/*END while */

    if (lp_dirs_subclass_proc)
       FreeProcInstance(lp_dirs_subclass_proc);

    GlobalFree (h_global_mem);

    return sz_msg.wParam;
}/*END WinMain */
/******************************************************************

	Name:        RegisterCls

        Parameters : h_inst the instance handle

	Action:      1) Fill in the necessary data

	Returns:     False if the Register action failed

******************************************************************/

int RegisterCls(HANDLE h_inst)
{/*BEGIN RegisterCls */
   WNDCLASS	wndcls;

/* style          The basic style of the class */
/* lpfnWndProc    The name of the message processing function */
/* cbClsExtra     Extra bytes to store data with the class */
/* cbWndExtra     Extra bytes to store data with the window */
/* hInstance      The application instance handle */
/* hIcon          Handle for the class icon */
/* hCursor        Handle for the class cursor */
/* hbrBackground  Handle for the background brush */
/* lpszMenuName   The default menu name */
/* lpszClassName  The Application name */

   wndcls.style	     = NULL;
   wndcls.lpfnWndProc   = FrameWndProc;
   wndcls.cbClsExtra    = 0;
   wndcls.cbWndExtra    = DLGWINDOWEXTRA;
   wndcls.hInstance     = h_inst;
   wndcls.hIcon	     = LoadIcon(h_inst,MAKEINTRESOURCE(IDI_APPICON));
   wndcls.hCursor	     = LoadCursor(NULL,IDC_ARROW);
// wndcls.hbrBackground = COLOR_APPWORKSPACE+1;
   wndcls.hbrBackground = COLOR_WINDOW+1;
   wndcls.lpszMenuName  = NULL;
   wndcls.lpszClassName = sz_frame;

   if (!RegisterClass (&wndcls) )
	return FALSE;

   return TRUE;
}/*END RegisterCls */
/******************************************************************

	Name:        CreateWin

	Parameters : h_inst is the instance handle
		     n_show determines the initial appearance of the window

	Action:      1) Create the main app and the windows

	Returns:     The handle to the main app window

******************************************************************/

HWND CreateWin(HANDLE h_inst, int n_show)
{/*BEGIN CreateWin */
   HMENU h_menu;
   HWND h_wnd;
   HFONT h_font;
   TEXTMETRIC tm;
   HWND h_dirs;

/* get the menu handle from the resource file */
   h_menu = LoadMenu(h_inst,"WDIR_MENU");

/* create a modeless dialog box and get the window handle */
   h_wnd = CreateDialog(h_inst,"WDIR",0,NULL);

/* get the handles for the box controls */
   h_listbox = GetDlgItem(h_wnd,IDC_LISTBOX); 
   h_pie = GetDlgItem(h_wnd,IDC_PIE);
   h_percent = GetDlgItem(h_wnd,IDC_PERCENT);
   h_header = GetDlgItem(h_wnd,IDC_HEADER); 
   h_message = GetDlgItem(h_wnd,IDC_MESSAGE);

   h_which_icon = h_icon1 = LoadIcon(h_inst,MAKEINTRESOURCE(IDI_FACE1));
   h_icon2 = LoadIcon(h_inst,MAKEINTRESOURCE(IDI_FACE2));

   h_hour_glass = LoadCursor(NULL,IDC_WAIT);

   if (!h_listbox || !h_wnd)
      return NULL;

/* get the dimensions of the two fonts and scroll bar */

   n_char_width = LOWORD(GetDialogBaseUnits());
   n_char_height = HIWORD(GetDialogBaseUnits());

   h_dc = GetDC(h_wnd);
   h_font = GetStockObject(SYSTEM_FIXED_FONT);
   if (!h_font)
      h_font = GetStockObject(ANSI_FIXED_FONT);

   SelectObject(h_dc,h_font);
   GetTextMetrics(h_dc, &tm);
   ReleaseDC(h_wnd,h_dc);
   n_lb_char_width = tm.tmAveCharWidth;
   n_lb_char_height = tm.tmHeight;
   n_scroll_width = GetSystemMetrics(SM_CXVSCROLL);

   SendMessage(h_listbox,WM_SETFONT,h_font,0L);

/* resize the listbox based on the size of the dialog window */
   LocateChildWindows(h_wnd);

/* create the listbox window as an invisible window to get file names */
   h_listall = CreateWindow ("listbox", NULL,
                              WS_CHILDWINDOW | LBS_STANDARD,
                              tm.tmAveCharWidth, tm.tmHeight * 3,
                              tm.tmAveCharWidth * 13 +
                                   GetSystemMetrics (SM_CXVSCROLL),
                              tm.tmHeight * 10,
                              h_wnd, 1,
			      h_inst, NULL) ;

/* setup the subclass procedures to handle keystrokes */
   h_dirs = GetDlgItem(h_wnd,IDC_DIRS);
   lp_dirs_proc = (FARPROC) GetWindowLong(h_dirs,GWL_WNDPROC);
   lp_dirs_subclass_proc = MakeProcInstance((FARPROC)DirsSubClassProc,h_inst);
   SetWindowLong(h_dirs,GWL_WNDPROC,(LONG)lp_dirs_subclass_proc);

   return h_wnd;
}/*END CreateWin */

/******************************************************************

	Name:        FrameWndProc

	Parameters : h_wnd is the window handle
                     w_msg is the message number
		     w_param is a message parameter
                     l_param is a message parameter

	Action:      1) Process the message loop

	Returns:

******************************************************************/


LONG FAR PASCAL _export FrameWndProc (HWND h_wnd, WORD w_msg, WORD w_param, LONG l_param )
{/*BEGIN FrameWndProc */
   switch(w_msg)
   {/*BEGIN switch */

      case WM_SIZE:
	   LocateChildWindows(h_wnd);
	   if (b_pie_ok)
	      SizePie(h_wnd,h_listbox);
	   break;

      case WM_DESTROY:
	   PostQuitMessage(0);
	   break;


      case WM_COMMAND:
	   switch (w_param)
	   {/*BEGIN switch */
	      case IDM_FILE_EXIT:
		   DestroyWindow(h_wnd);
		   break;  
	      case IDM_FILE_PRINT:
		   PrintListBox(h_listbox);
		   break;  
	      case IDM_FILE_PRINT_ALL:
		   PrintListBoxAll(h_listbox);
		   break;
	      case IDC_LISTBOX: 
		   switch(HIWORD(l_param))
		   {/*BEGIN switch */
//		      case LBN_DBLCLK:
		      case LBN_SELCHANGE:
			   SizePie(h_wnd,(HWND) LOWORD(l_param));
			   break;
		   }/*END switch */
		   break;
	      case IDC_DIRS:
		   switch(HIWORD(l_param))
		   {/*BEGIN switch */
		      case LBN_DBLCLK:
//		      case LBN_SELCHANGE:
			   NewDir(h_wnd,(HWND) LOWORD(l_param));
			   break;
                   }/*END switch */
		   break;
	      case IDM_FILE_ABOUT:
		   {/*BEGIN*/

		      FARPROC lp_proc;

		      k = 0;
		      lp_proc = MakeProcInstance( AboutBox, h_inst_save);
		      w_timer = SetTimer(h_wnd,1,200,lp_proc);
		      DialogBox(h_inst_save,"WDIR_ABOUT", h_wnd, lp_proc);
                      KillTimer(h_wnd,w_timer);
		      FreeProcInstance(lp_proc);
	           }/*END*/
	           break;
           }/*END switch */
	   break;
      default:
	   return DefWindowProc(h_wnd,w_msg,w_param,l_param);
	   break;
   }/*END switch */
   return 0L;
}/*END FrameWndProc */

/******************************************************************

	Name:        FillListBox

	Parameters : h_listbox is the handle to the listbox

	Action:      1) Loop through ast_dir_data and fill the box

	Returns:

******************************************************************/

WORD FillListBox(HWND h_listbox)
{/*BEGIN FillListBox */

   char sz_previous[128],
	sz_sender[128],
	sz_cmp_dir_i[_MAX_DIR],
	sz_cmp_dir_j[_MAX_DIR];
   int  n_start;
	
   SendMessage(h_listbox,WM_SETREDRAW,0,0L);
   SendMessage(h_listbox,LB_RESETCONTENT,0,0L);

   for (i=0; i<128; i++)
       sz_previous[i] = ' ';

   for (i=0; i<n_max_index; i++)
   {/*BEGIN for*/
       lp_dir_walker_i = lp_dir_data + i;
       strcpy(sz_cmp_dir_i,lp_dir_walker_i -> sz_name);
       ln_tot_size = 0;
       n_tot_files = 0;
       for (j=i; j<n_max_index; j++)
       {/*BEGIN for*/ 
	   lp_dir_walker_j = lp_dir_data + j;
	   if (!strncmp(sz_cmp_dir_i,lp_dir_walker_j -> sz_name,strlen(sz_cmp_dir_i)))
	   {/*BEGIN*/
	      if ((lp_dir_walker_j -> sz_name[strlen(sz_cmp_dir_i)] == '\\') || (lp_dir_walker_j -> sz_name[strlen(sz_cmp_dir_i)] == '\0') || (strlen(sz_cmp_dir_i)==1))
	      {/*BEGIN*/
	         ln_tot_size += lp_dir_walker_j -> ln_size;
		 n_tot_files += lp_dir_walker_j -> n_num_files;
	      }/*END*/
	   }/*END*/
       }/*END for*/
       sprintf(sz_buf,"%10ld %4d %10ld %4d %s%s", ln_tot_size, n_tot_files, lp_dir_walker_i -> ln_size, lp_dir_walker_i -> n_num_files, sz_drive, lp_dir_walker_i -> sz_name );
       strupr(sz_buf);
       strcpy(sz_sender,sz_buf);

 // The commented out code allows for blanking out duplicated portions
 // of the directory name. I originally thought I wanted it, but then
 // decided it did not look too good. If you want to see it simply
 // uncomment the code.
 //
 //      n_start = 32;
 //      for (j=32; j<128; j++)
 //          if (sz_sender[j] != sz_previous[j])
 //          {/*BEGIN*/
 //	      if ((sz_previous[j] == NULL) && (sz_sender[j] == '\\'))
 //                for (m=n_start; m<=j; m++)
 //                    sz_sender[m] = ' ';
 //             j=150;
 //          }/*END*/
 //          else
 //             if (sz_previous[j] == '\\')
 //             {/*BEGIN*/
 //                for (m=n_start; m<=j; m++)
 //                    sz_sender[m] = ' ';
 //                n_start = j;
 //             }/*END*/
 //      strcpy(sz_previous,sz_buf);
       SendMessage(h_listbox,LB_ADDSTRING,0,(DWORD) (LPSTR)sz_sender);
   }/*END for*/


   SendMessage(h_listbox,WM_SETREDRAW,1,0L);
   InvalidateRect(h_listbox,NULL,TRUE);

   return n_max_index;
}/*END FillListBox */
/******************************************************************

	Name:        LocateChildWindows

	Parameters : h_wnd is the handle to the window

	Action:      1) Resize the listbox to match the window

	Returns:

******************************************************************/

void LocateChildWindows(HWND h_wnd)
{/*BEGIN LocateChildWindows */
	GetClientRect(h_wnd,&r_client);
	MoveWindow(h_listbox,
		   n_char_width,16*n_char_height/2,
		   min((LINE_LENGTH)*n_lb_char_width+n_scroll_width,
		   (r_client.right-2*n_char_width)),
		   r_client.bottom-17*n_char_height/2,
		   TRUE);
}/*END LocateChildWindows */
/******************************************************************

	Name:        CommandLine

	Parameters : lp_cmd_line is the command line

	Action:      1) Parse the command line using OpenFile()

	Returns:     TRUE if everything ok
		     on the way, it sets
			szDrive		the displayed disk
			szDir		the displayed directory
			szFName		the notes file
			szExt		the notes file


******************************************************************/
BOOL	CommandLine(LPSTR lp_cmd_line)
{/*BEGIN CommandLine */
	char	sz_temp[_MAX_PATH];

// copy down the text from the far string
	if (lstrlen(lp_cmd_line) > _MAX_PATH) return FALSE;

	lstrcpy(sz_temp, lp_cmd_line);

	strupr(sz_temp);
	OpenFile(sz_temp,&st_ofs,OF_PARSE);
	_splitpath(st_ofs.szPathName,sz_drive,sz_dir,sz_fname,sz_ext);

	return TRUE;
}/*END CommandLine */

/******************************************************************

	Name:        TotalDir

        Parameters : n_level is the node depth
                     sz_direct is the directory to search
                     ff is the standard find file structure 

	Action:      1) Total up the size of a directory
                     2) Uses recursion to walk through the directory
                        nodes

	Returns:

******************************************************************/
void TotalDir(int n_level, char *sz_direct, struct ffblk ff)
{/*BEGIN TotalDir */
  char sz_new_dir[_MAX_DIR];
  char sz_cmp1_dir[_MAX_DIR];
  char sz_cmp2_dir[_MAX_DIR];
  int n_save_size;
  DWORD dw_size;
    
    dw_size = GlobalSize(h_global_mem);
    if (n_max_index >= n_alloc_size)
    {/*BEGIN*/
       GlobalUnlock(h_global_mem);
       n_save_size = n_alloc_size;
       n_alloc_size += REALLOC_SIZE;
       h_realloc_mem = GlobalReAlloc(h_global_mem, ((n_alloc_size+1) * sizeof(DIRINFO)), GMEM_MOVEABLE);
       if (h_realloc_mem == NULL)
       {/*BEGIN*/
	  n_alloc_size -= REALLOC_SIZE;
	  return;
       }/*END*/
       else
	  h_global_mem = h_realloc_mem;

       lp_dir_data = (char huge *) GlobalLock(h_global_mem) + ln_alloc_offset;
       dw_size = GlobalSize(h_global_mem);

       for (i=0; i<=REALLOC_SIZE; i++)
       {/*BEGIN for*/  
	   lp_dir_walker_i = lp_dir_data + n_save_size + i;
	   strcpy(lp_dir_walker_i -> sz_name,"");
	   lp_dir_walker_i -> ln_size = 0;
	   lp_dir_walker_i -> n_num_files = 0;
	   lp_dir_walker_i -> n_level = 0;
       }/*END for*/

    }/*END*/

  fnmerge(sz_buf,sz_drive,sz_direct,"*",".*");
  st_dir_item.n_level = n_level;
  st_dir_item.n_num_files = 0;
  st_dir_item.ln_size = 0;
  strcpy(st_dir_item.sz_name,sz_direct);

/*
 To insert the directory name into DArray in sorted order       
 I have to replace the \ with a / during this phase to       
 keep the list ordered because \ sorts after letters and     
 creates a problem in sorting directories with similar names. 
 As an example the following will happen if theis is not done

   TC
   TCWIN
   TCWIN\BIN
   TC\INCLUDE

 The TC\INCLUDE is out of order because \ sorts after letters
*/

  for (j=0; j<n_max_index; j++)
  {/*BEGIN*/
      lp_dir_walker_j = lp_dir_data + j;
      strcpy(sz_cmp1_dir,lp_dir_walker_j -> sz_name);
      strcpy(sz_cmp2_dir,sz_direct);
      for (m=0; m<strlen(sz_cmp1_dir); m++)
          if (sz_cmp1_dir[m] == '\\')
	     sz_cmp1_dir[m] = '/';
      for (m=0; m<strlen(sz_cmp2_dir); m++)
          if (sz_cmp2_dir[m] == '\\')
	     sz_cmp2_dir[m] = '/';

      if (strcmp(sz_cmp1_dir,sz_cmp2_dir) > 0)
      {/*BEGIN*/
	 for (k=n_max_index-1; k>=j; k--)
	 {/*BEGIN*/
	     lp_dir_walker_k1 = lp_dir_data + k;
	     lp_dir_walker_k = lp_dir_walker_k1++;
	     *lp_dir_walker_k1 = *lp_dir_walker_k;
         }/*END*/
	  *lp_dir_walker_j = st_dir_item;
	 j=n_max_index;
      }/*END*/
  }/*END*/
  lp_dir_walker_j = lp_dir_data + n_max_index;
  if (strlen(lp_dir_walker_j -> sz_name) == 0)
     *lp_dir_walker_j = st_dir_item;

  n_max_index++;

/* Start looping through the directory */
  if (!findfirst(sz_buf,&ff,_A_NORMAL | _A_SUBDIR | _A_RDONLY | _A_ARCH))
  {/*BEGIN */
     do
     {/*BEGIN do */
/* if we have a directory name and it's not <.>  then setup for recursion */
	if (ff.ff_attrib & _A_SUBDIR)
	{/*BEGIN*/
	   if(ff.ff_name[0]!='.')
	   {/*BEGIN */
	      strcpy(sz_new_dir,sz_direct);
	      if (strlen(sz_direct)!=1)
		 strncat(sz_new_dir,"\\",1);
	      strncat(sz_new_dir,ff.ff_name,13);
	      TotalDir(n_level+1,sz_new_dir,ff);
	   }/*END */
	}/*END*/
	else
/* must be a file so search ast_dir_data for a match and add it up */
	{/*BEGIN*/
	   for (j=0; j<n_max_index; j++)
	   {/*BEGIN*/  
	       lp_dir_walker_j = lp_dir_data + j;
	       if(!strcmp(lp_dir_walker_j -> sz_name,sz_direct))
               {/*BEGIN*/
		 lp_dir_walker_j -> ln_size += ff.ff_fsize;
		 lp_dir_walker_j -> n_num_files ++;
		 ln_max_size += ff.ff_fsize;
		 n_max_files ++;
	       }/*END*/
           }/*END*/
        }/*END*/
	sprintf(sz_message,"%4d   %4d", n_max_index, n_max_files);
	SetDlgItemText(h_wnd,IDC_MESSAGE,sz_message);
     }/*END do */
     while (!findnext(&ff));

  }/*END */

  return;

}/*END TotalDir */

/******************************************************************

	Name:        NewDir

	Parameters : h_wnd
		     h_dirs

	Action:      1) Search to a new directory

	Returns:

******************************************************************/

void NewDir(HWND h_wnd,HWND h_dirs)
{/*BEGIN NewDir */
	BOOL f_disk;
        char *p_strip;
	char sz_temp[_MAX_FNAME+_MAX_EXT]; 

	f_disk = DlgDirSelect(h_wnd,sz_temp,IDC_DIRS);

// All of this juggling around of the name was necessary to move
// from directory to directory and drive to drive. There is
// probably a much cleaner way to do this, but this evolved
// as I was debugging problems and since it works I haven't
// bothered to change it.
// Basically DlgDirSelect puts a drive letter: into sz_temp
// or a .. if you are backing up a level in the directory
// or a directory node if you are stepping down a level
// I need to end up with the drive in sz_drive and the
// directory name in sz_dir.

	if (sz_temp[1]==':')
        {/*BEGIN*/
	   strcpy(sz_drive,sz_temp);
	   sz_dir[0] = '\\';
	   sz_dir[1]=NULL;
        }/*END*/
	else
	   if (sz_temp[0]=='.')
	   {/*BEGIN*/
	      p_strip = strrchr(sz_dir,'\\');
	      if (p_strip)
		 *p_strip = '\0';
           }/*END*/
	   else
	   {/*BEGIN*/
	      k = strlen(sz_temp);
	      sz_temp[k-1] = '\0';
	      if (strlen(sz_dir)!=1)
	         strncat(sz_dir,"\\",1);
	      strcat(sz_dir,sz_temp);
	   }/*END*/
	if (strlen(sz_dir)==0)
	   strncat(sz_dir,"\\",1);

	_makepath(sz_buf,sz_drive,sz_dir,"*",".*");  


	ClearAndFill(h_wnd);

}

/******************************************************************

	Name:        ClearAndFill

	Parameters : h_wnd

	Action:      1) Clear the array
                     2) Fill the listbox

	Returns:     TRUE if OK

******************************************************************/

BOOL ClearAndFill(HWND h_wnd)
{/*BEGIN ClearAndFill */

        SetCapture(h_wnd);
	h_save_cursor = SetCursor(h_hour_glass);
	lp_dir_data = (char huge *) GlobalLock(h_global_mem) + ln_alloc_offset;
	for (i=0; i<=n_alloc_size; i++)
	{/*BEGIN for*/
	    lp_dir_walker_i = lp_dir_data + i;
	    strcpy(lp_dir_walker_i -> sz_name,"");
	    lp_dir_walker_i -> ln_size = 0;
	    lp_dir_walker_i -> n_num_files = 0;
	    lp_dir_walker_i -> n_level = 0;
	}/*END for*/
	n_max_index = 0;
        n_max_files = 0;
        ln_max_size = 0L;
	
	strcpy(sz_message,"Dirs   Files");
	SetDlgItemText(h_wnd,IDC_HEADER, sz_message);

        TotalDir(0,sz_dir,ff);

// fill the listbox
	FillListBox(h_listbox);


// prep the combo box
	_makepath(sz_buf,sz_drive,sz_dir,"*",".*");

	DlgDirList(h_wnd,sz_buf,IDC_DIRS,IDC_PATH,0xC010);

// set the caption line
	strcpy(sz_buf,IDS_APPNAME);
	SetWindowText(h_wnd,sz_buf);
	SetCursor(h_save_cursor);
	ReleaseCapture();
	GlobalUnlock(h_global_mem);

	return TRUE;
}/*END ClearAndFill */

/******************************************************************

	Name:        SizePie

	Parameters : h_wnd
		     h_list_box

	Action:      1) Draw pie chart of disk percentage

	Returns:

******************************************************************/

void SizePie(HWND h_wnd,HWND h_list_box)
{/*BEGIN SizePie */
	int n_sel_index;
	int s_startx,
              s_starty,
              s_endx,
              s_endy;

	BOOL f_disk;
        char *p_strip;
	char sz_temp[128]; 

	n_sel_index = (int) SendMessage(h_list_box,LB_GETCURSEL,0,0L);

	if(n_sel_index != LB_ERR)
        {/*BEGIN*/
	   SendMessage(h_list_box,LB_GETTEXT,n_sel_index,(LONG)(LPSTR)sz_temp);
	   ln_tot_size = atol(&sz_temp);
	   f_temp1 = ln_tot_size;
           f_temp2 = ln_max_size;
	   f_temp = f_temp1 / f_temp2;
	   sprintf(sz_temp,"%6.2f", f_temp * 100.00);
	   SetDlgItemText(h_wnd,IDC_PERCENT,sz_temp);
           h_dc_pie = GetDC(h_pie);
           SetMapMode(h_dc_pie,MM_ISOTROPIC);
           SetWindowExt(h_dc_pie,50,50);
           SetViewportExt(h_dc_pie,50,-50);
           SetViewportOrg(h_dc_pie,25,25);
           s_startx = 25;
           s_starty = 0;
           s_endx = (int) (25.0 * cos(6.28318 * f_temp));
	   s_endy = (int) (25.0 * sin(6.28318 * f_temp));
	   if ((f_temp<0.10) && s_endy == 0)
	      s_endy++;
	   if ((f_temp>0.90) && s_endy == 0)
	      s_endy--;

//	   DebugBox(7,"sx %d sy %d ex %d ey %d %6.2f %6.2f", s_startx, s_starty, s_endx, s_endy, f_temp1, f_temp2);

	   h_black   = CreateSolidBrush(RGB(0,0,0));
    	   h_white   = CreateSolidBrush(RGB(255,255,255));
    	   h_grey    = CreateSolidBrush(RGB(80,80,80));
	   h_brown   = CreateSolidBrush(RGB(180,100,0));
	   h_red     = CreateSolidBrush(RGB(255,0,0));
	   h_yellow  = CreateSolidBrush(RGB(255,255,0));
    	   h_green   = CreateSolidBrush(RGB(0,255,0));
    	   h_cyan    = CreateSolidBrush(RGB(0,255,255));
    	   h_blue    = CreateSolidBrush(RGB(0,0,255));
	   h_magenta = CreateSolidBrush(RGB(255,0,255));

	   h_old_brush = SelectObject(h_dc_pie,h_red);

           Pie(h_dc_pie, -25, 25, 25, -25, s_startx, s_starty, s_endx, s_endy);     

	   SelectObject(h_dc_pie,h_old_brush);

	   Pie(h_dc_pie, -25, 25, 25, -25, s_endx, s_endy, s_startx, s_starty);

	   DeleteObject (h_black);
	   DeleteObject (h_white);
	   DeleteObject (h_grey);
	   DeleteObject (h_brown);
	   DeleteObject (h_red);
	   DeleteObject (h_yellow);
	   DeleteObject (h_green);
	   DeleteObject (h_cyan);
	   DeleteObject (h_blue);
	   DeleteObject (h_magenta);

	   ReleaseDC(h_pie,h_dc_pie);

           b_pie_ok = TRUE;
        }/*END*/   
}


/******************************************************************

	Name:        AboutBox

        Parameters : hDlg
                     message
		     w_param
		     l_param

	Action:      1) Display the About Box
		     2) Uses the Timer to overlay the face icon
		        with a red tongue 

	Returns:

******************************************************************/
BOOL FAR PASCAL _export AboutBox(HWND h_dlg, WORD w_message, WORD w_param, LONG l_param)
{/*BEGIN AboutBox */
	switch (w_message)
	{/*BEGIN switch */
	   case WM_COMMAND:
		if (w_param==IDOK)
                {/*BEGIN*/
		   ReleaseDC(h_control,h_dc);
		   EndDialog(h_dlg,TRUE);
                }/*END*/
		break; 
	   case WM_TIMER:
		if (++k > 5 )
                {/*BEGIN */
		   h_which_icon = h_which_icon == h_icon1 ? h_icon2 : h_icon1;
		   DrawIcon(h_dc,0,0,h_which_icon);
		   if (k>6)
		      k=0;
	        }/*END */
		break;
	   case WM_INITDIALOG:
           	h_which_icon = h_icon1;
		h_control = GetDlgItem(h_dlg,IDI_FACE); 
		h_dc = GetDC(h_control);
	        break;
	   default:
	        return FALSE;
	}/*END switch */
	return TRUE;
}/*END AboutBox */


/******************************************************************

	Name:        DirsSubClassProc

	Parameters : h_dirs
		     w_message
		     w_param
		     l_param

	Action:      1) Trap the Enter key
                        and send a double click to parent

	Returns:     The window procedure

******************************************************************/

LONG FAR PASCAL _export DirsSubClassProc(HWND h_dirs, WORD w_message, WORD w_param, LONG l_param)
{/*BEGIN DirsSubClassProc */
	switch (w_message)
	{/*BEGIN switch */
	   case WM_KEYDOWN:
		switch (w_param)
		{/*BEGIN switch */
		   case VK_SPACE:
		   case VK_RETURN:
			PostMessage(GetParent(h_dirs),
			            WM_COMMAND,
				    IDC_DIRS,
				    MAKELONG(h_dirs,LBN_DBLCLK));
		}/*END switch */
		break;
	   case WM_GETDLGCODE:
	        return (LONG) (DLGC_WANTCHARS |
			       CallWindowProc(lp_dirs_proc,h_dirs,w_message,w_param,l_param));
	}/*END switch */
 	return CallWindowProc(lp_dirs_proc,h_dirs,w_message,w_param,l_param);
}/*END DirsSubClassProc */

/******************************************************************

	Name:        PrintDlgProc

	Parameters : h_pdlg
		     w_message
		     w_param
		     l_param

	Action:      1) Display printing dialog box

	Returns:     True or False

******************************************************************/

BOOL FAR PASCAL _export PrintDlgProc (HWND h_pdlg, WORD w_message, WORD w_param, LONG l_param)
{/*BEGIN PrintDlgProc */
     switch (w_message)
     {/*BEGIN*/
          case WM_INITDIALOG:
               EnableMenuItem (GetSystemMenu (h_pdlg, FALSE), SC_CLOSE, MF_GRAYED);
               return TRUE;

          case WM_COMMAND:
	       b_user_abort = TRUE;
               EnableWindow (GetParent (h_pdlg), TRUE);
               DestroyWindow (h_pdlg);
	       h_dlg_print = 0;
               return TRUE;
     }/*END*/
     return FALSE;
}/*END PrintDlgProc */          

/******************************************************************

	Name:        AbortProc

	Parameters : h_printer_dc the device context to the printer
		     n_code parameter for out of disk GDI errors

	Action:      1) Handles the abort of printing
		     2) Uses peekmessage to allow other programs
			to run during printing

	Returns:     True or False

******************************************************************/

BOOL FAR PASCAL _export AbortProc (HDC h_printer_dc, short n_code)
{/*BEGIN AbortProc */
     MSG msg;

     while (!b_user_abort && PeekMessage (&msg, NULL, 0, 0, PM_REMOVE))
     {/*BEGIN*/
	  if (!h_dlg_print || !IsDialogMessage (h_dlg_print, &msg))
          {/*BEGIN*/
             TranslateMessage (&msg);
             DispatchMessage (&msg);
          }/*END*/
     }/*END*/
     return !b_user_abort;
}/*END AbortProc*/

/******************************************************************

	Name:        PrintListBox

	Parameters : h_listbox is the handle to the listbox

	Action:      1) Loop through listbox and print
		     2) Uses COMMDLG common dialogs and
			allows for printing multiple copies
			and collating copies

	Returns:

******************************************************************/

WORD PrintListBox(HWND h_listbox)
{/*BEGIN PrintListBox */

     static PRINTDLG pd;
     BOOL            b_success;
     char            sz_job_name [40],
		     sz_heading [80];
     NPSTR           npstr_buffer;
     int             n_y_char, n_chars_per_line, n_lines_per_page,
		     n_total_lines, n_total_pages, n_page, n_line,
		     n_line_num, n_page_length;
     TEXTMETRIC      tm;
     WORD            w_col_copy, w_non_col_copy;

     pd.lStructSize         = sizeof (PRINTDLG);
     pd.hwndOwner           = h_wnd;
     pd.hDevMode            = NULL;
     pd.hDevNames           = NULL;
     pd.hDC                 = NULL;
     pd.Flags               = PD_ALLPAGES | PD_COLLATE | PD_RETURNDC;
     pd.nFromPage           = 0;
     pd.nToPage             = 0;
     pd.nMinPage            = 0;
     pd.nMaxPage            = 0;
     pd.nCopies             = 1;
     pd.hInstance           = NULL;
     pd.lCustData           = 0L;
     pd.lpfnPrintHook       = NULL;
     pd.lpfnSetupHook       = NULL;
     pd.lpPrintTemplateName = NULL;
     pd.lpSetupTemplateName = NULL;
     pd.hPrintTemplate      = NULL;
     pd.hSetupTemplate      = NULL;

     if (!PrintDlg (&pd))
          return TRUE;

     n_total_lines = SendMessage (h_listbox, LB_GETCOUNT, 0, 0L);

     if (n_total_lines == 0)
          return TRUE;
     
     GetTextMetrics (pd.hDC, &tm);
     n_y_char = tm.tmHeight + tm.tmExternalLeading;

     n_chars_per_line = GetDeviceCaps (pd.hDC, HORZRES) / tm.tmAveCharWidth;
     n_page_length = GetDeviceCaps (pd.hDC, VERTRES) / n_y_char;
     n_lines_per_page = n_page_length - 6;
     n_total_pages   = (n_total_lines + n_lines_per_page - 1) / n_lines_per_page;

     npstr_buffer = (NPSTR) LocalAlloc (LPTR, n_chars_per_line + 1);

     EnableWindow (h_wnd, FALSE);

     b_success   = TRUE;
     b_user_abort = FALSE;

     lp_fn_print_dlg_proc = MakeProcInstance ((FARPROC) PrintDlgProc, h_inst_save);
     h_dlg_print = CreateDialog (h_inst_save, "WDIR_PRINT", h_wnd, lp_fn_print_dlg_proc);

     lp_fn_abort_proc = MakeProcInstance ((FARPROC) AbortProc, h_inst_save);
     Escape (pd.hDC, SETABORTPROC, 0, (LPSTR) lp_fn_abort_proc, NULL);

     GetWindowText (h_wnd, sz_job_name, sizeof (sz_job_name));
     if (Escape (pd.hDC, STARTDOC, strlen (sz_job_name), sz_job_name, NULL) > 0)
     {/*BEGIN*/
	for (w_col_copy = 0; w_col_copy < (pd.Flags & PD_COLLATE ? pd.nCopies : 1); w_col_copy++)
        {/*BEGIN for */
	    for (n_page = 0 ; n_page < n_total_pages ; n_page++)
            {/*BEGIN for */
		for (w_non_col_copy = 0; w_non_col_copy < (pd.Flags & PD_COLLATE ? 1 : pd.nCopies); w_non_col_copy++)
		{/*BEGIN for */
		    strcpy(sz_buf,IDS_HEADING);
		    sprintf(sz_heading,"%s%4d", IDS_HEADING, n_page + 1);
		    TextOut (pd.hDC, 0, 0, sz_heading, strlen(sz_heading));
		    for (n_line = 0; n_line < n_lines_per_page; n_line++)
                    {/*BEGIN for */
		        n_line_num = n_lines_per_page * n_page + n_line;

			if (n_line_num >= n_total_lines)
                           break ;

			* (short *) npstr_buffer = n_chars_per_line;

			TextOut (pd.hDC, 0, n_y_char * (n_line+2), npstr_buffer,
				   (short) SendMessage (h_listbox, LB_GETTEXT,
				   n_line_num, (LONG) (LPSTR) npstr_buffer));
		    }/*END for */
		    if (Escape (pd.hDC, NEWFRAME, NULL, NULL, NULL) < 0)
                    {/*BEGIN*/
		       b_success = FALSE;
                       break;
                    }/*END*/

		    if (b_user_abort)
                       break;
                }/*END for */

		if (!b_success || b_user_abort)
                    break;
            }/*END for */

	    if (!b_success || b_user_abort)
               break;
        }/*END for */
     }/*END*/
     else
        b_success = FALSE;

     if (b_success)
	Escape (pd.hDC, ENDDOC, NULL, NULL, NULL);

     if (!b_user_abort)
     {/*BEGIN*/
        EnableWindow (h_wnd, TRUE);
        DestroyWindow (h_dlg_print);
     }/*END*/

     LocalFree ((LOCALHANDLE) npstr_buffer);
     FreeProcInstance (lp_fn_print_dlg_proc);
     FreeProcInstance (lp_fn_abort_proc);
     DeleteDC (pd.hDC);

     return b_success && !b_user_abort;


}/*END PrintListBox */

/******************************************************************

	Name:        PrintListBoxAll

	Parameters : h_listbox is the handle to the listbox

	Action:      1) Loop through listbox and print
		     2) Uses COMMDLG common dialogs and
			allows for printing multiple copies
			and collating copies

	Returns:

******************************************************************/

WORD PrintListBoxAll(HWND h_listbox)
{/*BEGIN PrintListBoxAll */

     static PRINTDLG pd;
     BOOL            b_success;
     char            sz_job_name [40],
                     sz_list_box [128],
                     sz_list_all [128],
		     sz_tmp_dir [_MAX_DIR],
		     sz_heading [80];
     int             n_y_char, n_chars_per_line, n_lines_per_page,
		     n_total_lines, n_total_pages, n_page, n_line,
                     n_listbox_num, n_listall_num, n_total_listbox,
		     n_total_listall, n_line_num, n_page_length;
     TEXTMETRIC      tm;

     pd.lStructSize         = sizeof (PRINTDLG);
     pd.hwndOwner           = h_wnd;
     pd.hDevMode            = NULL;
     pd.hDevNames           = NULL;
     pd.hDC                 = NULL;
     pd.Flags               = PD_RETURNDC;
     pd.nFromPage           = 0;
     pd.nToPage             = 0;
     pd.nMinPage            = 0;
     pd.nMaxPage            = 0;
     pd.nCopies             = 1;
     pd.hInstance           = NULL;
     pd.lCustData           = 0L;
     pd.lpfnPrintHook       = NULL;
     pd.lpfnSetupHook       = NULL;
     pd.lpPrintTemplateName = NULL;
     pd.lpSetupTemplateName = NULL;
     pd.hPrintTemplate      = NULL;
     pd.hSetupTemplate      = NULL;

     if (n_max_files > 500)
	if (IDCANCEL == MessageBox (NULL, "This will print over 500 lines!","Print All",MB_ICONEXCLAMATION | MB_OKCANCEL))
           return FALSE; 

     if (!PrintDlg (&pd))
          return TRUE;

     n_total_listbox = SendMessage (h_listbox, LB_GETCOUNT, 0, 0L);

     if (n_total_listbox == 0)
          return TRUE;
     
     GetTextMetrics (pd.hDC, &tm);
     n_y_char = tm.tmHeight + tm.tmExternalLeading;

     n_chars_per_line = GetDeviceCaps (pd.hDC, HORZRES) / tm.tmAveCharWidth;
     n_page_length = GetDeviceCaps (pd.hDC, VERTRES) / n_y_char;
     n_lines_per_page = n_page_length - 6;
     n_page = 0;
     EnableWindow (h_wnd, FALSE);

     b_success   = TRUE;
     b_user_abort = FALSE;

     lp_fn_print_dlg_proc = MakeProcInstance ((FARPROC) PrintDlgProc, h_inst_save);
     h_dlg_print = CreateDialog (h_inst_save, "WDIR_PRINT", h_wnd, lp_fn_print_dlg_proc);

     lp_fn_abort_proc = MakeProcInstance ((FARPROC) AbortProc, h_inst_save);
     Escape (pd.hDC, SETABORTPROC, 0, (LPSTR) lp_fn_abort_proc, NULL);

     GetWindowText (h_wnd, sz_job_name, sizeof (sz_job_name));
     if (Escape (pd.hDC, STARTDOC, strlen (sz_job_name), sz_job_name, NULL) > 0)
     {/*BEGIN*/
	sprintf(sz_heading,"%s%4d", IDS_HEADING, n_page + 1);
	TextOut (pd.hDC, 0, 0, sz_heading, strlen(sz_heading));
        n_line = 0;

	for (n_listbox_num = 0; n_listbox_num < n_total_listbox; n_listbox_num++)
	{/*BEGIN for */
	    SendMessage (h_listbox, LB_GETTEXT, n_listbox_num, (LONG) (LPSTR) sz_list_box);
	    TextOut (pd.hDC, 0, n_y_char * (n_line+2), sz_list_box, strlen(sz_list_box));
            n_line++;
            strcpy(sz_tmp_dir,&sz_list_box[34]);
            fnmerge(sz_buf,sz_drive,sz_tmp_dir,"*",".*");

/* Start looping through the directory */
            if (!findfirst(sz_buf,&ff,_A_NORMAL | _A_RDONLY | _A_ARCH))
            {/*BEGIN */
               do
               {/*BEGIN do */
		  sprintf(sz_list_all,"                                     %-13.13s%8ld  %2d-%2.2d-%2.2d  %2d:%2.2d%c%c ",
			   ff.ff_name,
			   ff.ff_fsize,
			   (ff.ff_fdate >> 5)&0xf, (ff.ff_fdate & 0x1f), 80 + (ff.ff_fdate >> 9),
			   ((ff.ff_ftime >>11)+11)%12+1 ,(ff.ff_ftime >>5) & 0x3f,(WORD)ff.ff_ftime > 0x6000 ? 'p' : 'a',
					'm');
	          TextOut (pd.hDC, 0, n_y_char * (n_line+2), sz_list_all, strlen(sz_list_all));
		  n_line++;
                  if (n_line > n_lines_per_page)
                  {/*BEGIN*/
                     if (Escape (pd.hDC, NEWFRAME, NULL, NULL, NULL) < 0)
                     {/*BEGIN*/
  		      b_success = FALSE;
                        break;
		     }/*END*/
                     n_page++;
		     strcpy(sz_buf,IDS_HEADING);
  		     sprintf(sz_heading,"%s%4d", IDS_HEADING, n_page + 1);
  		     TextOut (pd.hDC, 0, 0, sz_heading, strlen(sz_heading));
                     n_line = 0;
                  }/*END*/
	   	  if (!b_success || b_user_abort)
                     break;
   
               }/*END do */
	       while (!findnext(&ff));
	    }/*END */
            n_line++;
	    if (!b_success || b_user_abort)
               break;
	}/*END for */
	if (Escape (pd.hDC, NEWFRAME, NULL, NULL, NULL) < 0)
  	   b_success = FALSE;
     }/*END*/
     else
        b_success = FALSE;

     if (b_success)
	Escape (pd.hDC, ENDDOC, NULL, NULL, NULL);

     if (!b_user_abort)
     {/*BEGIN*/
        EnableWindow (h_wnd, TRUE);
        DestroyWindow (h_dlg_print);
     }/*END*/

     FreeProcInstance (lp_fn_print_dlg_proc);
     FreeProcInstance (lp_fn_abort_proc);
     DeleteDC (pd.hDC);

     return b_success && !b_user_abort;


}/*END PrintListBoxAll */

/******************************************************************

	Name:        DebugBox

	Parameters : sz_caption message box caption
		     sz_format  format for vsprintf
                     sz_arguments variable parameters

	Action:      1) Display debug info in a message box

	Returns:

******************************************************************/

void DebugBox(HWND h_wnd,char *sz_format,...)
{/*BEGIN DebugBox */
	
        char *p_arguments;
	char sz_debug[256];

        p_arguments = (char *) &sz_format + sizeof(sz_format);
	sprintf(sz_debug, "(%4x) ",(int)h_wnd);
	vsprintf( &sz_debug[strlen(sz_debug)], sz_format, p_arguments);
	MessageBox(NULL,(LPSTR)sz_debug,(LPSTR)"DebugBox",MB_OK);

}/*END DebugBox*/



