/*
   CHGSER.CPP
   By Tom Astin 73407,3427
   Copyright 1991
   Use as is.
   Not extensively tested.
   Author not responsible for any negative results.
   Program to test VolLabel class - please see notes in VOLLAB.H before
   using.
   *** USE WITH CAUTION ***
	 Tested on small/floppy media (once on a large media 130mb hard drive).
	 special VolLabel::myabsread/myabswrite are used for larger media

	 Will abort on dos version < 4 (ie: serial numbers not supported).
*/

#include <iostream.h>
#include <iomanip.h>
#include <stdlib.h>
#include <ctype.h>
#include "vollab.h"

void ErrorMsg(char *msg)
{
	cout << msg << endl << endl;
	exit(1);
}

int sertol(char *szSer, unsigned long *nSer)
{
	char valid[]="0123456789ABCDEF";

	if (strlen(strupr(szSer))!=9 || szSer[4]!='-' ||
		strspn(szSer,valid)<4 || strspn(&szSer[5],valid)<4)
		return 0;
	*nSer=strtol(szSer,NULL,16) << 16;
	*nSer=*nSer | strtol(&szSer[5],NULL,16);
	return 1;
}

int main(int argc, char *argv[])
{
	VolLabel vl;
	unsigned long VolID;
	char szVolID[10], cDrive;
	unsigned char nDrive;

	cout << "Volume ID changer." << endl << endl;

	if (_osmajor<4)
		ErrorMsg("Cannot use with DOS version less than 4.00");

	if (argc>2)
		ErrorMsg("Invalid number of parameters. CHGSER [d:]");

	if (argc==2) {
		cDrive=toupper(argv[1][0]);
		if (strlen(argv[1])>2 || argv[1][1]!=':' || cDrive<'A' || cDrive>'Z')
			ErrorMsg("Invalid parameter.");
		nDrive='A'-cDrive+1;
	}
	else {
		nDrive=vl.GetDisk();
		cDrive='A'+nDrive;
		++nDrive;
	}

	VolID=vl.GetSerial(nDrive);
	cout.setf(ios::uppercase);
	cout << "Current serial # for " << cDrive << " is ";
	cout << hex << setfill('0') << setw(4)
		 << ((unsigned) (VolID >> 16)) << '-'
		 << setfill('0') << setw(4)
		 << ((unsigned) VolID) << endl;
	cout << "Enter new serial # (NNNN-NNNN):";
	cin.get(szVolID,sizeof(szVolID));
	cin.ignore();
	if (sertol(szVolID,&VolID)) {
		if (vl.SetSerial(nDrive,VolID))
			cout << "Volume ID changed." << endl;
		else
			ErrorMsg("Error while chaning volume ID.");
	}
	else
		if (strlen(szVolID)==0)
			cout << "Volume ID not changed." << endl;
		else
			ErrorMsg("Error with volume ID input.");
	cout << endl;
	return 0;
}
