#ifndef INC_DBTEMPOB_HPP
#define INC_DBTEMPOB_HPP

//. MODULE: DbTempObjs

// @@Includes
#ifndef INC_GLOBAL_HPP
#include "global.hpp"
#endif
#ifndef D_TEMPORAL_H
#include "d_tempor.h"
#endif
// @@End
#ifndef INC_TEMPDB_HPP
#include "tempdb.hpp"
#endif
class CollectionNodeObj : public StoreObj, private Rec_CollectionNode

{
	public:
		inline REC_TYPE RecType ();
		// @@UserEntry
		STOREDIN(D_Temporal);
		CUSTOMOPS(CollectionNodeObj);
		OWNEROF(SCollectionElementsObj, COLLECTION);
		OWNEROF(LCollectionElementsObj, COLLECTION);
		OWNEROF(SSCollectionElementsObj, SSCOLLECTION);
		OWNEROF(LSCollectionElementsObj, LSCOLLECTION);
		// @@End
		CollectionNodeObj ();
		virtual ~CollectionNodeObj ();
	protected:
		void SetId (unsigned long id);
		unsigned long GetId () const;
	public:
		BOOL New ();
		CollectionNodeObj& operator = (const CollectionNodeObj& op);
		CollectionNodeObj (const CollectionNodeObj& o);
};

class SSCollectionElementsObj : public StoreObj, private Rec_SSCollectionElements

{
	public:
		inline REC_TYPE RecType ();
		// @@UserEntry
		STOREDIN(D_Temporal);
		CUSTOMOPS(SSCollectionElementsObj);
		MEMBEROF(CollectionNodeObj, SSCOLLECTION);
		// @@End
		SSCollectionElementsObj ();
		virtual ~SSCollectionElementsObj ();
	protected:
		inline const char * GetPString () const;//; the persistent string
		inline const char * GetPKey () const;//; the persistent key
		void SetPString (const char* linea);//; persistent strings
		void SetPKey (const char* key);//; persistent key
		VirtualRecordId GetPVirtualRecordId () const;//; the persistent virtual record id
		void SetPVirtualRecordId (const VirtualRecordId& rec_ids);//; persistent virtual record id
	public:
		inline unsigned long GetPSequence () const;
		inline void SetPSequence (unsigned long cur);
		SSCollectionElementsObj& operator = (const SSCollectionElementsObj& op);
		SSCollectionElementsObj (const SSCollectionElementsObj& op);
};

class SCollectionElementsObj : public StoreObj, private Rec_SCollectionElements

{
	public:
		SCollectionElementsObj ();
		virtual ~SCollectionElementsObj ();
		inline REC_TYPE RecType ();
		// @@UserEntry
		STOREDIN(D_Temporal);
		CUSTOMOPS(SCollectionElementsObj);
		MEMBEROF(CollectionNodeObj, COLLECTION);
		// @@End
	protected:
		inline const char * GetPKey () const;//; the persistent key
		inline const char * GetPString () const;//; the persistent string
		VirtualRecordId GetPVirtualRecordId () const;//; the persistent virtual record id
		void SetPKey (const char* key);//; persistent key
		void SetPString (const char* linea);//; persistent strings
		void SetPVirtualRecordId (const VirtualRecordId& rec_ids);//; persistent virtual record id
	public:
		inline unsigned long GetPSequence () const;
		inline void SetPSequence (unsigned long cur);
		SCollectionElementsObj& operator = (const SCollectionElementsObj& op);
		SCollectionElementsObj (const SCollectionElementsObj& op);
};

class LSCollectionElementsObj : public StoreObj, private Rec_LSCollectionElements

{
	public:
		LSCollectionElementsObj ();
		inline REC_TYPE RecType ();
		// @@UserEntry
		STOREDIN(D_Temporal);
		CUSTOMOPS(LSCollectionElementsObj);
		MEMBEROF(CollectionNodeObj, LSCOLLECTION);
		// @@End
		virtual ~LSCollectionElementsObj ();
	protected:
		inline const char * GetPKey () const;//; the persistent key
		inline const char * GetPString () const;//; the persistent string
		VirtualRecordId GetPVirtualRecordId () const;//; the persistent virtual record id
		void SetPKey (const char* key);//; persistent key
		void SetPString (const char* linea);//; persistent strings
		void SetPVirtualRecordId (const VirtualRecordId& rec_ids);//; persistent virtual record id
	public:
		inline unsigned long GetPSequence () const;
		inline void SetPSequence (unsigned long cur);
		LSCollectionElementsObj& operator = (const LSCollectionElementsObj& op);
		LSCollectionElementsObj (const LSCollectionElementsObj& op);
};

class LCollectionElementsObj : public StoreObj, private Rec_LCollectionElements

{
	public:
		LCollectionElementsObj ();
		virtual ~LCollectionElementsObj ();
		inline REC_TYPE RecType ();
		// @@UserEntry
		STOREDIN(D_Temporal);
		CUSTOMOPS(LCollectionElementsObj);
		MEMBEROF(CollectionNodeObj, COLLECTION);
		// @@End
	protected:
		inline const char * GetPKey () const;//; the persistent key
		inline const char * GetPString () const;//; the persistent string
		VirtualRecordId GetPVirtualRecordId () const;//; the persistent virtual record id
		void SetPKey (const char* key);//; persistent key
		void SetPString (const char* linea);//; persistent strings
		void SetPVirtualRecordId (const VirtualRecordId& rec_ids);//; persistent virtual record id
	public:
		inline unsigned long GetPSequence () const;
		inline void SetPSequence (unsigned long cur);
		LCollectionElementsObj& operator = (const LCollectionElementsObj& op);
		LCollectionElementsObj (const LCollectionElementsObj& op);
};

class DBElementBase

{
	public:
		virtual inline void SetString (const char* linea) =0;
		virtual inline void SetKey (const char* key) =0;//; for sorted collections !
		virtual inline const char * GetString () const =0;
		virtual inline VirtualRecordId GetVirtualRecordId () const =0;
		virtual inline void SetVirtualRecordId (const VirtualRecordId& rec_ids) =0;
		virtual inline BOOL Destroy (DBCollectionNode& node) =0;
		virtual inline void First (DBCollectionNode& node) =0;
		virtual inline void Last () =0;
		virtual inline void Next () =0;
		virtual inline BOOL Okay () const =0;
		virtual inline void Prev () =0;
		virtual inline unsigned long GetCount (DBCollectionNode& node) =0;
		virtual inline void SetStatus (int s) =0;
		enum ElementConstants
		{
			RecCount = ::DbaCount,
			SmallElementWidth = ::SmallContentsLen,
			LargeElementWidth = ::LargeContentsLen
		};
		virtual inline BOOL New (DBCollectionNode& node) =0;
		virtual long GotoVirtualRecordId (VirtualRecordId& id) =0;
		virtual void SetSequence (unsigned long current) =0;
		virtual unsigned long GetSequence () const =0;
		virtual DBElementBase* CloneElement () =0;
};

class DBSortedSmallCollectionElement : public DBElementBase, public SSCollectionElementsObj

{
	public:
		virtual void First (DBCollectionNode& node);
		virtual BOOL New (DBCollectionNode& node);
		virtual unsigned long GetCount (DBCollectionNode& node);
		virtual inline const char * GetString () const;
		virtual void Last ();
		virtual void Next ();
		virtual BOOL Okay () const;
		virtual void Prev ();
		virtual inline void SetKey (const char* key);//; for sorted collections !
		virtual void SetStatus (int s);
		virtual void SetString (const char* linea);
		virtual inline VirtualRecordId GetVirtualRecordId () const;
		virtual inline void SetVirtualRecordId (const VirtualRecordId& rec_ids);
		virtual inline BOOL Destroy (DBCollectionNode& node);
		virtual long GotoVirtualRecordId (VirtualRecordId& id);
		virtual inline unsigned long GetSequence () const;
		virtual inline void SetSequence (unsigned long current);
		DBSortedSmallCollectionElement (const DBSortedSmallCollectionElement& op);
		DBSortedSmallCollectionElement ();
		virtual DBElementBase* CloneElement ();
};

class DBSmallCollectionElement : public DBElementBase, public SCollectionElementsObj

{
	public:
		virtual void First (DBCollectionNode& node);
		virtual unsigned long GetCount (DBCollectionNode& node);
		virtual inline const char * GetString () const;
		virtual void Last ();
		virtual BOOL New (DBCollectionNode& node);
		virtual void Next ();
		virtual BOOL Okay () const;
		virtual void Prev ();
		virtual inline void SetKey (const char* key);//; for sorted collections !
		virtual void SetStatus (int s);
		virtual void SetString (const char* linea);
		virtual inline VirtualRecordId GetVirtualRecordId () const;
		virtual inline void SetVirtualRecordId (const VirtualRecordId& rec_ids);
		virtual inline BOOL Destroy (DBCollectionNode& node);
		virtual long GotoVirtualRecordId (VirtualRecordId& id);
		virtual inline unsigned long GetSequence () const;
		virtual inline void SetSequence (unsigned long current);
		DBSmallCollectionElement (const DBSmallCollectionElement& op);
		DBSmallCollectionElement ();
		virtual DBElementBase* CloneElement ();
};

class DBSortedLargeCollectionElement : public DBElementBase, public LSCollectionElementsObj

{
	public:
		virtual void First (DBCollectionNode& node);
		virtual unsigned long GetCount (DBCollectionNode& node);
		virtual inline const char * GetString () const;
		virtual void Last ();
		virtual BOOL New (DBCollectionNode& node);
		virtual void Next ();
		virtual BOOL Okay () const;
		virtual void Prev ();
		virtual inline void SetKey (const char* key);//; for sorted collections !
		virtual void SetStatus (int s);
		virtual void SetString (const char* linea);
		virtual inline void SetVirtualRecordId (const VirtualRecordId& rec_ids);
		virtual inline VirtualRecordId GetVirtualRecordId () const;
		virtual inline BOOL Destroy (DBCollectionNode& node);
		virtual long GotoVirtualRecordId (VirtualRecordId& id);
		virtual inline unsigned long GetSequence () const;
		virtual inline void SetSequence (unsigned long current);
		DBSortedLargeCollectionElement (const DBSortedLargeCollectionElement& op);
		DBSortedLargeCollectionElement ();
		virtual DBElementBase* CloneElement ();
};

class DBLargeCollectionElement : public DBElementBase, public LCollectionElementsObj

{
	public:
		virtual void First (DBCollectionNode& node);
		virtual unsigned long GetCount (DBCollectionNode& node);
		virtual inline const char * GetString () const;
		virtual void Last ();
		virtual BOOL New (DBCollectionNode& node);
		virtual void Next ();
		virtual BOOL Okay () const;
		virtual void Prev ();
		virtual inline void SetKey (const char* key);//; for sorted collections !
		virtual void SetStatus (int s);
		virtual void SetString (const char* linea);
		virtual inline VirtualRecordId GetVirtualRecordId () const;
		virtual inline void SetVirtualRecordId (const VirtualRecordId& rec_ids);
		virtual inline BOOL Destroy (DBCollectionNode& node);
		virtual long GotoVirtualRecordId (VirtualRecordId& id);
		virtual inline unsigned long GetSequence () const;
		virtual inline void SetSequence (unsigned long current);
		DBLargeCollectionElement (const DBLargeCollectionElement& op);
		DBLargeCollectionElement ();
		virtual DBElementBase* CloneElement ();
};

class DBCollectionNode : public CollectionNodeObj

{
	public:
		DBCollectionNode (unsigned long id = 0);
		virtual ~DBCollectionNode ();
		DBCollectionNode& operator = (const DBCollectionNode& op);
};

#ifndef INC_VIRRECID_HPP
#include "virrecid.hpp"
#endif
inline const char * DBSortedSmallCollectionElement::GetString () const 
{
	return GetPString () ;
}

inline void DBSortedSmallCollectionElement::SetKey (const char* key)
{
	SetPKey ( key ) ;
}

inline const char * DBSmallCollectionElement::GetString () const 
{
	return GetPString () ;
}

inline void DBSmallCollectionElement::SetKey (const char* key)
{
	SetPKey ( key ) ;
}

inline const char * DBLargeCollectionElement::GetString () const 
{
	return GetPString () ;
}

inline void DBLargeCollectionElement::SetKey (const char* key)
{
	SetPKey ( key ) ;
}

inline const char * DBSortedLargeCollectionElement::GetString () const 
{
	return GetPString () ;
}

inline void DBSortedLargeCollectionElement::SetKey (const char* key)
{
	SetPKey ( key ) ;
}

inline const char * SSCollectionElementsObj::GetPString () const 
{
	return sortElemS ;
}

inline const char * SSCollectionElementsObj::GetPKey () const 
{
	return collKeyS ;
}

inline const char * SCollectionElementsObj::GetPKey () const //; Not a keyed element
{
	return "" ;
}

inline const char * SCollectionElementsObj::GetPString () const 
{
	return elemS ;
}

inline const char * LCollectionElementsObj::GetPString () const 
{
	return elemL ;
}

inline const char * LCollectionElementsObj::GetPKey () const //; Not a keyed element
{
	return "" ;
}

inline const char * LSCollectionElementsObj::GetPKey () const 
{
	return collKeyL ;
}

inline const char * LSCollectionElementsObj::GetPString () const 
{
	return sortElemL ;
}

inline VirtualRecordId DBSmallCollectionElement::GetVirtualRecordId () const 
{
	return GetPVirtualRecordId () ;
}

inline void DBSmallCollectionElement::SetVirtualRecordId (const VirtualRecordId& rec_ids)
{
	SetPVirtualRecordId ( rec_ids );
}

inline VirtualRecordId DBLargeCollectionElement::GetVirtualRecordId () const 
{
	return GetPVirtualRecordId () ;
}

inline void DBLargeCollectionElement::SetVirtualRecordId (const VirtualRecordId& rec_ids)
{
	SetPVirtualRecordId ( rec_ids );
}

inline VirtualRecordId DBSortedLargeCollectionElement::GetVirtualRecordId () const 
{
	return GetPVirtualRecordId () ;
}

inline void DBSortedLargeCollectionElement::SetVirtualRecordId (const VirtualRecordId& rec_ids)
{
	SetPVirtualRecordId ( rec_ids );
}

inline VirtualRecordId DBSortedSmallCollectionElement::GetVirtualRecordId () const 
{
	return GetPVirtualRecordId () ;
}

inline void DBSortedSmallCollectionElement::SetVirtualRecordId (const VirtualRecordId& rec_ids)
{
	SetPVirtualRecordId ( rec_ids );
}

inline REC_TYPE CollectionNodeObj::RecType ()
{
	return REC_COLLECTIONNODE ;
}

inline REC_TYPE SSCollectionElementsObj::RecType ()
{
	return REC_SSCOLLECTIONELEMENTS ;
}

inline REC_TYPE SCollectionElementsObj::RecType ()
{
	return REC_SCOLLECTIONELEMENTS ;
}

inline REC_TYPE LSCollectionElementsObj::RecType ()
{
	return REC_LSCOLLECTIONELEMENTS ;
}

inline REC_TYPE LCollectionElementsObj::RecType ()
{
	return REC_LCOLLECTIONELEMENTS ;
}

inline BOOL DBSortedSmallCollectionElement::Destroy (DBCollectionNode& node)
{
	BOOL rtn = DisConnect ( node ) ;
	Delete ();
	return rtn ;
}

inline BOOL DBSmallCollectionElement::Destroy (DBCollectionNode& node)
{
	BOOL rtn = DisConnect ( node ) ;
	Delete ();
	return rtn ;
}

inline BOOL DBLargeCollectionElement::Destroy (DBCollectionNode& node)
{
	BOOL rtn = DisConnect ( node ) ;
	Delete ();
	return rtn ;
}

inline BOOL DBSortedLargeCollectionElement::Destroy (DBCollectionNode& node)
{
	BOOL rtn = DisConnect ( node ) ;
	Delete ();
	return rtn ;
}

inline unsigned long SSCollectionElementsObj::GetPSequence () const 
{
	return sequence ;
}

inline void SSCollectionElementsObj::SetPSequence (unsigned long cur)
{
	sequence = cur ;
}

inline unsigned long DBSortedSmallCollectionElement::GetSequence () const 
{
	return GetPSequence () ;
}

inline void DBSortedSmallCollectionElement::SetSequence (unsigned long current)
{
	SetPSequence ( current );
}

inline unsigned long DBLargeCollectionElement::GetSequence () const 
{
	return GetPSequence () ;
}

inline void DBLargeCollectionElement::SetSequence (unsigned long current)
{
	SetPSequence ( current );
}

inline unsigned long DBSortedLargeCollectionElement::GetSequence () const 
{
	return GetPSequence () ;
}

inline void DBSortedLargeCollectionElement::SetSequence (unsigned long current)
{
	SetPSequence ( current );
}

inline unsigned long DBSmallCollectionElement::GetSequence () const 
{
	return GetPSequence () ;
}

inline void DBSmallCollectionElement::SetSequence (unsigned long current)
{
	SetPSequence ( current );
}

inline void LCollectionElementsObj::SetPSequence (unsigned long cur)
{
	sequence = cur ;
}

inline unsigned long LCollectionElementsObj::GetPSequence () const 
{
	return sequence ;
}

inline unsigned long SCollectionElementsObj::GetPSequence () const 
{
	return sequence ;
}

inline void SCollectionElementsObj::SetPSequence (unsigned long cur)
{
	sequence = cur ;
}

inline unsigned long LSCollectionElementsObj::GetPSequence () const 
{
	return sequence ;
}

inline void LSCollectionElementsObj::SetPSequence (unsigned long cur)
{
	sequence = cur ;
}


#endif
