#ifndef INC_DBCOLLEC_HPP
#define INC_DBCOLLEC_HPP

//. MODULE: DBCollection

// @@Includes
#ifndef INC_DBTEMPOB_HPP
#include "dbtempob.hpp"
#endif
// @@End
class DBAbstractCollection//; After building any collection, remember to call Init () !!

{
	private:
		void SetCount ();
		DBCollectionNode node;
	public:
		inline unsigned long GetCount () const;
	private:
		unsigned long count;//; total # of elements in the collection.
	public:
		VirtualRecordId At (unsigned long num);
		DBAbstractCollection (unsigned long id, DBElementBase* anElement, unsigned short len);//; must set currency to first pElement of collection
		void Insert (const VirtualRecordId& rec_ids, const char* str, const char* key = 0);
	private:
		unsigned long current;
	public:
		VirtualRecordId GetVirtualRecordId () const;
	private:
		void First ();
		void Next ();
		void Prev ();
		void Last ();
	protected:
		BOOL Okay () const;
		void Init ();//; Initialize the collection for use: set count and make first element current
	public:
		inline DBAbstractCollection & operator [] (unsigned long num);
		inline const char * AtAsAscii (unsigned long num);//; return string at position passed.
	private:
		DBAbstractCollection & Goto (unsigned long num);
		inline const char * GetString () const;
	public:
		BOOL Valid () const;
	private:
		BOOL initHasBeenCalled;
	public:
		virtual inline BOOL IsSorted () const =0;
		virtual ~DBAbstractCollection ();
	private:
		DBElementBase* pElement;
		unsigned short cColWidth;
	public:
		inline unsigned short GetWidth () const;
		long GotoVirtualRecordId (VirtualRecordId& id);
	protected:
		long CollectionId;
		static long CollectionCount;
	public:
		inline BOOL operator != (const DBAbstractCollection& OtherCollection) const;
		inline BOOL operator == (const DBAbstractCollection& OtherCollection) const;
	private:
		RefCounter* ref;
		void DestroyCollection ();//; from disk !
	public:
		DBAbstractCollection & operator = (const DBAbstractCollection& o);
	protected:
		DBAbstractCollection (const DBAbstractCollection& o);
	public:
		virtual DBAbstractCollection * Clone () =0;
};

class DBSortedCollection : public DBAbstractCollection//: Se sabe el tamano de los elementos y si
	//+ es sorted o no. Se puede pues pedir una
	//. coleccion apropiada !

{
	public:
		DBSortedCollection (unsigned long id, unsigned short len);//; must set currency to first element of collection
		virtual inline BOOL IsSorted () const;
	private:
		DBElementBase * SuitableElement (unsigned short len);
	public:
		virtual DBAbstractCollection * Clone ();
	protected:
		DBSortedCollection (const DBSortedCollection& o);
};

class DBUnsortedCollection : public DBAbstractCollection

{
	public:
		DBUnsortedCollection (unsigned long id, unsigned short len);//; must set currency to first element of collection
		virtual inline BOOL IsSorted () const;
	private:
		DBElementBase * SuitableElement (unsigned short len);
	protected:
		DBUnsortedCollection (const DBUnsortedCollection& o);
	public:
		virtual DBAbstractCollection * Clone ();
};

inline BOOL DBUnsortedCollection::IsSorted () const 
{
	return False ;
}

inline unsigned long DBAbstractCollection::GetCount () const 
{
	return count ;
}

inline DBAbstractCollection & DBAbstractCollection::operator [] (unsigned long num)
{
	return Goto ( num ) ;
}

inline const char * DBAbstractCollection::AtAsAscii (unsigned long num)
{
	if ( Valid () )
	{
		Goto ( num ) ;
		return pElement->GetString () ;
	}
	else
	{
		return "" ;
	}
}

inline const char * DBAbstractCollection::GetString () const 
{
	return pElement->GetString () ;
}

inline unsigned short DBAbstractCollection::GetWidth () const 
{
	return cColWidth ;
}

inline BOOL DBSortedCollection::IsSorted () const 
{
	return True ;
}

inline BOOL DBAbstractCollection::operator != (const DBAbstractCollection& OtherCollection) const 
{
	return ! ( operator== ( OtherCollection ) );
}

inline BOOL DBAbstractCollection::operator == (const DBAbstractCollection& OtherCollection) const 
{
	return CollectionId == OtherCollection.CollectionId ;
}


#endif
