// vlistbox.cpp		VIRTUAL LISTBOX CLASS WITH TWO SCROLL BARS
//	written by Gregory K. Miskin
//	COPYRIGHT (C) 1992.  All Rights Reserved.
//	Gregory K. Miskin, Orem, Utah  USA

#define Uses_TListViewer
#define Uses_TEvent
#define Uses_TScrollBar
#define Uses_TKeys
#define Uses_TView
#define Uses_MsgBox

#include <tv.h>
#include <string.h>
#include <stdlib.h>
#include "commands.hpp"
#include "vlistbox.hpp"

/*------------------------------------------------------------------------*/
VListBox::VListBox( const TRect& bounds,
						  ushort aNumCols,
						  TScrollBar *hScrollBar,
						  TScrollBar *vScrollBar, DataIndex **i):
	 TListViewer(bounds, aNumCols, hScrollBar, vScrollBar)
{
	name  = i;
	(*name)->top();
	numRecs = (*name)->reccount();

	oldItem = 0;
	setRange(numRecs);
	vScrollBar->maxVal = numRecs;
}

/*------------------------------------------------------------------------*/
VListBox::~VListBox()
{
}

/*------------------------------------------------------------------------*/
void VListBox::getText( char *dest, short item, short )
{
	GetRecord(item, TRUE);
	strcpy( dest, line );
}

/*------------------------------------------------------------------------*/
long VListBox::GetRecord(short item, int build)
{
	short skipVal;
	long RECNO = 0;

	skipVal 	= item - oldItem;
	(*name)->skip(skipVal);
	RECNO		= (*name)->recno();  // CodeBase function returns a long value
	oldItem 	= item;

	if(build == TRUE)
	{
		GetFields();
		BuildLine();
	}
	return(RECNO);
}

/*------------------------------------------------------------------------*/
void VListBox::GetFields(void)
{
	memset(&fields, 0, sizeof(fields));
	GetStr(nmFIRST_NAME, fields.fname);
	GetStr(nmLAST_NAME, 	fields.lname);
	GetStr(nmSTREET, 		fields.street);
	GetStr(nmCITY, 		fields.city);
	GetStr(nmSTATE, 		fields.state);
	GetStr(nmZIP, 			fields.zip);
}

/*------------------------------------------------------------------------*/
void VListBox::GetStr(int field_num, char *fld)
{
	int len = 0;

	Fld = (*name)->field(field_num);
	len = Fld->len();
	strncpy(fld,Fld->ptr(),len);
}

/*------------------------------------------------------------------------*/
void VListBox::BuildLine()
{
	long recno;
	char recstr[7];
	char temp[7];
	char blank[] = " ";
	char del[]	 = "*";
	memset(&line, 0, sizeof(line));

	recno = (*name)->recno();
	ltoa(recno, temp, 10);
	for(int x = 0; x < 7; x++)
		recstr[x] = 32;

	recstr[6] = NULL;
	int s = strlen(temp) - 1;

	for(int ln = strlen(recstr) -1; s >= 0; ln--)
	{
		recstr[ln] = temp[s];
		s--;
	}

	if((*name)->deleted())
		strcpy(line, del);
	else
		strcpy(line, blank);

	strcat(line, recstr);
	strcat(line, blank);
	strcat(line, blank);
	strcat(line, fields.lname);
	strcat(line, blank);
	strcat(line, fields.fname);
	strcat(line, blank);
	strcat(line, blank);
	strcat(line, fields.street);
	strcat(line, blank);
	strcat(line, fields.city);
	strcat(line, blank);
	strcat(line, fields.state);
	strcat(line, blank);
	strcat(line, fields.zip);
}
