// search.cpp			BROWSE SEARCH WINDOW
//	written by Gregory K. Miskin
//	COPYRIGHT (C) 1992.  All Rights Reserved.
//	Gregory K. Miskin, Orem, Utah  USA

#define Uses_TButton
#define Uses_TEvent
#define Uses_TDialog
#define Uses_TRect
#define Uses_TStaticText
#define Uses_TInputLine

#include <tv.h>
#include <stdlib.h>
#include <string.h>
#include "commands.hpp"
#include "formatln.hpp"
#include "search.hpp"

/*------------------------------------------------------------------------*/
TSearchRecord::TSearchRecord() :
		TDialog(TRect(0, 0, 30, 9), "Search"),
		TWindowInit(&TSearchRecord::initFrame)
{
	recno = new TFormatLine(TRect(16,2,25,3),"NNNNNN", 7);
	key = new TFormatLine(TRect(16,4,28,5), "AAAAAAAA",9);

	if(GeneralFlag == 1)
		recno->options &= (!ofSelectable);
	else
		key->options &= (!ofSelectable);

	insert(recno);
	insert(key);

	insert(new TStaticText(TRect(1,2,16,3), "Record Number:"));
	insert(new TStaticText(TRect(5,4,16,5), "Name Key:"));

	insert(new TButton(TRect(2,6,12,8), "~S~earch", cmEnd, bfNormal));
	insert(new TButton(TRect(17,6,27,8), "~C~ancel", cmCancel, bfNormal));

	memset(&fields, 0, sizeof(fields));
	setData(&fields);
	search = FALSE;
	options |= ofCentered;
	selectNext(FALSE);
}

/*------------------------------------------------------------------------*/
void TSearchRecord::handleEvent(TEvent &event)
{
	 TDialog::handleEvent(event);

	 switch(event.what)
	 {
		case evCommand:
			switch(event.message.command)
			{
				case cmEnd:
					getData(&fields);
					search = TRUE;
					event.what = evCommand;
					event.message.command = cmCancel;
					event.message.infoPtr = 0;
					putEvent(event);
					break;

				default:
					break;
			}
			break;

		case evBroadcast:
			if(event.message.command == cmDefault)
			{
				selectNext(FALSE);
			}
			break;
		default:
			return;
	}
}

/*------------------------------------------------------------------------*/
TSearchRecord::~TSearchRecord(void)
{
}
