/****************************************************************************
*****************************************************************************
***                                                                       ***
***  TFormatLine - A formatted derivative of TInputLine                   ***
***                                                                       ***
***  Formatting Specifiers:                                               ***
***    U = Uppercase Alpha/Numeric                                        ***
***    u = Alpha/Numeric                                                  ***
***    A = Uppercase Alpha                                                ***
***    a = Alpha                                                          ***
***    N = Numeric                                                        ***
***                                                                       ***
***  Any other character passed in the format string will be treated as   ***
***  a literal character and will be displayed in the string              ***
***                                                                       ***
*****************************************************************************
****************************************************************************/

#ifndef _formatln_hpp
#define _formatln_hpp

#define Uses_TRect
#define Uses_TInputLine
#define Uses_TKeys
#define Uses_TDrawBuffer
#define Uses_TEvent
#include <tv.h>

class TFormatLine: public TInputLine
{
	public:
		TFormatLine( const TRect& bounds, const char *aFormat, int aDataLen);
		~TFormatLine();
		virtual ushort dataSize() { return dataLen; }
		virtual void getData( void *rec );
		virtual void handleEvent( TEvent& event );
		virtual void setData( void *rec );
		virtual void selectAll( Boolean enable );

		//*** Add read and write methods when stream use is necessary ***

	protected:
		//*** Private Member Functions ***
		int 	CursorBack();
		int 	CursorForward();
		void	CursorEnd();
		int   isInputPos(int Position);
		void	atDelete(int deletePos);
		void 	deleteSelect();

		//*** Private Data Members ***
		char 	*format;
		char 	*out;
		ushort dataLen;
};

#endif