// demo.hpp				DESKTOP FOR VIRTUAL LISTBOX DEMO
//	written by Gregory K. Miskin
//	COPYRIGHT (C) 1992.  All Rights Reserved.
//	Gregory K. Miskin, Orem, Utah  USA


#ifndef _demo_hpp_
#define _demo_hpp_

extern unsigned _stklen = 10000;

class TStatusLine;
class TMenuBar;
class TEvent;
class THeapView;
class TClockView;
class TBrowseNames;
class TSelectIndex;

class BrowseDemo : public TApplication
{
public:
	BrowseDemo( int argc, char **argv );
	static TStatusLine *initStatusLine( TRect r );
	static TMenuBar *initMenuBar( TRect r );
	virtual void handleEvent(TEvent& Event);
	virtual void idle();              // Updates heap and clock views

protected:
	THeapView 		*heap;			// Heap view
	TClockView 		*clock;			// Clock view
	TBrowseNames	*browse_names;
	TSelectIndex	*select_index;

	void About();
	void Browse();
	void ChangeDir();                 // Change directory
	void Shell();                     // DOS Shell
	void OutOfMemory();               // For validView() function
};
#endif