// browse.cpp			BROWSE DIALOG BOX
//	written by Gregory K. Miskin
//	COPYRIGHT (C) 1992.  All Rights Reserved.
//	Gregory K. Miskin, Orem, Utah  USA

#define Uses_TEvent
#define Uses_TScrollBar
#define Uses_TListBox
#define Uses_TDialog
#define Uses_TKeys
#define Uses_TProgram
#define Uses_TDeskTop
#define Uses_TButton
#define Uses_MsgBox

#include <tv.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include "commands.hpp"
#include "structs.hpp"
#include "edit.hpp"
#include "search.hpp"
#include "browse.hpp"

short screenSize = 18;

/*------------------------------------------------------------------------*/
TBrowseNames::TBrowseNames() :
		TDialog(TRect(0, 0, 80, 23), "Browse Names"),
		TWindowInit(&TBrowseNames::initFrame)
{
	cBase = new CodeBase;
	name  = new DataIndex(cBase);
	cBase->open_error = 0;
	OpenFiles();

	TRect r = getClipRect();
	r.grow(-1,-1);
	r.b.y = r.b.y -1;
	r.b.x = r.b.x -1;

	vbar = new TScrollBar(TRect (78,1,79,21));
	hbar = new TScrollBar(TRect (1,21,78,22));

	vbar->setStep(screenSize, 1);
	hbar->maxVal = 26;
	hbar->setStep(26, 1);
	hbar->setValue(0);

	listBox = new VListBox(r, 1, hbar, vbar, &name);
	insert(listBox);
	insert(vbar);
	insert(hbar);

	options |= ofCentered;
	delCount = 0;
}

/*------------------------------------------------------------------------*/
TBrowseNames::~TBrowseNames()
{
	int rcode;

	if(delCount > 0)
	{
		rcode = messageBox("\003 Remove Deleted Records?", mfConfirmation | mfOKCancel);

		if(rcode == cmOK)
		{
			long num_recs;
			name->pack();
			num_recs = name->reccount();
			name->file.read(4, StrLen(&num_recs,sizeof(num_recs)));
			name->zap(num_recs + 1L, name->reccount());
		}
	}
	cBase->close_all();

	delete(cBase);
	delete(name);
}

/*------------------------------------------------------------------------*/
void TBrowseNames::OpenFiles()
{
	name->open("DEMO.DBF");

	if(GeneralFlag == 1)
		status = name->select("DEMONDX");
}

/*------------------------------------------------------------------------*/
void TBrowseNames::handleEvent(TEvent &event)
{
	 TDialog::handleEvent(event);

	 switch(event.what)
	 {
		case evCommand:
			switch(event.message.command)
			{
				case cmSearch:
					Search();
					break;

				default:
					break;
			}
			break;

		case evKeyDown:
			switch(event.keyDown.keyCode)
			{
				case kbRight:
					if(hbar->value <= hbar->maxVal)
					{
						int val = hbar->value + 1;
						hbar->setValue(val);
					}
					break;

				case kbLeft:
					if(hbar->value > 0)
					{
						int val = hbar->value - 1;
						hbar->setValue(val);
					}
					break;

				case kbCtrlRight:
					if(hbar->value <= hbar->maxVal)
					{
						int val = hbar->maxVal;
						hbar->setValue(val);
					}
					break;

				case kbCtrlLeft:
					if(hbar->value > 0)
					{
						int val = 0;
						hbar->setValue(val);
					}
					break;

				case kbAltF3:
					event.what = evCommand;
					event.message.command = cmCancel;
					event.message.infoPtr = 0;
					putEvent(event);
					break;

				default:
					break;
			}
			break;

		case evBroadcast:
			if(event.message.command == cmDefault)
				EditRecord();
			break;

		default:
			return;
	}
}

/*------------------------------------------------------------------------*/
void TBrowseNames::EditRecord()
{
	long currRecord;
	int recPos = 0;

	long item = listBox->focused;
	currRecord = listBox->GetRecord(item, FALSE);

	edit_record = new TEditRecord(&name);
	TProgram::deskTop->execView(edit_record);
	delCount += edit_record->delCount;
	destroy(edit_record);

	listBox->drawView();
}

/*------------------------------------------------------------------------*/
void TBrowseNames::Search()
{
	long searchRecord = 0;
	char searchKey[9];

	TSearchRecord *search_record = new TSearchRecord();
	TProgram::deskTop->execView(search_record);

	if(search_record->search)
	{
		if(strlen(search_record->fields.recno) > 0)
			searchRecord = atol(search_record->fields.recno);

		strcpy(searchKey, search_record->fields.key);
		count = name->reccount();

		if(searchRecord)
		{
			if(searchRecord > count)
				messageBox("Record number larger than number of records in file",
								mfError | mfOKButton);
			else
				searchByRecord(searchRecord);
		}
		else
			searchByName(searchKey);
	}
	destroy(search_record);
}

/*------------------------------------------------------------------------*/
void TBrowseNames::searchByRecord(long newRecord)
{

	newRecord--;
	listBox->GetRecord(newRecord, FALSE);
	listBox->focusItemNum(newRecord);
}

/*------------------------------------------------------------------------*/
void TBrowseNames::searchByName(char *key)
{
	long 		botItem			= 0;
	long 		topItem 			= 0;
	long		oldItem			= 0;
	float		newItem 			= 0;
	int		move				= 99;
	int		done				= 0;
	long		skipval			= 0;
	char		recKey[16];
	char		searchKey[16];

	newItem = listBox->focused;
	listBox->GetRecord(newItem, FALSE);

	Field		*field;
	field = name->field(nmLAST_NAME);
	botItem = count;
	strcpy(searchKey, key);

	while(done == NULL)
	{
		strncpy(recKey, field->ptr(), 16);
		move = strcmp(searchKey, recKey);

		if(move == NULL)
			done = 1;
		else
			if(move > NULL)
			{
				topItem = newItem;
				oldItem = newItem;
				newItem = (((botItem - topItem) / 2) + topItem);
				if((newItem - oldItem) < 1)
				{
					newItem++;
					done = 1;
				}
			}
			else
				if(move < NULL)
				{
					botItem = newItem;
					oldItem = newItem;
					newItem = (((botItem - topItem) / 2) + topItem);
					if((oldItem - newItem) < 1)
						done = 1;
				}
		listBox->GetRecord(newItem, FALSE);
	}
	listBox->focusItemNum(newItem);
}
