/****************************************************************************

    PROGRAM:    Vlibdemo.exe

    PURPOSE:    To demonstrate the usage of Visualib(TM) functions.
    
    PROVIDER:   Visual Technology, Co.
				P.O.Box 901-413
				Kansas City, MO 64190
				Tel. (219) 289-0235
				Fax. (816) 746-6618
    
    DATE:		May, 1993

****************************************************************************/

#include <windows.h>
#include <stdlib.h>
#include <math.h>
#include "visualib.h"
#include "menu.h"
#include "vlibdemo.h"
#include "demoproc.h"

HINSTANCE	hdllinst = 0;

int WINAPI LibMain (HINSTANCE hinst, WORD wDataSeg, WORD cbHeapSize, LPSTR lpszCmdLine)
{
	if (cbHeapSize != 0)
		UnlockData (0);
	hdllinst = hinst;
	return (1);
}

VOID WINAPI MinRoutine (int nParameter, LPSTR lpszParam2)
{
	
}

int	WINAPI WEP (int nParameter)
{
	if (nParameter == WEP_SYSTEM_EXIT) {
		return (1);
	}
	else if (nParameter == WEP_FREE_DLL) {
		return (1);
	}
	else {
		return (1);
	}
}

VOIDED	LineDemo2D (HDC hdc)
{
	SetViewerName (VL_CURRENT, "2D Lines");
	PenColor (hdc, VL_RED);
	MoveTo2D (hdc, 0, 0);
	LineTo2D (hdc, 1, 1);
	RLineTo2D (hdc, -2, 0);
	RLineTo2D (hdc, 0, -2);
	RLineTo2D (hdc, 2, 0);
	RLineTo2D (hdc, 0, 2);
	RMoveTo2D (hdc, 1, 1);
	LineTo2D (hdc, -2, 2);
	PenColor (hdc, VL_BLUE);
	MoveTo2H (hdc, 1, 1, 0.5f);
	LineTo2H (hdc, 0, 1, 0);
	LineTo2H (hdc, 0, 0, 1);
	MoveTo2H (hdc, -1, 1, 0.5f);
	LineTo2H (hdc, -1, 0, 0);
	LineTo2H (hdc, 0, 0, 1);
	MoveTo2H (hdc, -1, -1, 0.5f);
	LineTo2H (hdc, 0, -1, 0);
	LineTo2H (hdc, 0, 0, 1);
	MoveTo2H (hdc, 1, -1, 0.5f);
	LineTo2H (hdc, 1, 0, 0);
	LineTo2H (hdc, 0, 0, 1);
	PenColor (hdc, VL_GREEN);
	Line2D (hdc, -15, 5, 15, 5);
	Line2D (hdc, -15, -5, 15, -5);
	Line2D (hdc, -5, -15, -5, 15);
	Line2D (hdc, 5, -15, 5, 15);
	Line2D (hdc, -15, 0, 0, 15);
	Line2D (hdc, 15, 0, 0, 15);
	Line2D (hdc, 0, -15, 15, 0);
	Line2D (hdc, 0, -15, -15, 0);
	PenColor (hdc, VL_YELLOW);
	Line2H (hdc, -5, 5, 0.75f, 5, 5, 0.75f);
	Line2H (hdc, -5, -5, 0.75f, 5, -5, 0.75f);
	Line2H (hdc, -5, -5, 0.75f, -5, 5, 0.75f);
	Line2H (hdc, 5, -5, 0.75f, 5, 5, 0.75f);
	PenColor (hdc, VL_BROWN);
	RLine2D (hdc, 2, 3, -5, -5);
}

VOIDED	PolylineDemo2D (HDC hdc)
{
	COORD	poly[] = {-1, -1, -1, 1, 1, 1, 1, -1};

	SetViewerName (VL_CURRENT, "2D PolyLines");
	PenColor (hdc, VL_RED);
	Polyline2D (hdc, VL_2D, poly, 4);
	PushTransformation2D (NULL);
	TranslateTo2D (3, 3);
	ClosedPolyline2D (hdc, VL_2D, poly, 4);
	TranslateTo2D (10, 0);
	ClosedPolyline2D (hdc, VL_2D, poly, 4);
	TranslateTo2D (10, -6);
	ClosedPolyline2D (hdc, VL_2D, poly, 4);
	TranslateTo2D (-10, -6);
	ClosedPolyline2D (hdc, VL_2D, poly, 4);
	TranslateTo2D (-10, 6);
	ClosedPolyline2D (hdc, VL_2D, poly, 4);
	PopTransformation2D (NULL);
	LineTo2D (hdc, 0, 0);
}

VOIDED	PointerDemo2D (HDC hdc)
{
	real	x, y, a;
	short	i;

	SetViewerName (VL_CURRENT, "2D Pointers");
	PenColor (hdc, VL_YELLOW);
	for (i = 0, a = 0; i < 12; i++, a += 0.5f) {
		x = (real) cos (a) * 9;
		y = (real) sin (a) * 5;
		Pointer2D (hdc, 0, 0, x, y, 1, 0.5f, VL_CLOSEDARROW);
	}
}

VOIDED	MarkDemo2D (HDC hdc)
{
	short	i;
	real	x, y;

	SetViewerName (VL_CURRENT, "2D Marks");
	PenColor (hdc, VL_BLUE);
	for (i = 0, x = -9, y = -6; i < 10; i++, x += 2)
		Mark2D (hdc, x, y, i+2, i+2, VL_CIRCLEMARK);
	for (i = 0, x = -9, y = -4; i < 10; i++, x += 2)
		Mark2D (hdc, x, y, i+2, i+2, VL_CROSSMARK);
	for (i = 0, x = -9, y = -2; i < 10; i++, x += 2)
		Mark2D (hdc, x, y, i+2, i+2, VL_XMARK);
	for (i = 0, x = -9, y = 0; i < 10; i++, x += 2)
		Mark2D (hdc, x, y, i+2, i+2, VL_TRIANGLEMARK);
	for (i = 0, x = -9, y = 2; i < 10; i++, x += 2)
		Mark2D (hdc, x, y, i+2, i+2, VL_BOXMARK);
	for (i = 0, x = -9, y = 4; i < 10; i++, x += 2)
		Mark2D (hdc, x, y, i+2, i+2, VL_DIAMONDMARK);
	for (i = 0, x = -9, y = 6; i < 10; i++, x += 2)
		Mark2D (hdc, x, y, i+2, i+2, VL_HEXAGONMARK);
}

VOIDED	LabelDemo2D (HDC hdc)
{
	SetViewerName (VL_CURRENT, "2D Labels");
	TextColor (hdc, VL_RED, VL_WHITE, TRANSPARENT);
	PenColor (hdc, VL_GREEN);
	SetTextAlign (hdc, TA_CENTER | TA_BASELINE);
	Label2D (hdc, 0, 0, "Center & BaseLine");
	Mark2D (hdc, 0, 0, 15, 5, VL_CROSSMARK);
	SetTextAlign (hdc, TA_CENTER | TA_TOP);
	Label2D (hdc, 0, 3, "Center & Top");
	Mark2D (hdc, 0, 3, 15, 3, VL_CROSSMARK);
	SetTextAlign (hdc, TA_CENTER | TA_BOTTOM);
	Label2D (hdc, 0, -3, "Center & Bottom");
	Mark2D (hdc, 0, -3, 15, 3, VL_CROSSMARK);

	SetTextAlign (hdc, TA_LEFT | TA_BASELINE);
	Label2D (hdc, 3.5f, 0, "Left & BaseLine");
	Mark2D (hdc, 3.5f, 0, 15, 5, VL_CROSSMARK);
	SetTextAlign (hdc, TA_LEFT | TA_TOP);
	Label2D (hdc, 3.5f, 3, "Left & Top");
	Mark2D (hdc, 3.5f, 3, 15, 3, VL_CROSSMARK);
	SetTextAlign (hdc, TA_LEFT | TA_BOTTOM);
	Label2D (hdc, 3.5f, -3, "Left & Bottom");
	Mark2D (hdc, 3.5f, -3, 15, 3, VL_CROSSMARK);

	SetTextAlign (hdc, TA_RIGHT | TA_BASELINE);
	Label2D (hdc, -3.5f, 0, "Right & BaseLine");
	Mark2D (hdc, -3.5f, 0, 15, 5, VL_CROSSMARK);
	SetTextAlign (hdc, TA_RIGHT | TA_TOP);
	Label2D (hdc, -3.5f, 3, "Right & Top");
	Mark2D (hdc, -3.5f, 3, 15, 3, VL_CROSSMARK);
	SetTextAlign (hdc, TA_RIGHT | TA_BOTTOM);
	Label2D (hdc, -3.5f, -3, "Right & Bottom");
	Mark2D (hdc, -3.5f, -3, 15, 3, VL_CROSSMARK);
}

VOIDED	NetDemo2D (HDC hdc)
{
	COORD	net[140];
	short	i, j, index = 0;
	real	x, y;

	PenColor (hdc, VL_BLUE);
	;
	for (i = 0, y = -6.5f; i < 7; i++, y += 2) {
		for (j = 0, x = -9.5f; j < 10; j++, x += 2) {
			net[index++] = x + ((real) rand () / RAND_MAX);
			net[index++] = y + ((real) rand () / RAND_MAX);
		}
	}
	Net2D (hdc, VL_2D, (LPCOORD) net, 7, 10);
	SetViewerName (VL_CURRENT, "2D Net");
}

VOIDED	Prime2D (HDC hdc, int func)
{
	PenColor (hdc, VL_WHITE);
	DisplayViewerFrame (hdc, VL_CURRENT);
	switch (func) {
		case IDM_2DPRIME_LINE:
			LineDemo2D (hdc);
			break;
		case IDM_2DPRIME_POLYLINE:
			PolylineDemo2D (hdc);
			break;
		case IDM_2DPRIME_POINTER:
			PointerDemo2D (hdc);
			break;
		case IDM_2DPRIME_MARK:
			MarkDemo2D (hdc);
			break;
		case IDM_2DPRIME_LABEL:
			LabelDemo2D (hdc);
			break;
		case IDM_2DPRIME_ARROW:
			SetViewerName (VL_CURRENT, "3D Arrows");
			break;
		case IDM_2DPRIME_NET:
			NetDemo2D (hdc);
			break;
	}
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
	DisplayViewerName (hdc, VL_CURRENT, FALSE);
}

VOIDED	LineDemo3D (HDC hdc)
{
	SetViewerName (VL_CURRENT, "3D Lines");
	PenColor (hdc, VL_RED);
	MoveTo3D (hdc, 0, 0, 0);
	LineTo3D (hdc, 10, 10, 0);
	RLineTo3D (hdc, 0, -20, 0);
	RLineTo3D (hdc, -20, 0, 0);
	RLineTo3D (hdc, 0, 20, 0);
	RLineTo3D (hdc, 20, 0, 0);
	PenColor (hdc, VL_BLUE);
	MoveTo3H (hdc, 1, 1, 0, 0.5f);
	LineTo3H (hdc, 0, 1, 0, 0);
	LineTo3H (hdc, 0, 0, 0, 1);
	MoveTo3H (hdc, -1, 1, 0, 0.5f);
	LineTo3H (hdc, -1, 0, 0, 0);
	LineTo3H (hdc, 0, 0, 0, 1);
	MoveTo3H (hdc, -1, -1, 0, 0.5f);
	LineTo3H (hdc, 0, -1, 0, 0);
	LineTo3H (hdc, 0, 0, 0, 1);
	MoveTo3H (hdc, 1, -1, 0, 0.5f);
	LineTo3H (hdc, 1, 0, 0, 0);
	LineTo3H (hdc, 0, 0, 0, 1);
	PenColor (hdc, VL_YELLOW);
	MoveTo3D (hdc, 100, 100, 90);
	LineTo3D (hdc, 10, 0, 0);
	MoveTo3D (hdc, 100, 100, 90);
	LineTo3D (hdc, 0, 10, 0);
	MoveTo3D (hdc, 100, 100, 90);
	LineTo3D (hdc, 0, 0, 10);
}

VOIDED	PolylineDemo3D (HDC hdc)
{
	COORD	poly[] = {-1, -1, -1, 1, 1, 1, 1, -1};

	SetViewerName (VL_CURRENT, "3D PolyLines");
	PenColor (hdc, VL_RED);
	Polyline3D (hdc, VL_2D, poly, 4);
	PushTransformation3D (NULL);
	Scale3D (5, 5, 5);
	TranslateTo3D (3, 3, 0);
	PenColor (hdc, VL_GREEN);
	ClosedPolyline3D (hdc, VL_2D, poly, 4);
	TranslateTo3D (10, 0, 0);
	PenColor (hdc, VL_BLUE);
	ClosedPolyline3D (hdc, VL_2D, poly, 4);
	TranslateTo3D (10, -6, 0);
	PenColor (hdc, VL_YELLOW);
	ClosedPolyline3D (hdc, VL_2D, poly, 4);
	TranslateTo3D (-10, -6, 0);
	PenColor (hdc, VL_BROWN);
	ClosedPolyline3D (hdc, VL_2D, poly, 4);
	TranslateTo3D (-10, 6, 0);
	PenColor (hdc, VL_WHITE);
	ClosedPolyline3D (hdc, VL_2D, poly, 4);
	PopTransformation3D (NULL);
	LineTo3D (hdc, 0, 0, 0);
}

VOIDED	PointerDemo3D (HDC hdc)
{
	SetViewerName (VL_CURRENT, "3D Pointers");
	PenColor (hdc, VL_RED);
	Pointer3D (hdc, 0, 0, 0, 20, 0, 0, 5, 3, VL_OPENARROW);
	PenColor (hdc, VL_GREEN);
	Pointer3D (hdc, 0, 0, 0, 0, 20, 0, 5, 3, VL_CLOSEDARROW);
	PenColor (hdc, VL_BLUE);
	Pointer3D (hdc, 0, 0, 0, 0, 0, 20, 5, 3, VL_CROSSMARK);
	PenColor (hdc, VL_YELLOW);
	Pointer3D (hdc, 0, 0, 0, -20, 0, 0, 5, 3, VL_HEXAGONMARK);
	PenColor (hdc, VL_BROWN);
	Pointer3D (hdc, 0, 0, 0, 0, -20, 0, 5, 3, VL_TRIANGLEMARK);
	PenColor (hdc, VL_WHITE);
	Pointer3D (hdc, 0, 0, 0, 0, 0, -20, 5, 3, VL_BOXMARK);
}

VOIDED	MarkDemo3D (HDC hdc)
{
	SetViewerName (VL_CURRENT, "3D Marks");
	PenColor (hdc, VL_RED);
	Mark3D (hdc, 0, 0, 0, 5, 5, VL_CROSSMARK);
	PenColor (hdc, VL_GREEN);
	Mark3D (hdc, 20, 0, 0, 5, 5, VL_HEXAGONMARK);
	PenColor (hdc, VL_BLUE);
	Mark3D (hdc, 0, 20, 0, 5, 5, VL_DIAMONDMARK);
	PenColor (hdc, VL_WHITE);
	Mark3D (hdc, 0, 0, 20, 5, 5, VL_TRIANGLEMARK);
}

VOIDED	LabelDemo3D (HDC hdc)
{
	int	method;

	SetViewerName (VL_CURRENT, "3D Labels");
	Scale3D (2, 2, 2);
	method = ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, VL_WIREFRAME);
	PenColor (hdc, VL_GREEN);
	Cube (hdc, 20, 20, 20);
	ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, method);
	TextColor (hdc, VL_RED, VL_BLACK, TRANSPARENT);
	SetTextAlign (hdc, TA_BOTTOM | TA_CENTER);
	Label3D (hdc, -10, -10, 10, "Back Top");
	SetTextAlign (hdc, TA_BASELINE | TA_CENTER);
	Label3D (hdc, 10, 10, 10, "Front Top");
	SetTextAlign (hdc, TA_TOP | TA_CENTER);
	Label3D (hdc, 10, 10, -10, "Front Bottom");
	SetTextAlign (hdc, TA_BASELINE | TA_RIGHT);
	Label3D (hdc, 10, -10, 10, "Left Top");
	Label3D (hdc, 10, -10, -10, "Left Bottom");
	SetTextAlign (hdc, TA_BASELINE | TA_LEFT);
	Label3D (hdc, -10, 10, 10, "Right Top");
	Label3D (hdc, -10, 10, -10, "Right Bottom");
}

VOIDED	NetDemo3D (HDC hdc)
{
	COORD	net[210];
	short	i, j, index = 0;
	real	x, y;

	PushTransformation3D (NULL);
	Scale3D (5, 5, 5);
	PenColor (hdc, VL_BLUE);
	for (i = 0, y = -6.5f; i < 7; i++, y += 2) {
		for (j = 0, x = -9.5f; j < 10; j++, x += 2) {
			net[index++] = x + ((real) rand () / RAND_MAX);
			net[index++] = y + ((real) rand () / RAND_MAX);
			net[index++] = (real) rand () / RAND_MAX;
		}
	}
	Net3D (hdc, VL_3D, (LPCOORD) net, 7, 10);
	PopTransformation3D (NULL);
	SetViewerName (VL_CURRENT, "3D Net");
}

VOIDED	Prime3D (HDC hdc, int func)
{
	PenColor (hdc, VL_WHITE);
	DisplayViewerFrame (hdc, VL_CURRENT);
	MarkPosition3D (hdc, 0, 0, 0, 10, VL_ORIGIN);
	switch (func) {
		case IDM_3DPRIME_LINE:
			LineDemo3D (hdc);
			break;
		case IDM_3DPRIME_POLYLINE:
			PolylineDemo3D (hdc);
			break;
		case IDM_3DPRIME_POINTER:
			PointerDemo3D (hdc);
			break;
		case IDM_3DPRIME_MARK:
			MarkDemo3D (hdc);
			break;
		case IDM_3DPRIME_LABEL:
			LabelDemo3D (hdc);
			break;
		case IDM_3DPRIME_ARROW:
			SetViewerName (VL_CURRENT, "3D Arrows");
			break;
		case IDM_3DPRIME_NET:
			NetDemo3D (hdc);
			break;
	}
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
	DisplayViewerName (hdc, VL_CURRENT, FALSE);
}

VOIDED	DrawNgon (HDC hdc, int type)
{
	real	x, y, t, w, h;
	short	i, j, n;

	t = 0;
	w = h = 1.75f;
	for (i = 0, y = -5; i < 3; i++, y += 5) {
		for (j = 0, x = -7.5f; j < 4; j++, x += 5) {
			n = i * 4 + j;
			PenColor (hdc, VL_RED + n);
			BrushColor (hdc, VL_RED + j * 3 + i);
			n += 3;
			if (type == VL_THREED)
				Ngon3D (hdc, x, y, t, w, h, n);
			else
				Ngon2D (hdc, x, y, t, w, h, n);
		}
	}
}

VOIDED	DrawStar (HDC hdc, int type)
{
	real	x, y, t, w, h;
	short	i, j, n;

	t = 0; w = h = 1.75f;
	for (i = 0, y = -5; i < 3; i++, y += 5) {
		for (j = 0, x = -7.5f; j < 4; j++, x += 5) {
			n = i * 4 + j;
			PenColor (hdc, VL_RED + n);
			BrushColor (hdc, VL_RED + j * 3 + i);
			n += 3;
			if (type == VL_THREED)
				Star3D (hdc, x, y, t, w, h, n);
			else
				Star2D (hdc, x, y, t, w, h, n);
		}
	}
}

VOIDED	DrawFlower (HDC hdc, int type)
{
	real	x, y, t, w, h, r;
	short	i, j, n;

	t = 0; w = h = 1.75f; r = 0.75f;
	for (i = 0, y = -5; i < 3; i++, y += 5) {
		;
		for (j = 0, x = -7.5f; j < 4; j++, x += 5) {
			n = i * 4 + j;
			PenColor (hdc, VL_RED + n);
			BrushColor (hdc, VL_RED + j * 3 + i);
			n += 3;
			if (type == VL_THREED)
				Flower3D (hdc, x, y, t, w, h, n, r);
			else
				Flower2D (hdc, x, y, t, w, h, n, r);
		}
	}
}

VOIDED	DrawWedge (HDC hdc, int type)
{
	real	x, y, t, w, h, a, b;
	short	i, j, n;

	t = 0;
	a = 0; ; w = h = 1.75f;
	for (i = 0, y = -5; i < 3; i++, y += 5) {
		for (j = 0, x = -7.5f, b = 30; j < 4; j++, x += 5, b += 30) {
			n = i * 4 + j;
			PenColor (hdc, VL_RED + n);
			BrushColor (hdc, VL_RED + j * 3 + i);
			if (type == VL_THREED)
				Wedge3D (hdc, x, y, t, w, h, a, b);
			else
				Wedge2D (hdc, x, y, t, w, h, a, b);
			t += 15;
		}
	}
}

VOIDED	DrawDisk (HDC hdc, int type)
{
	real	x, y, t, w, h;
	short	i, j, n;

	t = 0;
	w = 2; h = 0.2f;
	for (i = 0, y = -5; i < 3; i++, y += 5) {
		for (j = 0, x = -7.5f; j < 4; j++, x += 5) {
			n = i * 4 + j;
			PenColor (hdc, VL_RED + n);
			BrushColor (hdc, VL_RED + j * 3 + i);
			if (type == VL_THREED)
				Disk3D (hdc, x, y, t, w, h);
			else
				Disk2D (hdc, x, y, t, w, h);
			t += 15;
			w -= 0.15f;
			h += 0.15f;
		}
	}
}

VOIDED	DrawRose (HDC hdc, int type)
{
	real	x, y, t, r;
	short	i, j, m, n;

	t = 0;
	r = 2;
	for (i = 0, y = -4; i < 3; i++, y += 4) {
		n = i + 1;
		for (j = 0, x = -7.5f; j < 4; j++, x += 5) {
			switch (n) {
				case 1:
					m = j + 2;
					break;
				case 2:
					m = j * 2 + 1;
					break;
				case 3:
					m = j + 1 + j / 2;
					break;
			}
			PenColor (hdc, VL_RED + i * 4 + j);
			BrushColor (hdc, VL_RED + j * 3 + i);
			if (type == VL_THREED)
				Rose3D (hdc, x, y, t, r, m, n);
			else
				Rose2D (hdc, x, y, t, r, m, n);
			t += 15;
		}
	}
}

VOIDED	DrawBox (HDC hdc, int type)
{
	real	x, y, t, w, h;
	short	i, j, n;

	t = 0;
	w = 3; h = 0.6f;
	for (i = 0, y = -5; i < 3; i++, y += 5) {
		for (j = 0, x = -7.5f; j < 4; j++, x += 5, w -= 0.2f, h += 0.2f) {
			n = i * 4 + j;
			PenColor (hdc, VL_RED + n);
			BrushColor (hdc, VL_RED + j * 3 + i);
			if (type == VL_THREED)
				Box3D (hdc, x, y, t, w, h);
			else
				Box2D (hdc, x, y, t, w, h);
			t += 15;
		}
	}
}

VOIDED	DrawBow (HDC hdc, int type)
{
	real	x, y, t, w, h, a, b;
	short	i, j, n;

	t = 0;
	a = 0; b = 30; w = h = 1.75f;
	for (i = 0, y = -5; i < 3; i++, y += 5) {
		for (j = 0, x = -7.5f; j < 4; j++, x += 5, b += 30, t += 15) {
			n = i * 4 + j;
			PenColor (hdc, VL_RED + n);
			BrushColor (hdc, VL_RED + j * 3 + i);
			if (type == VL_THREED)
				Bow3D (hdc, x, y, a, w, h, a, b);
			else
				Bow2D (hdc, x, y, a, w, h, a, b);
		}
	}
}

VOIDED	DrawRing (HDC hdc, int type)
{
	real	x, y, t, w, h, a, b;
	short	i, j, n;

	; t = 0;
	a = 0; b = 30; w = h = 1;
	for (i = 0, y = -5; i < 3; i++, y += 5) {
		for (j = 0, x = -7.5f; j < 4; j++, x += 5, b += 30, t += 15) {
			n = i * 4 + j;
			PenColor (hdc, VL_RED + n);
			BrushColor (hdc, VL_RED + j * 3 + i);
			if (type == VL_THREED)
				Ring3D (hdc, x, y, a, w, h, a, b, 0.5f);
			else
				Ring2D (hdc, x, y, a, w, h, a, b, 0.5f);
		}
	}
}

VOIDED	DrawBezierCurve (HDC hdc, int type)
{
	COORD	point[40];

	point[0] = -8; point[1] = 3.5f;
	point[2] = -5; point[3] = 6;
	point[4] = -5; point[5] = 1;
	point[6] = -2; point[7] = 3.5f;
	PenColor (hdc, VL_WHITE);
	if (type == VL_TWOD)
		BezierCurve2D (hdc, VL_2D, point);
	else
		BezierCurve3D (hdc, VL_2D, point);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 4);
	else
		Polyline3D (hdc, VL_2D, point, 4);
	PenColor (hdc, VL_WHITE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 4, 4, 4, VL_HEXAGONMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 4, 4, 4, VL_HEXAGONMARK);

	point[0] = 2; point[1] = 3.5f;
	point[2] = 5; point[3] = 6;
	point[4] = 8; point[5] = 3.5f;
	point[6] = 5; point[7] = 1;
	PenColor (hdc, VL_WHITE);
	if (type == VL_TWOD)
		BezierCurve2D (hdc, VL_2D, point);
	else
		BezierCurve3D (hdc, VL_2D, point);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 4);
	else
		Polyline3D (hdc, VL_2D, point, 4);
	PenColor (hdc, VL_WHITE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 4, 4, 4, VL_CROSSMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 4, 4, 4, VL_CROSSMARK);

	point[0] = -8; point[1] = -3;
	point[2] = -2; point[3] = -6;
	point[4] = -2; point[5] = -1;
	point[6] = -8; point[7] = -5;
	PenColor (hdc, VL_WHITE);
	if (type == VL_TWOD)
		BezierCurve2D (hdc, VL_2D, point);
	else
		BezierCurve3D (hdc, VL_2D, point);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 4);
	else
		Polyline3D (hdc, VL_2D, point, 4);
	PenColor (hdc, VL_WHITE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 4, 4, 4, VL_XMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 4, 4, 4, VL_XMARK);

	point[0] = 2; point[1] = -6;
	point[2] = 5; point[3] = -1;
	point[4] = 8; point[5] = -6;
	point[6] = 2; point[7] = -6;
	PenColor (hdc, VL_WHITE);
	if (type == VL_TWOD)
		BezierCurve2D (hdc, VL_2D, point);
	else
		BezierCurve3D (hdc, VL_2D, point);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 4);
	else
		Polyline3D (hdc, VL_2D, point, 4);
	PenColor (hdc, VL_WHITE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 4, 4, 4, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 4, 4, 4, VL_DIAMONDMARK);
}

VOIDED	DrawBSplineCurve (HDC hdc, int type)
{
	COORD	point[] = {0, 0, 0, 4, 2, 4, 2, 0, 4, 0, 6, 4, 8, 4, 8, 0};
    real    knot[20] = {0, 0, 0, 1, 2, 3, 3, 3, 4, 5, 6, 6, 6};

	PenColor (hdc, VL_RED);
	TransfVertex (VL_2D, -9, 1, 0, 1, 1, point, 8);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 8);
	else
		Polyline3D (hdc, VL_2D, point, 8);
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		BSplineCurve2D (hdc, VL_2D, point, 8);
	else
		BSplineCurve3D (hdc, VL_2D, point, 8);
	TransfVertex (VL_2D, 10, 0, 0, 1, 1, point, 8);
	PenColor (hdc, VL_RED);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 8);
	else
		Polyline3D (hdc, VL_2D, point, 8);
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		SplineInterp2D (hdc, VL_2D, point, 8);
	else
		SplineInterp3D (hdc, VL_2D, point, 8);
	TransfVertex (VL_2D, -10, -6, 0, 1, 1, point, 8);
	PenColor (hdc, VL_RED);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 8);
	else
		Polyline3D (hdc, VL_2D, point, 8);

	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		BSplineCurveClosed2D (hdc, VL_2D, point, 8);
	else
		BSplineCurveClosed3D (hdc, VL_2D, point, 8);
	TransfVertex (VL_2D, 10, 0, 0, 1, 1, point, 8);
	PenColor (hdc, VL_RED);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 8);
	else
		Polyline3D (hdc, VL_2D, point, 8);
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		NURBSCurveClosed2D (hdc, VL_2D, point, 8, knot);
	else
		NURBSCurveClosed3D (hdc, VL_2D, point, 8, knot);
}

VOIDED	DrawCatmullRomCurve (HDC hdc, int type)
{
	COORD	point[] = {0, 0, 0, 1, 1, 1, 1, 0, 2, 0, 3, 1, 4, 1, 4, 0};

	TransfVertex (VL_2D, -8, -4, 0, 4, 8, point, 8);
	PenColor (hdc, VL_RED);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 8);
	else
		Polyline3D (hdc, VL_2D, point, 8);
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		CatmullRomSpline2D (hdc, VL_2D, point, 8);
	else
		CatmullRomSpline3D (hdc, VL_2D, point, 8);
}

void    heart (HDC hdc, int type, BOOL showpnt)
{
    COORD point[] = {0, 0, 0.4f, 0.8f, 2, 1.4f, 2.5f, -1, 1, -2, 0, -3,
                    -1, -2, -2.5f, -1, -2, 1.4f,
                    -0.4f, 0.8f, 0, 0};
    real    knot[20] = {0, 0, 0, 1, 2, 3, 3, 3, 4, 5, 6, 6, 6};

	if (type == VL_TWOD) {
		PenColor (hdc, VL_RED);
		PushTransformation2D (NULL);
		Scale2D (2, 2);
		NURBSCurve2D (hdc, VL_2D, point, 11, knot);
	}
	else {
		PenColor (hdc, VL_WHITE);
		PushTransformation3D (NULL);
		Scale3D (3, 3, 3);
		NURBSCurve3D (hdc, VL_2D, point, 11, knot);
	}
	if (showpnt) {
		if (type == VL_TWOD) {
			PenColor (hdc, VL_GREEN);
			ClosedPolyline2D (hdc, VL_2D, point, 10); 
			PolyMark2D (hdc, VL_2D, point, 10, 4, 4, VL_BOXMARK);
		}
		else {
			PenColor (hdc, VL_BLUE);
			ClosedPolyline3D (hdc, VL_2D, point, 10); 
			PolyMark3D (hdc, VL_2D, point, 10, 4, 4, VL_BOXMARK);
		}
	}
	if (type == VL_TWOD)
		PopTransformation2D (NULL);
	else
		PopTransformation3D (NULL);
}

void    circle (HDC hdc, int type, BOOL showpnt)
{
    POINT2H p[20] = {
		{0, 1, 1}, {0.707f, 0.707f, 0.707f}, {1, 0, 1},
		{0.707f, -0.707f, 0.707f}, {0, -1, 1}, {-0.707f, -0.707f, 0.707f},
		{-1, 0, 1}, {-0.707f, 0.707f, 0.707f}, {0, 1, 1}};
    real    knot[20] = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4};

	if (type == VL_TWOD) {
		PenColor (hdc, VL_RED);
		PushTransformation2D (NULL);
		Scale2D (3, 3);
		QNURBSCurve2D (hdc, VL_2H, (LPCOORD) p, 9, knot);
	}
	else {
		PenColor (hdc, VL_WHITE);
		PushTransformation3D (NULL);
		Scale3D (3, 3, 3);
		QNURBSCurve3D (hdc, VL_2H, (LPCOORD) p, 9, knot);
	}
	if (showpnt) {
		if (type == VL_TWOD) {
			PenColor (hdc, VL_GREEN);
			ClosedPolyline2D (hdc, VL_2H, (LPCOORD) p, 8);
			PolyMark2D (hdc, VL_2H, (LPCOORD) p, 8, 4, 4, VL_BOXMARK);
		}
		else {
			PenColor (hdc, VL_BLUE);
			ClosedPolyline3D (hdc, VL_2H, (LPCOORD) p, 8);
			PolyMark3D (hdc, VL_2H, (LPCOORD) p, 8, 4, 4, VL_BOXMARK);
		}
	}
	if (type == VL_TWOD)
		PopTransformation2D (NULL);
	else
		PopTransformation3D (NULL);
}

VOIDED	DrawNURBSCurve (HDC hdc, int type)
{
	circle (hdc, type, TRUE);
	heart (hdc, type, TRUE);
}

VOIDED	DrawHermitCurve (HDC hdc, int type)
{
	COORD	point[20];

	point[0] = -6; point[1] = -1; point[2] = 6; point[3] = -1;
	point[4] = -10; point[5] = 0; point[6] = 0; point[7] = -40;
	PenColor (hdc, VL_WHITE);
	if (type == VL_TWOD)
		HermitCurve2D (hdc, VL_2D, point);
	else
		HermitCurve3D (hdc, VL_2D, point);
	PenColor (hdc, VL_GREEN);	
	if (type == VL_TWOD) {
		Arrow2D (hdc, point[0], point[1], point[4], point[5],
			4, 1, 0.5f, VL_OPENARROW);
		Arrow2D (hdc, point[2], point[3], point[6], point[7],
			4, 1, 0.5f, VL_OPENARROW);
	}
	else {
		Arrow3D (hdc, point[0], point[1], 0, point[4], point[5], 0,
			4, 1, 0.5f, VL_OPENARROW);
		Arrow3D (hdc, point[2], point[3], 0, point[6], point[7], 0,
			4, 1, 0.5f, VL_OPENARROW);
	}
	PenColor (hdc, VL_WHITE);
	if (type == VL_TWOD) {
		Mark2D (hdc, point[0], point[1], 4, 4, VL_DIAMONDMARK);
		Mark2D (hdc, point[2], point[3], 4, 4, VL_DIAMONDMARK);
	}
	else {
		Mark3D (hdc, point[0], point[1], 0, 4, 4, VL_DIAMONDMARK);
		Mark3D (hdc, point[2], point[3], 0, 4, 4, VL_DIAMONDMARK);
	}
}

VOIDED	DrawNURBSCurveKnot (HDC hdc, int type)
{
	COORD	point[] = {0, 0, 0, 4, 2, 4, 2, 0, 4, 0, 6, 4, 8, 4, 8, 0};
	real Knot1[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
	real Knot2[] = {0, 0, 0, 1, 1, 1, 4, 5, 5, 5};
	real Knot3[] = {0, 0, 0, 1, 1, 1, 1, 2, 3, 4, 5, 6};
	real Knot4[] = {0, 0, 0, 1, 3, 5, 7, 9, 10, 15};

	TransfVertex (VL_2D, -9, 1, 0, 1, 1, point, 8);
	PenColor (hdc, VL_RED);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 8);
	else
		Polyline3D (hdc, VL_2D, point, 8);
		
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		NURBSCurve2D (hdc, VL_2D, point, 8, Knot1);
	else
		NURBSCurve3D (hdc, VL_2D, point, 8, Knot1);

	TransfVertex (VL_2D, 10, 0, 0, 1, 1, point, 8);
	PenColor (hdc, VL_RED);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 8);
	else
		Polyline3D (hdc, VL_2D, point, 8);
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		NURBSCurve2D (hdc, VL_2D, point, 8, Knot2);
	else
		NURBSCurve3D (hdc, VL_2D, point, 8, Knot2);

	TransfVertex (VL_2D, -10, -6, 0, 1, 1, point, 8);
	PenColor (hdc, VL_RED);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 8);
	else
		Polyline3D (hdc, VL_2D, point, 8);
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		NURBSCurve2D (hdc, VL_2D, point, 8, Knot3);
	else
		NURBSCurve3D (hdc, VL_2D, point, 8, Knot3);

	TransfVertex (VL_2D, 10, 0, 0, 1, 1, point, 8);
	PenColor (hdc, VL_RED);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 8);
	else
		Polyline3D (hdc, VL_2D, point, 8);
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		NURBSCurve2D (hdc, VL_2D, point, 8, Knot4);
	else
		NURBSCurve3D (hdc, VL_2D, point, 8, Knot4);
}

VOIDED	DrawQNURBSCurve (HDC hdc, int type)
{
	COORD	point[] = {0, 1, 1, 0.707f, 0.707f, 0.707f, 1, 0, 1,
		0.707f, -0.707f, 0.707f, 0, -1, 1, -0.707f, -0.707f, 0.707f,
		-1, 0, 1, -0.707f, 0.707f, 0.707f, 0, 1, 1};
	real knot[] = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4};

	PenColor (hdc, VL_RED);
	if (type == VL_TWOD) {
		PushTransformation2D (NULL);
		Translate2D (-5, -3);
		Scale2D (3, 3);
		ClosedPolyline2D (hdc, VL_2H, point, 8);
	}
	else {
		PushTransformation3D (NULL);
		Translate3D (-5, -3, 0);
		Scale3D (3, 3, 3);
		ClosedPolyline3D (hdc, VL_2H, point, 8);
	}
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2H, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2H, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD) {
		QNURBSCurve2D (hdc, VL_2H, point, 9, knot);
		PopTransformation2D (NULL);
	}
	else {
		QNURBSCurve3D (hdc, VL_2H, point, 9, knot);
		PopTransformation3D (NULL);
	}
}

VOIDED	DrawQuadraticCurve (HDC hdc, int type)
{
	COORD	point[] = {0, 0, 0, 4, 2, 4, 2, 0, 4, 0, 6, 4, 8, 4, 8, 0, 0, 0};
    real    knot[20] = {0, 0, 1, 2, 3, 4, 5, 6, 7, 7, 7};
	short	i;

	PenColor (hdc, VL_RED);
	TransfVertex (VL_2D, -9, 1, 0, 1, 1, point, 9);
	if (type == VL_TWOD)
		ClosedPolyline2D (hdc, VL_2D, point, 8);
	else
		ClosedPolyline3D (hdc, VL_2D, point, 8);
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD) {
		for (i = 0; i < 7; i += 2)
			QBezierCurve2D (hdc, VL_2D, &point[i*2]);
	}
	else {
		for (i = 0; i < 7; i += 2)
			QBezierCurve3D (hdc, VL_2D, &point[i*2]);
	}
	TransfVertex (VL_2D, 10, 0, 0, 1, 1, point, 9);
	PenColor (hdc, VL_RED);
	if (type == VL_TWOD)
		ClosedPolyline2D (hdc, VL_2D, point, 8);
	else
		ClosedPolyline3D (hdc, VL_2D, point, 8);
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		QBSplineCurve2D (hdc, VL_2D, point, 9);
	else
		QBSplineCurve3D (hdc, VL_2D, point, 9);

	TransfVertex (VL_2D, 0, -6, 0, 1, 1, point, 9);
	PenColor (hdc, VL_RED);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 8);
	else
		Polyline3D (hdc, VL_2D, point, 8);
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		QNURBSCurve2D (hdc, VL_2D, point, 8, knot);
	else
		QNURBSCurve3D (hdc, VL_2D, point, 8, knot);
	DrawQNURBSCurve (hdc, type);
}

VOIDED	SelectPrimitives (HDC hdc, WORD cmd)
{
	switch (cmd) {
		case IDM_2DCURVE_BEZIER:
			SetViewerName (VL_CURRENT, "Bezier Curves in 2D");
			DrawBezierCurve (hdc, VL_TWOD);
			break;
		case IDM_3DCURVE_BEZIER:
			SetViewerName (VL_CURRENT, "Bezier Curves in 3D");
			DrawBezierCurve (hdc, VL_THREED);
			break;
		case IDM_2DCURVE_BSPLINE:
			SetViewerName (VL_CURRENT, "B-Spline Curves in 2D");
			DrawBSplineCurve (hdc, VL_TWOD);
			break;
		case IDM_3DCURVE_BSPLINE:
			SetViewerName (VL_CURRENT, "B-Spline Curves in 3D");
			DrawBSplineCurve (hdc, VL_THREED);
			break;
		case IDM_2DCURVE_HERMIT:
			SetViewerName (VL_CURRENT, "2D Hermit Curves");
			DrawHermitCurve (hdc, VL_TWOD);
			break;
		case IDM_3DCURVE_HERMIT:
			SetViewerName (VL_CURRENT, "3D Hermit Curves");
			DrawHermitCurve (hdc, VL_THREED);
			break;
		case IDM_2DCURVE_NURBSKNOTS:
			SetViewerName (VL_CURRENT, "2D NUBRS Curves w/ Different Knots");
			DrawNURBSCurveKnot (hdc, VL_TWOD);
			break;
		case IDM_3DCURVE_NURBSKNOTS:
			SetViewerName (VL_CURRENT, "3D NUBRS Curves w/ Different Knots");
			DrawNURBSCurveKnot (hdc, VL_THREED);
			break;
        case IDM_2DCURVE_CATMULLROM:
			SetViewerName (VL_CURRENT, "2D Catmull-Rom Curve");
			DrawCatmullRomCurve (hdc, VL_TWOD);
			break;
        case IDM_3DCURVE_CATMULLROM:
			SetViewerName (VL_CURRENT, "3D Catmull-Rom Curve");
			DrawCatmullRomCurve (hdc, VL_THREED);
			break;
		case IDM_2DCURVE_NURBS:
			SetViewerName (VL_CURRENT, "2D Cubic and Quadratic NUBRS");
			DrawNURBSCurve (hdc, VL_TWOD);
			break;
		case IDM_3DCURVE_NURBS:
			SetViewerName (VL_CURRENT, "3D Cubic and Quadratic NUBRS");
			DrawNURBSCurve (hdc, VL_THREED);
			break;
        case IDM_2DCURVE_QBEZIER:
			SetViewerName (VL_CURRENT, "2D Quadratic Bezier Curve");
			DrawQuadraticCurve (hdc, VL_TWOD);
			break;
        case IDM_3DCURVE_QBEZIER:
			SetViewerName (VL_CURRENT, "3D Quadratic Bezier Curve");
			DrawQuadraticCurve (hdc, VL_THREED);
			break;
		case IDM_3DSHAPE_ROSE:
			SetViewerName (VL_CURRENT, "Roses in 3D");
			DrawRose (hdc, VL_THREED);
			break;
		case IDM_3DSHAPE_BOX:
			SetViewerName (VL_CURRENT, "Rectangles in 3D");
			DrawBox (hdc, VL_THREED);
			break;
		case IDM_3DSHAPE_DISK:
			SetViewerName (VL_CURRENT, "Disks in 3D");
			DrawDisk (hdc, VL_THREED);
			break;
		case IDM_3DSHAPE_NGON:
			SetViewerName (VL_CURRENT, "Nside Polygons in 3D");
			DrawNgon (hdc, VL_THREED);
			break;
		case IDM_3DSHAPE_STAR:
			SetViewerName (VL_CURRENT, "Nside Stars in 3D");
			DrawStar (hdc, VL_THREED);
			break;
		case IDM_3DSHAPE_FLOWER:
			DrawFlower (hdc, VL_THREED);
			SetViewerName (VL_CURRENT, "Nside Flowers in 3D");
			break;
		case IDM_3DSHAPE_BOW:
			SetViewerName (VL_CURRENT, "Bows in 3D");
			DrawBow (hdc, VL_THREED);
			break;
		case IDM_3DSHAPE_WEDGE:
			SetViewerName (VL_CURRENT, "Wedges in 3D");
			DrawWedge (hdc, VL_THREED);
			break;
		case IDM_3DSHAPE_RING:
			SetViewerName (VL_CURRENT, "Rings in 3D");
			DrawRing (hdc, VL_THREED);
			break;
		case IDM_2DSHAPE_ROSE:
			SetViewerName (VL_CURRENT, "Roses in 2D");
			DrawRose (hdc, VL_TWOD);
			break;
		case IDM_2DSHAPE_BOX:
			SetViewerName (VL_CURRENT, "Rectangles in 2D");
			DrawBox (hdc, VL_TWOD);
			break;
		case IDM_2DSHAPE_DISK:
			SetViewerName (VL_CURRENT, "Disks in 2D");
			DrawDisk (hdc, VL_TWOD);
			break;
		case IDM_2DSHAPE_NGON:
			SetViewerName (VL_CURRENT, "Nside Polygons in 2D");
			DrawNgon (hdc, VL_TWOD);
			break;
		case IDM_2DSHAPE_STAR:
			SetViewerName (VL_CURRENT, "Nside Stars in 2D");
			DrawStar (hdc, VL_TWOD);
			break;
		case IDM_2DSHAPE_FLOWER:
			SetViewerName (VL_CURRENT, "Nside Flowers in 2D");
			DrawFlower (hdc, VL_TWOD);
			break;
		case IDM_2DSHAPE_BOW:
			SetViewerName (VL_CURRENT, "Bows in 2D");
			DrawBow (hdc, VL_TWOD);
			break;
		case IDM_2DSHAPE_WEDGE:
			SetViewerName (VL_CURRENT, "Wedges in 2D");
			DrawWedge (hdc, VL_TWOD);
			break;
		case IDM_2DSHAPE_RING:
			SetViewerName (VL_CURRENT, "Rings in 2D");
			DrawRing (hdc, VL_TWOD);
			break;
	}
}

VOIDED	Primitives2D (HDC hdc, int cmd)
{
	PenColor (hdc, VL_RED);
	DisplayViewerFrame (hdc, VL_CURRENT);
	SelectPrimitives (hdc, cmd);
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
	DisplayViewerName (hdc, VL_CURRENT, 0);
}

VOIDED	Primitives3D (HDC hdc, int cmd)
{
	PenColor (hdc, VL_RED);
	DisplayViewerFrame (hdc, VL_CURRENT);
	PushTransformation3D (NULL);
	Scale3D (3, 3, 3);
	MarkPosition3D (hdc, 0, 0, 0, 10, VL_ORIGIN);

	PushTransformation3D (NULL);
	Translate3D (10, 8, 0);
	SelectPrimitives (hdc, cmd);
	PopTransformation3D (NULL);
	PushTransformation3D (NULL);
	Rotate3D (90, 'x');
	Translate3D (10, 8, 0);
	SelectPrimitives (hdc, cmd);
	PopTransformation3D (NULL);
	PushTransformation3D (NULL);
	Rotate3D (-90, 'y');
	Translate3D (10, 8, 0);
	SelectPrimitives (hdc, cmd);
	PopTransformation3D (NULL);
	PopTransformation3D (NULL);
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
	DisplayViewerName (hdc, VL_CURRENT, 0);
}

VOIDED	Curves2D (HDC hdc, int cmd)
{
	PenColor (hdc, VL_BLUE);
	DisplayViewerFrame (hdc, VL_CURRENT);
	switch (cmd) {
		case IDM_2DCURVE_NURBS:
			SetViewerName (VL_CURRENT, "2D NURBS Curves");
			PushTransformation2D (NULL);
			Scale2D (2, 2);
			PopTransformation2D (NULL);
			break;
        case IDM_2DCURVE_QBSPLINE:
		{
			COORD	point[] = {0, 0, 0, 1, 1, 1, 1, 0, 2, 0, 3, 1, 4, 1, 4, 0};
			SetViewerName (VL_CURRENT, "2D Quadratic Bezier Curve");
			Scale2D (2, 2);
			PenColor (hdc, VL_RED);
			Polyline2D (hdc, VL_2D, point, 8);
			PenColor (hdc, VL_BLUE);
			PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
			PenColor (hdc, VL_GREEN);
			QBSplineCurve2D (hdc, VL_2D, point, 8);
			break;
		}
        case IDM_2DCURVE_QNURBS:
		{
			COORD	point[] = {0, 0, 0, 1, 1, 1, 1, 0, 2, 0, 3, 1, 4, 1, 4, 0};
			real knot[] = {0, 0, 0, 1, 1, 1, 1, 2, 3, 4, 5, 6};
			
			SetViewerName (VL_CURRENT, "2D Quadratic Bezier Curve");
			Scale2D (2, 2);
			PenColor (hdc, VL_RED);
			Polyline2D (hdc, VL_2D, point, 8);
			PenColor (hdc, VL_BLUE);
			PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
			PenColor (hdc, VL_GREEN);
			QNURBSCurve2D (hdc, VL_2D, point, 8, knot);
			break;
		}
		case IDM_2DCURVE_PARABOLA:
			SetViewerName (VL_CURRENT, "2D Parabola Curve");
			break;
        case IDM_2DCURVE_HYPERBOLA:
			PenColor (hdc, VL_YELLOW);
//            Hyperbola (hdc, 1, 2);
			SetViewerName (VL_CURRENT, "2D Hyperbola Curve");
            break;
        case IDM_2DCURVE_OSCILWAVE:
			PenColor (hdc, VL_YELLOW);
//            OscillatoryWave (hdc, 1, 2, 3, 4);
			SetViewerName (VL_CURRENT, "2D Oscillatory Wave");
            break;
        case IDM_2DCURVE_CATENARY:
			PenColor (hdc, VL_BLUE);
//            Catenary (hdc, 1, 2);
			SetViewerName (VL_CURRENT, "2D Catenary Curve");
            break;
        case IDM_2DCURVE_SPIRAL:
			PenColor (hdc, VL_YELLOW);
            Spiral2D (hdc, 0, 0, 30, 5, 1, 1);
			SetViewerName (VL_CURRENT, "2D Spiral Curve");
            break;
        case IDM_2DSHAPE_CYCLOID:
			PenColor (hdc, VL_RED);
//            Cycloid (hdc, 1);
			SetViewerName (VL_CURRENT, "2D Cycloid Curve");
            break;
        case IDM_2DSHAPE_EPICYCLOID:
			PenColor (hdc, VL_GREEN);
//            Epicycloid (hdc, 1, 2);
			SetViewerName (VL_CURRENT, "2D Epicycloid Curve");
            break;
        case IDM_2DSHAPE_CARDIOID:
			PenColor (hdc, VL_WHITE);
//            Cardioid (hdc);
			SetViewerName (VL_CURRENT, "2D Cardioid Curve");
            break;
        case IDM_2DSHAPE_HYPOCYCLOID:
			PenColor (hdc, VL_GRAY);
//            Hypocycloid (hdc, 1, 2);
			SetViewerName (VL_CURRENT, "2D Hypocycloid Curve");
            break;
		
    }
	TextColor (hdc, VL_BLUE, VL_BLUE, TRANSPARENT);
	DisplayViewerName (hdc, VL_CURRENT, 0);
}

BINARY	BiArrayBox (HDC hdc, int row, int col)
{
	short	mid;

	switch ((row + col) % 4) {
		case 0: mid = 1; break;
		case 1: mid = 2; break;
		case 2: mid = 3; break;
		case 3: mid = 4; break;
	}
	SelectMaterial (mid);
	return (Cube (hdc, 2, 3, 4));
}

BINARY	TriArrayBox (HDC hdc, int row, int col, int lev)
{
	SelectMaterial ((row + col + lev) % 4 + 1);
	return (Cube (hdc, 2, 3, 2));
}

VOIDED	ObjectArray3D (HDC hdc, int func)
{
	PenColor (hdc, VL_CYAN);
	TextColor (hdc, VL_CYAN, VL_BLACK, TRANSPARENT);
	DisplayViewerFrame (hdc, VL_CURRENT);
	ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, VL_PHONGSHADE);
	ClearDepthBuffer (0xffff);
	switch (func) {
		case IDM_3DARRAY_RECTANGLE:
			RectangularArray3D (hdc, 4, 6, 8, 8, BiArrayBox);
			SetViewerName (VL_CURRENT, "4x6 Rectangular Object Array");
			break;
		case IDM_3DARRAY_POLAR:
			PolarArray3D (hdc, 4, 6, 10, 30, 5, BiArrayBox);
			SetViewerName (VL_CURRENT, "4x6 Polar Object Array");
			break;
		case IDM_3DARRAY_CUBIC:
			CubicArray (hdc, 4, 6, 5, 8, 8, 4, TriArrayBox);
			SetViewerName (VL_CURRENT, "4x6x5 Cubic Object Array");
			break;
		case IDM_3DARRAY_CYLINDRIC:
			CylindricArray (hdc, 4, 6, 5, 10, 30, 5, 5, TriArrayBox);
			SetViewerName (VL_CURRENT, "4x6x5 Cylindric Object Array");
			break;
		case IDM_3DARRAY_SPHERIC:
			SphericArray (hdc, 4, 6, 5, 10, 30, 30, 10, 30, TriArrayBox);
			SetViewerName (VL_CURRENT, "4x6x5 Spheric Object Array");
			break;
	}
	DisplayViewerName (hdc, VL_CURRENT, FALSE);
}

BINARY	RectangularArray2DProc (HDC hdc, int row, int col)
{
	short	index;

	index = row * 6 + col + 1;
	BrushColor (hdc, index);
	Ngon2D (hdc, 0, 0, 0, 1, 1, index + 2);
	return (TRUE);
}

BINARY	PolarArray2DProc (HDC hdc, int row, int col)
{
	BrushColor (hdc, row * 3 + col + 1);
	switch (col % 3) {
		case 0:
			Ngon2D (hdc, 0, 0, 0, 1, 1, row + 3);
			break;
		case 1:
			Star2D (hdc, 0, 0, 0, 1, 1, row + 3);
			break;
		case 2:
			Flower2D (hdc, 0, 0, 0, 1, 1, row + 3, 2);
			break;
	}
	return (TRUE);
}

VOIDED	ObjectArray2D(HDC hdc, int func)
{
	switch (func) {
		case IDM_2DARRAY_RECTANGLE:
			SetViewerName (VL_CURRENT, "4x6 Rectangular Object Array");
			Translate2D (-8, -5);
			RectangularArray2D (hdc, 4, 6, 3, 3, RectangularArray2DProc);
			break;
		case IDM_2DARRAY_POLAR:
			PolarArray2D (hdc, 12, 3, 2, 30, 2, PolarArray2DProc);
			SetViewerName (VL_CURRENT, "4x6 Polar Object Array");
			break;
	}
	PenColor (hdc, VL_BLUE);
	DisplayViewerFrame (hdc, VL_CURRENT);
	TextColor (hdc, VL_RED, VL_BLACK, TRANSPARENT);
	DisplayViewerName (hdc, VL_CURRENT, FALSE);
}

BINARY	USFlag (HDC hdc)
{
    short   i, j;
    real    x1, y1, x2, y2;
    real    r, width, height;

    width = 1;
    height = (real) 13 / 24;
    x1 = 0;
    x2 = width;
    y1 = 0;
    y2 = height / 13;
    BrushColor (hdc, VL_RED);
    PenColor (hdc, VL_RED);
    for (i = 0; i < 7; i ++) {
        Rectangle2D (hdc, x1, y1, x2, y2);
        y1 += height * 2 / 13;
        y2 += height * 2 / 13;
    }

    BrushColor (hdc, VL_WHITE);
    PenColor (hdc, VL_WHITE);
    y1 = height / 13;
    y2 = height * 2 / 13 - 0.001f;
    for (i = 0; i < 6; i ++) {
        Rectangle2D (hdc, x1, y1, x2, y2);
        y1 += height * 2 / 13;
        y2 += height * 2 / 13;
    }

    BrushColor (hdc, VL_BLUE);
    PenColor (hdc, VL_BLUE);
    x2 = 10 * width / 24;
    y1 = 6 * height / 13;
    y2 = height;
    Rectangle2D (hdc, x1, y1, x2, y2);

    BrushColor (hdc, VL_WHITE);
    PenColor (hdc, VL_WHITE);
    x2 /= 6;
    x1 = x2 / 2;
    y2 = height * 7 / 13 / 5;
	r = 0.01f;
    for (i = 0; i < 6 ; i ++) {
        y1 = height - y2 / 2;
        for (j = 0; j < 5; j ++) {
            Star2D (hdc, x1, y1, 0, r, r, 5);
            y1 -= y2;
        }
        x1 = x1 + x2;
    }
    x1 = x2;
    for (i = 0; i < 5; i ++) {
        y1 = height - y2;
        for (j = 0; j < 4; j ++) {
            Star2D (hdc, x1, y1, 0, r, r, 5);
            y1 -= y2;
        }
        x1 = x1 + x2;
    }
	return (TRUE);
}


