// Matrix.h, by Scott Litvinoff
// 3x3 Matrix class definition
#include "vect3.h"
#include "iostream.h"
#include "float.h"
#include "math.h"
#include "stdlib.h"
#include "stddef.h"
#include "string.h"

class matrix
{
    vector3 row1,row2,row3,col1,col2,col3;

    public:
    matrix(double a11=0,double a12=0,double a13=0,double a21=0,double a22=0,double a23=0,double a31=0,double a32=0,double a33=0)
    {
        row1=vector3(a11,a12,a13);               // Matrix constructor with
        row2=vector3(a21,a22,a23);               // inputs given as:
        row3=vector3(a31,a32,a33);               // doubles a11...a13, then
        col1=vector3(a11,a21,a31);               // doubles a21...a23, then
        col2=vector3(a12,a22,a32);               // doubles a31...a33
        col3=vector3(a13,a23,a33);
    }
    matrix(vector3 r1,vector3 r2,vector3 r3)
    {
        row1=r1;                                 // Matrix constructor using
        row2=r2;                                 // Three vectors representing
        row3=r3;                                 // Rows 1,2, and 3
        col1=vector3(r1.x(),r2.x(),r3.x());
        col2=vector3(r1.y(),r2.y(),r3.y());
        col3=vector3(r1.z(),r2.z(),r3.z());
    }
    friend matrix operator+(matrix&,matrix&);    // Binary matrix addition

    friend matrix operator-(matrix&,matrix&);    // Binary matrix subtraction

    friend matrix operator*(matrix&,matrix&);    // Binary matrix multiplication

    friend matrix operator+(matrix&);            // Returns same as input

    friend matrix operator-(matrix&);            // Unary matrix negation

    friend matrix operator*(double,matrix&);     // Scalar matrix multiplication

    friend matrix operator*(matrix&,double);     // Scalar matrix multiplication

    double det(matrix&);                         // Matrix determinant

    matrix tran();                               // Matrix transpose

    double aij(unsigned char,unsigned char);     // Returns element at location
                                                 // (i,j)
    void print();                                // Outputs matrix to stream
};
