#include  <windows.h>
#include  <bivbx.h>
#include  "vbxmain.rh"
#include "vbxdll.rh"
#define Event_SpreadSheet_RightClick 18

// ======================================================== //
extern "C" BOOL CALLBACK DialogProc( HWND, UINT, WPARAM, LPARAM );
long FAR PASCAL WndProc(HWND, UINT, WPARAM, LPARAM);
// ======================================================== //
HINSTANCE hInst;
HINSTANCE    hInstDLL;
int result;


// ======================================================== //
#pragma argsused
int PASCAL WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,
			LPSTR lpCmdLine,  int nCmdShow )
{
  static char szAppName[]  = "VBXDLL";
  HWND     hwnd;
  MSG      msg;
  WNDCLASS wndclass;


  hInst = hInstance;

  if( !hPrevInstance )
  {
	 wndclass.style = CS_HREDRAW | CS_VREDRAW;
	 wndclass.lpfnWndProc   = WndProc;
	 wndclass.cbClsExtra    = 0;
	 wndclass.cbWndExtra    = 0;
	 wndclass.hInstance     = hInstance;
	 wndclass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
	 wndclass.hCursor       = LoadCursor( NULL, IDC_ARROW );
	 wndclass.hbrBackground =(HBRUSH)GetStockObject(WHITE_BRUSH);
	 wndclass.lpszMenuName  = MAKEINTRESOURCE(MENU_1);
	 wndclass.lpszClassName = szAppName;

	 RegisterClass( &wndclass );

  }
  //  (1)  Initialize VB emulator DLL
  result = VBXInit( hInst, "Thunder" );
  hInstDLL = LoadLibrary("c:\\vbxdll\\vbxdll.dll");
  result = VBXEnableDLL( hInst, hInstDLL );

  hwnd = CreateWindow( szAppName, "VBX Dialog Program",
					WS_OVERLAPPEDWINDOW,
					CW_USEDEFAULT, CW_USEDEFAULT,
					CW_USEDEFAULT, CW_USEDEFAULT,
					NULL, NULL, hInst, NULL );
  ShowWindow( hwnd, nCmdShow );
  UpdateWindow( hwnd );

  while( GetMessage( &msg, NULL, 0, 0 ) )
  {
	 TranslateMessage(&msg);
	 DispatchMessage(&msg);
  }

  //  7) clean up and unload the DLL
  VBXTerm();
  FreeLibrary(hInstDLL);
  return msg.wParam;
}


long FAR PASCAL WndProc( HWND hwnd, UINT msg,
					WPARAM wParam, LPARAM lParam )
{
  int result;
  switch( msg )
  {
	 case WM_COMMAND:
	 {
	 switch( wParam )
	 {
		case CM_FILETEST:
		{
		FARPROC fproc;
		fproc=(FARPROC)MakeProcInstance( FARPROC(DialogProc), hInstDLL );
		result = DialogBox(hInstDLL,"DIALOG_1",NULL,(DLGPROC)fproc);
		FreeProcInstance( fproc );
		break;
		}
		case CM_FILEEXIT:
		PostMessage( hwnd, WM_CLOSE, 0, 0L );
		break;
	 }
	 break;
	 }
	 case WM_DESTROY:
	 PostQuitMessage(0);
	 return 0;
	 default: break;
  }
  return DefWindowProc( hwnd, msg, wParam, lParam );
}

