/*
	USER1.CPP

	Copyright 1987-1993		Ambrose & Muckerman

	Written by:				Dan Ambrose
							Ambrose & Muckerman
	CIS ID:					71062,523
*/

#ifndef _USER1_
#define _USER1_



#define Uses_TStaticText
#define Uses_TEvent
#define Uses_TButton
#define Uses_TKeys
#define Uses_TLabel
#define Uses_TScrollBar
#define Uses_TSItem
#define Uses_MsgBox
#define Uses_TProgram
#define Uses_TDeskTop

#include <tv.h>

#include "debug.h"
#include "user1.h"
#include <strstrea.h>
#include <iomanip.h>
#include <string.h>
#include <stdio.h>
#include <dos.h>

#define	Uses_TDEAlpha
#define	Uses_TDEState
#define	Uses_TDEZipCode
#define	Uses_TDENumeric
#define Uses_TDEButton
#define Uses_TDERadioButtons
#define Uses_TDECheckBoxes
#include "tde.h"

#include "px.h"
#include "eventcmd.h"



DUserInfo::DUserInfo():
	TWindowInit(&DUserInfo::initFrame),
	TDialog(TRect(3,2,76,20), "User Information")
{
	add = False;

	options = 0x0343;

	TDataEntry *v;

	TDataEntry::globalID = 0;  //* don't forget to set this
	TDataEntry::globalMode |=
		(tdgEnterIsTab|tdgUpDownEnable|tdgValidNow|tdgValidUpDown);

	insert((v = new TDEAlpha(10,2,24, "First")));
	insert(new TLabel(TRect(2,2,8,3), "~F~irst", v));
	v->dataFormat |= tdfUpper;
	v->localMode |= tdlRequired;

	insert((v = new TDEAlpha(10,3,24, "Mid")));
	insert(new TLabel(TRect(2,3,6,4), "~M~id", v));
	v->dataFormat |= tdfUpper;

	insert((v = new TDEAlpha(10,4,24, "Last")));
	insert(new TLabel(TRect(2,4,7,5), "~L~ast", v));
	v->dataFormat |= tdfUpper;
	v->localMode |= tdlRequired;

	insert((v = new TDataEntry(46,2,24)));
	insert(new TLabel(TRect(36,2,44,3), "~A~ddress", v));
	v->dataFormat |= tdfUpper;

	insert((v = new TDataEntry(46,3,24)));
	insert(new TLabel(TRect(36,3,44,4), "Add~r~ess", v));
	v->dataFormat |= tdfUpper;

	insert((v = new TDataEntry(46,4,24)));
	insert(new TLabel(TRect(36,4,42,5), "C~i~ty", v));
	v->dataFormat |= tdfUpper;

	insert((v = new TDEState(46,5,2, "State")));
	v->localMode |= tdlAutoExit;
	insert(new TLabel(TRect(36,5,42,6), "Stat~e~", v));

	insert((v = new TDEZipCode(60,5,"~~~~~-~~~~")));
	v->localMode |= tdlAutoExit;
	insert(new TLabel(TRect(50,5,59,6), "~Z~ip Code", v));

	insert((v = new TDENumeric(10, 6, "(~~~) ~~~-~~~~")));
	v->localMode |= tdlAutoExit;
	insert(new TLabel(TRect(2,6,6,7), "~T~el", v));

	insert((v = new TDENumeric(10, 7, "~~~-~~-~~~~", "Social")));
	v->localMode |= tdlAutoExit;
	v->localMode |= tdlRequired;
	insert(new TLabel(TRect(2,7,9,8), "~S~ocial", v));

	insert((v = new TDataEntry(46, 7, 24, "Password")));
	v->localMode |= tdlRequired;
	v->dataFormat |= tdfUpper;
	insert(new TLabel(TRect(36,7,45,8), "~P~assword", v));

	TDERadioButtons *r = new TDERadioButtons(TRect(2,10,18,14),
		new TSItem("Disable",
		new TSItem("Normal",
		new TSItem("Reserved",
		new TSItem("Supervisor", 0)))));
	insert(r);
	insert(new TLabel(TRect(2,9,8,10), "Lo~g~in", r));

	TDECheckBoxes *c = new TDECheckBoxes(TRect(20,10,71,14),
		new TSItem("Transfer get",
		new TSItem("Transfer away",
		new TSItem("Edit customer",
		new TSItem("Set time",
		new TSItem("Edit user",
		new TSItem("Delete msg",
		new TSItem("DOS exit",
		new TSItem("Reserved 8",
		new TSItem("Reserved 9",
		new TSItem("Reserved 10",
		new TSItem("Reserved 11",
		new TSItem("Reserved 12", 0)))))))))))),
		"Rights" );
	insert(c);
	insert(new TLabel(TRect(20,9,27,10), "~R~ights", c));

	insert( new TDEButton(TRect(11,15,23,17), "  ~O~k  ", cmOK, bfNormal) );
	insert( new TDEButton(TRect(31,15,43,17), "~C~ancel", cmCancel, bfNormal));
	insert( new TDEButton(TRect(51,15,63,17), "~D~elete", cmRecDelete, bfNormal));

	selectNext(False);

	int a = dataSize();
	int b = sizeof(UserInfoRec);
	if (a != b)
	{
		messageBox(mfOKButton|mfWarning,
			"\003Structure size wrong\n"
			"is currently %d but should be %d", b, a);
	}

}

DUserInfo::~DUserInfo()
{

}


void DUserInfo::handleEvent(TEvent &event)
{
	switch(event.what)
	{
	case evCommand:
		switch(event.message.command)
		{
		case cmRecDelete:
			if (add == True)
				break;
			int c = messageBox(mfConfirmation|mfYesNoCancel,
				"\003Are you SURE you want\n"
				"\003to DELETE this record ?\n");
			if (c == cmYes)
			{
				if( (state & sfModal) != 0 )
				{
					endModal(event.message.command);
					clearEvent(event);
				}
				return;
			}
			break;

		default:
			TDialog::handleEvent(event);
			return;
		}
		break;

	default:
		TDialog::handleEvent(event);
		return;
	}
	clearEvent(event);
}

Boolean DUserInfo::valid(ushort cmd)
{
	Boolean  isChanged = False;
	int c;

	switch( cmd )
	{
	case cmValid:
		break;

	case cmCancel:
	case cmClose:
	case cmQuit:
	case cmOK:
		if ( TDataEntry::queryChanged(this) )
			isChanged = True;

		if ( isChanged && cmd != cmOK )
		{
			c = messageBox(mfWarning|mfYesNoCancel,
				"\003The data has changed.\n"
				"\003Do you want to save ?"
			);

			if ( c == cmNo )
				return True;
			else if ( c == cmCancel )
				return False;
		}
		else if ( cmd != cmOK )
		{
			return True;
		}

		//* cmOK
		if ( isChanged && TDataEntry::queryValid(this) )
		{
			return False;
		}
		//* save the stuff
			return (Boolean) !save();

		default:
			break;
	}
	return TDialog::valid(cmd);
}



void DUserInfo::getFlds(UserInfoRec *u)
{
	pxCheck(PXGetAlpha(uiRecHandle, 1, 25, u->last) );
	pxCheck(PXGetAlpha(uiRecHandle, 2, 25, u->first) );
	pxCheck(PXGetAlpha(uiRecHandle, 3, 25, u->middle) );
	pxCheck(PXGetAlpha(uiRecHandle, 4, 10, u->social) );
	pxCheck(PXGetAlpha(uiRecHandle, 5, 25, u->addr1) );
	pxCheck(PXGetAlpha(uiRecHandle, 6, 25, u->addr2) );
	pxCheck(PXGetAlpha(uiRecHandle, 7, 25, u->city) );
	pxCheck(PXGetAlpha(uiRecHandle, 8, 3, u->state) );
	pxCheck(PXGetAlpha(uiRecHandle, 9, 10, u->zip) );
	pxCheck(PXGetAlpha(uiRecHandle, 10, 25, u->tel) );
	pxCheck(PXGetAlpha(uiRecHandle, 11, 25, u->password) );
	pxCheck(PXGetShort(uiRecHandle, 12, (short*)&u->login) );

	char aRights[33];
	pxCheck(PXGetAlpha(uiRecHandle, 13, 32, aRights) );
	arrayToi( (unsigned int) u->aRights, aRights, '0');

	setData(u);			// set dialog data
}

void DUserInfo::setFlds(UserInfoRec *u)
{
	getData(u);			// get dialog data

	pxCheck(PXRecBufEmpty(uiRecHandle) );
	pxCheck(PXPutAlpha(uiRecHandle, 1, u->last) );
	pxCheck(PXPutAlpha(uiRecHandle, 2, u->first) );
	pxCheck(PXPutAlpha(uiRecHandle, 3, u->middle) );
	pxCheck(PXPutAlpha(uiRecHandle, 4, u->social) );
	pxCheck(PXPutAlpha(uiRecHandle, 5, u->addr1) );
	pxCheck(PXPutAlpha(uiRecHandle, 6, u->addr2) );
	pxCheck(PXPutAlpha(uiRecHandle, 7, u->city) );
	pxCheck(PXPutAlpha(uiRecHandle, 8, u->state) );
	pxCheck(PXPutAlpha(uiRecHandle, 9, u->zip) );
	pxCheck(PXPutAlpha(uiRecHandle, 10, u->tel) );
	pxCheck(PXPutAlpha(uiRecHandle, 11, u->password) );
	pxCheck(PXPutShort(uiRecHandle, 12, u->login) );

	char aRights[32];
	iToArray(u->aRights, aRights, '0', '1');
	pxCheck(PXPutAlpha(uiRecHandle, 13, aRights) );

}

Boolean DUserInfo::save()
{
	int c;
	UserInfoRec *u = new UserInfoRec;
	setFlds(u);
	if (add == False)
		c = pxCheck(PXRecUpdate(uiTblHandle, uiRecHandle));
	else
		c = pxCheck(PXRecAppend(uiTblHandle, uiRecHandle));
	delete u;

	if (c)
		messageBox(mfError|mfOKButton, "\003%s", PXOopErrMsg(_pxerror) );
	return (Boolean) c;
}


UserInfoListView::UserInfoListView (const TRect& bounds,
						  ushort aNumCols,
						  TScrollBar *hScrollBar,
						  TScrollBar *vScrollBar):
	ListViewer(bounds, aNumCols, hScrollBar, vScrollBar)
{
	eventMask |= evBroadcast;
	u = new UserInfoRec;
	setValue(False);
}

UserInfoListView::~UserInfoListView()
{
	delete u;
}


#pragma argsused
void UserInfoListView::getText( char *dest, short item, short maxLen)
{
	RECORDNUMBER recNum;

	recNum = item+1;

	pxCheck(PXRecGoto(uiTblHandle, recNum));
	pxCheck(PXRecBufEmpty(uiRecHandle));
	pxCheck(PXRecGet(uiTblHandle, uiRecHandle));
	pxCheck(PXGetAlpha(uiRecHandle, 1, 25, u->last) );
	pxCheck(PXGetAlpha(uiRecHandle, 2, 25, u->middle) );
	pxCheck(PXGetAlpha(uiRecHandle, 3, 25, u->first) );

	char lock[10];
	int isLocked = 0;
//	Using PXNetRecLocked is too slow.  Why ?
//	pxCheck(PXNetRecLocked(uiTblHandle, &isLocked));
	if (isLocked)
	{
		sprintf(lock,"%c", (char) '*');
	}
	else
	{
		lock[0] = 0;
	}

	sprintf(dest, "%s%s %s %s", lock, u->last, u->middle, u->first);

}

void UserInfoListView::setValue(Boolean check)
{
	RECORDNUMBER nRecords;

	if (check==True)
	{
		int hasChanged;
		pxCheck(PXNetTblChanged(uiTblHandle, &hasChanged));
		if (!hasChanged)
			return;
	}

	PXNetTblRefresh(uiTblHandle);
	pxCheck(PXTblNRecs(uiTblHandle, &nRecords));
	setRange(nRecords);
	drawView();
}

void UserInfoListView::handleEvent(TEvent &event)
{
	switch(event.what)
	{
	case evMouseDown:
		if (event.mouse.doubleClick)
		{
			edit();
		}
		else
			TListViewer::handleEvent(event);
		break;

	case evKeyDown:
		switch(event.keyDown.keyCode)
		{
		case kbEnter:
			edit();
			break;

		case kbDel:
			del();
			break;

		case kbIns:
			add();
			break;

		default:
			TListViewer::handleEvent(event);
			return;
		}
		break;

	case evBroadcast:
		switch(event.message.command)
		{
		case cmRefresh:
			setValue(True);
			break;

		default:
			TListViewer::handleEvent(event);
			return;
		}

	default:
		TListViewer::handleEvent(event);
		return;
	}
	clearEvent(event);
}

Boolean UserInfoListView::isEmpty()
{
	if (range==0)
		return True;
	return False;
}

void UserInfoListView::edit()
{
	if (isEmpty()==True)
		return;

	RECORDNUMBER recNum;

	recNum = focused+1;
	if (pxCheck(PXRecGoto(uiTblHandle, recNum)))
	{
		messageBox(mfError|mfOKButton, "%s", PXOopErrMsg(_pxerror) );
		return;
	}

	if (uses_Network == True)
	{

		int isLocked;
		pxCheck(PXNetRecLocked(uiTblHandle, &isLocked));
		if (isLocked)
		{
			messageBox(mfInformation|mfOKButton,
				"\003This record is curently\n"
				"\003locked by another user");
			return;
		}
	}

	if (pxCheck(PXRecGet(uiTblHandle, uiRecHandle)))
	{
		messageBox(mfError|mfOKButton, "%s", PXOopErrMsg(_pxerror) );
		return;
	}

	LOCKHANDLE lock;
	if (uses_Network == True)
	{
		if (pxCheck(PXNetRecLock(uiTblHandle, &lock)))
		{
			messageBox(mfError|mfOKButton, "%s", PXOopErrMsg(_pxerror) );
			return;
		}
	}

	DUserInfo *userInfo = new DUserInfo;
	userInfo->getFlds(u);

	int c = TProgram::deskTop->execView(userInfo);
	TProgram::deskTop->destroy(userInfo);
	if (c == cmRecDelete)
		pxCheck(PXRecDelete(uiTblHandle));
	else
		if (uses_Network==True)
			pxCheck(PXNetRecUnlock(uiTblHandle, lock));

	setValue(False);
}

void UserInfoListView::del()
{
	if (isEmpty()==True)
		return;

	RECORDNUMBER recNum;

	recNum = focused+1;
	if (pxCheck(PXRecGoto(uiTblHandle, recNum)))
	{
		messageBox(mfError|mfOKButton, "%s", PXOopErrMsg(_pxerror) );
		return;
	}

	int isLocked;

	if (uses_Network == True)
	{
		pxCheck(PXNetRecLocked(uiTblHandle, &isLocked));
		if (isLocked)
		{
			messageBox(mfInformation|mfOKButton,
				"\003This record is curently\n"
				"\003locked by another user");
			return;
		}
	}

	LOCKHANDLE lock;
	if (uses_Network == True)
	{

		if (pxCheck(PXNetRecLock(uiTblHandle, &lock)))
		{
			messageBox(mfError|mfOKButton, "%s", PXOopErrMsg(_pxerror) );
			return;
		}
	}

	pxCheck(PXRecBufEmpty(uiRecHandle));
	pxCheck(PXRecGet(uiTblHandle, uiRecHandle));
	pxCheck(PXGetAlpha(uiRecHandle, 1, 25, u->last) );
	pxCheck(PXGetAlpha(uiRecHandle, 2, 25, u->middle) );
	pxCheck(PXGetAlpha(uiRecHandle, 3, 25, u->first) );
	char dest[100];
	sprintf(dest, "%s %-1s %s", u->last, u->middle, u->first);

	int c = messageBox(mfConfirmation|mfYesNoCancel,
		"\003Are you SURE you want\n"
		"\003to DELETE this record ?\n"
		"\003%s", dest);

	if (c == cmYes)
		pxCheck(PXRecDelete(uiTblHandle));
	else
		if (uses_Network == True)
			pxCheck(PXNetRecUnlock(uiTblHandle, lock));

	if (c == cmYes)
		setValue(False);
}

void UserInfoListView::add()
{
	pxCheck(PXRecBufEmpty(uiRecHandle));

	memset(u, 0, sizeof(UserInfoRec));
	strcpy(u->password, "PASSWORD");
	u->login = 1;
	u->aRights = 0;

	DUserInfo *userInfo = new DUserInfo;
	userInfo->add = True;
	userInfo->setData(u);
	TProgram::deskTop->execView(userInfo);
	TProgram::deskTop->destroy(userInfo);
	setValue(False);
}



DUserInfoList::DUserInfoList():
	TWindowInit(&DUserInfoList::initFrame),
	TDialog(TRect(10,3,70,20), "User List")
{
	options = 0x0343;

	TScrollBar *v = new TScrollBar(TRect(44,3,45,13));
	insert(v);
	listView = new UserInfoListView(TRect(4,3,44,13), 1, 0, v);
	insert(listView);
	insert(new TLabel(TRect(3,2,14,3), "User ~N~ames", listView));

	insert(new TButton(TRect(46,3,58,5), "~A~ppend", cmRecAppend, bfNormal));
	insert(new TButton(TRect(46,7,58,9), " ~U~pdate ", cmRecUpdate, bfNormal));
	insert(new TButton(TRect(46,11,58,13), "~D~elete", cmRecDelete, bfNormal));
	insert(new TButton(TRect(8,14,20,16), "  ~O~k  ", cmOK, bfNormal));
	insert(new TButton(TRect(28,14,40,16), "~C~ancel", cmCancel, bfNormal));

	selectNext(False);
}


void DUserInfoList::handleEvent(TEvent &event)
{
	switch(event.what)
	{
	case evCommand:
		switch(event.message.command)
		{
		case cmRecUpdate:
			listView->edit();
			break;

		case cmRecDelete:
			listView->del();
			break;

		case cmRecAppend:
			listView->add();
			break;

		default:
			TDialog::handleEvent(event);
			return;
		}
		break;

	default:
		TDialog::handleEvent(event);
		return;
	}
	clearEvent(event);
}


DLogin::DLogin():
	TWindowInit(&DLogin::initFrame),
	TDialog(TRect(24,6,56,17), "Login")
{
	options = 0x0343;

	data = new LoginRec;

	TDataEntry::globalID = 0;  //* don't forget to set this
	TDataEntry::globalMode |=
		(tdgEnterIsTab|tdgUpDownEnable|tdgValidNow|tdgValidUpDown);
	TDataEntry::globalMode &= ~tdgBeepEnable;


	TDataEntry *v;

	insert((v = new TDataEntry(4, 3, 24, "User Id")));
	v->localMode |= tdlRequired + tdlSecure;
	v->dataFormat |= tdfUpper;
	insert(new TLabel(TRect(3,2,11,3), "User ~I~d", v));

	insert((v = new TDataEntry(4, 6, 24, "Password")));
	v->localMode |= tdlRequired + tdlSecure;
	v->dataFormat |= tdfUpper;
	insert(new TLabel(TRect(3,5,12,6), "~P~assword", v));

	insert(new TDEButton(TRect(3,8,15,10), "  ~O~k  ", cmOK, bfNormal));
	insert(new TDEButton(TRect(17,8,29,10), "~C~ancel", cmCancel, bfNormal));
	selectNext(False);
	memset(data,0,sizeof(LoginRec));
	setData(data);
}

DLogin::~DLogin()
{
	delete data;
}

void DLogin::handleEvent(TEvent &event)
{
	switch(event.what)
	{
	case evCommand:
		switch(event.message.command)
		{
		case cmOK:
			login(True);
			TDialog::handleEvent(event);
			return;

		default:
			TDialog::handleEvent(event);
			return;
		}
	//	break;

	default:
		TDialog::handleEvent(event);
		return;
	}
//	clearEvent(event);
}


void DLogin::setFlds(LoginRec *aData)
{
	getData(aData);			// get dialog data
	pxCheck(PXRecBufEmpty(uiRecHandle) );
	pxCheck(PXPutAlpha(uiRecHandle, 4, aData->id) );
	pxCheck(PXPutAlpha(uiRecHandle, 11, aData->password) );
}

const char *getDaysGreeting()
{
	struct time tm;
	gettime(&tm);

	if (tm.ti_hour < 12)
		return "morning";
	if (tm.ti_hour < 16)
		return "afternoon";
	return "evening";
}

int DLogin::login(Boolean showResults)
{
	int rc = login();
	if (showResults==False)
		return rc;
	if (rc)
	{
		messageBox(mfError|mfOKButton, "\003Access denied!");
		return 1;
	}

	char first[25];
	pxCheck(PXGetAlpha(uiRecHandle, 2, 25, first) );

	messageBox(mfInformation|mfOKButton,
		"\003System access granted.\n"
		"\003Good %s %s !"
		,getDaysGreeting(), first);

	return 0;
}

int DLogin::login()
{
	setFlds(data);

	int c = PXSrchFld(uiTblHandle, uiRecHandle, 4, SEARCHFIRST);
	if (c)
		return 1;

	if (pxCheck(PXRecGet(uiTblHandle, uiRecHandle)))
	{
		messageBox(mfError|mfOKButton, "%s", PXOopErrMsg(_pxerror) );
		return 1;
	}

	char pass[25];
	pxCheck(PXGetAlpha(uiRecHandle, 11, 25, pass) );
//	tout << "user=" << data->password << "  file=" << pass << endl;

	if (strcmp(data->password, pass)==0)
		return 0;

	return 1;
}



#endif	//	_USER1_