/***************************************************************************

 FILENAME - TDE.H: Header file for classes:
 ----------------
            To use this class:    #define this (before #included TDE.H):
            ------------------    --------------------------------------
                     TDataEntry       (always included)
                     TDEAlpha         Uses_TDEAlpha
                     TDEAlphaNum      Uses_TDEAlphaNum
                     TDENumeric       Uses_TDENumeric
                     TDEInteger       Uses_TDEInteger
                     TDEDate          Uses_TDEDate
                     TDEPhone         Uses_TDEPhone
                     TDEZipCode       Uses_TDEZipCode
                     TDEState         Uses_TDEState
                     TDEButton        Uses_TDEButton
                     TDEInputLine     Uses_TDEInputLine
                     TDERadioButtons  Uses_TDERadioButtons
                     TDECheckBoxes    Uses_TDECheckBoxes

 Class TDataEntry v1.0 - 07/14/92
 --------------------------------

 ----------------------------------------------------------------------------
 Author: Jeff Penrose * JDP Custom Software * (818) 344-7303 * CIS 71043,3727
 ----------------------------------------------------------------------------

 A data entry class for Borland's Turbo Vision, derived from TInputLine.

 Copyright Notice
 ================
  As this material is ultimately derived from Borland source files, any of
 their copyrights which MAY apply DO apply.
  From the author's standpoint, you may use this material freely and,
 hopefully, post any comments/corrections/enhancements to me at the above-
 noted addresses.  I do ask that you not distribute this material except as
 originally received, including all source/documentation files in their
 original form.
  If you DO modify or enhance any of this code, please send any such changes
 to me for incorporation into a future version.  Any such enhancements will
 be DONATED, without expectation of compensation or incorporation into
 future versions.  Again, if you distribute this code, please do so in its
 original, unmodified form including all source files and documentation.

Source files included
=====================
 TDE     .DOC: This documentation.
 TDE     .MAN: How to use TDataEntry in your dialog objects
 TDE     .H  : header file containing class declarations for classes
 TDEFLAGS.H  :   "     "      "       flags and command definitions
 TDE     .CPP: Class TDataEntry
 TDEDATE .CPP: Class TDEDate
 TDEPHONE.CPP: Classes TDEPhone, TDEZipCode, TDEState
 TDENUMS .CPP: Class TDEInteger
 TDECLUST.CPP: Non-TDataEntry classes TDEButton, TDERadioButtons, TDECheckBoxes
 TDEINPLI.CPP: Non-TDataEntry class TDEInputLine
 TDELIB  .PRJ: Project for building library TDELIB.LIB
 TDEDEMO .CPP: Demo program
 TDEDEMO .PRJ: Project for building TDEDEMO.EXE

***************************************************************************/

#if !defined( __T_DATA_ENTRY_H )
#define  __T_DATA_ENTRY_H

#define Uses_TInputLine
#define Uses_MsgBox
#define Uses_TButton
#define Uses_TRadioButtons
#define Uses_TCheckBoxes
#include <tv.h>

#if !defined(__CTYPE_H)  // for toupper(), isxxxx() macros
#include <ctype.h>
#endif

#include  "tdeflags.h"   // #define's for all the constants

#define  MASK_CHAR  '~'

//--------------------------------------------------------------------------
//
// **** class TDataEntry  ( TDE.CPP )
//
//--------------------------------------------------------------------------
class TDataEntry : public TInputLine
{
public:
  uchar   localMode;
  ushort  dataFormat;
  static  uchar   globalID;
  static  ushort  globalMode;
  static  char    *msgDataRequired;
  static  char    *msgDataInvalid;
  static  char    secureChar;

  TDataEntry(int col, int row, char *format, const char *fName = NULL );
  TDataEntry(int col, int row, int len, const char *fName = NULL );
  ~TDataEntry();
  void selectAll( Boolean enable );
  virtual ushort dataSize();
  virtual void draw();
  virtual void getData( void *rec );
  virtual void handleEvent(TEvent& event);
  virtual void setData( void *rec );
  virtual void setState( ushort aState, Boolean enable );
  virtual Boolean valid(ushort);
  virtual Boolean validData( const char *InvalidMsg, char const *RequiredMsg );
  virtual Boolean validKey(uchar *key ) { return (Boolean)isprint(*key); };
  static  inline  TDataEntry *locateID( TView *fieldOwner, uchar fieldNumber,
                                        Boolean select = False );
  static  inline  TDataEntry *locateName( TView *fieldOwner, const char *fName,
                                          Boolean select = False );
  static  inline  void       resetData( TView *fieldOwner, TDataEntry *target = NULL );
  static  inline  TDataEntry *queryChanged( TView *fieldOwner, TDataEntry *target = NULL );
  static  inline  TDataEntry *queryValid( TView *fieldOwner, TDataEntry *target = NULL );

protected:
  char    *mask, *outView, *origData;
  int     tdCurPos, tdLastPos, tdSelStart, tdSelEnd;
  ushort  localID;
  char    *fieldName;

private:
  int  mousePos( TEvent& event );
  void deleteSelect();
  void near setViewPos(ushort);
  void near formatView();
};

//--------------------------------------------------------------------------
//
// **** class TDEAlpha - alpha strings only  ( TDE.CPP )
//
//--------------------------------------------------------------------------
#if defined( Uses_TDEAlpha )
class TDEAlpha : public TDataEntry
{
public:
  TDEAlpha(int col, int row, char *format, const char *fName = NULL) :
    TDataEntry(col, row, format, fName) {};
  TDEAlpha(int col, int row, int len, const char *fName = NULL) :
    TDataEntry(col, row, len, fName) {};

  virtual Boolean validKey(uchar *key) { return (Boolean)isalpha(*key); };
  virtual Boolean validData( char *, char * )
  { return
    TDataEntry::validData( "\003Data must be alpha characters only!", NULL);
  };
};
#endif

//--------------------------------------------------------------------------
//
// **** class TDEAlphaNum - alphanumeric strings only  ( TDE.CPP )
//
//--------------------------------------------------------------------------
#if defined( Uses_TDEAlphaNum )
class TDEAlphaNum : public TDataEntry
{
public:
  TDEAlphaNum(int col, int row, char *format, const char *fName = NULL) :
    TDataEntry(col, row, format, fName) {};
  TDEAlphaNum(int col, int row, int len, const char *fName = NULL) :
    TDataEntry(col, row, len, fName) {};

  virtual Boolean validKey(uchar *key) { return (Boolean)isalnum(*key); };
  virtual Boolean validData( const char *, const char * )
  { return
    TDataEntry::validData( "\003Data must be alphanumeric characters only!", NULL);
  };
};
#endif

//--------------------------------------------------------------------------
//
// **** class TDENumeric - numeric strings only  ( TDE.CPP )
//
//--------------------------------------------------------------------------
#if defined( Uses_TDENumeric )
class TDENumeric : public TDataEntry
{
public:
  TDENumeric(int col, int row, char *format, const char *fName = NULL) :
    TDataEntry(col, row, format, fName), SpaceAllowed( False ) {};
  TDENumeric(int col, int row, int len, const char *fName = NULL) :
    TDataEntry(col, row, len, fName), SpaceAllowed( False ) {};

  Boolean SpaceAllowed;

  virtual Boolean validKey(uchar *key)
    { return (Boolean) ( (*key == ' ' && SpaceAllowed) || isdigit(*key)); };
  virtual Boolean validData( const char *, const char * )
  { return
    TDataEntry::validData( "\003Data must be numeric only!", NULL);
  };
};
#endif

//--------------------------------------------------------------------------
//
// **** class TDEInteger - signed integer values ( TDEDATE.CPP )
//
//--------------------------------------------------------------------------
#if defined( Uses_TDEInteger )
class TDEInteger : public TDataEntry
{
public:
  TDEInteger(int col, int row, char *format, const char *fName = NULL) :
    TDataEntry(col, row, format, fName) {};
  TDEInteger(int col, int row, int len, const char *fName = NULL) :
    TDataEntry(col, row, len, fName) {};

  virtual void    getData(void *);
  virtual void    setData(void *);
  virtual ushort  dataSize() { return sizeof( int ); };
  virtual void    handleEvent( TEvent& event );
  virtual Boolean validData( const char *, const char * );
  virtual Boolean validKey(uchar *key) { return (Boolean)isdigit(*key); };
protected:
  int     origInt;
};
#endif

//--------------------------------------------------------------------------
//
// **** class TDEDate - date strings only (TDEDATE.CPP)
//
//--------------------------------------------------------------------------
#if defined( Uses_TDEDate )

#define  dateMDY  0x01
#define  dateYMD  0x02
#define  dateDMY  0x03

class TDEDate : public TDataEntry
{
public:
  TDEDate(int col, int row, char *format, const char *fName = NULL) :
    TDataEntry(col, row, format, fName) {};
  TDEDate(int col, int row, int len, const char *fName = NULL) :
    TDataEntry(col, row, len, fName) {};

  static  ushort  defCentury;
  static  ushort  dateFormat;
  virtual ushort  dataSize() { return sizeof( long ); };
  virtual void    getData( void *rec );
  virtual void    setData( void *rec );
  virtual Boolean valid(ushort cmd);
  virtual Boolean validData( const char *, const char * );
  virtual Boolean validKey(uchar *key) { return (Boolean)isdigit(*key); };
};
#endif

//--------------------------------------------------------------------------
//
// **** class TDEPhone - phone number strings only (TDEPHONE.CPP)
//
//--------------------------------------------------------------------------
#if defined( Uses_TDEPhone )
class TDEPhone : public TDataEntry
{
public:
  TDEPhone(int col, int row, char *format, const char *fName = NULL) :
    TDataEntry(col, row, format, fName) {};
  TDEPhone(int col, int row, int len, const char *fName = NULL) :
    TDataEntry(col, row, len, fName) {};

  virtual Boolean valid(ushort cmd);
  virtual Boolean validData( const char *, const char * );
  virtual Boolean validKey(uchar *key) { return (Boolean)isdigit(*key); };
};
#endif

//--------------------------------------------------------------------------
//
// **** class TDEZipCode - zip code strings only (TDEPHONE.CPP)
//
//--------------------------------------------------------------------------
#if defined( Uses_TDEZipCode )
class TDEZipCode : public TDataEntry
{
public:
  TDEZipCode(int col, int row, char *format, const char *fName = NULL) :
    TDataEntry(col, row, format, fName) {};
  TDEZipCode(int col, int row, int len, const char *fName = NULL) :
    TDataEntry(col, row, len, fName) {};

  virtual Boolean valid(ushort cmd);
  virtual Boolean validData( const char *, const char * );
  virtual Boolean validKey(uchar *key) { return (Boolean)isdigit(*key); };
};
#endif

//--------------------------------------------------------------------------
//
// **** class TDEState - state abbreviation strings only (TDEPHONE.CPP)
//
//--------------------------------------------------------------------------
#if defined( Uses_TDEState)
class TDEState : public TDataEntry
{
public:
  TDEState(int col, int row, char *format, const char *fName = NULL) :
    TDataEntry(col, row, format, fName) {};
  TDEState(int col, int row, int len, const char *fName = NULL) :
    TDataEntry(col, row, len, fName) {};

  virtual Boolean valid(ushort cmd);
  virtual Boolean validData( const char *, const char * );
  virtual Boolean validKey(uchar *key)
    { return (Boolean)isalpha(*key = toupper(*key)); };
};
#endif

//--------------------------------------------------------------------------
//
// **** class TDEButton ( TDECLUST.CPP )
//
// TButton control for use with dialogs containing TDataEntry objects when
//  globalMode's tdgUpDownEnable flag is set.  Allows button to respond to
//  up/down arrow movement.
//--------------------------------------------------------------------------
#if defined( Uses_TDEButton )
class TDEButton : public TButton
{
public:
  TDEButton::TDEButton( const TRect& bounds, const char *aTitle,
                        ushort aCommand, ushort aFlags ) :
             TButton( bounds, aTitle, aCommand, aFlags ) { };

  virtual void handleEvent( TEvent& event );
};
#endif

//--------------------------------------------------------------------------
//
// **** class TDEInputLine  ( TDEINPLI.CPP )
//
// TInputLine for use with dialogs containing TDataEntry objects when
//  globalMode's tdgUpDownEnable flag is set.  Allows input line to respond
//  to up/down arrow movement.
//--------------------------------------------------------------------------
#if defined( Uses_TDEInputLine )
class TDEInputLine : public TInputLine
{
public:
  TDEInputLine( const TRect& bounds, int aMaxLen, const char *fName = NULL );
  ~TDEInputLine();

  virtual void     handleEvent( TEvent& event );
  virtual void     getData( void * );
  virtual void     setData( void * );
  virtual void     setState( ushort aState, Boolean enable );
  virtual Boolean  valid( ushort );
protected:
  char   *origData, *fieldName;
  ushort localID;

};
#endif

//--------------------------------------------------------------------------
//
// **** class TDERadioButtons  ( TDECLUST.CPP )
//
// TRadioButtons for use with dialogs containing TDataEntry objects when
//  globalMode's tdgEnterIsTab flag is set.  Allows radio buttons to respond
//  to enter key without exiting dialog.
//--------------------------------------------------------------------------
#if defined( Uses_TDERadioButtons )
class TDERadioButtons : public TRadioButtons
{
public:
  TDERadioButtons( const TRect& bounds, TSItem *aStrings, const char *fName = NULL );
  ~TDERadioButtons();
  virtual void handleEvent( TEvent& event );
  virtual void setData( void * );
protected:
  ushort  origData, localID;
  char    *fieldName;
};
#endif

//--------------------------------------------------------------------------
//
// **** class TDECheckBoxes  ( TDECLUST.CPP )
//
// TCheckBoxes for use with dialogs containing TDataEntry objects when
//  globalMode's tdgEnterIsTab flag is set.  Allows check boxes to respond to
//  enter key without exiting dialog.
//--------------------------------------------------------------------------
#if defined( Uses_TDECheckBoxes )
class TDECheckBoxes : public TCheckBoxes
{
public:
  TDECheckBoxes( const TRect& bounds, TSItem *aStrings, const char *fName = NULL );
  ~TDECheckBoxes();
  virtual void handleEvent( TEvent& event );
  virtual void setData( void * );
protected:
  ushort  origData, localID;
  char    *fieldName;
};
#endif

#endif