; cc.asm

_TEXT		SEGMENT	BYTE PUBLIC 'CODE'
		ASSUME	cs:_TEXT, ds:NOTHING, es:NOTHING, ss:NOTHING
		ORG	100h

CR		EQU	13
LF		EQU	10
TAB		EQU	9

INACTIVE	EQU	0		; TSR not active.
TRIGGERED	EQU	1		; TSR triggered.
ACTIVE		EQU	2		; TSR active.

tsr:
		jmp	NEAR PTR install

key		DB	'C'		; Hotkey character.
scancode	DB	2eh		; Activation scancode.
signature	DB	"TSR:cc"	; Our signature in memory.
SIGLENGTH	EQU	$-signature	; Length of this signature.
		DB	0

; --------------------- ;
; Resident Data Section ;
; --------------------- ;

critdisk	DB	0		; Critical disk flag.
criterr		DD	?		; Address of critical error flag.
critsec		DD	?		; Address of critical section flag.
dta		DD	?		; Saved DTA address.
errax		DW	?		; Saved extended error info.
errbx		DW	?
errcx		DW	?
oldint8h	DD	?		; Old interrupt 8h vector.
oldint9h	DD	?		; Old interrupt 9h vector.
oldint13h	DD	?		; Old interrupt 13h vector.
oldint1bh	DD	?		; Old interrupt 1bh vector.
oldint23h	DD	?		; Old interrupt 23h vector.
oldint24h	DD	?		; Old interrupt 24h vector.
oldint28h	DD	?		; Old interrupt 28h vector.
port61h		DB	?		; Current value in port 61h.
_psp		DW	?		; Saved PSP.
savesp		DW	?		; Saved stack pointer.
savess		DW	?		; Saved stack segment.
tsr_state	DB	INACTIVE	; TSR state.

; --------------------- ;
; Resident Code Section ;
; --------------------- ;

; ----------------------- ;
; New interrupt 8h vector ;
; ----------------------- ;

newint8h	PROC	FAR
		pushf
		call	DWORD PTR oldint8h

		cmp	BYTE PTR tsr_state, TRIGGERED
		jnz	newint8h1

		push	ax
		push	bx
		push	es

		les	bx, DWORD PTR criterr
		mov	al, es:[bx]

		cmp	al, 0

		pop	es
		pop	bx
		pop	ax

		jnz	newint8h1

		push	ax
		push	bx
		push	es

		les	bx, DWORD PTR critsec
		mov	al, es:[bx]

		cmp	al, 0

		pop	es
		pop	bx
		pop	ax

		jnz	newint8h1

		cmp	BYTE PTR critdisk, 0
		jnz	newint8h1

		mov	BYTE PTR tsr_state, ACTIVE

		call	launch

		mov	BYTE PTR tsr_state, INACTIVE
newint8h1:
		iret
newint8h	ENDP

; ----------------------- ;
; New interrupt 9h vector ;
; ----------------------- ;

newint9h	PROC	FAR
		push	ax

		in	al, 60h		; Examine scan code.

		cmp	al, scancode	; Does it match our scan code?
		jz	newint9h2	; Yes, branch.
newint9h1:
		pop	ax		; Exit to original handler.
		jmp	DWORD PTR oldint9h
newint9h2:
		push	es		; Check for simultaneous ALT press.
		mov	ax, 0
		mov	es, ax

		mov	al, es:[417h]	; Get shift status byte.
		and	al, 15		; Remove toggle data.
		cmp	al, 8		; ALT (alone) pressed?

		pop	es
		jnz	newint9h1	; No, branch.

		in	al, 61h		; Acknowledge scan code.
		jmp	$+2
		mov	ah, al
		or	al, 10000000b
		out	61h, al
		jmp	$+2
		mov	al, ah
		out	61h, al
		jmp	$+2

		cmp	BYTE PTR tsr_state, INACTIVE
		jnz	newint9h3	; Branch if TSR not inactive.

		mov	BYTE PTR tsr_state, TRIGGERED
newint9h3:
		mov	al, 20h		; Reset 8259 PIC.
		out	20h, al

		pop	ax
		iret
newint9h	ENDP

; ------------------------ ;
; New interrupt 13h vector ;
; ------------------------ ;

newint13h	PROC	FAR
		mov	BYTE PTR critdisk, 1

		pushf
		call	DWORD PTR oldint13h

		mov	BYTE PTR critdisk, 0

		sti
		ret	2		; Return without original flags.
newint13h	ENDP

; ------------------------ ;
; New interrupt 1bh vector ;
; ------------------------ ;

newint1bh	PROC	FAR
		iret
newint1bh	ENDP

; ------------------------ ;
; New interrupt 23h vector ;
; ------------------------ ;

newint23h	PROC	FAR
		iret
newint23h	ENDP

; ------------------------ ;
; New interrupt 24h vector ;
; ------------------------ ;

newint24h	PROC	FAR
		mov	ax, 3		; Fail code.
		iret
newint24h	ENDP

; ------------------------ ;
; New interrupt 28h vector ;
; ------------------------ ;

newint28h	PROC	FAR
		pushf
		call	DWORD PTR oldint28h

		cmp	BYTE PTR tsr_state, TRIGGERED
		jnz	newint28h1

		push	ax
		push	bx
		push	es

		les	bx, DWORD PTR criterr
		mov	al, es:[bx]

		cmp	al, 0

		pop	es
		pop	bx
		pop	ax

		jnz	newint28h1

		push	ax
		push	bx
		push	es

		les	bx, DWORD PTR critsec
		mov	al, es:[bx]

		cmp	al, 1

		pop	es
		pop	bx
		pop	ax

		ja	newint28h1

		cmp	BYTE PTR critdisk, 0
		jnz	newint28h1

		mov	BYTE PTR tsr_state, ACTIVE

		call	launch

		mov	BYTE PTR tsr_state, INACTIVE
newint28h1:
		iret
newint28h	ENDP

; ------------------------------ ;
; Launch: Launch TSR Application ;
; ------------------------------ ;

		ASSUME	ds:_TEXT, es:_TEXT, ss:_TEXT

launch		PROC	NEAR
		mov	cs:savess, ss	; Switch stacks.
		mov	cs:savesp, sp
		mov	sp, cs
		mov	ss, sp
		lea	sp, _stack
		sti

		cld
		push	ax
		push	bx
		push	cx
		push	dx
		push	si
		push	di
		push	bp
		push	ds
		push	es

		push	cs
		pop	ds

		mov	ax, 351bh
		int	21h

		mov	WORD PTR oldint1bh, bx
		mov	WORD PTR oldint1bh [2], es

		mov	ax, 3523h
		int	21h

		mov	WORD PTR oldint23h, bx
		mov	WORD PTR oldint23h [2], es

		mov	ax, 3524h
		int	21h

		mov	WORD PTR oldint24h, bx
		mov	WORD PTR oldint24h [2], es

		lea	dx, newint1bh
		mov	ax, 251bh
		int	21h

		lea	dx, newint23h
		mov	ax, 2523h
		int	21h

		lea	dx, newint24h
		mov	ax, 2524h
		int	21h

		mov	ah, 62h		; Save current PSP.
		int	21h

		mov	_psp, bx

		mov	bx, cs		; Set PSP to our own.
		mov	ah, 50h
		int	21h

		mov	ah, 2fh		; Save current DTA.
		int	21h

		mov	WORD PTR dta, bx
		mov	WORD PTR dta [2], es

		mov	dx, 80h		; Set DTA to our own.
		mov	ah, 1ah
		int	21h

		mov	bx, 0		; Must be zero.
		mov	ah, 59h		; Save extended error info.
		int	21h

		push	cs		; DS destroyed by function.
		pop	ds

		mov	errax, ax
		mov	errbx, bx
		mov	errcx, cx
launch1:
		mov	ah, 1		; Remove unwanted keys.
		int	16h
		jz	launch2

		mov	ah, 0
		int	16h
		jmp	SHORT launch1
launch2:
		in	al, 61h		; Save port value.
		mov	port61h, al

		and	al, 0fch	; Disconnect speaker.
		out	61h, al

		push	cs
		pop	es

		call	_main		; Invoke app entry point.

		mov	al, 61h		; Restore port value.
		out	61h, al

		push	ds

		mov	bx, 0		; Must be zero.
		lea	dx, errax	; Point to info structure.
		mov	ax, 5d0ah	; Restore extended error info.
		int	21h

		pop	ds

		lds	dx, dta		; Restore DTA.
		mov	ah, 1ah
		int	21h

		push	cs		; Restore DS.
		pop	ds

		mov	bx, _psp	; Restore PSP.
		mov	ah, 50h
		int	21h

		lds	dx, cs:oldint24h
		mov	ax, 2524h
		int	21h

		lds	dx, cs:oldint23h
		mov	ax, 2523h
		int	21h

		lds	dx, cs:oldint1bh
		mov	ax, 251bh
		int	21h

		pop	es
		pop	ds
		pop	bp
		pop	di
		pop	si
		pop	dx
		pop	cx
		pop	bx
		pop	ax

		cli			; Switch stacks.
		mov	ss, cs:savess
		mov	sp, cs:savesp
		ret
launch		ENDP

		DB	256 DUP (?)
_stack		LABEL	BYTE

		INCLUDE cc.tsr

; ------------------------- ;
; Installation Data Section ;
; ------------------------- ;

installsec:

ctailaddr	DW	81h		; Command tail address.
psp		DW	?		; PSP of "searched" TSR.

scancodes	DB	30,48,46,32,18,33,34,35,23,36,37,38,50 ; A-M
		DB	49,24,25,16,19,31,20,22,47,17,45,21,44 ; N-Z
		DB	11,02,03,04,05,06,07,08,09,10          ; 0-9

tsr_delmsg	DB	CR, LF
		DB	"successfully uninstalled"
		DB	CR, LF
		DB	'$'

tsr_keymsg	DB	CR, LF
		DB	"hotkey = ALT-"
tsr_keymsg1	DB	?
		DB	CR, LF
		DB	'$'

tsr_errmsg1	DB	CR, LF
		DB	"invalid DOS version (must be 3.3 or higher)"
		DB	CR, LF
		DB	'$'

tsr_errmsg2	DB	CR, LF
		DB	"invalid character on command line"
		DB	CR, LF
		DB	'$'

tsr_errmsg3	DB	CR, LF
		DB	"invalid option"
		DB	CR, LF
		DB	'$'

tsr_errmsg4	DB	CR, LF
		DB	"not in memory"
		DB	CR, LF
		DB	'$'

tsr_errmsg5	DB	CR, LF
		DB	"unable to uninstall"
		DB	CR, LF
		DB	'$'

tsr_errmsg6	DB	CR, LF
		DB	"invalid hotkey character"
		DB	CR, LF
		DB	'$'

; ------------------------- ;
; Installation Code Section ;
; ------------------------- ;

install:
		lea	bx, _title	; Display suitable title.
		mov	dx, [bx]
		mov	ah, 9
		int	21h

		mov	ah, 30h		; Obtain DOS version number.
		int	21h

		cmp	al, 3		; Test major portion.
		jb	install1	; Branch if less that 3.
		ja	install2	; Branch if greater than 3.

		cmp	ah, 30		; Test minor portion.
		jae	install2	; Branch if >= 30.
install1:
		lea	dx, tsr_errmsg1	; Display error message.
		mov	ah, 9
		int	21h

		mov	ax, 4c01h	; Exit with error code 1.
		int	21h
install2:
		mov	ax, 5d06h	; Obtain critical error flag.
		int	21h

		mov	ax, ds

		push	cs		; Restore DS.
		pop	ds

		mov	WORD PTR criterr, si
		mov	WORD PTR criterr [2], ax

		mov	ah, 34h		; Obtain critical section flag.
		int	21h

		mov	WORD PTR critsec, bx
		mov	WORD PTR critsec [2], es

		lea	bx, signature	; Search for resident copy.
		not	BYTE PTR [bx]	; Avoid false cache match.
		mov	cx, SIGLENGTH	; Get length of signature.
		call	search		; Search for prior copy.
		mov	psp, ax		; Save PSP of prior/current TSR.

		call	skipws		; Skip whitespace.
		call	parse		; Parse nonwhitespace character.

		cmp	al, CR		; Empty command tail?
		jnz	install3		; No, branch.

		mov	ax, psp		; Point ES to resident or ...
		mov	es, ax		; ... current segment.

		mov	al, es:key	; Get hotkey character.
		mov	tsr_keymsg1, al

		push	cs		; Restore ES if necessary.
		pop	es

		lea	dx, tsr_keymsg	; Display hotkey message.
		mov	ah, 9
		int	21h

		mov	ax, cs		; First install?
		cmp	ax, psp
		jz	install10	; Yes, branch.

		mov	ax, 4c00h	; Exit with OK code.
		int	21h
install3:
		cmp	al, '/'		; Option?
		jz	install4

		lea	dx, tsr_errmsg2	; Display error message.
		mov	ah, 9
		int	21h

		mov	ax, 4c01h	; Exit with error code 1.
		int	21h
install4:
		call	parse		; Extract next character.

		cmp	al, 'K'		; Hotkey option?
		jz	install5	; Yes, branch.

		cmp	al, 'k'		; Lowercase version?
		jnz	install6	; No, branch.
install5:
		call	parse_key	; Parse hotkey.

		mov	ax, psp		; Point ES to resident or ...
		mov	es, ax		; ... current segment.

		mov	al, es:key	; Get hotkey character.
		mov	tsr_keymsg1, al

		push	cs		; Restore ES if necessary.
		pop	es

		lea	dx, tsr_keymsg	; Display hotkey message.
		mov	ah, 9
		int	21h

		mov	ax, cs		; First install?
		cmp	ax, psp
		jz	install10	; Yes, branch.

		mov	ax, 4c00h	; Exit with OK code.
		int	21h
install6:
		cmp	al, 'U'		; Uninstall option?
		jz	install7	; Yes, branch.

		cmp	al, 'u'		; Lowercase version?
		jnz	install9	; No, branch.
install7:
		mov	ax, cs		; First install?
		cmp	ax, psp
		jnz	install8	; No, branch.

		lea	dx, tsr_errmsg4	; Display error message.
		mov	ah, 9
		int	21h

		mov	ax, 4c01h	; Exit with error code 1.
		int	21h
install8:
		jmp	uninstall
install9:
		lea	dx, tsr_errmsg3	; Display error message.
		mov	ah, 9
		int	21h

		mov	ax, 4c01h	; Exit with error code 1.
		int	21h
install10:
		mov	ax, 3508h	; Get timer interrupt vector.
		int	21h

		mov	WORD PTR oldint8h, bx
		mov	WORD PTR oldint8h [2], es

		mov	ax, 3509h	; Get key interrupt vector.
		int	21h

		mov	WORD PTR oldint9h, bx
		mov	WORD PTR oldint9h [2], es

		mov	ax, 3513h	; Get disk interrupt vector.
		int	21h

		mov	WORD PTR oldint13h, bx
		mov	WORD PTR oldint13h [2], es

		mov	ax, 3528h	; Get idle interrupt vector.
		int	21h

		mov	WORD PTR oldint28h, bx
		mov	WORD PTR oldint28h [2], es

		mov	ax, ds:[002ch]	; Attempt to free environment.
		cmp	ax, 0		; Can we free environment?
		jz	install11	; No, branch.

		mov	es, ax		; Free environment block.
		mov	ah, 49h
		int	21h

		mov	WORD PTR ds:[002ch], 0	; Indicate no environment.
install11:
		mov	ax, 2508h	; Set new timer interrupt vector.
		lea	dx, newint8h
		int	21h

		mov	ax, 2513h	; Set new disk interrupt vector.
		lea	dx, newint13h
		int	21h

		mov	ax, 2528h	; Set new idle interrupt vector.
		lea	dx, newint28h
		int	21h

		mov	ax, 2509h	; Set new key interrupt vector.
		lea	dx, newint9h
		int	21h

		lea	dx, installsec	; Calculate number of para- ...
		add	dx, 15		; ... graphs to keep resident.
		mov	cl, 4
		shr	dx, cl

		mov	ax, 3100h	; TSR.
		int	21h

; ---------------------------------------------- ;
; Convert: Convert hotkey character to scancode. ;
;                                                ;
; Entry: AL = character ('A'-'Z' or '0'-'9')     ;
;                                                ;
; Exit:  AL = scancode                           ;
;                                                ;
; All other registers preserved.                 ;
; Requires presence of scancodes array.          ;
; ---------------------------------------------- ;

convert		PROC	NEAR
		push	bx

		mov	bl, al		; Get hotkey character.
		xor	bh, bh

		cmp	bl, 'A'		; Alphabetic hotkey?
		jb	convert1	; No, branch.

		sub	bl, 'A'		; Get alphabetic scancode.
		mov	al, scancodes [bx]

		pop	bx
		ret
convert1:
		sub	bl, '0'		; Get digit scancode.
		mov	al, scancodes [bx+26]

		pop	bx

		ret
convert		ENDP

; ------------------------------------- ;
; Parse: Parse nonwhitespace character. ;
;                                       ;
; Entry: none                           ;
;                                       ;
; Exit: AL = character                  ;
;                                       ;
; All other registers preserved.        ;
; ------------------------------------- ;

parse		PROC	NEAR
		push	bx

		mov	bx, ctailaddr	; Get command tail address.
		mov	al, [bx]	; Get character at this address.

		cmp	al, CR		; End of command tail?
		jz	parse1		; Yes, branch.

		inc	bx		; Point to next character.
		mov	ctailaddr, bx	; Update command tail address.
parse1:
		pop	bx

		ret
parse		ENDP

; -------------------------- ;
; Parse_key: Parse K option. ;
;                            ;
; Entry: none                ;
;                            ;
; Exit: none                 ;
;                            ;
; All registers preserved.   ;
; -------------------------- ;

parse_key	PROC	NEAR
		push	ax
		push	es

		call	parse		; Parse character after K.

		cmp	al, 'a'		; Convert to uppercase.
		jb	parse_key1

		cmp	al, 'z'
		ja	parse_key1

		sub	al, 32
parse_key1:
		cmp	al, '0'		; Validate.
		jb	parse_key2

		cmp	al, 'Z'
		ja	parse_key2

		cmp	al, '9'
		jbe	parse_key3

		cmp	al, 'A'
		jae	parse_key3
parse_key2:
		lea	dx, tsr_errmsg6	; Display error message.
		mov	ah, 9
		int	21h

		pop	es		; Cleanup stack even though ...
		pop	ax		; ... we don't have to.

		mov	ax, 4c01h	; Exit with error code 1.
		int	21h
parse_key3:
		push	ax

		mov	ax, psp		; Point ES to resident segment.
		mov	es, ax

		pop	ax

		mov	es:key, al	; Save character.

		call	convert		; Convert character to scancode.

		mov	es:scancode, al	; Save scancode.

		pop	es
		pop	ax

		ret
parse_key	ENDP

; ------------------------------------------------ ;
; Search: Search memory for previous TSR copy.     ;
;                                                  ;
; Entry: BX = address of signature to search       ;
;        CX = length of signature                  ;
;                                                  ;
; Exit:  AX = PSP address of prior or current copy ;
;                                                  ;
; All registers preserved (direction flag cleared) ;
; ------------------------------------------------ ;

search		PROC	NEAR
		push	bx
		push	cx
		push	si
		push	di
		push	es

		mov	si, bx		; SI will point to signature.

		mov	ax, 0a000h	; Initial segment.
		mov	bx, cs		; Final segment.
		cld			; Forward string operations.
search1:
		inc	ax		; Point to next segment.

		cmp	ax, bx		; At current segment?
		jz	search2		; Yes, exit search.

		mov	es, ax		; Target segment.
		mov	di, si		; Same offset.

		push	cx		; CMPSB destroys CX and SI.
		push	si

		rep	cmpsb		; Search for match.

		pop	si
		pop	cx

		jnz	search1		; Branch if no match.
search2:
		pop	es
		pop	di
		pop	si
		pop	cx
		pop	bx

		ret
search		ENDP

; ---------------------------------------- ;
; Skipws: Skip whitespace on command tail. ;
;                                          ;
; Entry: none                              ;
;                                          ;
; Exit: none                               ;
;                                          ;
; All registers preserved.                 ;
; ---------------------------------------- ;

skipws		PROC	NEAR
		push	ax
		push	bx

		mov	bx, ctailaddr	; Get command tail address.
skipws1:
		mov	al, [bx]	; Get command tail character.

		cmp	al, ' '		; Is character a space?
		jz	skipws2		; Yes, skip character.

		cmp	al, TAB		; Is character a tab?
		jnz	skipws3		; Yes, skip character.
skipws2:
		inc	bx		; Point to next character.
		jmp	SHORT skipws1	; Continue.
skipws3:
		mov	ctailaddr, bx	; Update command tail address.

		pop	bx
		pop	ax

		ret
skipws		ENDP

; ---------------------------------- ;
; Uninstall: Remove TSR from memory. ;
;                                    ;
; Entry: none                        ;
;                                    ;
; Exit: does not return              ;
; ---------------------------------- ;

uninstall	PROC	NEAR
		mov	ax, 3508h	; Make sure timer int exists.
		int	21h

		mov	ax, es
		cmp	ax, psp
		jnz	uninstall1

		mov	ax, 3509h	; Make sure key int exists.
		int	21h

		mov	ax, es
		cmp	ax, psp
		jnz	uninstall1

		mov	ax, 3513h	; Make sure disk int exists.
		int	21h

		mov	ax, es
		cmp	ax, psp
		jnz	uninstall1

		mov	ax, 3528h	; Make sure idle int exists.
		int	21h

		mov	ax, es
		cmp	ax, psp
		jnz	uninstall1

		mov	ax, psp
		mov	es, ax

		lds	dx, es:oldint8h	; Restore timer int.
		mov	ax, 2508h
		int	21h

		lds	dx, es:oldint9h	; Restore key int.
		mov	ax, 2509h
		int	21h

		lds	dx, es:oldint13h ; Restore disk int.
		mov	ax, 2513h
		int	21h

		lds	dx, es:oldint28h ; Restore idle int.
		mov	ax, 2528h
		int	21h

		push	cs
		pop	ds

		mov	ax, psp		; Get resident PSP segment.
		mov	es, ax

		mov	ah, 49h		; Free memory.
		int	21h
		jc	uninstall1

		lea	dx, tsr_delmsg	; Display success message.
		mov	ah, 9
		int	21h

		mov	ax, 4c00h	; Exit with OK code.
		int	21h
uninstall1:
		lea	dx, tsr_errmsg5	; Display error message.
		mov	ah, 9
		int	21h

		mov	ax, 4c01h	; Exit with error code 1.
		int	21h
uninstall	ENDP

_TEXT		ENDS
		END	tsr
