/*
	filter.C

	Version 1.1

	Filter BCC generated .asm file into TSR compatible file.

	Copyright (C) 1993, Geoff Friesen B.Sc.
	All rights reserved.

	Developed with: Borland C++ 3.1
*/

#if !defined(__LARGE__)
#error Large Memory Model Expected
#endif

#include <dir.H>
#include <fcntl.H>
#include <io.H>
#include <process.H>
#include <stdio.H>
#include <string.H>

int handle [4];

void	error		(char *msg);
int	getchr		(int handle);
int	getline		(int handle, char *line);
void	setfileext	(char *filespec, char *newext);

void main (int argc, char **argv)
{
   int i;
   struct ffblk f;
   char filespec [MAXPATH], line [256], *ptr;

   fprintf (stderr, "ͻ\n");
   fprintf (stderr, " filter v1.1: BCC .ASM file filter       \n");
   fprintf (stderr, "                                         \n");
   fprintf (stderr, " Copyright (C) 1993, Geoff Friesen B.Sc. \n");
   fprintf (stderr, " All rights reserved.                    \n");
   fprintf (stderr, "ͼ\n\n");

   if (argc != 2)
       error ("bad command line\nusage: filter filespec");

   strcpy (filespec, argv [1]);
   setfileext (filespec, ".asm");

   if ((handle [0] = _open (filespec, O_RDONLY)) == -1)
   {
       fprintf (stderr, "filter: unable to open %s\n", filespec);
       exit (1);
   }

   if ((handle [1] = _creat ("tsr1.tmp", 0)) == -1)
       error ("unable to create tsr1.tmp");

   if ((handle [2] = _creat ("tsr2.tmp", 0)) == -1)
       error ("unable to create tsr2.tmp");

   if ((handle [3] = _creat ("tsr3.tmp", 0)) == -1)
       error ("unable to create tsr3.tmp");

   while (1)
   {
      if (!getline (handle [0], line))
	  break;

      if (strstr (line, "extrn"))
	  continue;

      if (!strnicmp (line, "_TEXT", 5))
      {
	  do
	  {
	     if (!getline (handle [0], line))
		 error ("premature EOF");

	     ptr = strstr (line, ":DGROUP@");
	     if (ptr)
		 strcpy (ptr, "\n");

	     if (!strnicmp (line, "_TEXT", 5))
		 break;

	     if (_write (handle [1], line, strlen (line)) == -1)
		 error ("unable to write to TSR1.TMP");
	  }
	  while (1);
	  continue;
      }

      if (!strnicmp (line, "_DATA", 5))
      {
	  do
	  {
	     if (!getline (handle [0], line))
		 error ("premature EOF");

	     if (!strnicmp (line, "_DATA", 5))
		 break;

	     if (_write (handle [2], line, strlen (line)) == -1)
		 error ("unable to write to TSR2.TMP");
	  }
	  while (1);
	  continue;
      }

      if (!strnicmp (line, "_BSS", 4))
      {
	  do
	  {
	     if (!getline (handle [0], line))
		 error ("premature EOF");

	     if (!strnicmp (line, "_BSS", 4))
		 break;

	     if (_write (handle [3], line, strlen (line)) == -1)
		 error ("unable to write to TSR3.TMP");
	  }
	  while (1);
	  continue;
      }

      if (strstr (line, "end\r\n"))
	  continue;

      if (strstr (line, "group"))
	  strcpy (line, "DGROUP\tgroup\t_TEXT\r\n");

      if (_write (handle [1], line, strlen (line)) == -1)
	  error ("unable to write to TSR1.TMP");
   }

   (void) lseek (handle [2], 0L, SEEK_SET);

   while (getline (handle [2], line))
      if (_write (handle [1], line, strlen (line)) == -1)
	  error ("unable to write to TSR1.TMP");

   (void) lseek (handle [3], 0L, SEEK_SET);

   while (getline (handle [3], line))
      if (_write (handle [1], line, strlen (line)) == -1)
	  error ("unable to write to TSR1.TMP");

   for (i = 0; i < 4; i++)
	(void) _close (handle [i]);

   setfileext (filespec, ".tsr");

   if (!findfirst (filespec, &f, 0) && unlink (filespec) == -1)
       error ("unable to erase original file");

   if (rename ("tsr1.tmp", filespec) == -1)
       error ("unable to rename tsr1.tmp");

   if (unlink ("tsr2.tmp") == -1 || unlink ("tsr3.tmp") == -1)
       error ("unable to erase tsr2.tmp or tsr3.tmp");

   setfileext (filespec, ".asm");
   fprintf (stderr, "filter: %s successfully filtered\n", filespec);

   exit (0);
}

/* ------------------------------------------------------ */
/* Function: error ()                                     */
/*                                                        */
/* Prototype: void error (char *msg);                     */
/*                                                        */
/* Close all open files, display error message, and exit. */
/*                                                        */
/* Arguments:                                             */
/*                                                        */
/* msg - address of error message                         */
/*                                                        */
/* Local Variables:                                       */
/*                                                        */
/* i - loop index                                         */
/* ------------------------------------------------------ */

void error (char *msg)
{
   int i;

   for (i = 0; i < 4; i++)
	if (handle [i] != -1)
	    (void) _close (handle [i]);

   fprintf (stderr, "filter: %s\n", msg);

   exit (1);
}

/* ------------------------------------------------------------ */
/* Function: getchr ()                                          */
/*                                                              */
/* Prototype: int getchr (int handle);                          */
/*                                                              */
/* Get the next character from the file associated with handle. */
/*                                                              */
/* Arguments:                                                   */
/*                                                              */
/* handle - file handle                                         */
/*                                                              */
/* Return: EOF if end of file else character                    */
/*                                                              */
/* Local Variables:                                             */
/*                                                              */
/* n    - current number of characters in buffer                */
/* bufp - pointer to next character in buffer                   */
/* buf  - buffer used for buffered I/O                          */
/* ------------------------------------------------------------ */

int getchr (int handle)
{
   static int n = 0;
   static char *bufp;
   static char buf [2048];

   if (n <= 0)
   {
       n = _read (handle, buf, 2048);
       bufp = buf;
   }

   return ((--n >= 0) ? *bufp++ & 255 : EOF);
}

/* -------------------------------------------------------- */
/* Function: getline ()                                     */
/*                                                          */
/* Prototype: int getline (int handle, char *line);         */
/*                                                          */
/* Get a line of text from the file associated with handle. */
/* Each line is assumed to end with a CR/LF combination.    */
/* Any terminating CTRL-Z is ignored.                       */
/*                                                          */
/* Arguments:                                               */
/*                                                          */
/* handle - file handle                                     */
/* line   - buffer for storing line (must be large enough   */
/*          to hold a full 253-character line plus a CR/LF  */
/*          pair and a '\0' or 256 characters).             */
/*                                                          */
/* Local Variables:                                         */
/*                                                          */
/* c - next character read from file                        */
/* i - loop index                                           */
/* -------------------------------------------------------- */

int getline (int handle, char *line)
{
   int c, i;

   for (i = 0; i < 253 && (c = getchr (handle)) != EOF && c != '\r'; i++)
	line [i] = c;

   if (!i || line [0] == 0x1a)
       return 0;

   line [i++] = '\r';
   line [i++] = '\n';
   line [i] = '\0';

   if (c == '\r')
       getchr (handle);

   return i;
}

/* ---------------------------------------------------------- */
/* Function: setfileext ()                                    */
/*                                                            */
/* Prototype: void setfileext (char *filespec, char *newext); */
/*                                                            */
/* setfileext () sets the extension of filespec to newext.    */
/* It is assumed that filespec has enough room for MAXPATH    */
/* characters.                                                */
/*                                                            */
/* Arguments:                                                 */
/*                                                            */
/* filespec - filespec to modify                              */
/* newext   - new extension for filespec                      */
/*                                                            */
/* Local Variables:                                           */
/*                                                            */
/* drive - filespec drive (including ':')                     */
/* dir   - filespec directory                                 */
/* file  - filespec file name                                 */
/* ext   - filespec extension                                 */
/* ---------------------------------------------------------- */

void setfileext (char *filespec, char *newext)
{
   char drive [MAXDRIVE];
   char dir [MAXDIR];
   char file [MAXFILE];
   char ext [MAXEXT];

   fnsplit (filespec, drive, dir, file, ext);
   fnmerge (filespec, drive, dir, file, newext);
}