/* ------------- xmsinit.c --------------- */

/*
 * Extended Memory Specification (XMS) Driver Functions
 * This is the initialization XMS code. Its memory is
 * returned to DOS when the TSR becomes resident
 */

#include "tsr.h"

/* ------- test for XMS installed in system -------- */
BOOL xms_present(void)
{
	_AX = 0x4300;
	geninterrupt(0x2f);
	if (_AL != 0x80)
		return FALSE;
	_AX = 0x4310;
	geninterrupt(0x2f);
	xmscall = MK_FP(_ES, _BX);
	return TRUE;
}

/* ------- return size in KB of largest XMS block available --------- */
unsigned xms_available(void)
{
	_AH = 8;
	(*xmscall)();
	return _AX;
}

/* ------- allocate block in KB of XMS to an application ------ */
int xms_allocate(unsigned blksize)
{
	_DX = blksize;
	_AH = 9;
	(*xmscall)();
	return _DX;
}

