/* ---------- tsr.h ------------- */

#ifndef TSR_H
#define TSR_H

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>

typedef enum {FALSE, TRUE} BOOL;

#include "interupt.h"
#include "emm.h"
#include "xms.h"
#include "tsrplus.h"

#define OVERLAYFILE	"MEMOIR.EXE"
#define SWAPFILE	"MEMSWAP."

#ifdef EXTERNS
#define EXTERN /* */
#else
#define EXTERN extern
#endif

/* ------ interrupt vector chains ------ */
EXTERN void (interrupt *oldtimer)(void);
EXTERN void (interrupt *old28)(void);
EXTERN void (interrupt *oldkb)(void);
EXTERN void (interrupt *olddisk)(void);
EXTERN void (interrupt *oldvideo)(void);
EXTERN void (interrupt *old2f)(void);

EXTERN void (interrupt *oldcrit)(void);
EXTERN void (interrupt *oldbreak)(void);
EXTERN void (interrupt *oldctrlc)(void);

EXTERN unsigned dossegmnt;	  /* DOS segment address		*/
EXTERN unsigned dosbusy;	  /* offset to InDOS flag 		*/
EXTERN char far *mydta;		  /* TSRPLUS's DTA 				*/
EXTERN unsigned MouseSegment; /* segment of mouse ISR       */

EXTERN int tsrss;  		/* TSRPLUS's stack segment */
EXTERN int tsrsp;  		/* TSRPLUS's stack pointer */

EXTERN unsigned highmemory;
EXTERN unsigned length;			/* length of TSR's swapped image */
EXTERN unsigned TPAlength;		/* length of TPA being swapped   */

EXTERN unsigned RunningSize;
EXTERN unsigned WaitingSize;

EXTERN BOOL registered;
EXTERN int diskflag;
EXTERN BOOL hotkeyhit;

/* ---------------- context for the popup ------------------ */
EXTERN unsigned intpsp;			/* Interrupted PSP address 	 */
EXTERN BOOL running				/* TSR running indicator 	 */
#ifdef EXTERNS
= TRUE
#endif
;
EXTERN char far *intdta;		/* interrupted DTA			 */
EXTERN unsigned intsp;			/*     "       stack pointer */
EXTERN unsigned intss;			/*     "       stack segment */
EXTERN unsigned ctrl_break; 	/* Ctrl-Break setting		 */

EXTERN unsigned char Keymask
#ifdef EXTERNS
= 10							/* Hot key shift mask */
#endif
;
EXTERN unsigned char Scancode
#ifdef EXTERNS
= 0x32							/* hot key scan code  */
#endif
;
EXTERN BOOL UseXMS
#ifdef EXTERNS
= TRUE
#endif
;
EXTERN BOOL UseEMM
#ifdef EXTERNS
= TRUE
#endif
;

EXTERN struct swap_header swap;

/* ------------- XMS variables ---------------- */
EXTERN BOOL xms; 			/* indicates XMS is available*/
EXTERN int xmshandle;
EXTERN void far (*xmscall)(void);

/* -------------- EMS variables --------------- */
EXTERN BOOL emm; 			/* indicates EMM is available*/
EXTERN int emmhandle;
EXTERN int frame;	 	    /* EMM frame segment   		 */

/* ----------- swap file variables --------------- */
EXTERN int diskhandle;	/* swap file handle		 		*/
EXTERN char SwapPath[64];
EXTERN BOOL swaperror;	/* Swap file error indicator	*/

EXTERN int MouseIRQ;

#define readcode(wh) swapcode(wh, 1)
#define writecode(wh) swapcode(wh, 0)
#define readvectors(wh) swapvectors(wh, 1)
#define writevectors(wh) swapvectors(wh, 0)

unsigned allocsize(void);
int register_tsr(struct swap_header far *sw);
void openswaps(void);
void closeswaps(void);
void swapcode(BOOL wh, BOOL dir);
void swapvectors(BOOL wh, BOOL dir);

void sendvectors(void);

#ifdef EXTERNS
/* ------ ISRs for the TSR ------- */
static void interrupt newtimer(void);
static void interrupt new28(void);
static void interrupt newdisk(IREGS);
static void interrupt newkb(void);
static void interrupt newcrit(IREGS);
static void interrupt newbreak(void);
#endif

BOOL isinvideo(void);
void new2f(void);
void newvideo(void);
void resterm(int);

EXTERN struct vectors {
	int vno;
	void (interrupt **oldvect)(void);
	void (interrupt *newvect)(void);
} vectors[]

#ifdef EXTERNS
=	{
		{TIMER,      &oldtimer, (void interrupt (*)())newtimer},
		{INT28,      &old28,    (void interrupt (*)())new28},
		{KYBRD,      &oldkb,    (void interrupt (*)())newkb},
		{DISK,       &olddisk,  (void interrupt (*)())newdisk},
		{VIDEO,      &oldvideo, (void interrupt (*)())newvideo},
		{TSRPLUSINT, &old2f,    (void interrupt (*)())new2f},
		{0,          NULL,      NULL}
	}
#endif
;

EXTERN struct vectors critvects[] 
#ifdef EXTERNS
=	{
		{CRIT,	  &oldcrit,  (void interrupt (*)())newcrit},
		{CTRLBRK, &oldbreak, (void interrupt (*)())newbreak},
		{CTRLC,	  &oldctrlc, (void interrupt (*)())newbreak},
		{0,          NULL,      NULL}
	}
#endif
;

EXTERN int unloading;				/* TSR unload flag				 */

#define newvectors(vecs)					\
{											\
	register struct vectors *vc = vecs;		\
	while (vc->vno)	{						\
		*(vc->oldvect) = getvect(vc->vno);	\
		setvect(vc->vno, vc->newvect);		\
		vc++;								\
	}										\
}

#define oldvectors(vecs)				\
{										\
	register struct vectors *vc = vecs;	\
	while (vc->vno)	{					\
		setvect(vc->vno, *vc->oldvect);	\
		vc++;							\
	}									\
}

#endif
