// *********************************************************************
// This file contains the definitions for class TPicture derived from
// class TInputLine.  Even though I have some doubts about how elegant
// the definition of this class is, it works.  TPicture's constructor
// is defined by specifying the bounds (just like in TInputLine) and
// the mask string.  From the length of the maskstring maxLen is
// calculated "privately" by the member functions.  The string mask
// uses the characters #?&@! and ~.  The characters are treated as
// follows:
//              #  -  only a digit is accepted
//              ?  -  letter (any case)
//              &  -  letter (convert to uppercase)
//              @  -  any character
//              !  -  any character (convert to uppercase)
//              ~  -  digits 0 to 9, . (period) and - (minus sign)
//
//  Any other character will appear literally, and its position in the
//  entry field will be protected.
//
//  examples for mask:
//
//     "(###) ###-####"  for a phone number (digits only)
//     "##/##/##"        a numeric entry for a date
//     "~~~~~~~~~"       a number (digits,.,-)
//     "##-&&&-##"       another date format (03-JAN-91)
//     etc.
//
//   The streamable part of this class compiles fine.  I have not been
//   able to test it yet.  Any help will be accepted.  My compuserve
//   user number is 73257,2655.
//
//   I wrote some internal functions for the class as private member
//   functions.  I suppose it's more elegant to write static functions
//   within the file in which the class is defined because the user will
//   not have any access whatsoever to those functions.  I did not do
//   it this way, for I have the doubt at the beginning and chose this
//   alternative.  Any comment from an expert in C++ will be well received.
//   Which way is better?
//
//   Any comments on this TPicture class will be appreciated.  The next
//   step would be to add a history class for TPicture.
//
//   TPicture was written by Gonzalo Isaza, compuserve member No. 73257,2655
//   This object can be freely distributed to other users without incurring
//   in any copyright violation.  Should any modification be made to this
//   object please notify such change via compuserve.  This notification
//   is requested so that many people can benefit from the changes to the 
//   object.  
//
//*************************************************************************

#define  STRINGMASK  "#?&@!~"

char  capitalize(char c);

class TPicture : public TInputLine     // define a new input line class
{
protected:
  char   *mask;

public:
  static const char  * const name;

  TPicture(const TRect& bounds,char *maskstring);
  ~TPicture();
  virtual void handleEvent(TEvent& event);   // override event handling
  virtual Boolean valid(ushort command);
  virtual void *read(ipstream&);
  virtual void write(opstream& os);
  void setData(void *rec);
  static  TStreamable  *build();

protected:

  TPicture(StreamableInit) : TInputLine(streamableInit){}

private:
  virtual int  NextPos(int place,int increment=1);
  virtual void HomePos() {curPos=selStart=selEnd=NextPos(-1);}
  virtual void LastPos() {curPos=selStart=selEnd=NextPos(strlen(mask),-1);}
  virtual Boolean Insert(char c);  // Insert char in Picture
  virtual Boolean RemChar();    //remove char at current cursor Position
  virtual Boolean validChar(char c,char cmask); // check c for picture cmask
  virtual Boolean DelBlock();  // deletes selected characters
  virtual char ConvertChar(char c,char cmask)
    { return (cmask=='&' || cmask=='!')? c=capitalize(c) : c;}
  virtual const char *streamableName() const  {return name;}
};
