/*****************************************************************************

   PROGRAM:    TLTEST - MDI Test Application for TLCLASS.DLL
               (C) Copyright 1992, Lindley Enterprises

   SOURCE:     TLTEST.CPP

   PURPOSE:    

   COMMENTS:

*****************************************************************************/

#include <arrays.h>

#include <owl.h>
#include <mdi.h>
#include <bwcc.h>

#include "tltest.h"

void  CheckPaint( TCellText& sText, void *pParm );
void  FPaint( TCellText& sText, void *pParm );

TMyWindow::TMyWindow( PTMyMDIFrame AParent, LPSTR ATitle )
          :TBWindow( AParent, ATitle ),
           lScreen1( 10, 0, 2 ),
           lScreen2( 10, 0, 2 )
{
   char           szDateString[81];
   PTJulianDate   pJDate;
   PTCellText     pNewWnd;

   pBitmap  = NULL;
   pParent  = AParent;
   pJDate   = new TJulianDate();
   pJDate->GetDateString( szDateString, 80 );
   delete pJDate;

   pCarButton = new TCellButton( 260, 45, ID_CARBUTTON, "NormalBmp", "DisabledBmp" );
   pNrmButton = new TLButton( this, 300, 280, 95, 42, 34, TRUE, "BoxUp", "BoxDown", "BoxUFocus", "BoxDFocus" );
   pNewWnd = new TCellText( 10, 10, 200, 18, "Test Window One" );
   pNewWnd->SetColor( VGA_RED );
   pNewWnd->SetAlignment( SH_LEFT );
   pNewWnd->SetType( SH_INDENT );
   lScreen1.add( pNewWnd );
   pNewWnd = new TCellText( 10, 35, 200, 18, "Test Window Two" );
   pNewWnd->SetColor( VGA_GREEN );
   pNewWnd->SetAlignment( SH_CENTER );
   pNewWnd->SetType( SH_NORMAL );
   lScreen1.add( pNewWnd );
   pNewWnd = new TCellText( 10, 60, 200, 18, "Test Window Three" );
   pNewWnd->SetColor( VGA_BLUE );
   pNewWnd->SetAlignment( SH_RIGHT );
   pNewWnd->SetType( SH_RAISE );
   lScreen1.add( pNewWnd );
   pNewWnd = new TCellText( 10, 85, 50, 18, 25 );
   pNewWnd->SetColor( VGA_MAGENTA );
   pNewWnd->SetAlignment( SH_CENTER );
   pNewWnd->SetType( SH_INDENT );
   pNewWnd->SetMask( "%4d" );
   lScreen1.add( pNewWnd );
   pNewWnd = new TCellText( 70, 85, 100, 18, (float) 355.21 );
   pNewWnd->SetColor( VGA_MAGENTA );
   pNewWnd->SetAlignment( SH_CENTER );
   pNewWnd->SetType( SH_INDENT );
   pNewWnd->SetMask( "%10.3f" );
   lScreen1.add( pNewWnd );
   pNewWnd = new TCellText( 10, 110, 250, 18, szDateString );
   pNewWnd->SetColor( VGA_YELLOW );
   pNewWnd->SetAlignment( SH_CENTER );
   pNewWnd->SetType( SH_INDENT );
   lScreen1.add( pNewWnd );

   pNewWnd = new TCellText( 10, 110, 200, 18, "Test Window One" );
   pNewWnd->SetColor( VGA_RED );
   pNewWnd->SetAlignment( SH_LEFT );
   pNewWnd->SetType( SH_INDENT );
   lScreen2.add( pNewWnd );
   pNewWnd = new TCellText( 10, 85, 200, 18, "Test Window Two" );
   pNewWnd->SetColor( VGA_GREEN );
   pNewWnd->SetAlignment( SH_CENTER );
   pNewWnd->SetType( SH_NORMAL );
   lScreen2.add( pNewWnd );
   pNewWnd = new TCellText( 10, 60, 200, 18, "Test Window Three" );
   pNewWnd->SetColor( VGA_BLUE );
   pNewWnd->SetAlignment( SH_RIGHT );
   pNewWnd->SetType( SH_RAISE );
   lScreen2.add( pNewWnd );
   pNewWnd = new TCellText( 10, 35, 50, 18, 52 );
   pNewWnd->SetColor( VGA_MAGENTA );
   pNewWnd->SetAlignment( SH_CENTER );
   pNewWnd->SetType( SH_INDENT );
   pNewWnd->SetMask( "%04d" );
   lScreen2.add( pNewWnd );
   pNewWnd = new TCellText( 70, 35, 100, 18, (float) 125.53 );
   pNewWnd->SetColor( VGA_MAGENTA );
   pNewWnd->SetAlignment( SH_CENTER );
   pNewWnd->SetType( SH_INDENT );
   pNewWnd->SetMask( "%10.3f" );
   lScreen2.add( pNewWnd );
   pNewWnd = new TCellText( 10, 10, 250, 18, szDateString );
   pNewWnd->SetColor( VGA_YELLOW );
   pNewWnd->SetAlignment( SH_CENTER );
   pNewWnd->SetType( SH_INDENT );
   lScreen2.add( pNewWnd );

   pSBar   = new TSlideBar( this, 10, 135, 300, 25 );
   pActive = &lScreen1;

   Attr.H     = 200;
   Attr.W     = 350;
   Attr.Style = WS_VISIBLE|WS_BORDER|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX;
}

TMyWindow::~TMyWindow()
{
   lScreen1.flush( TShouldDelete::Delete );
   lScreen2.flush( TShouldDelete::Delete );
   delete pSBar;
   delete pCarButton;
   delete pNrmButton;
}

void  TMyWindow::SetupWindow()
{          
   TBWindow::SetupWindow();
}

void  TMyWindow::Paint( HDC hDC, PAINTSTRUCT& sPaint )
{
   pActive->forEach( CheckPaint, (void *) &sPaint );
   if( pCarButton->NeedsPaint( &sPaint.rcPaint ) )
      pCarButton->Paint( sPaint.hdc );
   if( pBitmap )
      pBitmap->Draw( hDC, 305, 135, SRCCOPY );
   TBWindow::Paint( hDC, sPaint );
}

void  TMyWindow::WMLButtonDown( RTMessage Msg )
{
   pCarButton->MouseDown( HWindow, Msg.LP.Lo, Msg.LP.Hi );
}

void  TMyWindow::WMLButtonUp( RTMessage Msg )
{
   pCarButton->MouseUp( HWindow, Msg.LP.Lo, Msg.LP.Hi );
}

void  TMyWindow::WMMouseMove( RTMessage Msg )
{
   pCarButton->MouseMove( HWindow, Msg.LP.Lo, Msg.LP.Hi );
}

void  TMyWindow::ShowBar( RTMessage )
{
   int   iIndex = 0;
   int   iMax;
   int   iInnerLoop;

   pSBar->SetPos(0);
   iMax = pSBar->GetRange();
   while( iIndex++ < iMax )
   {
      iInnerLoop = 0;
      while( iInnerLoop++ < 500 )
         Yield();
      pSBar->IncPos();
   }
}

void  TMyWindow::ShowSwitch( RTMessage )
{
   pActive->forEach( FPaint, (void *) &HWindow );
   if( pActive == &lScreen1 )
      pActive = &lScreen2;
   else
      pActive = &lScreen1;
   pActive->forEach( FPaint, (void *) &HWindow );
}

void  TMyWindow::ToggleButton( RTMessage )
{
   if( pCarButton->IsDisabled() )
      pCarButton->Enable( HWindow );
   else
      pCarButton->Disable( HWindow );
}

void  TMyWindow::CarButton( RTMessage )
{
   pParent->SetStatus( "Car Button Pressed...", TRUE );
}

void  TMyWindow::ShowBitmap( RTMessage )
{
   if( pBitmap == NULL )
      pBitmap = new TBitmap( "SHOWTEST.BMP" );
   else
   {
      delete pBitmap;
      pBitmap = NULL;
   }
   InvalidateRect( HWindow, NULL, TRUE );
}

TMyMDIFrame::TMyMDIFrame( LPSTR ATitle, LPSTR MenuName )
            :TMDIFrame( ATitle, MenuName )
{
   BWCCGetVersion();
   ChildNum = 1;
   pStatus  = new TStatusLine( this );
   pToolBar = new TToolBar( this, TB_TOP, 22, 19, 5, 4, pStatus );
   pToolBar->SetButton( 0, "OneNormal", "OneDisabl", ID_TOOLBAR1 );
   pToolBar->SetButton( 1, "TwoNormal", "OneDisabl", ID_TOOLBAR2 );
   pToolBar->SetButton( 2, "ThreeNorm", "OneDisabl", ID_TOOLBAR3 );
}

TMyMDIFrame::~TMyMDIFrame()
{
   delete pStatus;
}

void  TMyMDIFrame::SetupWindow()
{
   LONG         lStyles;
   PTMDIClient  pMDIClient;

   TMDIFrame::SetupWindow();

   pMDIClient = GetClient();
   lStyles    = GetWindowLong( pMDIClient->HWindow, GWL_STYLE );
   lStyles   |= MDIS_ALLCHILDSTYLES;
   SetWindowLong( pMDIClient->HWindow, GWL_STYLE, lStyles );
}

PTWindowsObject TMyMDIFrame::InitChild()
{
   char szChildName[81];

   wsprintf( szChildName, "TLTest MDI Child %d", ChildNum++ );
   return( new TMyWindow( this, szChildName ) );
}

void  TMyMDIFrame::WMSize( RTMessage sMsg )
{
   TMDIFrame::WMSize( sMsg );

   if( pStatus )
      pStatus->ResizeStatus();
   if( pToolBar )
      pToolBar->ResizeToolBar();
}

void  TMyMDIFrame::DemoBar( RTMessage )
{
   if( ActiveChild )
      PostMessage( ActiveChild->HWindow, WM_SHOWBAR, 0, 0L );
}

void  TMyMDIFrame::DemoSwitch( RTMessage )
{
   if( ActiveChild )
      PostMessage( ActiveChild->HWindow, WM_SWITCH, 0, 0L );
}

void  TMyMDIFrame::ChangeStatus( RTMessage )
{
   PTMyDialog  pDialog;

   if( ActiveChild )
   {
      pDialog = new TMyDialog( this, this );
      if( pDialog )
         GetApplication()->ExecDialog( pDialog );
   }
   else
      MessageBeep( IDABORT );
}

void  TMyMDIFrame::SetStatus( LPSTR lpText, BOOL bDelete )
{
   if( pStatus )
      pStatus->SetText( lpText, bDelete );
}

void  TMyMDIFrame::ToolBar1( RTMessage )
{
   SetStatus( "ToolBar Item 1 Pushed...", TRUE );
}

void  TMyMDIFrame::ToolBar2( RTMessage )
{
   SetStatus( "ToolBar Item 2 Pushed...", TRUE );
}

void  TMyMDIFrame::ToolBar3( RTMessage )
{
   SetStatus( "ToolBar Item 3 Pushed...", TRUE );
}

void TMDIApp::InitMainWindow()
{
   MainWindow = new TMyMDIFrame( "TLCLASS MDI Test App", "MDIMenu" );
}

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmd, int nCmdShow )
{
   TMDIApp MDIApp( "MDIApp", hInstance, hPrevInstance, lpCmd, nCmdShow );
   MDIApp.Run();
   return( MDIApp.Status );
}

void  CheckPaint( TCellText& sText, void *pParm )
{
   LPPAINTSTRUCT  lpPaint;

   lpPaint = (LPPAINTSTRUCT) pParm;
   if( sText.NeedsPaint( &lpPaint->rcPaint ) )
      sText.Paint( lpPaint->hdc );
}

void  FPaint( TCellText& sText, void *pParm )
{
   HWND  *pHWnd;

   pHWnd = (HWND *) pParm;
   sText.ForcePaint( *pHWnd );
}

TMyDialog::TMyDialog( PTWindowsObject AParent, PTMyMDIFrame pMyParent )
          :TDialog( AParent, "StatDialog" )
{
   pParent   = pMyParent;
   pGroup    = new TBGroupBox( this, ID_GRPBOX );
   pEditText = new TEdit( this, ID_STATTEXT, 40 );
   pCheckBox = new TBCheckBox( this, ID_TIMED, pGroup );
}

TMyDialog::~TMyDialog()
{
   delete pEditText;
   delete pCheckBox;
   delete pGroup;
}

void TMyDialog::SetupWindow()
{
   TDialog::SetupWindow();
   pCheckBox->Check();
}

void TMyDialog::Ok( RTMessage Msg )
{
   BOOL  bDelete = FALSE;
   char  szEnteredText[81];

   szEnteredText[0] = '\0';
   pEditText->GetText( szEnteredText, 80 );
   if( pCheckBox->GetCheck() )
      bDelete = TRUE;
   pParent->SetStatus( szEnteredText, bDelete );
   
   TDialog::Ok( Msg );
}
