/*--------------------------------------------------------------------------*
 *
 *  Placed in Public Domain By Damir Nadramija.
 *
 *  Module:         TOOLS.H
 *  Purpose:        Defines, macros, prototypes for TOOLS.C
 *                                                                            
 *  Created by:     Damir Nadramija 
 *  Date:           February 3, 1990
 *--------------------------------------------------------------------------*/
#include <stdarg.h>

#define TRUE    1
#define FALSE   0
 
#define TEXT_COLOR      WHITE + (BLUE << 4)
#define ERROR_COLOR     YELLOW + (RED << 4) + BLINK
#define WARNING_COLOR   YELLOW + (BROWN << 4)
#define DIALOG_COLOR    YELLOW + (BLUE << 4)
#define BLANK_COLOR     BLACK
#define TITLE_COLOR     WHITE + (RED << 4)
#define HIGHLIGHT_COLOR RED + (WHITE << 4)
#define SHADOW_COLOR    DARKGRAY + (BLACK << 4)
#define COMMA 0X20

#define XF    0x100
#define ALT_E 18|XF
#define ALT_W 17|XF
#define ALT_S 31|XF
#define ALT_C 46|XF
#define ALT_D 32|XF
#define ALT_I 23|XF

#define RUBOUT            8
#define BS                8
#define FORM_FEED        12
#define CR               13
#define ESC              27
#define SPACE            32
#define NEW_LINE         10
#define HOME_KEY        327
#define END_KEY         335
#define UP_KEY          328
#define DOWN_KEY        336
#define PG_UP_KEY       329
#define PG_DN_KEY       337
#define LEFT_KEY        331
#define RIGHT_KEY       333
#define INS_KEY         338
#define DEL_KEY         339
#define CTRL_X_KEY      301
#define CTRL_LEFT_KEY   371
#define CTRL_RIGHT_KEY  372

#define F1              315
#define F2              316
#define F3              317
#define F4              318
#define F5              319
#define F6              320
#define F7              321
#define F8              322
#define F9              323
#define F10             324

#define NO_CURSOR           0x2000
#define MONO_SHORT_CURSOR   0x0A0C
#define MONO_TALL_CURSOR    0x090C
#define CGA_SHORT_CURSOR    0x0607
#define CGA_TALL_CUROSR     0x0507

#define SCREEN_ROWS     25
#define SCREEN_COLUMNS  80
#define PUT_MESSAGE      1
#define CLEAR_MESSAGE    0
#define LINE_LEN        80
#define MAX_LINE_LEN   256
#define INVALID_INDEX   -1
#define NAME_LEN        32

typedef void     *NearPtr;
typedef void far *FarPtr;
typedef unsigned char far *BytePtr;
typedef unsigned char byte;
typedef unsigned int  word;
typedef unsigned long dword;
typedef double   real;
typedef char     *string;


typedef struct
{
    char Buffer[SCREEN_ROWS][SCREEN_COLUMNS * 2];

} WindowBuffer;

typedef struct
{
    int x1, y1, x2, y2;
    int FrameType, FgBgColor;
    int Saved, Active, Inverted, Flashing;
    WindowBuffer ScreenBuffer;

} MessageWindow;

typedef struct
{
    int MessageCode;
    char MessageText[40];
    int Flashing, AlarmCode, Disposition;

} MessageData;


/* Globals and externs  */

extern MessageWindow Message;

/* Bit Macros */
#define BitOn(value, bitindex)          (value & (1 << bitindex))
#define BitOff(value, bitindex)         (!BitOn(value, bitindex))
#define SetBitOn(value, bitindex)       (value |=  (1 << bitindex))
#define SetBitOff(value, bitindex)      (value &= ~(1 << bitindex))
#define IsBitOn(value, bit)             (BitOn(value, bit) ? 1: 0)
#define PackByte(mshalfb, lshalfb)      ((mshalfb << 4) + lshalfb)
#define MSHalfByte(value)               (value >> 4) /* Most  significant 4 bits */
#define LSHalfByte(value)               (value & 0xF /* Least significant 4 bits */
#define PackWord(msb, lsb)              ((msb << 8) + (lsb&0xFF))
#define MSByte(value)                   (value >> 8)  /* Most significant byte   */
#define LSByte(value)                   (value & 0xFF)/* Least significant byte  */
#define PackDWord(msw, lsw)             ((msw << 16) + lsw)
#define MSWord(value)                   (value >> 16)   /* Most significant word */
#define LSWord(value)                   (value & 0xFFFF)/* Least significant word*/

/* Function prototypes  */

int     GetKey(void);
int     keyhit(void);
void    CursorOn(void);
void    CursorOff(void);
word    GetCursor(void);
void    InitCursor(void);
int     InvertColor(int attr);
string  ltrim(string instring);
string  rtrim(string instring);
string  leftpad(string s, int fl);
int     DialogBoxMgr(int action);
void    ChangeCursor(int insmode);
string  rightpad(string s, int fl);
int     instr(string instring, int c);
void    SetCursor(unsigned int shape);
void    BlankString(string String, int Len);
int     IsBlank(string  str, string filterout);
void    Putc(char ch, char attr, int x, int y);
void    Cputs(char *ch, char attr, int x, int y);
string  LeftTrim(string instring, string filter);
string  RightTrim(string instring,  string filter);
void    WritePrompt(int row, int col,  string prompt);
void    MessageBox(int whattodo, va_list arg_list, ...);
void    BoxDraw(int x1, int y1, int x2, int y2, int frame, byte shadow);
void    WriteXY(int col, int row, int color, int width, va_list arg_list, ...);
int     GetString(int row, int col, int attr, string s, string filter, int size);
void    PaintBox(int x1, int y1, int x2, int y2, int frm, byte shade, byte atr, char *t);




