/*--------------------------------------------------------------------------
 *
 *  Placed in Public Domain By Damir Nadramija.
 *
 *  Module:         CLOCKINT.C 
 *  Purpose:        Clock hardware interrupt service routine used as a driver
 *                  for the "Small Multi Threader" project              
 *                                                                            
 *  Created by:     Damir Nadramija 
 *  Date:           September 17, 1991
 *--------------------------------------------------------------------------*/
#define TIME_INTERRUPT_H              /* Say everybody that we are included */

/* Defines and macros */
#define MAX_TICK_TIME 0x7FFFFFFFl

#ifndef DEBUGGING

    #define TIMER                  0x1c
    #define CLOCK                  0x08 
    #define TIMER_RESOLUTION       1193181.667
    #define INTERRUPT_CONTROLLER   (word) 0x0020
    #define CLOCK_CONTROL_WORD     (word) 0x0043
    #define CLOCK_COUNTER_0        (word) 0x0040
    #define CLOCK_COUNTER_1        (word) 0x0041
    #define CLOCK_COUNTER_2        (word) 0x0042
    #define SET_CLOCK_COUNTER_0_CW (word) 0x0036        
    #define END_OF_INTERRUPT       (byte) 0x20  
    #define DOS_CLOCK_RATE         (byte) 0
    #define HMI_CLOCK_RATE         (byte) 55
    #define HMI_COUNT_DOWN         (byte) 100   /* Timer interrupts per tick */
    #define SET_DOS_CLOCK_LSB      (byte) 0x00     
    #define SET_DOS_CLOCK_MSB      (byte) 0x00
    #define SET_HMI_CLOCK_LSB      (byte) 0xA7     
    #define SET_HMI_CLOCK_MSB      (byte) 0x04

#else

    #define CLOCK                  0x1c
    #define TIMER_RESOLUTION       1193181.667
    #define INTERRUPT_CONTROLLER   (word) 0x0020
    #define CLOCK_CONTROL_WORD     (word) 0x0043
    #define CLOCK_COUNTER_0        (word) 0x0040
    #define CLOCK_COUNTER_1        (word) 0x0041
    #define CLOCK_COUNTER_2        (word) 0x0042
    #define SET_CLOCK_COUNTER_0_CW (word) 0x0036        
    #define END_OF_INTERRUPT       (byte) 0x20  
    #define DOS_CLOCK_RATE         (byte) 0
    #define HMI_CLOCK_RATE         (byte) 1
    #define HMI_COUNT_DOWN         (byte) 100   /* Timer interrupts per tick */
    #define SET_DOS_CLOCK_LSB      (byte) 0x00     
    #define SET_DOS_CLOCK_MSB      (byte) 0x00
    #define SET_HMI_CLOCK_LSB      (byte) 0x00     
    #define SET_HMI_CLOCK_MSB      (byte) 0x00

#endif

#define ZERODIV 0x00
#define KEYBD   0x09
#define CLOCK   0x08 
#define COM2    0x0B
#define COM1    0x0C
#define DISK    0x13
#define VIDEO   0x10
#define INT28   0x28
#define CRIT    0x24
#define CTRLC   0x23
#define BREAK   0x1B

#define MAX_TASKS           32
#define INVALID_TASK_INDEX  -1
#define STACK_SIZE         512
typedef struct
{
    word  TickTime;
    word  MiliSecs;
    dword DOSTicks;
    dword Ticks;
    dword Seconds;

}   Time;     

typedef enum {  BACKGROUND_TASK,
                FOREGROUND_TASK,
                INITIAL_TASK,
                ETERNAL_TASK } TaskEnum;


typedef enum {  MIN_PRIORITY,
                LOW_PRIORITY,
                MEDIUM_PRIORITY,
                HIGH_PRIORITY,
                MAX_PRIORITY,
                NUM_PRIORITIES} PriorityEnum;

typedef void (*TaskFunc)(void);

typedef struct TASK_STRUCT
{
    int   TaskID;
    int   TaskIndex;
    int   TaskPriority;
    int   TaskClass;
    int   Active;
    int   KillTask;
    int   SuspendTask;

    char  LocStack[STACK_SIZE];
    char *ExtStack;
    word  TaskSS;
    word  TaskSP;
    word  TaskTimer;

    dword  SleepTimer;

    TaskFunc FunPtr;

    struct TASK_STRUCT *Next, *Prev;

} TaskData;

/* Declarations of externs */
extern int  CurrTaskIndex; 
extern int  NumberOfTasks;  
extern int  Semafore;    
extern int  FastClock;
extern Time Timer;

/* Function prototypes */
long ReadTimer(void);
void SetUpSystem(void);
void SetNewTimer(void);
void SetOldTimer(void);
void InitGlobals(void);
void RestoreTimer(void);
int  LastTaskIndex(void);
void RestoreSystem(void);
int  SetInitialTask(void);
void InitializeTimer(void);
void SuspendAllTasks(void);
void UnSuspendAllTasks(void);
void KillTask(int taskindex);
void InitializeCounters(void);
void InitializeTaskQueue(void);
void SuspendTask(int taskindex);
int  IsTaskSuspended(int index);
int  IsTaskToBeKilled(int index);
int  GetTaskTimer(int taskindex);
int  IsTaskActive(int taskindex);
void UnSuspendTask(int taskindex);
long GetTaskSleepTimer(int index);
void SetTaskSleep(int index, dword sleep);
int  ActivateTask(TaskFunc Fn, char *Stack, int Priority);




