// Copyright (c) 1992
// Dennis M. Carleton
// May be distributed freely but not used for profit
//
// Description: definitions for the 'typedList' template
//

#ifndef _LIST_H_
#define	_LIST_H_

//
// includes
//

#include "boolean.h"

//
// generic class listMember
//

template <class R> class listMember
{
public:
    R			*element;
    listMember<R>	*next;
    listMember<R>	*previous;
};

//
// generic class typedList
//

template <class T> class typedList
{
private:
    listMember<T>	*first;
    listMember<T>	*current;
public:
			typedList();
			~typedList();
    void		append(T* newMember);
    void		clear();
    void 		reset();
    T*			operator++();
    T*			getCurrent();
    T*			removeCurrent();
};



//
// typedList methods
//

//
// Function:	 typedList
// Abstract:	 constructor - initializes the structure
// Parameters:	 none
// Return Value: none
//

template <class T> typedList<T>::typedList()
			   : first(NULL), current(NULL)
{
};



//
// Function:	 ~typedList
// Abstract:	 destructor - removes the elements in the list, 
//			destroys the listMember nodes
// Parameters:	 none
// Return Value: none
//

template <class T> typedList<T>::~typedList()
{
 clear();
};


//
// Function:	 append
// Abstract:	 adds an element to the list
// Parameters:	 T* - a pointer to the element of type "T" to be appended
// Return Value: none
//

template <class T> void typedList<T>::append(T* newMember)
{
listMember<T> 	*newNode = new listMember<T>,
		*tempNode = first;

 newNode->element = newMember;
 if (!first)
    {
     first  = newNode;
     first->next = first;
     first->previous = first;
    }
 else    
    {
     while (tempNode->next != first)
	tempNode = tempNode->next;
     tempNode->next = newNode;
     newNode->next = first;
     first->previous = newNode;
     newNode->previous = tempNode;
    };
};


//
// Function:	 clear
// Abstract:	 deletes all of the elements in the list
// Parameters:	 none
// Return Value: none
//

template <class T> void typedList<T>::clear()
{
 if (first)
    {
     first->previous->next = NULL;
     while(first)
	{
         current = first;
	 first = first->next;
	 delete current->element;
 	 delete current;
	};
    };

 first = NULL;
 current = NULL;
};


//
// Function:	 reset
// Abstract:	 resets the current pointer to NULL, s.t. a call to operator++
//		 will result in the first element of the list being returned
// Parameters: 	 none
// Return Value: none
//

template <class T> void typedList<T>::reset()
{
 current = NULL;
};


//
// Function:	 operator++
// Abstract:	 returns a pointer to the next element in the list
// Parameters:	 none
// Return Value: T* - a pointer to the next element in the list
//

template <class T> T* typedList<T>::operator++()
{
 if (!current)
    {
     current = first;
    }
 else
    {
     current = current->next;
     if (current == first)
	current = NULL;
    };

 if (current)
    return current->element;
 return NULL;
};


//
// Function:	 getCurrent
// Abstract:	 returns a pointer to the current item
// Parameters:	 none
// Return Value: T* - a pointer to the current item
//

template <class T> T* typedList<T>::getCurrent()
{
 if (current)
     return current->element;
 return NULL;
};


//
// Function:	 removeCurrent
// Abstract:	 removes the current element in the list
// Parameters:	 none
// Return Value: T* - returns a pointer to the current item, so that the
//		 caller can delete the element
//

template <class T> T* typedList<T>::removeCurrent()
{
listMember<T>	*tempNode = current;
T		*tempElement = current->element;

 if (current)
    {
     if (current->next == current)
	{
	 current = NULL;
	 first = NULL;
        }
     else
	{
	 current->previous->next = current->next;
         current->next->previous = current->previous;
         current = current->next;
         if (current == first)
 	     current = NULL; 
         if (tempNode == first)
 	     first = first->next;
	};

     delete tempNode;
     return tempElement;
    };
 return NULL;
};

#endif

// end list.h

