// Generic list class using templates
//
// written by Tommy Hui @ Borland International
// (C)opyright June 1st, 1992
//
#include <iostream.h>


// Standard template definition.
// The following is the list of node pointers that will actually contain
// the elements and the list.
template <class T>
class nodePTR {
public:
	// data members
	T node;
	class nodePTR<T> *next;

	// member functions
	nodePTR(T elem) {
		cout << "constructing " << elem << endl;
		next = NULL;
		node = elem;
		// copy the element. Notice that this will not work with character
		// strings, as the copy operator must be overloaded to give nodePTR
		// its own copy. If the behaviour you want is that nodePTR to have
		// control over your string, then leave as is.
	}
	~nodePTR() {
		cout << "destroying " << node << endl;
	}
	void show()	{ cout << node << " "; }
	// function to show itself onto the stream. For all built-in types,
	// this will work. However, another function must be written to allow
	// streams to work with classes. See the function after MyClass
	// definition for an example.
};


// Template class wrapper.
// This class is used to manipulate the list.
template <class T>
class List {
	nodePTR<T> *head;   // notice head is pointer to class nodePTR of type T
public:
	List() { head = NULL; }
	void add(T elem);		// add an element to the end of the linked list
	void showList(void);	// display the entire list
	~List();
	// destroy all objects in the order of adding (from head to tail).
};

template <class T>
void List<T>::showList(void)
{
	nodePTR<T> *chase = head;	// go from head to tail
	while (chase != NULL) {
		chase->show();			// display the entire list by telling
								// each node to display itself
		chase = chase->next;
	}
	cout << endl;
}

template <class T>
void List<T>::add(T elem)
{
	nodePTR<T> *chase = head;

	if (chase==NULL) {			// see if there are no nodes
		head = new nodePTR<T>(elem);	// change the head
		return;
	}
	while (chase->next != NULL)			// else find the tail
		chase = chase->next;
	chase->next = new nodePTR<T>(elem); // add at the end
	return;
}

template <class T>
void List<T>::~List()
{
	nodePTR<T> *temp, *chase = head;

	if (head != NULL)			// check to see if there's only one node
		chase = head->next;
	delete head;				// delete the first node
	while (chase!=NULL) {
		temp = chase->next;
		delete chase;			// delete all the other nodes by
		chase = temp;			// traversing the list
	}
}


// dummy class to demonstrate list of MyClass
class MyClass {
public:
	int x, y;
	MyClass(int n=0, int m=0) :
		x(n), y(m)	{}	// same as saying x = n, y = m;
	~MyClass()		{}
};


// overload the stream operator << to accept MyClass
ostream& operator << (ostream &os, MyClass &temp)
{
	return os << "(" << temp.x << "," << temp.y << ")";
}

void main()
{
	List<int> a;
	List<double> b;
	List<MyClass> c;
	MyClass *mc;
	int i,j;

	a.add(3); a.add(4); a.add(1);
	a.showList();
	b.add(72.5); b.add(82.7); b.add(1.3);
	b.showList();
	for (i=0, j=0; i<7; i++, j+=3) {
		mc = new MyClass(i,j);
		c.add(*mc);
		delete mc;
	}
	c.showList();
}
