#ifndef __TCUST_H
#define __TCUST_H

#define WM_GAUGE_RANGE		WM_USER+1
#define WM_GAUGE_INC 		WM_USER+2
#define WM_GAUGE_DEC 		WM_USER+3
#define WM_GAUGE_SET 		WM_USER+4

#include <owl\control.h>

class TCustomFontLibrary
{
	public:
	HINSTANCE custInst;

	TCustomFontLibrary()
	{
		custInst = LoadLibrary("TCUST.DLL");
	};
	~TCustomFontLibrary()
	{
		if (custInst)
			FreeLibrary(custInst);
	};
};

class TCustomFont : public TControl
{
	public:
	TCustomFont(TWindow* parent, int resourceId, TModule* module = 0) :
		TControl(parent,resourceId,module)
	{
	};
};

class TCustomGaugeFont : public TControl
{
	public:
	// construct, range 0 to 100
	TCustomGaugeFont(TWindow* parent, int resourceId, TModule* module = 0) :
		TControl(parent,resourceId,module)
	{
	};

	inline char far* GetClassName() {return "GAUGEFONT";};


	inline void SetRange(int low, int high)
	{
		SendMessage(WM_GAUGE_RANGE,0,MAKELPARAM(low,high));
	};

	// Set abs pos (0 - 100)
	inline void Set(int pos)
	{
		SendMessage(WM_GAUGE_SET,pos);
	};

	// Increment by 1
	inline void Inc()
	{
		SendMessage(WM_GAUGE_INC);
	};

	// Decrement by 1
	inline void Dec()
	{
		SendMessage(WM_GAUGE_DEC);
	};
};


#endif