/*  strcatm() demo
 This program demonstrates using variable length parameters.  I wrote
this because I didn't want the overhead of sprintf() or the clutter of
multiple lines of strcat().  This was written using QuickC 2.0 so it
may need a little re-writing to work on a different compiler.

Note:  I also avoid using printf() in most programs because it adds
2-5 k to a program, depending on the implementation.  puts() isn't
always implemented real efficiently either, so if you are trying to
write small, efficient programs and you only are using printf() and
sprintf() occasionally, substitute more efficient routines.

strcatm() stands for strcat multiple, in case you hadn't guessed.

                 Larry Dresser     7/17/1990

*/

#include <stdio.h>
#include <stdarg.h>

void cdecl main(int argc,char *argv[]);
void cdecl strcatm(char *string,...);

void cdecl main(int argc,char *argv[])
{
  char s[100] = {"hello"};

  strcatm(s," world"," what's", " happening?",NULL);

  puts(s);
}

void cdecl strcatm(char *string,...)
/* strcatm("hello"," world",NULL)  */
{
  va_list marker;
  char *sp;

  va_start(marker,string);

  do
  {
     sp = va_arg(marker,char *);
     if (sp != NULL)
        strcat(string,sp);

  } while (sp != NULL);

  va_end(marker);

}

