//_____________________________________________________________________
//(c)StatBarPlus+, all rights reserved 1993 - 1994
//Continuum Software
//1379 Towne Harbor Trail
//Woodstock, GA 30188
//_____________________________________________________________________
#ifndef __STATBAR_HPP
#define __STATBAR_HPP
//'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
// FileName: 	Statbar.hpp
// Author:	Alan D. Stokes
// Date:	Oct. 6th 1993
// Company:	Continuum Software Systems
// Description: This file containes the class definitions for
//		the zStatusBar and zStatusItem classes.

#ifndef _ZAPPZAPP_INCLUDED
#include "zapp.hpp"
#endif
#ifndef __STATITEM_HPP
#include "statitem.hpp"
#endif

declDlist(zStatusItem);
//
// Status Bar Class
//
// Created: ADS 10/6/93
// Updated: ADS 10/15/93
//
//
class zStatusBar : public zPane
{
public:
	zStatusBar(zWindow *pAParent,
			zGravSizer *pBarSz,
			const zColor& zBColor,
			Style iFrameStyle);
	virtual ~zStatusBar(void);
	void setBarHeight(unsigned int ht);
	void setText(const zString& sAText);
	void setTextColor(const zColor& zBColor);
	void setTextFont(zFont* pFont);
	void setTextJustify(Align iJustify);
	zStatusItem* item(unsigned long int lID);
	zStatusItem* addItem(zStatusItem* pItem);
	void insertItem(zStatusItem* pItem, unsigned int iPos);
	void deleteItem(unsigned long int lID);
	void deleteItem(zStatusItem* pItem);


protected:
	zStatusItemDlist StatusItems;
	zFont  *pBarFont;		//Font to use for status bar
	zBrush *pButtonBrush;		//Brush for painting background
	zBrush *pBarBrush;		//Brush for painting background
	zPen   *pShadowPen;		//Pen for painting background
	zColor BarTextColor;		//Text color
	zColor BarBackColor;		//Background color
	Align  iBarJustify;		//Text Alignment
	Style  iBarFrame;		//Frame style 
	zString sText;			//Text to be displayed

       	virtual void displayText(zDisplay *pDc, zString& sAText);
	virtual int draw(zDrawEvt* Ev);
	virtual int size(zSizeEvt* Sv);
private:
};
//___________________________________________________________________________

inline void zStatusBar::setTextColor(const zColor& zColor)
{
	BarTextColor = zColor;
}
inline void zStatusBar::setTextJustify(Align iJustify)
{
	iBarJustify = iJustify;
}

#endif



