
#include <windows.h>
#include <string.h>

HWND   main_hwnd;
HBRUSH white_brush;
static char program_name[] = "Statusbar Demo";

extern HINSTANCE _hInstance; /* compiler startup code creates these */
extern HINSTANCE _hPrev;


#pragma argsused
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT message,
                                 WPARAM wParam, LPARAM lParam)
  {
  int           old_bk_mode;
  char         *status;
  PAINTSTRUCT   ps;
  COLORREF      old_txt_color;
  HDC           hdc;
  HPEN          old_pen;
  HFONT         old_font;
  static int    text_y;
  static HFONT  stat_font;
  static HBRUSH lgray_brush;
  static HPEN   dgray_pen;
  static HPEN   white_pen;
  static RECT   stat_rect;
  static short  click_pos = 4;
  static char   prompt[] = "Click on the client window to change status";
  static char  *messages[] =
    { "Upper Left", "Upper Right",
      "Lower Left", "Lower Right", "No Clicks" };

  switch (message)
    {
    case WM_CREATE :
      {
      stat_font = (HFONT) GetStockObject(ANSI_VAR_FONT);
      lgray_brush = CreateSolidBrush(RGB(192, 192, 192));
      white_pen = (HPEN) GetStockObject(WHITE_PEN);
      dgray_pen = (HPEN) CreatePen(PS_SOLID, 1, RGB(127, 127, 127));
      }  // fall through to WM_SIZE code
    case WM_SIZE :
      {   /* get sizes, compute status bar location */
      hdc = GetDC(hwnd);
      old_font = SelectObject(hdc, stat_font);
      text_y = (int) HIWORD(GetTextExtent(hdc, "W", 1));
      SelectObject(hdc, old_font);
      ReleaseDC(hwnd, hdc);
      GetClientRect(hwnd, &stat_rect);
      stat_rect.top = stat_rect.bottom - 7 - text_y;
      text_y = stat_rect.top + 4;
      ++stat_rect.bottom;
      ++stat_rect.right;
      return 0;
      }

    case WM_PAINT :
      {
      hdc = BeginPaint(hwnd, &ps);
      FillRect(hdc, &stat_rect, lgray_brush);  // gray out status bar area
      MoveTo(hdc, 0, stat_rect.top - 1);       // draw black line at top
      LineTo(hdc, stat_rect.right - 1, stat_rect.top - 1);

      old_pen = SelectObject(hdc, white_pen);    // draw the indenting lines
      SelectObject(hdc, white_pen);
      MoveTo(hdc, stat_rect.right - 11, stat_rect.top + 2);
      LineTo(hdc, stat_rect.right - 11, stat_rect.bottom - 4);
      LineTo(hdc, stat_rect.left + 10, stat_rect.bottom - 4);

      SelectObject(hdc, dgray_pen);
      LineTo(hdc, stat_rect.left + 10, stat_rect.top + 2);
      LineTo(hdc, stat_rect.right - 11, stat_rect.top + 2);

      old_font = SelectObject(hdc, stat_font); // write message in gray
      old_bk_mode = SetBkMode(hdc, TRANSPARENT);
      old_txt_color = SetTextColor(hdc, RGB(63, 63, 63));
      status = messages[click_pos];
      TextOut(hdc, stat_rect.left + 15, text_y, status, strlen(status));

      SetTextColor(hdc, old_txt_color);         // write prompt
      SelectObject(hdc, old_font);
      SelectObject(hdc, old_pen);
      TextOut(hdc, 1, 1, prompt,sizeof(prompt) - 1);
      SetBkMode(hdc, old_bk_mode);
      EndPaint(hwnd, &ps);
      return 0;
      }

    case WM_LBUTTONDOWN : // decide which status bar message to use 
      {
      if (LOWORD(lParam) >= (stat_rect.right / 2))
        click_pos |= 1;
      else
        click_pos &= 2;

      if (HIWORD(lParam) >= (stat_rect.top / 2))
        click_pos |= 2;
      else
        click_pos &= 1;

      click_pos &= 3;
      InvalidateRect(hwnd, &stat_rect, TRUE); // force status bar repaint
      UpdateWindow(hwnd);
      return 0;
      }

    case WM_CLOSE : // only need to delete non-stock objects 
      DeleteObject(lgray_brush);
      DeleteObject(dgray_pen);
      PostQuitMessage(0);
      break;

    default :
      break;
    }

  return DefWindowProc(hwnd, message, wParam, lParam);
  }


static BOOL PASCAL initialize(void)
  {
  WNDCLASS wclass;

  if (!_hPrev)
    {
    wclass.style = CS_HREDRAW | CS_VREDRAW;
    wclass.lpfnWndProc = WndProc;
    wclass.hInstance = _hInstance;
    wclass.hbrBackground = white_brush = (HBRUSH) GetStockObject(WHITE_BRUSH);
    wclass.lpszMenuName = NULL;
    wclass.lpszClassName = program_name;
    wclass.hIcon = LoadIcon(_hInstance, MAKEINTRESOURCE(IDI_APPLICATION));
    wclass.hCursor = LoadCursor(NULL, IDC_ARROW);
    wclass.cbClsExtra = wclass.cbWndExtra = 0;

    if (!RegisterClass(&wclass))
      return FALSE;
    }

  main_hwnd = CreateWindow(
    program_name, program_name, WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
    CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
    NULL, NULL, _hInstance, NULL);
  return(main_hwnd != NULL);
  }


#pragma argsused
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine,  int nCmdShow)
  {
  MSG msg;

  if (!initialize())
    return 0;

  ShowWindow(main_hwnd, nCmdShow);
  UpdateWindow(main_hwnd);

  while (GetMessage(&msg, NULL, 0, 0))
    {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
    }

  return msg.wParam;
  }

