#ifndef _CSLIDER_H_
#define _CSLIDER_H_

/***************************************************************

   Copyright 1993-95  Northeast Data Corp.  All Rights Reserved

****************************************************************/

/***************************************************************


   CSlider.h

   Class definition for MFC applications that use the slider.
   Version 3.0, November 1994, Wade Cobb & Paul King

   CONSTRUCTORS			Never create a CSLider directly.  Always create CVSlider
   						ot CHSlider (Horizontal or Vertical).

   FUNCTIONS:			Create is called after the object is constructed and 
   						the parent is known.  The function returns a BOOL.  
   						You must enter a unique ID for the control.  The 
						range for the slider is set through sMin and sMax.  The
						current position is set through sPos.

						IsValid can be called after the constructor is invoked to
						verify that the Slide32.dll was loaded correctly.  The
						DLL MUST reside in the same directory as the EXE.

			     		MoveWindow can be called to Move the Window.

						GetWindowRect returns the slider window rect in screen
						coordinates.

						The remaining Get/Set and Is functions are all used 
						in the view object.  Those wishing for more 
						information on their use should consult the source 
						code for the view.

****************************************************************/

   //Control-specific messages
   //CONTROL_BASE is needed to avoid confilcts with Window '95
#define CONTROL_BASE			(WM_USER + 100)
#define SCM_SETRANGE 			(CONTROL_BASE + 1)
#define SCM_GETRANGE           	(CONTROL_BASE + 2)
#define SCM_GETPOS             	(CONTROL_BASE + 3)
#define SCM_SETPOS             	(CONTROL_BASE + 4)
#define SCM_SETWIDTH           	(CONTROL_BASE + 5)
#define SCM_SETBITMAP          	(CONTROL_BASE + 6)
#define SCM_SETBEVELSTYLE      	(CONTROL_BASE + 7)
#define SCM_SETTICKSTYLE       	(CONTROL_BASE + 8)
#define SCM_CHANGEDIRECTION		(CONTROL_BASE + 9)

   // Bitmaps specified in wParam for SCM_SETBITMAP message
#define SCB_THUMB             	0
#define SCB_THUMBFOCUS        	1
#define SCB_BEZEL             	2

   // Tick styles (used in wParam for SCM_SETTICKSTYLE message)
#define SCTICK_NORMAL         	0
#define SCTICK_INSET          	1
#define SCTICK_RAISED         	2

   // Which bevel to turn on in the SCM_SETBEVELSTYLE message AND
   //  which width to set the the SCM_SETWIDTH message
#define SCBEVEL_INNER         	0
#define SCBEVEL_OUTER         	1
#define SCBORDER              	3

   // Border and bevel styles specified in lParam for SCM_SETBEVELSTYLE 
   //  message
#define SCS_NONE              	0
#define SCS_INSET             	1
#define SCS_RAISED            	2
#define SCS_FRAME             	3

   //Notification codes sent via WM_COMMAND from the control
#define SCN_RANGECHANGE     	1
#define SCN_THUMBUP         	2

   //Control specific styles specified in SetWindowStyle
#define SCS_VERTICAL        0x0001L
#define SCS_HORIZONTAL      0x0002L
#define SCS_TEXTHASRANGE    0x0008L
#define SCS_INVERTRANGE     0x0010L
#define SCS_LEFTTICKS       0x0020L
#define SCS_TOPTICKS        0x0020L
#define SCS_RIGHTTICKS      0x0040L
#define SCS_BOTTOMTICKS     0x0040L
#define SCS_TABSTOP         0x0080L

class CSlider
{
public:
	virtual				~CSlider();

			BOOL		Create(CWnd *pParent, UINT uiID, short sMin, short sMax,
							short sPos);
			BOOL		IsValid();
			void		MoveWindow(int nX, int nY, int nWidth,
							int nHeight, BOOL bRepaint = TRUE);
			void		MoveWindow(LPRECT pRect, BOOL bRepaint = TRUE);
			void		GetWindowRect(LPRECT pRect);

			short		GetPos();
			short		SetPos(short sPos);

			long		GetRange();
			long		SetRange(long lRange);

			void		SetDirection(BOOL bReverse);
			BOOL		GetDirection();

			void		SetInnerBevelStyle(int nStyle);
			int			GetInnerBevelStyle();

			void		SetOuterBevelStyle(int nStyle);
			int			GetOuterBevelStyle();

			void		SetTickStyle(int nStyle);
			int			GetTickStyle();

			void		SetBorderWidth(int nWidth);
			void		SetInnerBevelWidth(int nWidth);
			void		SetOuterBevelWidth(int nWidth);

			void		SetThumbBitmap(UINT uiID);
			BOOL		IsThumbBitmapSet();

			void		SetBackBitmap(UINT uiID);
			BOOL		IsBackBitmapSet();

			void		SetFocusBitmap(UINT uiID);
			BOOL		IsFocusBitmapSet();

protected:
						//Never create a CSlider directly
						CSlider(int nX, int nY, int nWidth, int nHeight,
							DWORD dwType);
	static	HINSTANCE	m_hDLL;
	static	long		m_uiRefCount;
			int			m_nX;
			int			m_nY;
			int			m_nWidth;
			int			m_nHeight;
			DWORD		m_dwStyle;
			HWND		m_hWnd;
			BOOL		m_bValid;
			BOOL		m_bDirection;
			int			m_nInnerBevelStyle;
			int			m_nOuterBevelStyle;
			int			m_nTickStyle;
			CBitmap		*m_pcbmpThumb;
			CBitmap		*m_pcbmpBack;
			CBitmap		*m_pcbmpFocus;
private:
						CSlider() {;};
};					  

#endif
