// File ooset.cpp
// Source file for class set

#	if !defined( __OOSET_H )
#		include "ooset.h"
#	endif

// Empty set constructor
set::set()
{
	min = MINIMUM;
	max = MAXIMUM;
	len = max - min + 1;

	if( len <= 0 )
		ptr = NULL;

	else
	{
		if( ! ( ptr = new char[ len ] ) )
		{
			cerr << "\nMemory allocation failure. Program terminated";
			exit(1);
		}
		memset( ptr, FALSE, len );
	}
}

// Singleton set constructor
set::set( int num )
{
	min = MINIMUM;
	max = MAXIMUM;
	len = max - min + 1;

	if( ( num < min ) || ( num > max ) )				//Check range
		ptr = NULL;

	else
	{
		if( ! ( ptr = new char[ len ] ) )
		{
			cerr << "\nMemory allocation failure. Program terminated";
			exit(1);
		}

		memset( ptr, FALSE, len );
		ptr[ num - min ] = TRUE ;						//Set "bit"
	}
}


// Assignment
set& set::operator= ( const set& set_two )
{
	if ( this == &set_two )
		return ( *this );

	else
	{
		len = set_two.len;
		min = set_two.min;
		max = set_two.max;
		delete ptr;

		if( ! ( ptr = new char[ len ] ) )
		{
			cerr << "\nMemory allocation failure. Program terminated";
			exit(1);
		}

		memcpy( ptr, set_two.ptr, len );
		return ( *this );
	}
}

// Copy Constructor
set::set( const set& s )
{
	if( s.ptr == NULL)
		ptr = NULL;

	else
	{
		len = s.len;
		min = s.min;
		max = s.max;

		if( ! ( ptr = new char[ s.len ] ) )
		{
			cerr << "\nMemory allocation failure. Program terminated";
			exit(1);
		}

		memcpy( ptr, s.ptr, s.len );
	}
}

// Union of two sets ( BINARY + )
// The union of set A and set B is the set of elements I that belong
// to either A or B or both A and B
set operator+ ( const set& set_one, const set& set_two )
{
	if( set_one.len == 0 )
		return set_two;

	else if( set_two.len == 0 )
		return set_one;

	else
	{
		set set_three = set_one;

		for( int i = 0; i < set_three.len; i++ )
		{
			if( set_two.ptr[i] )
				set_three.ptr[i] = TRUE;
		}
	return set_three;
	}
}

// Union of two sets ( BINARY += )
// The union of set A and set B is the set of elements I that belong
// to either A or B or both A and B
set& set::operator+= ( const set& set_two )
{
	set temp;
	temp = *this + set_two;
	*this = temp;
	return ( *this );
}

// Complement of a set ( UNARY - )
// The complement of set A  is the set of elements in the range of the set
// A that do not belong to set A
set operator- ( const set& s )
{
	set complement = s;

	for( int i = 0; i < complement.max - complement.min + 1; i++ )
		complement.ptr[ i ] = ! s.ptr[ i ];

	return ( complement );
}

// Difference of two sets ( BINARY - )
// The difference of set A and set B is the set of elements I that belong
// to set A but not set B
set operator- ( const set& set_one, const set& set_two )
{
	if( set_one.len == 0 )
		return set_one;

	else if( set_two.len == 0 )
		return set_one;

	else
	{
		set set_three;
		set_three.len = set_one.len;

		int jmin = 0;

		for( int i = 0; i < set_one.len; i++ )
		{
			int match = FALSE;

			if( set_one.ptr[i] )
			{
				for( int j = jmin; j < set_two.len; j++ )
				{
					if( set_two.ptr[j] )
					{
						if( set_one.min + i == set_two.min + j )
						{
							jmin = j + 1;
							match = TRUE;
							break;
						}
					}

					if( set_two.min + j >= set_one.min + i )
					{
						jmin = j + 1;
						break;
					}

				}

				if( ! match )
					set_three.ptr[i] = TRUE;
			}
		}
	return set_three;
	}
}

// Difference of two sets ( BINARY -= )
// The difference of set A and set B is the set of elements I that belong
// to set A but not set B
set& set::operator-= ( const set& set_two )
{
	set temp;
	temp = *this - set_two;
	*this = temp;
	return ( *this );
}

// Intersection of two sets ( BINARY * )
// The intersection of set A and set B is the set of elements I that
// belong to both set A and set B
set operator* ( const set& set_one, const set& set_two )
{
	if( set_one.len == 0 )
		return NULL;

	else if( set_two.len == 0 )
		return NULL;

	else
	{
		set set_three;
		set_three.len = set_one.len;

		int jmin = 0;

		for( int i = 0; i < set_one.len; i++ )
		{
			if( set_one.ptr[i] )
			{
				for( int j = jmin; j < set_two.len; j++ )
				{
					if( set_two.ptr[j] )
					{
						if( set_one.min + i == set_two.min + j )
						{
							jmin = j + 1;
							set_three.ptr[i] = TRUE;
							break;
						}
					}

					if( set_two.min + j >= set_one.min + i )
					{
						jmin = j + 1;
						break;
					}
				}
			}
		}

	return set_three;
	}
}

// Intersection of two sets ( BINARY *= )
// The intersection of set A and set B is the set of elements I that
// belong to both set A and set B
set& set::operator*= ( const set& set_two )
{
	set temp;
	temp = *this * set_two;
	*this = temp;
	return ( *this );
}

// Equality of two sets ( == )
// Set A and set B are equal if they have the same elements over the
// same range
BOOLEAN operator== ( const set& set_one, const set& set_two )
{
	int jmin = 0;

	for( int i = 0; i < set_one.len; i++ )
	{
		if( set_one.ptr[ i ] )
		{
			for( int j = jmin; j < set_two.len; j++ )
			{
				if( set_two.ptr[ j ] )
				{
					if( set_one.min + i != set_two.min + j )
						return FALSE;

					else
					{
						jmin = j + 1;
						break;
					}
				}
			}
		}

	}
	return TRUE;
}

// Inequality of two sets ( != )
// Set A and set B are not equal if they don't have the same elements
// over the same range
BOOLEAN operator!= ( const set& set_one, const set& set_two )
{
	if( set_one == set_two )
		return FALSE;
	else
		return TRUE;
}

// Compare set A less than B ( < )
// Set A is a subset of set B if every element of set A is also an element
// of set B.
BOOLEAN operator< ( const set& set_one, const set& set_two )
{
	int jmin = 0;

	for( int i = 0; i < set_one.len; i++ )
	{
		if( set_one.ptr[ i ] )
		{
			for( int j = jmin; j < set_two.len; j++ )
			{
				if( set_two.ptr[ j ] )
				{
					if( set_one.min + i == set_two.min + j )
					{
						jmin = j + 1;
						break;
					}

					else if( set_two.min + j  > set_one.min + i )
						return FALSE;
				}
			}
		}

	}
	return TRUE;
}


// Compare set A greater than B ( > )
// Set B is a subset of set A if every element of set B is also an element
// of set A.
BOOLEAN operator> ( const set& set_one, const set& set_two )
{
	return ( set_two < set_one );
}

// Compare set A greater than or equal to set B ( >= )
BOOLEAN operator>= ( const set& set_one, const set& set_two )
{
	return ( set_two < set_one );
}

// Compare set A less than or equal to set B ( <= )
BOOLEAN operator<= ( const set& set_one, const set& set_two )
{
	return ( set_one < set_two );
}

//  String output
ostream& operator<< ( ostream& stream, const set& data )
{
	BOOLEAN first = TRUE;
	BOOLEAN empty = TRUE;

	stream << "{ ";

	for( int i = 0; i < data.len; i++ )
	{

		if( data.ptr[i] )
		{
			if( ! first )
				stream << ", ";

			stream << ( data.min + i );

			first = FALSE;
			empty = FALSE;
		}

	}

	if ( empty )
		stream << "NULL";

	stream << " }\n";
	return stream;
}