/******************************************************************************
*
*       Module: scredit.h
*
*  Description: Header file for SCREDIT field editing system
*
*******************************************************************************/
/* Constants to be used with the Boolean variable required. */
#ifndef         TRUE
#define         FALSE   0
#define         TRUE    1
#endif
  
#ifndef     __SCREDIT__
#define     __SCREDIT__
#include    "scrwin.h"
#include    "getkey.h"
#include    "cursor.h"

/*  Return value for Field Processing */
extern int      procfld_direction;          /* 1 = forward direction, -1 backward direction */
extern void far *procfld_nxtoff;
#define 	PROCESS_FIELD	0xFFFF

/*  Numeric values for Boolean Yes/No type fields */
#define     BOOL_BLANK	    2	    /* Blank field */
#define     BOOL_YES	    TRUE    /* Yes answer  */
#define     BOOL_NO	    FALSE   /* No answer   */
  
/*  These values may be changed by the user, if desired */
extern char money_symbol;	/*  default  '$'                     */
extern char num_decimals;	/*  default 2			     */
extern char decimal_char;	/*  default '.'                      */
extern char *drcr_symbol;	/*  default "<>"                     */
extern char stat_attrib;	/*  default BLUE on WHITE	     */
extern char err_attrib; 	/*  default RED on WHITE	     */
extern char display_status;	/*  default FALSE		     */
extern char clear_kb_buffer;	/*  default FALSE, clear kb buffer before screen entry */
extern char move_windows;	/*  default TRUE		     */
extern char status_row; 	/*  default 25			     */
extern char err_column; 	/*  default 16			     */
extern char *tf_error;		/*  "Must enter 'T' or 'F'"          */
extern char *yn_error;		/*  "Must enter 'Y' or 'N'"          */
extern char *ynb_error; 	/*  "Must enter 'Y' or 'N' or Blank" */
extern char *req_error; 	/*  "Entry is required in this field"*/
extern char *bad_amount;	/*  "Invalid Amount"                 */
extern char *bad_entry; 	/*  "Invalid Entry"                  */
extern char *bad_date;		/*  "Invalid Date"                   */
extern char scredit_colors[];	/*  current color settings for SCREDIT screen operations */
extern char xlate_colors;	/*  Should color translation take place? (default TRUE) */

typedef struct opttype {
    char far	* far *option_list;
    char	option_select;
} OPTTYPE;

/*
 *  This function is called by edit_input_fields when serious errors
 *   occur during:
 *
 *      1. Field at specified offset is not an Input field
 *              "Field at specified Offset is not an input field"
 *
 *      2. If in finding the specified offset, the end of the
 *           screen is reached.
 *              "Specified Offset is outside of screen"
 *
 *      3. If during a screen wrap (cursor movement causes a screen wrap),
 *           and no input field can be found.
 *              "Error finding Input Field after Screen Wrap"
 *
 *    This function will wait for a keystroke, and abort the program.  If
 *      this action is not desired, then you may provide your own function
 *      in its place.  Your routine may perform a normal return, and
 *      edit_input_fields will return 0.
 *
 */
extern void (*abort_screen) (int err);
  
/*  Function Declarations  */
void set_status_mask(char *status_mask);
void save_status(void);
void restore_status(void);
void blank_status (void);
void note(char far *msg);
void errmsg (char far *msg);
WINDO far *disp_prompts(char far *(*scrnptr)(), WINDO far *winptr);
void undisp_prompts(char far *(*scrnptr)(), WINDO far *winptr);
void disp_io_fields (char far *(*scrnptr)(), void *struc_buf);

#define     edit_input_fields(a, b, c)	    edithelp_io_fields(a, b, c, NULL)

int edithelp_io_fields (char far *(*flds)(), void *struc_buf, void far **offset, char far *(*hlp)());
void set_scrcolors(char *origcolors);
  
/*
**  Conversion routines and their structures:
*/
typedef struct {	/* also compatible with Btrieve date key format */
    char	day;
    char	month;
    int 	year;
} PACK_DATE;

typedef struct {	/* also compatible with Btrieve time key format */
    char	hunds;	    /* hundredths of a second */
    char	second;
    char	minute;
    char	hour;
} PACK_TIME;

#define 	SECONDS_PER_DAY     86400L	    /* number of seconds in a day */

typedef struct {
    PACK_DATE	pdate;
    PACK_TIME	ptime;
    int 	dow;		/* day of week 0-6 (Sun - Sat) */
    char	cdow[4];	/* day of week string */
    char	cmmdd[6];	/* date string as Jan01 */
    char	cmmddyy[9];	/* date string as Jan01,90 */
    char	cmmdd4y[11];	/* date string as Jan01,1990 */
} SCREDIT_DATES;

/*
**  Converts a SCREDIT date date format into the structure in SCREDIT_DATES.
**	if <get_curtime> is TRUE, gets the current time for <ptime>,
**	if <get_curtime> is FALSE, uses the time in the scredit date format.
*/
void scredit_cvtlong_date(long scredit_date, int get_curtime, SCREDIT_DATES *pl);

/*
**  Converts a PACK_DATE structure format into the structure in SCREDIT_DATES.
**	if <get_curtime> is TRUE, gets the current time for <ptime>,
**	if <get_curtime> is FALSE, time is initialized to midnight.
*/
void scredit_cvtpack_date(PACK_DATE *datep, int get_curtime, SCREDIT_DATES *pl);

/*
**  Compute the elapsed days between the two packed date structures.
**	(day1 - day2)
*/
long scredit_diffdays(PACK_DATE *day1, PACK_DATE *day2);

/*
**  Add days to packed date structure, and return new date in packed structure
*/
void scredit_addays(PACK_DATE *date, int days_to_add);

#endif
