/******************************************************************************
*
*       Module: getkey.h
*
*  Description: Keyboard defines for returns from getkey
*
*******************************************************************************/
  
#define         BACKSPACE       0x0008
#define         TAB             0x0009
#define         CTRL_ENTER      0x000A
#define         ENTER           0x000D
#define         ESC             0x001B
#define         CTRL_BKSPC      0x007F

#define         CTRL_A          0x0001
#define         CTRL_B          0x0002
#define         CTRL_C          0x0003
#define         CTRL_D          0x0004
#define         CTRL_E          0x0005
#define         CTRL_F          0x0006
#define         CTRL_G          0x0007
#define         CTRL_H          BACKSPACE
#define         CTRL_I          TAB
#define         CTRL_J          CTRL_ENTER
#define         CTRL_K          0x000B
#define         CTRL_L          0x000C
#define         CTRL_M          ENTER
#define         CTRL_N          0x000E
#define         CTRL_O          0x000F
#define         CTRL_P          0x0010
#define         CTRL_Q          0x0011
#define         CTRL_R          0x0012
#define         CTRL_S          0x0013
#define         CTRL_T          0x0014
#define         CTRL_U          0x0015
#define         CTRL_V          0x0016
#define         CTRL_W          0x0017
#define         CTRL_X          0x0018
#define         CTRL_Y          0x0019
#define         CTRL_Z          0x001A
#define         CTRL_LTBRKT     ESC     /* control left bracket  - ^[ */
#define         CTRL_BKSLSH     0x001C  /* control backslash     - ^\ */
#define         CTRL_RTBRKT     0x001D  /* control right bracket - ^] */
#define         CTRL_CARAT      0x001E  /* control 6             - ^6 */
#define         CTRL_MINUS      0x001F  /* control minus         - ^- */

#define         ALT_A           0x1E00
#define         ALT_B           0x3000
#define         ALT_C           0x2E00
#define         ALT_D           0x2000
#define         ALT_E           0x1200
#define         ALT_F           0x2100
#define         ALT_G           0x2200
#define         ALT_H           0x2300
#define         ALT_I           0x1700
#define         ALT_J           0x2400
#define         ALT_K           0x2500
#define         ALT_L           0x2600
#define         ALT_M           0x3200
#define         ALT_N           0x3100
#define         ALT_O           0x1800
#define         ALT_P           0x1900
#define         ALT_Q           0x1000
#define         ALT_R           0x1300
#define         ALT_S           0x1F00
#define         ALT_T           0x1400
#define         ALT_U           0x1600
#define         ALT_V           0x2F00
#define         ALT_W           0x1100
#define         ALT_X           0x2D00
#define         ALT_Y           0x1500
#define         ALT_Z           0x2C00
#define         ALT_1           0x7800
#define         ALT_2           0x7900
#define         ALT_3           0x7A00
#define         ALT_4           0x7B00
#define         ALT_5           0x7C00
#define         ALT_6           0x7D00
#define         ALT_7           0x7E00
#define         ALT_8           0x7F00
#define         ALT_9           0x8000
#define         ALT_0           0x8100
#define         ALT_MINUS       0x8200
#define         ALT_EQUALS      0x8300
  
#define         F1              0x3B00
#define         F2              0x3C00
#define         F3              0x3D00
#define         F4              0x3E00
#define         F5              0x3F00
#define         F6              0x4000
#define         F7              0x4100
#define         F8              0x4200
#define         F9              0x4300
#define         F10             0x4400
#define         F11             0x8500
#define         F12             0x8600

#define         SHFT_F1         0x5400
#define         SHFT_F2         0x5500
#define         SHFT_F3         0x5600
#define         SHFT_F4         0x5700
#define         SHFT_F5         0x5800
#define         SHFT_F6         0x5900
#define         SHFT_F7         0x5A00
#define         SHFT_F8         0x5B00
#define         SHFT_F9         0x5C00
#define         SHFT_F10        0x5D00
#define         SHFT_F11        0x8700
#define         SHFT_F12        0x8800

#define         CTRL_F1         0x5E00
#define         CTRL_F2         0x5F00
#define         CTRL_F3         0x6000
#define         CTRL_F4         0x6100
#define         CTRL_F5         0x6200
#define         CTRL_F6         0x6300
#define         CTRL_F7         0x6400
#define         CTRL_F8         0x6500
#define         CTRL_F9         0x6600
#define         CTRL_F10        0x6700
#define         CTRL_F11        0x8900
#define         CTRL_F12        0x8A00

#define         ALT_F1          0x6800
#define         ALT_F2          0x6900
#define         ALT_F3          0x6A00
#define         ALT_F4          0x6B00
#define         ALT_F5          0x6C00
#define         ALT_F6          0x6D00
#define         ALT_F7          0x6E00
#define         ALT_F8          0x6F00
#define         ALT_F9          0x7000
#define         ALT_F10         0x7100
#define         ALT_F11         0x8B00
#define         ALT_F12         0x8C00

#define         _INSCHAR        0x5200
#define         _DELCHAR        0x5300
#define         PGUP            0x4900
#define         PGDN            0x5100
#define         END             0x4F00
#define         _HOME           0x4700
#define         _UP             0x4800
#define         _DOWN           0x5000
#define         _LEFT           0x4B00
#define         _RIGHT          0x4D00
#define         CTRL_DEL        0x5300
#define         CTRL_PGUP       0x8400
#define         CTRL_PGDN       0x7600
#define         CTRL_END        0x7500
#define         CTRL_HOME       0x7700
#define         CTRL_LEFT       0x7300
#define         CTRL_RIGHT      0x7400
#define         BACKTAB         0x0F00
  
#define         Shift_Bits      ((char far *) 0x00000417L)
#define         SCROLL_LOCK     0x0010
#define         NUM_LOCK        0x0020
#define         CAPS_LOCK       0x0040

/*
**  Get a keystroke
**
**  <type>  0 = get next keystroke, wait for one to be avaiable
**	    1 = test if keystroke is available, 0 if none available
**	    2 = get shift key status
**		    Bit 7	0x80	    insert on
**		    Bit 6	0x40	    caps on
**		    Bit 5	0x20	    numlock on
**		    Bit 4	0x10	    scroll-lock on
**		    Bit 3	0x08	    alt on
**		    Bit 2	0x04	    ctrl on
**		    Bit 1	0x02	    left shift on
**		    Bit 0	0x01	    right shift on
*/
int getkey(int type);
  
/*  End of getkey.h  */
