/******************************************************************************
*
*	Module: menu.c
*
*	 Title: MENU
*
*  Description: A functional application menu system.  User configurable
*		menu selections/options.  Uses MENU.CFG for the configuration
*		of the menu (Using LEX and YACC to parse the configuration
*		file)
*
*		Uses SWAP.COM (see DDJ April '89) to execute the program, and
*		shrink memory used before executing the program.
*
*******************************************************************************/
#include    "stdio.h"
#include    "bios.h"
#include    "stdlib.h"
#include    "scredit.h"
#include    "getkey.h"
#include    "cursor.h"
#include    "string.h"
#include    "mem.h"
#include    "dir.h"
#include    "menu.h"

extern unsigned _stklen = 0x2000;

char        *no_parms = "";
char        *menu_cfg = "MENU.CFG";
char   far  *bar_menu[MAXBAR];
char   far  *pull_menu[MAXBAR][MAXPULLDOWN];
char        *pull_option[MAXBAR][MAXPULLDOWN];
char        pause[MAXBAR][MAXPULLDOWN];
char	    swap[MAXBAR][MAXPULLDOWN];
int         bar_row = 4, bar_attrib = 0x30, bar_norm = 0x30;
int         bar_hilit = 0x70, bar_lnorm = 0x34, bar_lhilit = 0x74;
int         parse_error = FALSE;

WINDO       header = {UNINIT, 1, 1, 1, 78, attr(BLACK, GREEN), Single_Border, attr(BLACK,GREEN), "", ' '};
WINDO       old_scrn = {UNINIT, 4, 1, 21, 80, attr(BLACK,LIGHTGRAY), No_Border, 0x00, "", 178};

POPBAR      bar = {UNINIT, 0, 0, 0, 0, 0, TRUE, FALSE, bar_menu, ' '};

PULLDOWN    pull = {UNINIT, 0, 0, attr(BLACK,CYAN), attr(BLACK,CYAN),attr(BLACK,LIGHTGRAY),
                    attr(RED,CYAN),attr(RED,LIGHTGRAY), Single_Border, No_Enumerate,
                    FALSE, TRUE};


/******************************************************************************
*
*	  Name: do_pulldown_menu
*
*  Description: Executes the specified pulldown menu
*
*	 Parms: PULLDOWN far *pull, int pullnum
*
*      Returns: void
*
*******************************************************************************/
void do_pulldown_menu(PULLDOWN far *pull, int pullnum)
{
    int     ret;
    WINDO   savscrn = {UNINIT, 1, 1, 25, 80, attr(BLACK,LIGHTGRAY), No_Border, 0x00, "", ' '};
    char    temp[255];

    while (TRUE) {
        ret = make_pulldown_menu(pull);
        switch(ret) {
            case ESC :
                remove_pulldown_menu(pull);
                return;
            case 0:
            case 1:
            case 2:
            case 3:
            case 4:
            case 5:
            case 6:
            case 7:
            case 8:
            case 9:
                /* find the directory the program is to load from, and
                **  change to that directory
                */
                make_window(&savscrn);
                textattr(0x07);
                clrscr();
		if (swap[pullnum][ret])
		    sprintf(temp, "SWAP.COM -D %s", pull_option[pullnum][ret]);
		else
		    sprintf(temp, "%s", pull_option[pullnum][ret]);
		system(temp);
		textmode(C80);
		if ((ret == 0) && (pause[pullnum][ret])) {
                    printf("\n*** Press any key ***");
                    bioskey(0);
                }
                remove_window(&savscrn);
                break;
        }
    }
}


/******************************************************************************
*
*	  Name: menu
*
*  Description: Displays the bar menu
*
*	 Parms: void
*
*      Returns: void
*
*******************************************************************************/
void menu(void)
{
    int     ret;

    while (TRUE) {
        ret = make_bar_menu(&bar, bar_row);
        switch(ret) {
            case ESC :
                remove_bar_menu(&bar);
                return;
            case 0   :
            case 1   :
            case 2   :
            case 3   :
            case 4   :
            case 5   :
            case 6   :
            case 7   :
            case 8   :
            case 9   :
                if (pull_menu[ret][0]) {
                    pull.title = bar_menu[ret];
                    pull.selections = (char far **)pull_menu[ret];
                    pull.fill_char = ' ';
                    pull.col = bar.selection_start[ret] + 1;
                    pull.row = bar.save_win.row + 1;
                    do_pulldown_menu(&pull, ret);
                }
                else {
                    error_window("Pulldown Menu for this selection is not built");
                }
                break;
        }
    }
}


/******************************************************************************
*
*	  Name: main
*
*  Description: MAIN.  Will execute the specified menu, or if none given
*		at the command line, will execute the default menu MENU.CFG
*
*	 Parms: int argc, char *argv[]
*
*      Returns: void
*
*******************************************************************************/
void main(int argc, char *argv[])
{
    extern FILE *yyin;
    char        *menu_name = menu_cfg;
    int         yyparse(void);

    setmem(&pause, sizeof(pause), FALSE);
    setmem(&swap, sizeof(swap), FALSE);

    /* was a menu specified on the command line? */
    if (argc > 1)
        menu_name = argv[1];

    /* parse the menu configuration file */
    if ( (yyin = fopen(menu_name, "r")) == NULL) {
        printf("Error opening menu \"%s\"\n", menu_name);
        exit(1);
    }
    while(yyparse());
    fclose(yyin);
    if (parse_error)
        exit(1);

    /* now set up to execute the menu */
    bar.attrib = bar_attrib;
    bar.norm_attrib = bar_norm;
    bar.hilit_attrib = bar_hilit;
    bar.lnorm_attrib = bar_lnorm;
    bar.lhilit_attrib = bar_lhilit;
    /* save the old window(s) */
    make_window(&header);
    cprintf("  MENU.EXE                                  Copyright 1990 by Tim Underwood");
    make_window(&old_scrn);
    menu();
    /* restore the old window(s) */
    remove_window(&old_scrn);
    remove_window(&header);
}
