/*
 *
 *  input.c   - demonstration file for displaying and using an input screen
 *		using SCREDIT.
 *
 *
 *
 */
#include    "conio.h"
#include    "time.h"
#include    "mem.h"
#include    "stdio.h"
#include    "string.h"

#include    "scredit.h"     /* Header file for SCREDIT */
#include    "input.h"       /* Header file for input.sbj */

char far *options[] = {"Active", "Inactive", "Delete", NULL};

void main(void)
{
    SC_INPUT  scr;	    /* define variable scr for the screen structure */
    void far *offset;	    /* defines field where cursor should be placed */
    int     ret;	    /* return from edit_input_fields */
    int     done = FALSE;
    WINDO far	*xwin;

    clrscr();			    /* clear the screen */
    setmem(&scr, sizeof(scr), 0);   /* clear out scr */
    display_status = TRUE;	    /* display status line */
    err_column = 1;
    /*
     * scr fields may be initialized prior to calling SCREDIT.
     *	this allows using default values, retrieving a record
     *	from a database and displaying the data for editing, etc.
     */

    time(&scr.last_pmt_date);
    scr.last_balance = 100000L;     /* last balance is 1000.00 */
    scr.curr_balance = scr.last_balance;
    scr.last_pmt_amt = 57567L;	     /* payment is 575.67, as field is a 'money' type,
				     *	will have implied decimals as defined by the
				     *	variable num_decimals.
				     */

    /* since this demo does not contain a database, we will initialize the
     *	fields using strcpy, etc.
     */
    strcpy(scr.name, "Underwood, Tim");
    strcpy(scr.addr1, "1719 S. Shiloh");
    strcpy(scr.city, "Wichita");
    strcpy(scr.state, "KS");
    strcpy(scr.zip, "67207");
    scr.status.option_list = options;
    scr.status.option_select = 0;     /* change this value to indicate which entry to
					initially display */

    xwin = disp_prompts(sc_input_pmt, NULL);	 /* display main screen */
    offset = &scr.status;	      /* initialize the offset to start in the
				     * name field
				     */
    do {
	/*  call the edit routine,  note that it will also display data
	 *   already in the fields, then allow editing.
	 */
	ret = edithelp_io_fields(sc_input_inp, &scr, &offset, sc_input_hlp);
	switch (ret) {	    /* what key did the user exit with? */
	    case PROCESS_FIELD :    /* for extra field processing */
		/*
		**  We check to see if the offset is equal to the field we
		**   wish to do extra processing for.
		**  If the payment will make the balance less than 0, we
		**   will generate an error, and will not advance the
		**   offset to another field, so the user is forced to enter
		**   a correct amount.
		**  If the amount is OK, then we generate a new balance, and
		**   advance the cursor to the next field we wish to process
		*/
		if (offset == &scr.last_pmt_amt) {
		    if ( (scr.last_balance - scr.last_pmt_amt) < 0L)  /* will this make the payment less than 0? */
			errmsg("This will make the balance less than 0!");
		    else {
			scr.curr_balance = scr.last_balance - scr.last_pmt_amt;
			offset = &scr.last_pmt_date;	 /* must do this so we can advance to next field */
		    }
		}
	    case PGDN  :    /* Page Down */
		/* get next customer and edit */
		break;

	    case PGUP  :    /* Page Up */
		/* get previous customer and edit */
		break;

	    case ENTER :    /* ENTER key */
		/*
		 * here we can do some checking of the user's input,
		 *  or whatever else you may want to do.
		 *  We won't actually do any checking, but will simply
		 *   'drop' through tothe ESC case to clear the screen
		 *   and exit.
		 */

	    case ESC :	    /* quit/abort key? */
		undisp_prompts(sc_input_pmt, xwin);
		done = TRUE;
		break;
	}
    } while (!done);

    clrscr();
    printf("          Type: %d (%s)\n", scr.status.option_select, options[scr.status.option_select]);
    printf("          Name: %s\n", scr.name);
    printf("     Address 1: %s\n", scr.addr1);
    printf("     Address 2: %s\n", scr.addr2);
    printf("City/State/Zip: %-20s/%-2s/%s\n", scr.city, scr.state, scr.zip);

}
