/*
 * rdtimer -- attempt to read 8253 timer
 */
#include <dos.h>
#include <stdio.h>
#include <bios.h>
#define Timer0      0x40	/* timer 0 control port */
#define Timer1	    0x41	/* timer 1 control port */
#define TimerMode   0x43	/* timer mode port */

void main (void) {
    unsigned int TimerValue;
    unsigned int MaxValue = 0;

    disable ();
    do {
	outportb (TimerMode,0x40);
	TimerValue = inportb (Timer1) + (inportb (Timer1) << 8);
	printf ("%04X    ", TimerValue);
	if (TimerValue > MaxValue)
	    MaxValue = TimerValue;
    } while (!bioskey (1));
    enable ();
    bioskey (0);
    printf ("\n\nMax value = %04X\n", MaxValue);
} /* set_timer */
