#include "rtc.h"

/* Loop until "Update in Progress" bit is clear */
static void WaitForUpdate (void) {
    while (ReadCMOS (SRA) & UIP)
	;
}

/* Read Value from CMOS RAM */
int ReadCMOS (int Addr) {
    int ch;
    asm pushf           /* save interrupt flag */
    disable ();
    if (Addr < SRA) WaitForUpdate ();
    outportb (CMOS_Control, Addr | 0x80);
    ch = inportb (CMOS_Data);
    outportb (CMOS_Control, SRD);  /* re-enable NMI */
    inportb (CMOS_Data);           /* and read SRD */
    asm popf            /* restore interrupt flag */
    return ch;
} /* ReadCMOS */

/* Write Value to CMOS RAM */
void WriteCMOS (int Addr, int Value) {
    asm pushf           /* save interrupt flag */
    disable ();
    if (Addr < SRA) WaitForUpdate ();
    outportb (CMOS_Control, Addr | 0x80);
    outportb (CMOS_Data, Value);
    outportb (CMOS_Control, SRD);  /* re-enable NMI */
    inportb (CMOS_Data);           /* and read SRD */
    asm popf            /* restore interrupt flag */
} /* WriteCMOS */

/* Compute and store new CMOS checksum */
void NewCMOSChecksum (void) {
    int Loc, CheckSum = 0;
    for (Loc = 0x10; Loc < 0x2E; Loc++)
	CheckSum += ReadCMOS (Loc);
    WriteCMOS (0x2E, (CheckSum >> 8));
    WriteCMOS (0x2F, (CheckSum & 0xFF));
}
