/**************************************************************************
	RipTABS - Tab Folder Dialog  Version 2.00  (April 15 ,1994)

	(c) 1993, 1994 Jonathan Carroll - All Rights Reserved
**************************************************************************/


void RipTABRegister();
void RipTABUnregister();
CString* CStringPtr(const char*);


class CTabTitle;

/////////////////////////////////////////////////////////////////////////////
// CTabDialog dialog

class CTabDialog : public CDialog
{
// Construction
public:
	CTabDialog(int theDialog, CWnd* pParent = NULL);	// standard Modal constructor
	CTabDialog();	// standard Modeless constructor
	~CTabDialog();
	
	void NextTab();
	void PrevTab();

	CString& 			ActiveTabText() { return rtab_ActiveTabText; };
	int 					TabTextYpos() { return rtab_TabTextPos; };
	int						rtab_LastActiveTab, rtab_ActiveTab;
	
	BOOL					m_TabHasFocus;
	CPtrArray*		rtab_OptionsList[2];
	afx_msg void 	OnLButtonDown(UINT flags, CPoint point);
	

// Implementation
protected:

	void InitData(CPtrArray* theOptionsList1, CPtrArray* theOptionsList2, int TheStaticBox);
	// Generated message map functions
	//{{AFX_MSG(CTabDialog)
	virtual void OnOK();
	virtual void OnCancel();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	afx_msg void OnPaint();
	
	virtual void SwitchToNotification(int TabIndex, CString* TabName);
	virtual void SwitchFromNotification(int TabIndex, CString* TabName);


	DECLARE_MESSAGE_MAP()

private:

	void FAR*								 	rtab_lpsectiondir;

	CPtrArray									rtab_RectArray;
  CWordArray								rtab_SectionIndexArray;

	int								 				rtab_FTabWidth, rtab_Space, rtab_NumAccross;
	int												rtab_TabLines, rtab_LineHeight;
	int												rtab_OrderList[20];
	int												rtab_IDC_CSTATIC;
	int												rtab_LineOffset;
	CRect											rtab_BoxRect;
	CFont*										rtab_DlgFont;
	CWordArray          			rtab_RowHeaderList;
	CTabTitle*								TabTitle;
	CString										rtab_ActiveTabText; 
	int												rtab_TabTextPos;
};

class CTabTitle : public CWnd
{
	public:
	CTabTitle(CTabDialog* pParent, RECT& theRect);
	void PostNcDestroy();
	afx_msg void OnPaint();
	void RePosition(HWND hwndInsertAfter); 
	afx_msg void OnSetFocus(CWnd* OldWnd);  
	afx_msg void OnKillFocus(CWnd* NewWnd);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	
	private:
	CTabDialog* Parent;
	BOOL				HaveFocus;

	DECLARE_MESSAGE_MAP()
};
