/* Driver for routine SHOOTF */

#include <stdio.h>
#include <math.h>
#include "nr.h"

#define NVAR 3
#define N1 2
#define N2 1
#define DELTA 1.0e-3
#define EPS 1.0e-6
#define DX 1.0e-4

float c2,factr,dx;
int m;

void load1(x1,v1,y)
float x1,v1[],y[];
{
	y[3]=v1[1];
	y[2] = -(y[3]-c2)*factr/2.0/(m+1.0);
	y[1]=factr+y[2]*dx;
}

void load2(x2,v2,y)
float x2,v2[],y[];
{
	y[3]=v2[2];
	y[1]=v2[1];
	y[2]=(y[3]-c2)*y[1]/2.0/(m+1.0);
}

void score(xf,y,f)
float xf,y[],f[];
{
	int i;

	for (i=1;i<=3;i++) f[i]=y[i];
}

void derivs(x,y,dydx)
float x,y[],dydx[];
{
	dydx[1]=y[2];
	dydx[3]=0.0;
	dydx[2]=(2.0*x*(m+1.0)*y[2]-(y[3]-c2*x*x)*y[1])/(1.0-x*x);
}

main()
{
	int i,n;
	float h1,hmin,q1,x1,x2,xf;
	float v1[2],delv1[2],dv1[2],v2[3],delv2[3],dv2[3],f[4];

	do {
		printf("Input M,N,C-SQUARED: ");
		scanf("%d %d %f",&m,&n,&c2);
	} while (n < m || m < 0);
	dx=DX;
	factr=1.0;
	if (m) {
		q1=n;
		for (i=1;i<=m;i++) {
			factr *= (-0.5*(n+i)*(q1/i));
			q1 -= 1.0;
		}
	}
	v1[1]=n*(n+1)-m*(m+1)+c2/2.0;
	v2[1]=((n-m)%2 == 0 ? factr : -factr);
	v2[2]=v1[1]+1.0;
	delv1[1]=DELTA*v1[1];
	delv2[1]=DELTA*factr;
	delv2[2]=delv1[1];
	h1=0.1;
	hmin=0.0;
	x1 = -1.0+DX;
	x2=1.0-DX;
	xf=0.0;
 	printf("\n %26s %20s %19s\n","mu(-1)","y(1-dx)","mu(+1)");
	for (dv1[1]=v1[1];fabs(dv1[1]) > fabs(EPS*v1[1]);) {
		shootf(NVAR,v1,v2,delv1,delv2,N1,N2,x1,x2,
			xf,EPS,h1,hmin,f,dv1,dv2);
		printf("\n%6s %20.6f %20.6f %20.6f\n",
			"v ",v1[1],v2[1],v2[2]);
		printf("%6s %20.6f %20.6f %20.6f\n",
			"dv",dv1[1],dv2[1],dv2[2]);
	}
}
