/* Driver for routine VANDER */

#include <stdio.h>
#include "nr.h"
#include "nrutil.h"

#define N 5

main()
{
	int i,j;
	float sum,*w,*term;
	static float x[]={0.0,1.0,1.5,2.0,2.5,3.0};
	static float q[]={0.0,1.0,1.5,2.0,2.5,3.0};

	w=vector(1,N);
	term=vector(1,N);
	vander(x,w,q,N);
	printf("\nSolution vector:\n");
	for (i=1;i<=N;i++)
		printf("%7s%1d%2s %12f \n","w[",i,"]=",w[i]);
	printf("\nTest of solution vector:\n");
	printf("%14s %11s\n","mtrx*sol'n","original");
	sum=0.0;
	for (i=1;i<=N;i++) {
		term[i]=w[i];
		sum += w[i];
	}
	printf("%12.4f %12.4f\n",sum,q[1]);
	for (i=2;i<=N;i++) {
		sum=0.0;
		for (j=1;j<=N;j++) {
			term[j] *= x[j];
			sum += term[j];
		}
		printf("%12.4f %12.4f\n",sum,q[i]);
	}
	free_vector(term,1,N);
	free_vector(w,1,N);
}
