/* Driver for routine FACTRL */

#include <stdio.h>
#include <math.h>
#include "nr.h"
#include "nrutil.h"

#define MAXSTR 80

main()
{
	char txt[MAXSTR];
	float actual;
	int i,n,nval,strncmp();
	FILE *fp;

	if ((fp = fopen("fncval.dat","r")) == NULL)
		nrerror("Data file FNCVAL.DAT not found\n");
	fgets(txt,MAXSTR,fp);
	while(strncmp(txt,"N-factorial",11)) {
		fgets(txt,MAXSTR,fp);
		if (feof(fp)) return;
	}
	fscanf(fp,"%d %*s",&nval);
	printf("\n%s\n",txt);
	printf("%6s %18s %20s \n","n","actual","factrl(n)");
	for (i=1;i<=nval;i++) {
		fscanf(fp,"%d %f ",&n,&actual);
		if (actual < 1.0e10)
			printf("%6d %20.0f %20.0f\n",n,actual,factrl(n));
		else
			printf("%6d %20e %20e \n",n,actual,factrl(n));
	}
	fclose(fp);
}
